/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.imagecollections;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;
import org.jdesktop.swingx.JXList;
import org.jphototagger.domain.filefilter.FileFilterUtil;
import org.jphototagger.program.datatransfer.Flavor;
import org.jphototagger.program.module.imagecollections.ImageCollectionsUtil;
import org.jphototagger.program.resource.GUI;

public final class ImageCollectionsListTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        return support.isDataFlavorSupported(Flavor.THUMBNAILS_PANEL) && support.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && ((JList.DropLocation)support.getDropLocation()).getIndex() >= 0;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 0;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!support.isDrop()) {
            return false;
        }
        List<File> imageFiles = null;
        try {
            Transferable transferable = support.getTransferable();
            imageFiles = this.getImageFiles((List)transferable.getTransferData(DataFlavor.javaFileListFlavor));
        }
        catch (Throwable t) {
            Logger.getLogger(ImageCollectionsListTransferHandler.class.getName()).log(Level.SEVERE, null, t);
            return false;
        }
        int listIndex = ((JList.DropLocation)support.getDropLocation()).getIndex();
        this.handleDroppedThumbnails(listIndex, imageFiles);
        return true;
    }

    private void handleDroppedThumbnails(int itemIndex, List<File> imageFiles) {
        if (imageFiles == null) {
            throw new NullPointerException("imageFiles == null");
        }
        if (itemIndex >= 0) {
            this.addToImageCollection(itemIndex, imageFiles);
        } else {
            this.createImageCollection(imageFiles);
        }
    }

    private void addToImageCollection(int itemIndex, List<File> imageFiles) {
        boolean added = ImageCollectionsUtil.addImagesToCollection(this.getImageCollectionName(itemIndex), imageFiles);
        if (added) {
            GUI.refreshThumbnailsPanel();
        }
    }

    private void createImageCollection(List<File> imageFiles) {
        ImageCollectionsUtil.insertImageCollection(imageFiles);
    }

    private String getImageCollectionName(int itemIndex) {
        JXList list = GUI.getAppPanel().getListImageCollections();
        return list.getModel().getElementAt(itemIndex).toString();
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
    }

    private List<File> getImageFiles(List<File> list) {
        ArrayList<File> imageFiles = new ArrayList<File>(list.size() / 2);
        for (File file : list) {
            if (!FileFilterUtil.isImageFile(file)) continue;
            imageFiles.add(file);
        }
        return imageFiles;
    }
}

