/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.imagecollections;

import java.util.List;
import javax.swing.DefaultListModel;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.imagecollections.ImageCollection;
import org.jphototagger.domain.imagecollections.ImageCollectionSortAscendingComparator;
import org.jphototagger.domain.repository.ImageCollectionsRepository;
import org.jphototagger.domain.repository.Repository;
import org.jphototagger.domain.repository.event.imagecollections.ImageCollectionDeletedEvent;
import org.jphototagger.domain.repository.event.imagecollections.ImageCollectionInsertedEvent;
import org.jphototagger.domain.repository.event.imagecollections.ImageCollectionRenamedEvent;
import org.jphototagger.lib.swing.util.ListUtil;
import org.jphototagger.program.module.imagecollections.StringAscendingComparator;
import org.openide.util.Lookup;

public final class ImageCollectionsListModel
extends DefaultListModel<Object> {
    private static final long serialVersionUID = 1L;
    private static final String PREF_KEY_LOCALIZATION_BUG_FIX = "ImageCollectionsListModel.LocalizationBugFix";
    private final ImageCollectionsRepository imageCollectionsRepo = Lookup.getDefault().lookup(ImageCollectionsRepository.class);

    public ImageCollectionsListModel() {
        this.applyLocalizationBugFix();
        this.addElements();
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process(this);
    }

    private void addElements() {
        Repository repo = Lookup.getDefault().lookup(Repository.class);
        if (repo == null || !repo.isInit()) {
            return;
        }
        List<String> collections = this.imageCollectionsRepo.findAllImageCollectionNames();
        this.addSpecialCollections();
        for (String collection : collections) {
            if (ImageCollection.isSpecialCollection(collection)) continue;
            this.addElement(collection);
        }
    }

    private void addSpecialCollections() {
        for (String collection : ImageCollectionSortAscendingComparator.SORT_ORDER_OF_SPECIAL_COLLECTION.keySet()) {
            this.addElement(collection);
        }
    }

    @EventSubscriber(eventClass=ImageCollectionRenamedEvent.class)
    public void imageCollectionRenamed(ImageCollectionRenamedEvent evt) {
        String fromName = evt.getFromName();
        String toName = evt.getToName();
        int index = this.indexOf(fromName);
        if (index >= 0) {
            this.remove(index);
            this.insertElementAt(toName, index);
        }
    }

    @EventSubscriber(eventClass=ImageCollectionInsertedEvent.class)
    public void imageCollectionInserted(ImageCollectionInsertedEvent evt) {
        String collectionName = evt.getCollectionName();
        int startIndex = ImageCollection.getSpecialCollectionCount();
        int endIndex = this.getSize() - 1;
        ListUtil.insertSorted(this, collectionName, StringAscendingComparator.INSTANCE, startIndex, endIndex);
    }

    @EventSubscriber(eventClass=ImageCollectionDeletedEvent.class)
    public void imageCollectionDeleted(ImageCollectionDeletedEvent evt) {
        String collectionName = evt.getCollectionName();
        this.removeElement(collectionName);
    }

    private void applyLocalizationBugFix() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        if (!prefs.containsKey(PREF_KEY_LOCALIZATION_BUG_FIX) || !prefs.getBoolean(PREF_KEY_LOCALIZATION_BUG_FIX)) {
            this.imageCollectionsRepo.updateRenameImageCollection("Zuletzt importiert", "SpecialCollectionName.PreviousImport");
            this.imageCollectionsRepo.updateRenameImageCollection("Ausgew\u00e4hlt", "SpecialCollectionName.Picked");
            this.imageCollectionsRepo.updateRenameImageCollection("Verworfen", "SpecialCollectionName.Rejected");
            this.imageCollectionsRepo.updateRenameImageCollection("Previous import", "SpecialCollectionName.PreviousImport");
            this.imageCollectionsRepo.updateRenameImageCollection("Picked", "SpecialCollectionName.Picked");
            this.imageCollectionsRepo.updateRenameImageCollection("Rejected", "SpecialCollectionName.Rejected");
            this.imageCollectionsRepo.deleteImageCollection("Zuletzt importiert");
            this.imageCollectionsRepo.deleteImageCollection("Ausgew\u00e4hlt");
            this.imageCollectionsRepo.deleteImageCollection("Verworfen");
            this.imageCollectionsRepo.deleteImageCollection("Previous import");
            this.imageCollectionsRepo.deleteImageCollection("Picked");
            this.imageCollectionsRepo.deleteImageCollection("Rejected");
            prefs.setBoolean(PREF_KEY_LOCALIZATION_BUG_FIX, true);
        }
    }
}

