/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.imagecollections;

import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import org.jphototagger.domain.imagecollections.ImageCollection;
import org.jphototagger.program.app.ui.AppLookAndFeel;

public final class ImageCollectionsListCellRenderer
extends DefaultListCellRenderer {
    private static final Icon ICON_DEFAULT = AppLookAndFeel.getIcon("icon_imagecollection.png");
    private static final Color SPECIAL_COLLECTION_FOREGROUND = Color.BLUE;
    private static final Map<Object, Icon> ICON_OF_SPECIAL_COLLECTION = new HashMap<Object, Icon>();
    private static final long serialVersionUID = 1L;
    private int tempSelRow = -1;

    public ImageCollectionsListCellRenderer() {
        ICON_OF_SPECIAL_COLLECTION.put("SpecialCollectionName.PreviousImport", AppLookAndFeel.getIcon("icon_card.png"));
        ICON_OF_SPECIAL_COLLECTION.put("SpecialCollectionName.Picked", AppLookAndFeel.getIcon("icon_picked.png"));
        ICON_OF_SPECIAL_COLLECTION.put("SpecialCollectionName.Rejected", AppLookAndFeel.getIcon("icon_rejected.png"));
        this.setOpaque(true);
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        boolean isTempSelRow;
        JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        boolean specialCollection = ImageCollection.isSpecialCollection(value.toString());
        boolean tempSelExists = this.tempSelRow >= 0;
        boolean bl = isTempSelRow = index == this.tempSelRow;
        label.setForeground(isTempSelRow || isSelected && !tempSelExists ? AppLookAndFeel.getListSelectionForeground() : (specialCollection ? SPECIAL_COLLECTION_FOREGROUND : AppLookAndFeel.getListForeground()));
        label.setBackground(isTempSelRow || isSelected && !tempSelExists ? AppLookAndFeel.getListSelectionBackground() : AppLookAndFeel.getListBackground());
        label.setIcon(this.getIconOfValue(value));
        if (value instanceof String) {
            label.setText(ImageCollection.getLocalizedName((String)value));
        }
        return label;
    }

    private Icon getIconOfValue(Object value) {
        Icon icon = ICON_OF_SPECIAL_COLLECTION.get(value);
        return icon == null ? ICON_DEFAULT : icon;
    }

    public void setTempSelectionRow(int index) {
        this.tempSelRow = index;
    }
}

