/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.imagecollections;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jdesktop.swingx.JXList;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.factory.ModelFactory;
import org.jphototagger.program.module.imagecollections.ImageCollectionsListCellRenderer;
import org.jphototagger.program.module.imagecollections.ImageCollectionsListModel;
import org.jphototagger.program.resource.GUI;

public final class ImageCollectionsDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private boolean ok = false;
    private JButton buttonOk;
    private JLabel labelSelectImageCollection;
    private JXList listImageCollectionNames;
    private JScrollPane scrollPaneImageCollectionNames;

    public ImageCollectionsDialog() {
        super((Frame)GUI.getAppFrame(), true);
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.setHelpPageUrl(Bundle.getString(ImageCollectionsDialog.class, "ImageCollectionsDialog.HelpPage", new Object[0]));
        MnemonicUtil.setMnemonics(this);
    }

    public boolean isCollectionSelected() {
        return this.ok && this.listImageCollectionNames.getSelectedValue() != null;
    }

    public String getSelectedCollectionName() {
        Object value = this.listImageCollectionNames.getSelectedValue();
        return value == null || !this.ok ? null : value.toString();
    }

    private void checkDoubleClick(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            int index = this.listImageCollectionNames.locationToIndex(evt.getPoint());
            ListModel model = this.listImageCollectionNames.getModel();
            Object item = model.getElementAt(index);
            if (item != null) {
                this.ok = true;
                this.setVisible(true);
            }
        }
    }

    private void handleButtonOkClicked() {
        this.ok = true;
        this.setVisible(false);
    }

    @Override
    protected void escape() {
        this.setVisible(false);
    }

    private void initComponents() {
        this.labelSelectImageCollection = new JLabel();
        this.scrollPaneImageCollectionNames = new JScrollPane();
        this.listImageCollectionNames = new JXList();
        this.buttonOk = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/imagecollections/Bundle");
        this.setTitle(bundle.getString("ImageCollectionsDialog.title"));
        this.setName("Form");
        this.labelSelectImageCollection.setLabelFor(this.listImageCollectionNames);
        this.labelSelectImageCollection.setText(bundle.getString("ImageCollectionsDialog.labelSelectImageCollection.text"));
        this.labelSelectImageCollection.setName("labelSelectImageCollection");
        this.scrollPaneImageCollectionNames.setName("scrollPaneImageCollectionNames");
        this.listImageCollectionNames.setModel((ListModel)ModelFactory.INSTANCE.getModel(ImageCollectionsListModel.class));
        this.listImageCollectionNames.setSelectionMode(0);
        this.listImageCollectionNames.setCellRenderer((ListCellRenderer)new ImageCollectionsListCellRenderer());
        this.listImageCollectionNames.setName("listImageCollectionNames");
        this.listImageCollectionNames.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ImageCollectionsDialog.this.listImageCollectionNamesMouseClicked(evt);
            }
        });
        this.scrollPaneImageCollectionNames.setViewportView(this.listImageCollectionNames);
        this.buttonOk.setText(bundle.getString("ImageCollectionsDialog.buttonOk.text"));
        this.buttonOk.setName("buttonOk");
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageCollectionsDialog.this.buttonOkActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPaneImageCollectionNames, -1, 240, Short.MAX_VALUE).addComponent(this.labelSelectImageCollection, -1, 240, Short.MAX_VALUE).addComponent(this.buttonOk, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.labelSelectImageCollection).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPaneImageCollectionNames, -1, 160, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonOk).addContainerGap()));
        this.pack();
    }

    private void buttonOkActionPerformed(ActionEvent evt) {
        this.handleButtonOkClicked();
    }

    private void listImageCollectionNamesMouseClicked(MouseEvent evt) {
        this.checkDoubleClick(evt);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImageCollectionsDialog dialog = new ImageCollectionsDialog();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

