/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.imagecollections;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdesktop.swingx.JXList;
import org.jphototagger.domain.imagecollections.ImageCollection;
import org.jphototagger.lib.swing.util.ListUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.imagecollections.ImageCollectionsPopupMenu;
import org.jphototagger.program.module.imagecollections.ImageCollectionsUtil;
import org.jphototagger.program.resource.GUI;

public final class DeleteImageCollectionController
implements ActionListener,
KeyListener {
    private static final Logger LOGGER = Logger.getLogger(DeleteImageCollectionController.class.getName());

    public DeleteImageCollectionController() {
        this.listen();
    }

    private void listen() {
        ImageCollectionsPopupMenu.INSTANCE.getItemDelete().addActionListener(this);
        GUI.getImageCollectionsList().addKeyListener(this);
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        Object value;
        JXList list = GUI.getImageCollectionsList();
        if (evt.getKeyCode() == 127 && !list.isSelectionEmpty() && (value = list.getSelectedValue()) instanceof String) {
            this.deleteCollection((String)value);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.deleteCollection(ListUtil.getItemString(GUI.getImageCollectionsList(), ImageCollectionsPopupMenu.INSTANCE.getItemIndex()));
    }

    private void deleteCollection(String collectionName) {
        String errorMessage = Bundle.getString(DeleteImageCollectionController.class, "DeleteImageCollectionController.Error.SpecialCollection", ImageCollection.getLocalizedName(collectionName));
        if (!ImageCollectionsUtil.checkIsNotSpecialCollection(collectionName, errorMessage)) {
            return;
        }
        if (collectionName != null) {
            ImageCollectionsUtil.deleteImageCollection(collectionName);
        } else {
            LOGGER.log(Level.WARNING, "Delete photo album: Couldn't find the selected photo album in the repository!");
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }
}

