/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.filesystem;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.repository.RenameTemplatesRepository;
import org.jphototagger.domain.repository.Repository;
import org.jphototagger.domain.repository.event.renametemplates.RenameTemplateDeletedEvent;
import org.jphototagger.domain.repository.event.renametemplates.RenameTemplateInsertedEvent;
import org.jphototagger.domain.repository.event.renametemplates.RenameTemplateUpdatedEvent;
import org.jphototagger.domain.templates.RenameTemplate;
import org.jphototagger.lib.swing.util.ComboBoxUtil;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.app.ui.AppLookAndFeel;
import org.jphototagger.program.module.filesystem.FilenameFormat;
import org.jphototagger.program.module.filesystem.FilenameFormatArray;
import org.jphototagger.program.module.filesystem.FilenameFormatConstantString;
import org.jphototagger.program.module.filesystem.FilenameFormatDate;
import org.jphototagger.program.module.filesystem.FilenameFormatDateTime;
import org.jphototagger.program.module.filesystem.FilenameFormatEmptyString;
import org.jphototagger.program.module.filesystem.FilenameFormatFileName;
import org.jphototagger.program.module.filesystem.FilenameFormatFilenamePostfix;
import org.jphototagger.program.module.filesystem.FilenameFormatNumberSequence;
import org.jphototagger.program.module.filesystem.RenameTemplateUtil;
import org.openide.util.Lookup;

public class RenameTemplatesPanel
extends JPanel
implements ListDataListener {
    private static final long serialVersionUID = 1L;
    private static final String KEY_SEL_TEMPLATE = "RenameDialog.SelectedTemplate";
    private final FilenameFormatArray filenameFormatArray = new FilenameFormatArray();
    private File fileForExampleFilename = new File(Bundle.getString(RenameTemplatesPanel.class, "RenameTemplatesPanel.FileForExampleFilename", new Object[0]));
    private boolean listen;
    private boolean dirty;
    private JButton buttonCheckDirtyDialogCreateNew;
    private JButton buttonCheckDirtyDialogReject;
    private JButton buttonCheckDirtyDialogUpdate;
    private JButton buttonDeleteRenameTemplate;
    private JButton buttonRenameRenameTemplate;
    private JButton buttonSaveRenameTemplate;
    private JButton buttonUpdateRenameTemplate;
    private JDialog checkDirtyDialog;
    private JComboBox<Object> comboBoxAtBegin;
    private JComboBox<Object> comboBoxAtEnd;
    private JComboBox<Object> comboBoxDateDelimiter;
    private JComboBox<Object> comboBoxInTheMiddle;
    private JComboBox<Object> comboBoxRenameTemplates;
    private JLabel labelAfter;
    private JLabel labelAfterFilename;
    private JLabel labelAtBegin;
    private JLabel labelAtEnd;
    private JLabel labelBefore;
    private JLabel labelBeforeFilename;
    private JLabel labelDateDelim;
    private JLabel labelDelim1;
    private JLabel labelDelim2;
    private JLabel labelDirtyConfirmSaveChanges;
    private JLabel labelInTheMid;
    private JLabel labelNumberCount;
    private JLabel labelNumberStepWidth;
    private JLabel labelStartNumber;
    private JPanel panelButtonsRenameTemplates;
    private JPanel panelDateDelimiter;
    private JPanel panelDefineName;
    private JPanel panelDefineNameContents;
    private JPanel panelDirtyButtons;
    private JPanel panelExample;
    private JPanel panelExampleContents;
    private JPanel panelNumbers;
    private JPanel panelNumbersContents;
    private JPanel panelRenameTemplates;
    private JPanel panelRenameTemplatesContents;
    private JSpinner spinnerNumberCount;
    private JSpinner spinnerNumberStepWidth;
    private JSpinner spinnerStartNumber;
    private JTextField textFieldAtBegin;
    private JTextField textFieldAtEnd;
    private JTextField textFieldDelim1;
    private JTextField textFieldDelim2;
    private JTextField textFieldInTheMiddle;

    public RenameTemplatesPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        MnemonicUtil.setMnemonics(this);
        this.initCheckDirtyDialog();
        this.setComboBoxModels();
        this.setRenameTemplate();
        this.setEnabledRenameTemplateButtons();
        this.readProperties();
        this.comboBoxRenameTemplates.getModel().addListDataListener(this);
        this.listen = true;
    }

    private void initCheckDirtyDialog() {
        MnemonicUtil.setMnemonics(this.checkDirtyDialog);
        this.checkDirtyDialog.setIconImages(AppLookAndFeel.getAppIcons());
        this.checkDirtyDialog.setModal(true);
        this.checkDirtyDialog.pack();
        this.checkDirtyDialog.setLocationRelativeTo(this);
    }

    private void setComboBoxModels() {
        this.comboBoxAtBegin.setModel(this.getComboBoxModel());
        this.comboBoxInTheMiddle.setModel(this.getComboBoxModel());
        this.comboBoxAtEnd.setModel(this.getComboBoxModel());
    }

    private ComboBoxModel<Object> getComboBoxModel() {
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>();
        model.addElement(new FilenameFormatConstantString(""));
        model.addElement(new FilenameFormatNumberSequence(1, 1, 4));
        model.addElement(new FilenameFormatFileName());
        model.addElement(new FilenameFormatDate("-"));
        model.addElement(new FilenameFormatDateTime("-"));
        model.addElement(new FilenameFormatEmptyString());
        return model;
    }

    public File getFileForExampleFilename() {
        return this.fileForExampleFilename;
    }

    public void setFileForExampleFilename(File fileForExampleFilename) {
        if (fileForExampleFilename == null) {
            throw new NullPointerException("fileForExampleFilename == null");
        }
        this.fileForExampleFilename = fileForExampleFilename;
        if (fileForExampleFilename.exists()) {
            this.filenameFormatArray.setFile(fileForExampleFilename);
        }
    }

    public FilenameFormatArray getFilenameFormatArray() {
        return this.filenameFormatArray;
    }

    private void readProperties() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        if (prefs != null) {
            prefs.applySelectedIndex(KEY_SEL_TEMPLATE, this.comboBoxRenameTemplates);
        }
    }

    public void showExampleFilename() {
        this.setFileToFilenameFormats(this.fileForExampleFilename);
        this.setFilenameFormatArray(this.fileForExampleFilename);
        this.labelBeforeFilename.setText(this.fileForExampleFilename.getName());
        this.labelAfterFilename.setText(this.filenameFormatArray.format());
    }

    private void saveAsRenameTemplate() {
        this.listen = false;
        RenameTemplate template = this.createTemplate();
        boolean inserted = RenameTemplateUtil.insert(template);
        this.dirty = this.dirty && !inserted;
        this.listen = true;
    }

    private void renameRenameTemplate() {
        this.listen = false;
        Object selItem = this.comboBoxRenameTemplates.getSelectedItem();
        if (selItem instanceof RenameTemplate) {
            boolean renamed = RenameTemplateUtil.rename((RenameTemplate)selItem);
            this.dirty = this.dirty && !renamed;
        }
        this.listen = true;
    }

    private void deleteRenameTemplate() {
        this.listen = false;
        Object selItem = this.comboBoxRenameTemplates.getSelectedItem();
        if (selItem instanceof RenameTemplate) {
            boolean deleted = RenameTemplateUtil.delete((RenameTemplate)selItem);
            boolean bl = this.dirty = this.dirty && !deleted;
            if (deleted) {
                this.setRenameTemplate();
            }
        }
        this.listen = true;
    }

    private void updateRenameTemplate() {
        this.listen = false;
        Object selItem = this.comboBoxRenameTemplates.getSelectedItem();
        if (selItem instanceof RenameTemplate) {
            RenameTemplate template = (RenameTemplate)selItem;
            this.setValuesToTemplate(template);
            RenameTemplateUtil.update(template);
        }
        this.listen = true;
    }

    private void setRenameTemplate() {
        Object selItem = this.comboBoxRenameTemplates.getSelectedItem();
        if (selItem instanceof RenameTemplate) {
            this.setTemplate((RenameTemplate)selItem);
            this.setEnabledConstantTextFields();
            this.showExampleFilename();
        }
    }

    private void setTemplate(RenameTemplate template) {
        this.listen = false;
        this.spinnerStartNumber.getModel().setValue(template.getStartNumber());
        this.spinnerNumberStepWidth.getModel().setValue(template.getStepWidth());
        this.spinnerNumberCount.getModel().setValue(template.getNumberCount());
        ComboBoxUtil.selectString(this.comboBoxDateDelimiter.getModel(), template.getDateDelimiter());
        this.select(template.getFormatClassAtBegin(), this.comboBoxAtBegin);
        this.textFieldDelim1.setText(template.getDelimiter1());
        this.select(template.getFormatClassInTheMiddle(), this.comboBoxInTheMiddle);
        this.textFieldDelim2.setText(template.getDelimiter2());
        this.select(template.getFormatClassAtEnd(), this.comboBoxAtEnd);
        this.textFieldAtBegin.setText(template.getTextAtBegin());
        this.textFieldInTheMiddle.setText(template.getTextInTheMiddle());
        this.textFieldAtEnd.setText(template.getTextAtEnd());
        this.listen = true;
    }

    private void select(Class<?> formatClass, JComboBox<?> comboBox) {
        ComboBoxModel<?> model = comboBox.getModel();
        int size = model.getSize();
        boolean selected = false;
        for (int index = 0; !selected && index < size; ++index) {
            Object element = model.getElementAt(index);
            if (!element.getClass().equals(formatClass)) continue;
            model.setSelectedItem(element);
            selected = true;
        }
    }

    private void setEnabledConstantTextFields() {
        this.textFieldAtBegin.setEditable(this.comboBoxAtBegin.getSelectedItem() instanceof FilenameFormatConstantString);
        this.textFieldInTheMiddle.setEditable(this.comboBoxInTheMiddle.getSelectedItem() instanceof FilenameFormatConstantString);
        this.textFieldAtEnd.setEditable(this.comboBoxAtEnd.getSelectedItem() instanceof FilenameFormatConstantString);
    }

    private RenameTemplate createTemplate() {
        RenameTemplate template = new RenameTemplate();
        this.setValuesToTemplate(template);
        return template;
    }

    private void setValuesToTemplate(RenameTemplate template) {
        template.setStartNumber((Integer)this.spinnerStartNumber.getModel().getValue());
        template.setStepWidth((Integer)this.spinnerNumberStepWidth.getModel().getValue());
        template.setNumberCount((Integer)this.spinnerNumberCount.getModel().getValue());
        template.setDateDelimiter(this.getDateDelimiter());
        template.setFormatClassAtBegin(this.comboBoxAtBegin.getSelectedItem().getClass());
        template.setDelimiter1(this.textFieldDelim1.getText());
        template.setFormatClassInTheMiddle(this.comboBoxInTheMiddle.getSelectedItem().getClass());
        template.setDelimiter2(this.textFieldDelim2.getText());
        template.setFormatClassAtEnd(this.comboBoxAtEnd.getSelectedItem().getClass());
        template.setTextAtBegin(this.textFieldAtBegin.getText());
        template.setTextInTheMiddle(this.textFieldInTheMiddle.getText());
        template.setTextAtEnd(this.textFieldAtEnd.getText());
    }

    private void setEnabledRenameTemplateButtons() {
        Object selValue = this.comboBoxRenameTemplates.getSelectedItem();
        boolean templateSelected = selValue instanceof RenameTemplate;
        this.buttonRenameRenameTemplate.setEnabled(templateSelected);
        this.buttonDeleteRenameTemplate.setEnabled(templateSelected);
        this.buttonUpdateRenameTemplate.setEnabled(templateSelected);
    }

    private void setFileToFilenameFormats(File file) {
        this.setFilenameFormatToSelectedItem(this.comboBoxAtBegin, file, this.textFieldAtBegin.getText().trim());
        this.setFilenameFormatToSelectedItem(this.comboBoxInTheMiddle, file, this.textFieldInTheMiddle.getText().trim());
        this.setFilenameFormatToSelectedItem(this.comboBoxAtEnd, file, this.textFieldAtEnd.getText().trim());
    }

    private void setFilenameFormatToSelectedItem(JComboBox<?> comboBox, File file, String fmt) {
        ComboBoxModel<?> model = comboBox.getModel();
        FilenameFormat format = (FilenameFormat)model.getSelectedItem();
        format.setFile(file);
        format.setFormat(fmt);
        if (format instanceof FilenameFormatNumberSequence) {
            FilenameFormatNumberSequence f = (FilenameFormatNumberSequence)format;
            f.setStart((Integer)this.spinnerStartNumber.getValue());
            f.setIncrement((Integer)this.spinnerNumberStepWidth.getValue());
            f.setCountDigits((Integer)this.spinnerNumberCount.getValue());
        } else if (format instanceof FilenameFormatDate) {
            FilenameFormatDate f = (FilenameFormatDate)format;
            f.setDelimiter(this.getDateDelimiter());
        } else if (format instanceof FilenameFormatDateTime) {
            FilenameFormatDateTime f = (FilenameFormatDateTime)format;
            f.setDelimiter(this.getDateDelimiter());
        }
    }

    private void setFilenameFormatArray(File file) {
        this.filenameFormatArray.clear();
        this.filenameFormatArray.addFormat((FilenameFormat)this.comboBoxAtBegin.getSelectedItem());
        this.filenameFormatArray.addFormat(new FilenameFormatConstantString(this.textFieldDelim1.getText().trim()));
        this.filenameFormatArray.addFormat((FilenameFormat)this.comboBoxInTheMiddle.getSelectedItem());
        this.filenameFormatArray.addFormat(new FilenameFormatConstantString(this.textFieldDelim2.getText().trim()));
        this.filenameFormatArray.addFormat((FilenameFormat)this.comboBoxAtEnd.getSelectedItem());
        FilenameFormatFilenamePostfix postfix = new FilenameFormatFilenamePostfix();
        postfix.setFile(file);
        this.filenameFormatArray.addFormat(postfix);
    }

    private String getDateDelimiter() {
        return (String)this.comboBoxDateDelimiter.getModel().getSelectedItem();
    }

    @Override
    public void intervalAdded(ListDataEvent evt) {
        this.setEnabledRenameTemplateButtons();
    }

    @Override
    public void intervalRemoved(ListDataEvent evt) {
        this.setEnabledRenameTemplateButtons();
    }

    @Override
    public void contentsChanged(ListDataEvent evt) {
        this.setEnabledRenameTemplateButtons();
    }

    public void checkDirty() {
        if (this.dirty) {
            this.buttonCheckDirtyDialogCreateNew.requestFocusInWindow();
            this.checkDirtyDialog.setVisible(true);
            this.checkDirtyDialog.toFront();
            ComponentUtil.parentWindowToFront(this);
        }
    }

    private void startNumberChanged() {
        if (this.listen) {
            this.dirty = true;
            this.showExampleFilename();
        }
    }

    private void numberStepWidthChanged() {
        if (this.listen) {
            this.dirty = true;
            this.showExampleFilename();
        }
    }

    private void numberCountChanged() {
        if (this.listen) {
            this.dirty = true;
            this.showExampleFilename();
        }
    }

    private void dateDelimiterChanged() {
        if (this.listen) {
            this.dirty = true;
            this.showExampleFilename();
            this.setEnabledConstantTextFields();
        }
    }

    private void atBeginChanged() {
        if (this.listen) {
            this.dirty = true;
            this.showExampleFilename();
            this.setEnabledConstantTextFields();
        }
    }

    private void delimiter1Changed() {
        if (this.listen) {
            this.dirty = true;
            this.showExampleFilename();
        }
    }

    private void inTheMiddleChanged() {
        if (this.listen) {
            this.dirty = true;
            this.showExampleFilename();
            this.setEnabledConstantTextFields();
        }
    }

    private void delimiter2Changed() {
        if (this.listen) {
            this.dirty = true;
            this.showExampleFilename();
        }
    }

    private void atEndChanged() {
        if (this.listen) {
            this.dirty = true;
            this.showExampleFilename();
            this.setEnabledConstantTextFields();
        }
    }

    private void textAtBeginChanged() {
        if (this.listen) {
            this.dirty = true;
            this.showExampleFilename();
        }
    }

    private void textInTheMiddleChanged() {
        if (this.listen) {
            this.dirty = true;
            this.showExampleFilename();
        }
    }

    private void textAtEndChanged() {
        if (this.listen) {
            this.dirty = true;
            this.showExampleFilename();
        }
    }

    private void renameTemplateChanged() {
        if (this.listen) {
            this.checkDirty();
            Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
            prefs.setSelectedIndex(KEY_SEL_TEMPLATE, this.comboBoxRenameTemplates);
            this.setRenameTemplate();
            this.setEnabledRenameTemplateButtons();
        }
    }

    private void initComponents() {
        this.checkDirtyDialog = new JDialog();
        this.labelDirtyConfirmSaveChanges = new JLabel();
        this.panelDirtyButtons = new JPanel();
        this.buttonCheckDirtyDialogCreateNew = new JButton();
        this.buttonCheckDirtyDialogUpdate = new JButton();
        this.buttonCheckDirtyDialogReject = new JButton();
        this.panelNumbers = new JPanel();
        this.panelNumbersContents = new JPanel();
        this.labelStartNumber = new JLabel();
        this.spinnerStartNumber = new JSpinner();
        this.labelNumberStepWidth = new JLabel();
        this.spinnerNumberStepWidth = new JSpinner();
        this.labelNumberCount = new JLabel();
        this.spinnerNumberCount = new JSpinner();
        this.panelDateDelimiter = new JPanel();
        this.labelDateDelim = new JLabel();
        this.comboBoxDateDelimiter = new JComboBox();
        this.panelDefineName = new JPanel();
        this.panelDefineNameContents = new JPanel();
        this.labelAtBegin = new JLabel();
        this.labelDelim1 = new JLabel();
        this.labelInTheMid = new JLabel();
        this.labelDelim2 = new JLabel();
        this.labelAtEnd = new JLabel();
        this.comboBoxAtBegin = new JComboBox();
        this.textFieldDelim1 = new JTextField();
        this.comboBoxInTheMiddle = new JComboBox();
        this.textFieldDelim2 = new JTextField();
        this.comboBoxAtEnd = new JComboBox();
        this.textFieldAtBegin = new JTextField();
        this.textFieldInTheMiddle = new JTextField();
        this.textFieldAtEnd = new JTextField();
        this.panelExample = new JPanel();
        this.panelExampleContents = new JPanel();
        this.labelBefore = new JLabel();
        this.labelBeforeFilename = new JLabel();
        this.labelAfter = new JLabel();
        this.labelAfterFilename = new JLabel();
        this.panelRenameTemplates = new JPanel();
        this.panelRenameTemplatesContents = new JPanel();
        this.comboBoxRenameTemplates = new JComboBox();
        this.panelButtonsRenameTemplates = new JPanel();
        this.buttonSaveRenameTemplate = new JButton();
        this.buttonRenameRenameTemplate = new JButton();
        this.buttonDeleteRenameTemplate = new JButton();
        this.buttonUpdateRenameTemplate = new JButton();
        this.checkDirtyDialog.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/filesystem/Bundle");
        this.checkDirtyDialog.setTitle(bundle.getString("RenameTemplatesPanel.checkDirtyDialog.title"));
        this.checkDirtyDialog.getContentPane().setLayout(new GridBagLayout());
        this.labelDirtyConfirmSaveChanges.setText(bundle.getString("RenameTemplatesPanel.labelDirtyConfirmSaveChanges.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.checkDirtyDialog.getContentPane().add((Component)this.labelDirtyConfirmSaveChanges, gridBagConstraints);
        this.panelDirtyButtons.setLayout(new GridBagLayout());
        this.buttonCheckDirtyDialogCreateNew.setText(bundle.getString("RenameTemplatesPanel.buttonCheckDirtyDialogCreateNew.text"));
        this.buttonCheckDirtyDialogCreateNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenameTemplatesPanel.this.buttonCheckDirtyDialogCreateNewActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelDirtyButtons.add((Component)this.buttonCheckDirtyDialogCreateNew, gridBagConstraints);
        this.buttonCheckDirtyDialogUpdate.setText(bundle.getString("RenameTemplatesPanel.buttonCheckDirtyDialogUpdate.text"));
        this.buttonCheckDirtyDialogUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenameTemplatesPanel.this.buttonCheckDirtyDialogUpdateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelDirtyButtons.add((Component)this.buttonCheckDirtyDialogUpdate, gridBagConstraints);
        this.buttonCheckDirtyDialogReject.setText(bundle.getString("RenameTemplatesPanel.buttonCheckDirtyDialogReject.text"));
        this.buttonCheckDirtyDialogReject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenameTemplatesPanel.this.buttonCheckDirtyDialogRejectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelDirtyButtons.add((Component)this.buttonCheckDirtyDialogReject, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.checkDirtyDialog.getContentPane().add((Component)this.panelDirtyButtons, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        this.panelNumbers.setBorder(BorderFactory.createTitledBorder(bundle.getString("RenameTemplatesPanel.panelNumbers.border.title")));
        this.panelNumbers.setLayout(new GridBagLayout());
        this.panelNumbersContents.setLayout(new GridBagLayout());
        this.labelStartNumber.setLabelFor(this.spinnerStartNumber);
        this.labelStartNumber.setText(bundle.getString("RenameTemplatesPanel.labelStartNumber.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelNumbersContents.add((Component)this.labelStartNumber, gridBagConstraints);
        this.spinnerStartNumber.setModel(new SpinnerNumberModel(1, 1, 999999, 1));
        this.spinnerStartNumber.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RenameTemplatesPanel.this.spinnerStartNumberStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelNumbersContents.add((Component)this.spinnerStartNumber, gridBagConstraints);
        this.labelNumberStepWidth.setLabelFor(this.spinnerNumberStepWidth);
        this.labelNumberStepWidth.setText(bundle.getString("RenameTemplatesPanel.labelNumberStepWidth.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelNumbersContents.add((Component)this.labelNumberStepWidth, gridBagConstraints);
        this.spinnerNumberStepWidth.setModel(new SpinnerNumberModel(1, 1, 99, 1));
        this.spinnerNumberStepWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RenameTemplatesPanel.this.spinnerNumberStepWidthStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelNumbersContents.add((Component)this.spinnerNumberStepWidth, gridBagConstraints);
        this.labelNumberCount.setLabelFor(this.spinnerNumberCount);
        this.labelNumberCount.setText(bundle.getString("RenameTemplatesPanel.labelNumberCount.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelNumbersContents.add((Component)this.labelNumberCount, gridBagConstraints);
        this.spinnerNumberCount.setModel(new SpinnerNumberModel(3, 1, 7, 1));
        this.spinnerNumberCount.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RenameTemplatesPanel.this.spinnerNumberCountStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelNumbersContents.add((Component)this.spinnerNumberCount, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelNumbers.add((Component)this.panelNumbersContents, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.panelNumbers, gridBagConstraints);
        this.panelDateDelimiter.setBorder(BorderFactory.createTitledBorder(bundle.getString("RenameTemplatesPanel.panelDateDelimiter.border.title")));
        this.panelDateDelimiter.setLayout(new GridBagLayout());
        this.labelDateDelim.setLabelFor(this.comboBoxDateDelimiter);
        this.labelDateDelim.setText(bundle.getString("RenameTemplatesPanel.labelDateDelim.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelDateDelimiter.add((Component)this.labelDateDelim, gridBagConstraints);
        this.comboBoxDateDelimiter.setModel(new DefaultComboBoxModel<Object>(new Object[]{"", "-", ".", "/"}));
        this.comboBoxDateDelimiter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenameTemplatesPanel.this.comboBoxDateDelimiterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelDateDelimiter.add(this.comboBoxDateDelimiter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelDateDelimiter, gridBagConstraints);
        this.panelDefineName.setBorder(BorderFactory.createTitledBorder(bundle.getString("RenameTemplatesPanel.panelDefineName.border.title")));
        this.panelDefineName.setLayout(new GridBagLayout());
        this.panelDefineNameContents.setLayout(new GridBagLayout());
        this.labelAtBegin.setLabelFor(this.comboBoxAtBegin);
        this.labelAtBegin.setText(bundle.getString("RenameTemplatesPanel.labelAtBegin.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.panelDefineNameContents.add((Component)this.labelAtBegin, gridBagConstraints);
        this.labelDelim1.setLabelFor(this.textFieldDelim1);
        this.labelDelim1.setText(bundle.getString("RenameTemplatesPanel.labelDelim1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.panelDefineNameContents.add((Component)this.labelDelim1, gridBagConstraints);
        this.labelInTheMid.setLabelFor(this.comboBoxInTheMiddle);
        this.labelInTheMid.setText(bundle.getString("RenameTemplatesPanel.labelInTheMid.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.panelDefineNameContents.add((Component)this.labelInTheMid, gridBagConstraints);
        this.labelDelim2.setLabelFor(this.textFieldDelim2);
        this.labelDelim2.setText(bundle.getString("RenameTemplatesPanel.labelDelim2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.panelDefineNameContents.add((Component)this.labelDelim2, gridBagConstraints);
        this.labelAtEnd.setLabelFor(this.comboBoxAtEnd);
        this.labelAtEnd.setText(bundle.getString("RenameTemplatesPanel.labelAtEnd.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.panelDefineNameContents.add((Component)this.labelAtEnd, gridBagConstraints);
        this.comboBoxAtBegin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenameTemplatesPanel.this.comboBoxAtBeginActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelDefineNameContents.add(this.comboBoxAtBegin, gridBagConstraints);
        this.textFieldDelim1.setColumns(1);
        this.textFieldDelim1.setHorizontalAlignment(0);
        this.textFieldDelim1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                RenameTemplatesPanel.this.textFieldDelim1KeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.panelDefineNameContents.add((Component)this.textFieldDelim1, gridBagConstraints);
        this.comboBoxInTheMiddle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenameTemplatesPanel.this.comboBoxInTheMiddleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.panelDefineNameContents.add(this.comboBoxInTheMiddle, gridBagConstraints);
        this.textFieldDelim2.setColumns(1);
        this.textFieldDelim2.setHorizontalAlignment(0);
        this.textFieldDelim2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                RenameTemplatesPanel.this.textFieldDelim2KeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.panelDefineNameContents.add((Component)this.textFieldDelim2, gridBagConstraints);
        this.comboBoxAtEnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenameTemplatesPanel.this.comboBoxAtEndActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.panelDefineNameContents.add(this.comboBoxAtEnd, gridBagConstraints);
        this.textFieldAtBegin.setColumns(15);
        this.textFieldAtBegin.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                RenameTemplatesPanel.this.textFieldAtBeginKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelDefineNameContents.add((Component)this.textFieldAtBegin, gridBagConstraints);
        this.textFieldInTheMiddle.setColumns(15);
        this.textFieldInTheMiddle.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                RenameTemplatesPanel.this.textFieldInTheMiddleKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.panelDefineNameContents.add((Component)this.textFieldInTheMiddle, gridBagConstraints);
        this.textFieldAtEnd.setColumns(15);
        this.textFieldAtEnd.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                RenameTemplatesPanel.this.textFieldAtEndKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.panelDefineNameContents.add((Component)this.textFieldAtEnd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelDefineName.add((Component)this.panelDefineNameContents, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelDefineName, gridBagConstraints);
        this.panelExample.setBorder(BorderFactory.createTitledBorder(bundle.getString("RenameTemplatesPanel.panelExample.border.title")));
        this.panelExample.setLayout(new GridBagLayout());
        this.panelExampleContents.setLayout(new GridBagLayout());
        this.labelBefore.setText(bundle.getString("RenameTemplatesPanel.labelBefore.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.panelExampleContents.add((Component)this.labelBefore, gridBagConstraints);
        this.labelBeforeFilename.setText(" ");
        this.labelBeforeFilename.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelExampleContents.add((Component)this.labelBeforeFilename, gridBagConstraints);
        this.labelAfter.setText(bundle.getString("RenameTemplatesPanel.labelAfter.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelExampleContents.add((Component)this.labelAfter, gridBagConstraints);
        this.labelAfterFilename.setText(" ");
        this.labelAfterFilename.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panelExampleContents.add((Component)this.labelAfterFilename, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelExample.add((Component)this.panelExampleContents, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelExample, gridBagConstraints);
        this.panelRenameTemplates.setBorder(BorderFactory.createTitledBorder(bundle.getString("RenameTemplatesPanel.panelRenameTemplates.border.title")));
        this.panelRenameTemplates.setLayout(new GridBagLayout());
        this.panelRenameTemplatesContents.setLayout(new GridBagLayout());
        this.comboBoxRenameTemplates.setModel(new RenameTemplatesComboBoxModel());
        this.comboBoxRenameTemplates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenameTemplatesPanel.this.comboBoxRenameTemplatesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelRenameTemplatesContents.add(this.comboBoxRenameTemplates, gridBagConstraints);
        this.panelButtonsRenameTemplates.setLayout(new GridLayout(1, 0, 5, 0));
        this.buttonSaveRenameTemplate.setText(bundle.getString("RenameTemplatesPanel.buttonSaveRenameTemplate.text"));
        this.buttonSaveRenameTemplate.setToolTipText(bundle.getString("RenameTemplatesPanel.buttonSaveRenameTemplate.toolTipText"));
        this.buttonSaveRenameTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenameTemplatesPanel.this.buttonSaveRenameTemplateActionPerformed(evt);
            }
        });
        this.panelButtonsRenameTemplates.add(this.buttonSaveRenameTemplate);
        this.buttonRenameRenameTemplate.setText(bundle.getString("RenameTemplatesPanel.buttonRenameRenameTemplate.text"));
        this.buttonRenameRenameTemplate.setToolTipText(bundle.getString("RenameTemplatesPanel.buttonRenameRenameTemplate.toolTipText"));
        this.buttonRenameRenameTemplate.setEnabled(false);
        this.buttonRenameRenameTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenameTemplatesPanel.this.buttonRenameRenameTemplateActionPerformed(evt);
            }
        });
        this.panelButtonsRenameTemplates.add(this.buttonRenameRenameTemplate);
        this.buttonDeleteRenameTemplate.setText(bundle.getString("RenameTemplatesPanel.buttonDeleteRenameTemplate.text"));
        this.buttonDeleteRenameTemplate.setToolTipText(bundle.getString("RenameTemplatesPanel.buttonDeleteRenameTemplate.toolTipText"));
        this.buttonDeleteRenameTemplate.setEnabled(false);
        this.buttonDeleteRenameTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenameTemplatesPanel.this.buttonDeleteRenameTemplateActionPerformed(evt);
            }
        });
        this.panelButtonsRenameTemplates.add(this.buttonDeleteRenameTemplate);
        this.buttonUpdateRenameTemplate.setText(bundle.getString("RenameTemplatesPanel.buttonUpdateRenameTemplate.text"));
        this.buttonUpdateRenameTemplate.setToolTipText(bundle.getString("RenameTemplatesPanel.buttonUpdateRenameTemplate.toolTipText"));
        this.buttonUpdateRenameTemplate.setEnabled(false);
        this.buttonUpdateRenameTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenameTemplatesPanel.this.buttonUpdateRenameTemplateActionPerformed(evt);
            }
        });
        this.panelButtonsRenameTemplates.add(this.buttonUpdateRenameTemplate);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.panelRenameTemplatesContents.add((Component)this.panelButtonsRenameTemplates, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRenameTemplates.add((Component)this.panelRenameTemplatesContents, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelRenameTemplates, gridBagConstraints);
    }

    private void spinnerStartNumberStateChanged(ChangeEvent evt) {
        this.startNumberChanged();
    }

    private void spinnerNumberStepWidthStateChanged(ChangeEvent evt) {
        this.numberStepWidthChanged();
    }

    private void spinnerNumberCountStateChanged(ChangeEvent evt) {
        this.numberCountChanged();
    }

    private void comboBoxDateDelimiterActionPerformed(ActionEvent evt) {
        this.dateDelimiterChanged();
    }

    private void comboBoxAtBeginActionPerformed(ActionEvent evt) {
        this.atBeginChanged();
    }

    private void textFieldAtBeginKeyReleased(KeyEvent evt) {
        this.textAtBeginChanged();
    }

    private void textFieldDelim1KeyReleased(KeyEvent evt) {
        this.delimiter1Changed();
    }

    private void comboBoxInTheMiddleActionPerformed(ActionEvent evt) {
        this.inTheMiddleChanged();
    }

    private void textFieldInTheMiddleKeyReleased(KeyEvent evt) {
        this.textInTheMiddleChanged();
    }

    private void textFieldDelim2KeyReleased(KeyEvent evt) {
        this.delimiter2Changed();
    }

    private void comboBoxAtEndActionPerformed(ActionEvent evt) {
        this.atEndChanged();
    }

    private void textFieldAtEndKeyReleased(KeyEvent evt) {
        this.textAtEndChanged();
    }

    private void comboBoxRenameTemplatesActionPerformed(ActionEvent evt) {
        this.renameTemplateChanged();
    }

    private void buttonSaveRenameTemplateActionPerformed(ActionEvent evt) {
        this.saveAsRenameTemplate();
    }

    private void buttonRenameRenameTemplateActionPerformed(ActionEvent evt) {
        this.renameRenameTemplate();
    }

    private void buttonDeleteRenameTemplateActionPerformed(ActionEvent evt) {
        this.deleteRenameTemplate();
    }

    private void buttonUpdateRenameTemplateActionPerformed(ActionEvent evt) {
        this.updateRenameTemplate();
    }

    private void buttonCheckDirtyDialogCreateNewActionPerformed(ActionEvent evt) {
        this.checkDirtyDialog.setVisible(false);
        this.saveAsRenameTemplate();
    }

    private void buttonCheckDirtyDialogUpdateActionPerformed(ActionEvent evt) {
        this.checkDirtyDialog.setVisible(false);
        this.updateRenameTemplate();
    }

    private void buttonCheckDirtyDialogRejectActionPerformed(ActionEvent evt) {
        this.checkDirtyDialog.setVisible(false);
        this.dirty = false;
    }

    private static class RenameTemplatesComboBoxModel
    extends DefaultComboBoxModel<Object> {
        private static final long serialVersionUID = 1L;
        private final RenameTemplatesRepository renameTemplatesRepo = Lookup.getDefault().lookup(RenameTemplatesRepository.class);

        private RenameTemplatesComboBoxModel() {
            this.addElements();
            this.listen();
        }

        private void listen() {
            AnnotationProcessor.process(this);
        }

        private void addElements() {
            Repository repo = Lookup.getDefault().lookup(Repository.class);
            if (repo == null || !repo.isInit()) {
                return;
            }
            for (RenameTemplate template : this.renameTemplatesRepo.findAllRenameTemplates()) {
                this.addElement(template);
            }
        }

        private void updateTemplate(RenameTemplate template) {
            int index = this.getIndexOf(template);
            if (index >= 0) {
                ((RenameTemplate)this.getElementAt(index)).set(template);
                this.fireContentsChanged(this, index, index);
            }
        }

        private void insertTemplate(RenameTemplate template) {
            this.addElement(template);
            this.setSelectedItem(template);
        }

        private void deleteTemplate(RenameTemplate template) {
            this.removeElement(template);
        }

        @EventSubscriber(eventClass=RenameTemplateDeletedEvent.class)
        public void templateDeleted(RenameTemplateDeletedEvent evt) {
            this.deleteTemplate(evt.getTemplate());
        }

        @EventSubscriber(eventClass=RenameTemplateInsertedEvent.class)
        public void templateInserted(RenameTemplateInsertedEvent evt) {
            this.insertTemplate(evt.getTemplate());
        }

        @EventSubscriber(eventClass=RenameTemplateUpdatedEvent.class)
        public void templateUpdated(RenameTemplateUpdatedEvent evt) {
            this.updateTemplate(evt.getTemplate());
        }
    }
}

