/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.filesystem;

import java.awt.Component;
import org.jphototagger.domain.repository.RenameTemplatesRepository;
import org.jphototagger.domain.templates.RenameTemplate;
import org.jphototagger.lib.swing.InputDialog;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public final class RenameTemplateUtil {
    public static boolean insert(RenameTemplate template) {
        if (template == null) {
            throw new NullPointerException("template == null");
        }
        boolean saved = false;
        String name = RenameTemplateUtil.getUniqueName(null);
        if (name != null) {
            template.setName(name);
            RenameTemplatesRepository repo = Lookup.getDefault().lookup(RenameTemplatesRepository.class);
            saved = repo.saveRenameTemplate(template);
            if (!saved) {
                String message = Bundle.getString(RenameTemplateUtil.class, "RenameTemplateHelper.Error.Insert", template);
                MessageDisplayer.error(null, message);
            }
        }
        return saved;
    }

    public static boolean update(RenameTemplate template) {
        if (template == null) {
            throw new NullPointerException("template == null");
        }
        RenameTemplatesRepository repo = Lookup.getDefault().lookup(RenameTemplatesRepository.class);
        boolean updated = repo.updateRenameTemplate(template);
        if (!updated) {
            String message = Bundle.getString(RenameTemplateUtil.class, "RenameTemplateHelper.Error.Update", template);
            MessageDisplayer.error(null, message);
        }
        return updated;
    }

    public static boolean rename(RenameTemplate template) {
        if (template == null) {
            throw new NullPointerException("template == null");
        }
        String name = RenameTemplateUtil.getUniqueName(template.getName());
        if (name != null) {
            template.setName(name);
            return RenameTemplateUtil.update(template);
        }
        return false;
    }

    public static boolean delete(RenameTemplate template) {
        if (template == null) {
            throw new NullPointerException("template == null");
        }
        Component parentComponent = null;
        String message = Bundle.getString(RenameTemplateUtil.class, "RenameTemplateHelper.Confirm.Delete", template);
        RenameTemplatesRepository repo = Lookup.getDefault().lookup(RenameTemplatesRepository.class);
        boolean deleted = false;
        if (MessageDisplayer.confirmYesNo(parentComponent, message)) {
            boolean bl = deleted = repo.deleteRenameTemplate(template.getName()) >= 1;
            if (!deleted) {
                message = Bundle.getString(RenameTemplateUtil.class, "RenameTemplateHelper.Error.Delete", template);
                MessageDisplayer.error(null, message);
            }
        }
        return deleted;
    }

    private static String getUniqueName(String suggest) {
        String info = Bundle.getString(RenameTemplateUtil.class, "RenameTemplateHelper.Input.Name", new Object[0]);
        String input = suggest == null ? "" : suggest;
        InputDialog dlg = new InputDialog(info, input);
        dlg.setVisible(true);
        RenameTemplatesRepository repo = Lookup.getDefault().lookup(RenameTemplatesRepository.class);
        boolean unique = false;
        while (!unique && dlg.isAccepted()) {
            String name = dlg.getInput().trim();
            if (name.isEmpty()) {
                return null;
            }
            unique = !repo.existsRenameTemplate(name);
            Component parentComponent = null;
            String message = Bundle.getString(RenameTemplateUtil.class, "RenameTemplateHelper.Confirm.InputUniqueName", name);
            if (!unique && MessageDisplayer.confirmYesNo(parentComponent, message)) {
                dlg.setVisible(true);
                continue;
            }
            if (unique) {
                return name;
            }
            return null;
        }
        return null;
    }

    private RenameTemplateUtil() {
    }
}

