/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.filesystem;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileSystemView;
import org.bushe.swing.event.EventBus;
import org.jphototagger.api.file.event.FileRenamedEvent;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.preferences.PreferencesHints;
import org.jphototagger.domain.metadata.xmp.XmpSidecarFileResolver;
import org.jphototagger.domain.repository.SaveOrUpdate;
import org.jphototagger.domain.thumbnails.ThumbnailProvider;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.ImagePanel;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.StringUtil;
import org.jphototagger.program.module.filesystem.FilenameFormatArray;
import org.jphototagger.program.module.filesystem.FilesystemRepositoryUpdater;
import org.jphototagger.program.module.filesystem.RenameTemplatesPanel;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class RenameDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(RenameDialog.class.getName());
    private final FilenameFormatArray filenameFormatArray;
    private final XmpSidecarFileResolver xmpSidecarFileResolver = Lookup.getDefault().lookup(XmpSidecarFileResolver.class);
    private final ThumbnailProvider thumbnailProvider = Lookup.getDefault().lookup(ThumbnailProvider.class);
    private List<File> files = new ArrayList<File>();
    private int fileIndex = 0;
    private boolean lockClose = false;
    private boolean cancel = false;
    private JButton buttonNextFile;
    private JButton buttonRename;
    private JButton buttonRenameViaTemplate;
    private JLabel labelDirectory;
    private JLabel labelFromName;
    private JLabel labelFromNamePrompt;
    private JLabel labelInfoTemplatesTab;
    private JLabel labelToNamePrompt;
    private JPanel panelContents;
    private JPanel panelFolderPathname;
    private JPanel panelFromNameToName;
    private JPanel panelInputName;
    private JPanel panelRenameButtons;
    private RenameTemplatesPanel panelRenameTemplates;
    private JPanel panelTemplatesContents;
    private ImagePanel panelThumbnail;
    private JPanel panelThumbnailBorder;
    private JTabbedPane tabbedPane;
    private JTextField textFieldToName;

    public RenameDialog() {
        super((Frame)GUI.getAppFrame(), true);
        this.initComponents();
        this.filenameFormatArray = this.panelRenameTemplates.getFilenameFormatArray();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.setHelpPage();
        MnemonicUtil.setMnemonics(this);
    }

    private void setHelpPage() {
        this.setHelpPageUrl(Bundle.getString(RenameDialog.class, "RenameDialog.HelpPage", new Object[0]));
    }

    public void selectRenameViaTemplatesTab(boolean select) {
        this.tabbedPane.setEnabledAt(1, select);
        if (!select) {
            this.tabbedPane.setSelectedComponent(this.panelInputName);
        }
    }

    public void setImageFiles(List<File> imageFiles) {
        if (imageFiles == null) {
            throw new NullPointerException("imageFiles == null");
        }
        this.files = new ArrayList<File>(imageFiles);
    }

    public synchronized void notifyFileSystemListeners(File fromImageFile, File toImageFile) {
        if (fromImageFile == null) {
            throw new NullPointerException("fromImageFile == null");
        }
        if (toImageFile == null) {
            throw new NullPointerException("toImageFile == null");
        }
        FileRenamedEvent evt = new FileRenamedEvent(this, fromImageFile, toImageFile);
        evt.putProperty(SaveOrUpdate.class, SaveOrUpdate.NONE);
        EventBus.publish(evt);
    }

    private boolean renameImageFile(File fromImageFile, File toImageFile) {
        boolean renamed = fromImageFile.renameTo(toImageFile);
        if (renamed) {
            this.renameXmpFileOfImageFile(fromImageFile, toImageFile);
            FilesystemRepositoryUpdater.moveFile(fromImageFile, toImageFile);
        }
        return renamed;
    }

    private void renameXmpFileOfImageFile(File fromImageFile, File toImageFile) {
        File fromXmpFile = this.xmpSidecarFileResolver.getXmpSidecarFileOrNullIfNotExists(fromImageFile);
        if (fromXmpFile != null) {
            File toXmpFile = this.xmpSidecarFileResolver.suggestXmpSidecarFile(toImageFile);
            if (toXmpFile.exists() && !toXmpFile.delete()) {
                LOGGER.log(Level.WARNING, "XMP file ''{0}'' couldn''t be deleted!", toXmpFile);
            }
            if (!fromXmpFile.renameTo(toXmpFile)) {
                LOGGER.log(Level.WARNING, "XMP file ''{0}'' couldn''t be renamed to ''{1}''!", new Object[]{fromXmpFile, toXmpFile});
            }
        }
    }

    private void refreshThumbnailsPanel(int countRenamed) {
        if (countRenamed > 0) {
            GUI.refreshThumbnailsPanel();
        }
    }

    private void renameViaTemplate() {
        this.lockClose = true;
        this.tabbedPane.setEnabledAt(1, false);
        int countRenamed = 0;
        int size = this.files.size();
        for (int i = 0; !this.cancel && i < size; ++i) {
            this.fileIndex = i;
            File oldFile = this.files.get(i);
            String parent = oldFile.getParent();
            this.filenameFormatArray.setFile(oldFile);
            File newFile = new File((parent == null ? "" : parent + File.separator) + this.filenameFormatArray.format());
            if (this.checkNewFileDoesNotExist(newFile) && this.renameImageFile(oldFile, newFile)) {
                this.files.set(i, newFile);
                this.notifyFileSystemListeners(oldFile, newFile);
                ++countRenamed;
            } else {
                this.errorMessageNotRenamed(oldFile.getAbsolutePath());
            }
            this.filenameFormatArray.notifyNext();
        }
        this.refreshThumbnailsPanel(countRenamed);
        this.lockClose = false;
        this.setVisible(false);
        this.dispose();
    }

    private void renameViaInput() {
        this.lockClose = true;
        int countRenamed = 0;
        if (this.fileIndex >= 0 && this.fileIndex < this.files.size()) {
            File oldFile = this.files.get(this.fileIndex);
            if (this.canRenameViaInput()) {
                File newFile = this.getNewFileViaInput();
                if (this.renameImageFile(oldFile, newFile)) {
                    this.files.set(this.fileIndex, newFile);
                    this.notifyFileSystemListeners(oldFile, newFile);
                    this.setCurrentFilenameToInputPanel();
                    this.focusTextFieldToName();
                    ++countRenamed;
                } else {
                    this.errorMessageNotRenamed(oldFile.getAbsolutePath());
                }
                this.setNextFileViaInput();
            }
        }
        this.refreshThumbnailsPanel(countRenamed);
        this.lockClose = false;
    }

    private void setNextFileViaInput() {
        ++this.fileIndex;
        if (this.fileIndex > this.files.size() - 1) {
            this.setVisible(false);
            this.dispose();
        } else {
            this.setCurrentFilenameToInputPanel();
            this.focusTextFieldToName();
        }
    }

    private File getNewFileViaInput() {
        String directory = this.labelDirectory.getText();
        return new File(directory + (directory.isEmpty() ? "" : File.separator) + this.textFieldToName.getText().trim());
    }

    private boolean canRenameViaInput() {
        File oldFile = this.files.get(this.fileIndex);
        File newFile = this.getNewFileViaInput();
        return this.checkNewFilenameIsDefined() && this.checkNamesNotEquals(oldFile, newFile) && this.checkNewFileDoesNotExist(newFile);
    }

    private boolean checkNewFilenameIsDefined() {
        boolean defined;
        String input = this.textFieldToName.getText().trim();
        boolean bl = defined = !input.isEmpty();
        if (!defined) {
            String message = Bundle.getString(RenameDialog.class, "RenameDialog.Error.InvalidInput", new Object[0]);
            MessageDisplayer.error(this, message);
        }
        return defined;
    }

    private boolean checkNamesNotEquals(File oldFile, File newFile) {
        boolean equals = newFile.getAbsolutePath().equals(oldFile.getAbsolutePath());
        if (equals) {
            String message = Bundle.getString(RenameDialog.class, "RenameDialog.Error.FilenamesEquals", new Object[0]);
            MessageDisplayer.error(this, message);
            this.textFieldToName.requestFocusInWindow();
        }
        return !equals;
    }

    private boolean checkNewFileDoesNotExist(File file) {
        boolean exists = file.exists();
        if (exists) {
            String message = Bundle.getString(RenameDialog.class, "RenameDialog.Error.NewFileExists", file.getName());
            MessageDisplayer.error(this, message);
            this.textFieldToName.requestFocusInWindow();
        }
        return !exists;
    }

    private void setCurrentFilenameToInputPanel() {
        if (this.fileIndex >= 0 && this.fileIndex < this.files.size()) {
            File file = this.files.get(this.fileIndex);
            this.setDirectoryNameLabel(file);
            this.labelFromName.setText(file.getName());
            this.textFieldToName.setText(file.getName());
            this.setThumbnail(file);
        }
    }

    private void focusTextFieldToName() {
        this.textFieldToName.requestFocus();
        this.setInToNameCursorBevoreSuffix();
    }

    private void setInToNameCursorBevoreSuffix() {
        String toName = this.textFieldToName.getText();
        int indexOfSuffixDelimiter = toName.lastIndexOf(46);
        if (indexOfSuffixDelimiter > 0) {
            this.textFieldToName.setCaretPosition(indexOfSuffixDelimiter);
            this.textFieldToName.setSelectionStart(0);
            this.textFieldToName.setSelectionEnd(indexOfSuffixDelimiter);
        }
    }

    private void setDirectoryNameLabel(File file) {
        File dir = file.getParentFile();
        this.labelDirectory.setText(dir.getAbsolutePath());
        this.labelDirectory.setIcon(FileSystemView.getFileSystemView().getSystemIcon(dir));
    }

    private synchronized void setThumbnail(File file) {
        Image thumbnail = this.thumbnailProvider.getThumbnail(file);
        if (thumbnail != null) {
            this.panelThumbnail.setImage(thumbnail);
            this.panelThumbnail.repaint();
        }
    }

    private void errorMessageNotRenamed(String filename) {
        String message = Bundle.getString(RenameDialog.class, "RenameDialog.Confirm.RenameNextFile", filename);
        if (!MessageDisplayer.confirmYesNo(this, message)) {
            this.cancel = true;
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.setExampleFilenameToRenameTemplatesPanel();
            this.readProperties();
        } else {
            Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
            prefs.setComponent(this, new PreferencesHints(PreferencesHints.Option.SET_TABBED_PANE_CONTENT));
        }
        super.setVisible(visible);
    }

    private void setExampleFilenameToRenameTemplatesPanel() {
        if (!this.files.isEmpty()) {
            this.panelRenameTemplates.setFileForExampleFilename(this.files.get(0));
            this.panelRenameTemplates.showExampleFilename();
        }
    }

    private void readProperties() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.applyComponentSettings(this, new PreferencesHints(PreferencesHints.Option.SET_TABBED_PANE_CONTENT));
        if (!this.tabbedPane.isEnabledAt(1)) {
            this.tabbedPane.setSelectedComponent(this.panelInputName);
        }
    }

    private void inputNamePanelIsShown() {
        if (this.panelInputName.isVisible()) {
            this.setCurrentFilenameToInputPanel();
            this.focusTextFieldToName();
        }
    }

    @Override
    protected void escape() {
        if (!this.lockClose) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void closeWindowIfNotLocked() {
        if (!this.lockClose) {
            this.panelRenameTemplates.checkDirty();
            this.setVisible(false);
            this.dispose();
        }
    }

    private void initComponents() {
        this.panelContents = new JPanel();
        this.labelInfoTemplatesTab = new JLabel();
        this.tabbedPane = new JTabbedPane();
        this.panelInputName = new JPanel();
        this.panelFolderPathname = new JPanel();
        this.labelDirectory = new JLabel();
        this.panelThumbnailBorder = new JPanel();
        this.panelThumbnail = new ImagePanel();
        this.panelFromNameToName = new JPanel();
        this.labelFromNamePrompt = new JLabel();
        this.labelFromName = new JLabel();
        this.labelToNamePrompt = new JLabel();
        this.textFieldToName = new JTextField();
        this.panelRenameButtons = new JPanel();
        this.buttonNextFile = new JButton();
        this.buttonRename = new JButton();
        this.panelTemplatesContents = new JPanel();
        this.panelRenameTemplates = new RenameTemplatesPanel();
        this.buttonRenameViaTemplate = new JButton();
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/filesystem/Bundle");
        this.setTitle(bundle.getString("RenameDialog.title"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                RenameDialog.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.panelContents.setLayout(new GridBagLayout());
        this.labelInfoTemplatesTab.setText(bundle.getString("RenameDialog.labelInfoTemplatesTab.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.panelContents.add((Component)this.labelInfoTemplatesTab, gridBagConstraints);
        this.panelInputName.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                RenameDialog.this.panelInputNameComponentShown(evt);
            }
        });
        this.panelInputName.setLayout(new GridBagLayout());
        this.panelFolderPathname.setBorder(BorderFactory.createTitledBorder(bundle.getString("RenameDialog.panelFolderPathname.border.title")));
        this.panelFolderPathname.setLayout(new GridBagLayout());
        this.labelDirectory.setForeground(new Color(0, 175, 0));
        this.labelDirectory.setText(" ");
        this.labelDirectory.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFolderPathname.add((Component)this.labelDirectory, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.panelInputName.add((Component)this.panelFolderPathname, gridBagConstraints);
        this.panelThumbnailBorder.setBorder(BorderFactory.createBevelBorder(1));
        this.panelThumbnailBorder.setMinimumSize(new Dimension(260, 260));
        this.panelThumbnailBorder.setPreferredSize(new Dimension(260, 260));
        this.panelThumbnailBorder.setLayout(new GridBagLayout());
        this.panelThumbnail.setEnabled(false);
        this.panelThumbnail.setFocusable(false);
        this.panelThumbnail.setPreferredSize(new Dimension(250, 250));
        GroupLayout panelThumbnailLayout = new GroupLayout(this.panelThumbnail);
        this.panelThumbnail.setLayout(panelThumbnailLayout);
        panelThumbnailLayout.setHorizontalGroup(panelThumbnailLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 246, Short.MAX_VALUE));
        panelThumbnailLayout.setVerticalGroup(panelThumbnailLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 246, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelThumbnailBorder.add((Component)this.panelThumbnail, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 15, 0, 0);
        this.panelInputName.add((Component)this.panelThumbnailBorder, gridBagConstraints);
        this.panelFromNameToName.setLayout(new GridBagLayout());
        this.labelFromNamePrompt.setText(bundle.getString("RenameDialog.labelFromNamePrompt.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelFromNameToName.add((Component)this.labelFromNamePrompt, gridBagConstraints);
        this.labelFromName.setForeground(new Color(0, 175, 0));
        this.labelFromName.setText(" ");
        this.labelFromName.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelFromNameToName.add((Component)this.labelFromName, gridBagConstraints);
        this.labelToNamePrompt.setLabelFor(this.textFieldToName);
        this.labelToNamePrompt.setText(bundle.getString("RenameDialog.labelToNamePrompt.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelFromNameToName.add((Component)this.labelToNamePrompt, gridBagConstraints);
        this.textFieldToName.setColumns(25);
        this.textFieldToName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RenameDialog.this.textFieldToNameKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panelFromNameToName.add((Component)this.textFieldToName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.panelInputName.add((Component)this.panelFromNameToName, gridBagConstraints);
        this.panelRenameButtons.setLayout(new GridLayout(1, 0, 5, 0));
        this.buttonNextFile.setText(bundle.getString("RenameDialog.buttonNextFile.text"));
        this.buttonNextFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenameDialog.this.buttonNextFileActionPerformed(evt);
            }
        });
        this.panelRenameButtons.add(this.buttonNextFile);
        this.buttonRename.setText(bundle.getString("RenameDialog.buttonRename.text"));
        this.buttonRename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenameDialog.this.buttonRenameActionPerformed(evt);
            }
        });
        this.panelRenameButtons.add(this.buttonRename);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        this.panelInputName.add((Component)this.panelRenameButtons, gridBagConstraints);
        this.tabbedPane.addTab(bundle.getString("RenameDialog.panelInputName.TabConstraints.tabTitle"), this.panelInputName);
        this.panelTemplatesContents.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panelTemplatesContents.add((Component)this.panelRenameTemplates, gridBagConstraints);
        this.buttonRenameViaTemplate.setText(bundle.getString("RenameDialog.buttonRenameViaTemplate.text"));
        this.buttonRenameViaTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenameDialog.this.buttonRenameViaTemplateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.panelTemplatesContents.add((Component)this.buttonRenameViaTemplate, gridBagConstraints);
        this.tabbedPane.addTab(bundle.getString("RenameDialog.panelTemplatesContents.TabConstraints.tabTitle"), this.panelTemplatesContents);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelContents.add((Component)this.tabbedPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.panelContents, gridBagConstraints);
        this.pack();
    }

    private void buttonRenameActionPerformed(ActionEvent evt) {
        this.renameViaInput();
    }

    private void buttonNextFileActionPerformed(ActionEvent evt) {
        this.setNextFileViaInput();
    }

    private void buttonRenameViaTemplateActionPerformed(ActionEvent evt) {
        this.renameViaTemplate();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeWindowIfNotLocked();
    }

    private void panelInputNameComponentShown(ComponentEvent evt) {
        this.inputNamePanelIsShown();
    }

    private void textFieldToNameKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && StringUtil.hasContent(this.textFieldToName.getText())) {
            this.renameViaInput();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RenameDialog dialog = new RenameDialog();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

