/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.filesystem;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.file.CopyMoveFilesOptions;
import org.jphototagger.api.file.event.FileMovedEvent;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressListener;
import org.jphototagger.domain.event.listener.ProgressListenerSupport;
import org.jphototagger.domain.metadata.xmp.XmpSidecarFileResolver;
import org.jphototagger.lib.api.LookAndFeelChangedEvent;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.io.SourceTargetFile;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.DirectoryChooser;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.SelectRootFilesPanel;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.filesystem.FileSystemMove;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class MoveFilesToDirectoryDialog
extends Dialog
implements ProgressListener {
    private static final long serialVersionUID = 1L;
    private static final String KEY_TARGET_DIRECTORY = "org.jphototagger.program.view.dialogs.MoveFilesToDirectoryDialog.TargetDirectory";
    private final List<File> movedFiles = new ArrayList<File>();
    private final transient ProgressListenerSupport pListenerSupport = new ProgressListenerSupport();
    private final XmpSidecarFileResolver xmpSidecarFileResolver = Lookup.getDefault().lookup(XmpSidecarFileResolver.class);
    private transient FileSystemMove fileSystemMove;
    private boolean runs = false;
    private boolean cancel = false;
    private List<File> sourceFiles;
    private File targetDirectory = new File("");
    private boolean moveIfVisible = false;
    private JButton buttonCancel;
    private JButton buttonChooseDirectory;
    private JButton buttonStart;
    private JLabel labelCurrentFilename;
    private JLabel labelDirectoryName;
    private JLabel labelInfo;
    private JLabel labelInfoCurrentFilename;
    private JLabel labelInfoIsThread;
    private JProgressBar progressBar;

    public MoveFilesToDirectoryDialog() {
        super((Frame)GUI.getAppFrame(), false);
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.setHelpPage();
        MnemonicUtil.setMnemonics(this);
        AnnotationProcessor.process(this);
    }

    private void setHelpPage() {
        this.setHelpPageUrl(Bundle.getString(MoveFilesToDirectoryDialog.class, "MoveFilesToDirectoryDialog.HelpPage", new Object[0]));
    }

    public void addProgressListener(ProgressListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        this.pListenerSupport.add(listener);
    }

    private void checkClosing() {
        if (this.runs) {
            String message = Bundle.getString(MoveFilesToDirectoryDialog.class, "MoveFilesToDirectoryDialog.Error.CancelBeforeClose", new Object[0]);
            MessageDisplayer.error(this, message);
        } else {
            this.setVisible(false);
        }
    }

    private void addXmpFiles() {
        ArrayList<File> xmpFiles = new ArrayList<File>();
        for (File sourceFile : this.sourceFiles) {
            File xmpFile = this.xmpSidecarFileResolver.getXmpSidecarFileOrNullIfNotExists(sourceFile);
            if (xmpFile == null) continue;
            xmpFiles.add(xmpFile);
        }
        this.sourceFiles.addAll(xmpFiles);
    }

    private void reset() {
        this.runs = false;
        this.cancel = false;
        this.movedFiles.clear();
    }

    private void start() {
        this.reset();
        CopyMoveFilesOptions copyMoveFilesOptions = this.getCopyMoveFilesOptions();
        boolean renameIfTargetFileExists = copyMoveFilesOptions.equals((Object)CopyMoveFilesOptions.RENAME_SOURCE_FILE_IF_TARGET_FILE_EXISTS);
        this.fileSystemMove = new FileSystemMove(this.sourceFiles, this.targetDirectory, renameIfTargetFileExists);
        this.fileSystemMove.addProgressListener(this);
        Thread thread = new Thread((Runnable)this.fileSystemMove, this.getMoveThreadName());
        thread.start();
        this.runs = true;
    }

    private CopyMoveFilesOptions getCopyMoveFilesOptions() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.CopyMoveFiles") ? CopyMoveFilesOptions.parseInteger(prefs.getInt("UserSettings.CopyMoveFiles")) : CopyMoveFilesOptions.CONFIRM_OVERWRITE;
    }

    private String getMoveThreadName() {
        return "JPhotoTagger: Moving files to directory " + this.targetDirectory.getAbsolutePath();
    }

    private void cancel() {
        this.cancel = true;
    }

    private void chooseTargetDirectory() {
        List<File> hideRootFiles = SelectRootFilesPanel.readPersistentRootFiles("UserSettings.HideRootFilesFromDirectoriesTab");
        DirectoryChooser dlg = new DirectoryChooser((Frame)GUI.getAppFrame(), this.targetDirectory, hideRootFiles, this.getDirChooserOptionShowHiddenDirs());
        dlg.setPreferencesKey("MoveToDirectoriesDialog.DirChooser");
        dlg.setVisible(true);
        this.toFront();
        if (dlg.isAccepted()) {
            List<File> files = dlg.getSelectedDirectories();
            if (files.size() > 0) {
                this.targetDirectory = files.get(0);
                if (this.targetDirectory.canWrite()) {
                    this.labelDirectoryName.setText(this.targetDirectory.getAbsolutePath());
                    this.setIconToLabelTargetDirectory();
                    this.buttonStart.setEnabled(true);
                } else {
                    String message = Bundle.getString(MoveFilesToDirectoryDialog.class, "MoveFilesToDirectoryDialog.TargetDirNotWritable", this.targetDirectory);
                    MessageDisplayer.error(this, message);
                }
            }
        } else {
            File dir = new File(this.labelDirectoryName.getText().trim());
            this.buttonStart.setEnabled(FileUtil.isWritableDirectory(dir));
        }
    }

    private DirectoryChooser.Option getDirChooserOptionShowHiddenDirs() {
        return this.isAcceptHiddenDirectories() ? DirectoryChooser.Option.DISPLAY_HIDDEN_DIRECTORIES : DirectoryChooser.Option.NO_OPTION;
    }

    private boolean isAcceptHiddenDirectories() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.IsAcceptHiddenDirectories") ? prefs.getBoolean("UserSettings.IsAcceptHiddenDirectories") : false;
    }

    private void setIconToLabelTargetDirectory() {
        File dir = new File(this.labelDirectoryName.getText());
        if (dir.isDirectory()) {
            this.labelDirectoryName.setIcon(FileSystemView.getFileSystemView().getSystemIcon(dir));
        }
    }

    public void setSourceFiles(List<File> sourceFiles) {
        if (sourceFiles == null) {
            throw new NullPointerException("sourceFiles == null");
        }
        this.sourceFiles = new ArrayList<File>(sourceFiles);
        this.addXmpFiles();
        Collections.sort(this.sourceFiles);
    }

    public void setTargetDirectory(File directory) {
        if (directory == null) {
            throw new NullPointerException("directory == null");
        }
        if (directory.exists()) {
            this.targetDirectory = directory;
            this.buttonStart.setEnabled(false);
            this.buttonChooseDirectory.setEnabled(false);
            this.moveIfVisible = true;
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            if (this.moveIfVisible) {
                this.start();
            } else {
                this.setTargetDirectory();
            }
        } else {
            this.targetDirectoryToSettings();
        }
        super.setVisible(visible);
    }

    private void setTargetDirectory() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        this.targetDirectory = new File(prefs.getString(KEY_TARGET_DIRECTORY));
        if (this.targetDirectory.exists()) {
            this.labelDirectoryName.setText(this.targetDirectory.getAbsolutePath());
            this.setIconToLabelTargetDirectory();
            this.buttonStart.setEnabled(true);
        }
    }

    private void targetDirectoryToSettings() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.setString(KEY_TARGET_DIRECTORY, this.targetDirectory.getAbsolutePath());
    }

    private void checkCancel(ProgressEvent evt) {
        if (this.cancel) {
            evt.setCancel(true);
        }
    }

    @Override
    public void progressStarted(final ProgressEvent evt) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                MoveFilesToDirectoryDialog.this.buttonStart.setEnabled(false);
                MoveFilesToDirectoryDialog.this.buttonCancel.setEnabled(true);
                MoveFilesToDirectoryDialog.this.progressBar.setMinimum(evt.getMinimum());
                MoveFilesToDirectoryDialog.this.progressBar.setMaximum(evt.getMaximum());
                MoveFilesToDirectoryDialog.this.progressBar.setValue(evt.getValue());
                MoveFilesToDirectoryDialog.this.checkCancel(evt);
                MoveFilesToDirectoryDialog.this.pListenerSupport.notifyStarted(evt);
            }
        });
    }

    @Override
    public void progressPerformed(final ProgressEvent evt) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                MoveFilesToDirectoryDialog.this.progressBar.setValue(evt.getValue());
                Object info = evt.getInfo();
                if (info instanceof SourceTargetFile) {
                    SourceTargetFile sourceTargetFile = (SourceTargetFile)info;
                    String filename = sourceTargetFile.getSourceFile().getAbsolutePath();
                    MoveFilesToDirectoryDialog.this.labelCurrentFilename.setText(filename);
                }
                MoveFilesToDirectoryDialog.this.checkCancel(evt);
                MoveFilesToDirectoryDialog.this.pListenerSupport.notifyPerformed(evt);
            }
        });
    }

    @Override
    public void progressEnded(final ProgressEvent evt) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                MoveFilesToDirectoryDialog.this.progressBar.setValue(evt.getValue());
                MoveFilesToDirectoryDialog.this.buttonCancel.setEnabled(true);
                MoveFilesToDirectoryDialog.this.buttonStart.setEnabled(true);
                MoveFilesToDirectoryDialog.this.runs = false;
                MoveFilesToDirectoryDialog.this.fileSystemMove = null;
                GUI.getThumbnailsPanel().removeFiles(MoveFilesToDirectoryDialog.this.movedFiles);
                MoveFilesToDirectoryDialog.this.removeMovedFiles();
                MoveFilesToDirectoryDialog.this.pListenerSupport.notifyEnded(evt);
                MoveFilesToDirectoryDialog.this.setVisible(false);
            }
        });
    }

    private void removeMovedFiles() {
        for (File movedFile : this.movedFiles) {
            this.sourceFiles.remove(movedFile);
        }
        this.buttonStart.setEnabled(this.sourceFiles.size() > 0);
    }

    @Override
    protected void escape() {
        this.checkClosing();
    }

    @EventSubscriber(eventClass=FileMovedEvent.class)
    public void fileMoved(FileMovedEvent evt) {
        File sourceFile = evt.getSourceFile();
        this.movedFiles.add(sourceFile);
    }

    @EventSubscriber(eventClass=LookAndFeelChangedEvent.class)
    public void lookAndFeelChanged(LookAndFeelChangedEvent evt) {
        SwingUtilities.updateComponentTreeUI(this);
    }

    private void initComponents() {
        this.labelInfo = new JLabel();
        this.buttonChooseDirectory = new JButton();
        this.labelDirectoryName = new JLabel();
        this.progressBar = new JProgressBar();
        this.labelInfoCurrentFilename = new JLabel();
        this.labelCurrentFilename = new JLabel();
        this.labelInfoIsThread = new JLabel();
        this.buttonCancel = new JButton();
        this.buttonStart = new JButton();
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/filesystem/Bundle");
        this.setTitle(bundle.getString("MoveFilesToDirectoryDialog.title"));
        this.setName("Form");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MoveFilesToDirectoryDialog.this.formWindowClosing(evt);
            }
        });
        this.labelInfo.setText(bundle.getString("MoveFilesToDirectoryDialog.labelInfo.text"));
        this.labelInfo.setName("labelInfo");
        this.buttonChooseDirectory.setText(bundle.getString("MoveFilesToDirectoryDialog.buttonChooseDirectory.text"));
        this.buttonChooseDirectory.setName("buttonChooseDirectory");
        this.buttonChooseDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MoveFilesToDirectoryDialog.this.buttonChooseDirectoryActionPerformed(evt);
            }
        });
        this.labelDirectoryName.setBorder(BorderFactory.createEtchedBorder());
        this.labelDirectoryName.setName("labelDirectoryName");
        this.progressBar.setName("progressBar");
        this.labelInfoCurrentFilename.setText(bundle.getString("MoveFilesToDirectoryDialog.labelInfoCurrentFilename.text"));
        this.labelInfoCurrentFilename.setName("labelInfoCurrentFilename");
        this.labelCurrentFilename.setForeground(new Color(0, 0, 255));
        this.labelCurrentFilename.setName("labelCurrentFilename");
        this.labelInfoIsThread.setForeground(new Color(0, 0, 255));
        this.labelInfoIsThread.setText(bundle.getString("MoveFilesToDirectoryDialog.labelInfoIsThread.text"));
        this.labelInfoIsThread.setName("labelInfoIsThread");
        this.buttonCancel.setText(bundle.getString("MoveFilesToDirectoryDialog.buttonCancel.text"));
        this.buttonCancel.setEnabled(false);
        this.buttonCancel.setName("buttonCancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MoveFilesToDirectoryDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonStart.setText(bundle.getString("MoveFilesToDirectoryDialog.buttonStart.text"));
        this.buttonStart.setEnabled(false);
        this.buttonStart.setName("buttonStart");
        this.buttonStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MoveFilesToDirectoryDialog.this.buttonStartActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.labelInfo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 132, Short.MAX_VALUE).addComponent(this.buttonChooseDirectory)).addComponent(this.labelDirectoryName, -1, 622, Short.MAX_VALUE).addComponent(this.progressBar, -1, 622, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.labelInfoIsThread).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 132, Short.MAX_VALUE).addComponent(this.buttonCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonStart)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.labelInfoCurrentFilename).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelCurrentFilename, -1, 524, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.buttonChooseDirectory).addComponent(this.labelInfo)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelDirectoryName, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.progressBar, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelCurrentFilename).addComponent(this.labelInfoCurrentFilename)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonStart).addComponent(this.buttonCancel).addComponent(this.labelInfoIsThread)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(1, this.labelCurrentFilename, this.labelInfo);
        this.pack();
    }

    private void buttonStartActionPerformed(ActionEvent evt) {
        this.start();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void buttonChooseDirectoryActionPerformed(ActionEvent evt) {
        this.chooseTargetDirectory();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.checkClosing();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MoveFilesToDirectoryDialog dialog = new MoveFilesToDirectoryDialog();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

