/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.filesystem;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jphototagger.api.concurrent.Cancelable;
import org.jphototagger.api.file.CopyMoveFilesOptions;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressHandle;
import org.jphototagger.api.progress.ProgressHandleFactory;
import org.jphototagger.api.progress.ProgressListener;
import org.jphototagger.domain.filefilter.FileFilterUtil;
import org.jphototagger.domain.metadata.xmp.XmpSidecarFileResolver;
import org.jphototagger.lib.io.SourceTargetFile;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.factory.ControllerFactory;
import org.jphototagger.program.module.filesystem.FilesystemCopy;
import org.jphototagger.program.module.filesystem.MoveFilesController;
import org.jphototagger.program.resource.GUI;
import org.jphototagger.xmp.XmpMetadata;
import org.openide.util.Lookup;

public final class FilesystemImageUtil {
    private static final XmpSidecarFileResolver XMP_SIDECAR_FILE_RESOLVER = Lookup.getDefault().lookup(XmpSidecarFileResolver.class);

    private FilesystemImageUtil() {
    }

    public static void copyImageFiles(List<File> sourceFiles, File targetDirectory, ConfirmOverwrite confirm) {
        if (sourceFiles == null) {
            throw new NullPointerException("sourceFiles == null");
        }
        if (targetDirectory == null) {
            throw new NullPointerException("targetDirectory == null");
        }
        if (confirm == null) {
            throw new NullPointerException("confirm == null");
        }
        String message = Bundle.getString(FilesystemImageUtil.class, "FilesystemImageUtil.Confirm.Copy", sourceFiles.size(), targetDirectory.getAbsolutePath());
        if (confirm.yes() && !FilesystemImageUtil.confirmFileAction(message)) {
            return;
        }
        FilesystemCopy fileSystemCopy = new FilesystemCopy(FilesystemImageUtil.getFiles(sourceFiles, targetDirectory), FilesystemImageUtil.getCopyMoveFilesOptions());
        fileSystemCopy.setCopyListenerShallUpdateRepository(false);
        fileSystemCopy.addProgressListener(new CopyProgressListener(fileSystemCopy));
        Thread thread = new Thread((Runnable)fileSystemCopy, "JPhotoTagger: Copying files to directories");
        thread.start();
    }

    private static CopyMoveFilesOptions getCopyMoveFilesOptions() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.CopyMoveFiles") ? CopyMoveFilesOptions.parseInteger(prefs.getInt("UserSettings.CopyMoveFiles")) : CopyMoveFilesOptions.CONFIRM_OVERWRITE;
    }

    private static List<SourceTargetFile> getFiles(Collection<? extends File> sourceFiles, File targetDirectory) {
        ArrayList<SourceTargetFile> sourceTargetFiles = new ArrayList<SourceTargetFile>();
        for (File file : sourceFiles) {
            File targetFile = new File(targetDirectory + File.separator + file.getName());
            FilesystemImageUtil.addXmp(file, targetDirectory, sourceTargetFiles);
            sourceTargetFiles.add(new SourceTargetFile(file, targetFile));
        }
        return sourceTargetFiles;
    }

    private static void addXmp(File imageFile, File targetDirectory, List<SourceTargetFile> sourceTargetFiles) {
        File sidecarFile = XMP_SIDECAR_FILE_RESOLVER.getXmpSidecarFileOrNullIfNotExists(imageFile);
        if (sidecarFile != null) {
            File sourceSidecarFile = sidecarFile;
            File targetSidecarFile = new File(targetDirectory + File.separator + sourceSidecarFile.getName());
            sourceTargetFiles.add(new SourceTargetFile(sourceSidecarFile, targetSidecarFile));
        }
    }

    public static void moveImageFiles(List<File> sourceFiles, File targetDirectory, ConfirmOverwrite confirm) {
        String message = Bundle.getString(FilesystemImageUtil.class, "FilesystemImageUtil.Confirm.Move", sourceFiles.size(), targetDirectory.getAbsolutePath());
        if (confirm.yes() && !FilesystemImageUtil.confirmFileAction(message)) {
            return;
        }
        MoveFilesController ctrl = ControllerFactory.INSTANCE.getController(MoveFilesController.class);
        if (ctrl != null) {
            ctrl.moveFilesWithoutConfirm(FilesystemImageUtil.addSidecarFiles(sourceFiles), targetDirectory);
        }
    }

    private static boolean confirmFileAction(String message) {
        return MessageDisplayer.confirmYesNo(null, message);
    }

    public static List<File> addSidecarFiles(List<File> imageFiles) {
        if (imageFiles == null) {
            throw new NullPointerException("imageFiles == null");
        }
        ArrayList<File> files = new ArrayList<File>(imageFiles.size() * 2);
        for (File imageFile : imageFiles) {
            if (imageFile == null || !FileFilterUtil.isImageFile(imageFile)) continue;
            files.add(imageFile);
            File sidecarFile = XMP_SIDECAR_FILE_RESOLVER.getXmpSidecarFileOrNullIfNotExists(imageFile);
            if (sidecarFile == null) continue;
            files.add(sidecarFile);
        }
        return files;
    }

    public static boolean checkImageEditable(File imageFile) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        if (!XmpMetadata.canWriteSidecarFileForImageFile(imageFile)) {
            String message = Bundle.getString(FilesystemImageUtil.class, "FilesystemImageUtil.Error.WriteSidecarFile", imageFile.getParentFile());
            MessageDisplayer.error(null, message);
            return false;
        }
        return true;
    }

    private static class CopyProgressListener
    implements ProgressListener,
    Cancelable {
        private final FilesystemCopy fileSystemCopy;
        private ProgressHandle progressHandle;

        private CopyProgressListener(FilesystemCopy fileSystemCopy) {
            this.fileSystemCopy = fileSystemCopy;
        }

        @Override
        public void progressStarted(ProgressEvent evt) {
            this.progressHandle = Lookup.getDefault().lookup(ProgressHandleFactory.class).createProgressHandle(this);
            this.progressHandle.progressStarted(evt);
        }

        @Override
        public void progressPerformed(ProgressEvent evt) {
            this.progressHandle.progressPerformed(evt);
        }

        @Override
        public void progressEnded(ProgressEvent evt) {
            this.progressHandle.progressEnded();
            GUI.refreshThumbnailsPanel();
        }

        @Override
        public void cancel() {
            this.fileSystemCopy.cancel();
        }
    }

    public static enum ConfirmOverwrite {
        YES,
        NO;


        public boolean yes() {
            return this.equals((Object)YES);
        }

        public static ConfirmOverwrite fromBoolean(boolean b) {
            return b ? YES : NO;
        }
    }
}

