/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.filesystem;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.EventBus;
import org.jphototagger.api.file.CopyMoveFilesOptions;
import org.jphototagger.api.file.event.FileCopiedEvent;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressListener;
import org.jphototagger.domain.FileCopyService;
import org.jphototagger.domain.event.listener.ProgressListenerSupport;
import org.jphototagger.domain.filefilter.FileFilterUtil;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.metadata.xmp.XmpSidecarFileResolver;
import org.jphototagger.domain.repository.SaveOrUpdate;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.io.SourceTargetFile;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.filesystem.FilesystemRepositoryUpdater;
import org.jphototagger.xmp.XmpMetadata;
import org.openide.util.Lookup;

public final class FilesystemCopy
implements Runnable,
FileCopyService {
    private final ProgressListenerSupport progressListeners = new ProgressListenerSupport();
    private final List<File> errorFiles = new ArrayList<File>();
    private final XmpSidecarFileResolver xmpSidecarFileResolver = Lookup.getDefault().lookup(XmpSidecarFileResolver.class);
    private final CopyMoveFilesOptions options;
    private final List<SourceTargetFile> sourceTargetFiles;
    private volatile boolean cancel;
    private volatile boolean copyListenerShallUpdateRepository = true;
    private static final Logger LOGGER = Logger.getLogger(FilesystemCopy.class.getName());

    public FilesystemCopy() {
        this.sourceTargetFiles = Collections.emptyList();
        this.options = CopyMoveFilesOptions.CONFIRM_OVERWRITE;
    }

    public FilesystemCopy(Collection<? extends SourceTargetFile> sourceTargetFiles, CopyMoveFilesOptions options) {
        if (sourceTargetFiles == null) {
            throw new NullPointerException("sourceTargetFiles == null");
        }
        if (options == null) {
            throw new NullPointerException("options == null");
        }
        this.sourceTargetFiles = new ArrayList<SourceTargetFile>(sourceTargetFiles);
        this.options = options;
    }

    @Override
    public synchronized void cancel() {
        this.cancel = true;
    }

    @Override
    public void addProgressListener(ProgressListener progessListener) {
        this.progressListeners.add(progessListener);
    }

    @Override
    public void removeProgressListener(ProgressListener progessListener) {
        this.progressListeners.add(progessListener);
    }

    @Override
    public void run() {
        this.notifyStart();
        int size = this.sourceTargetFiles.size();
        for (int i = 0; !this.cancel && i < size; ++i) {
            SourceTargetFile sourceTargetFile = this.sourceTargetFiles.get(i);
            if (this.checkDifferent(sourceTargetFile) && this.checkOverwrite(sourceTargetFile)) {
                try {
                    File sourceFile = sourceTargetFile.getSourceFile();
                    File targetFile = this.getTargetFile(sourceTargetFile);
                    Object userObject = sourceTargetFile.getUserObject();
                    sourceTargetFile = new SourceTargetFile(sourceFile, targetFile);
                    sourceTargetFile.setUserObject(userObject);
                    this.logCopyFile(sourceFile, targetFile);
                    FileUtil.copyFile(sourceFile, targetFile);
                    this.copyXmp(sourceTargetFile);
                    if (!this.copyListenerShallUpdateRepository && FileFilterUtil.isImageFile(targetFile)) {
                        FilesystemRepositoryUpdater.insertFile(targetFile);
                    }
                    this.publishCopied(sourceFile, targetFile);
                }
                catch (Throwable t) {
                    Logger.getLogger(FilesystemCopy.class.getName()).log(Level.SEVERE, null, t);
                    this.errorFiles.add(sourceTargetFile.getSourceFile());
                }
            }
            this.notifyPerformed(i + 1, sourceTargetFile);
        }
        this.notifyEnded();
    }

    private void publishCopied(File sourceFile, File targetFile) {
        FileCopiedEvent evt = new FileCopiedEvent(this, sourceFile, targetFile);
        evt.putProperty(SaveOrUpdate.class, this.copyListenerShallUpdateRepository ? SaveOrUpdate.OUT_OF_DATE : SaveOrUpdate.NONE);
        EventBus.publish(evt);
    }

    private void copyXmp(SourceTargetFile sourceTargetFile) {
        File targetFile;
        Object userObject = sourceTargetFile.getUserObject();
        if (userObject instanceof Xmp && !this.xmpSidecarFileResolver.hasXmpSidecarFile(targetFile = sourceTargetFile.getTargetFile())) {
            File xmpFile = this.xmpSidecarFileResolver.suggestXmpSidecarFile(targetFile);
            Xmp xmp = (Xmp)userObject;
            if (!xmp.isEmpty() && !XmpMetadata.writeXmpToSidecarFile(xmp, xmpFile)) {
                LOGGER.log(Level.WARNING, "XMP sidecar file for ''{0}'' couldn''t be written!", targetFile);
            }
        }
    }

    private File getTargetFile(SourceTargetFile files) {
        File targetFile = files.getTargetFile();
        if (this.options.equals((Object)CopyMoveFilesOptions.RENAME_SOURCE_FILE_IF_TARGET_FILE_EXISTS) && targetFile.exists()) {
            targetFile = FileUtil.getNotExistingFile(targetFile);
        }
        return targetFile;
    }

    private void logCopyFile(File sourceFile, File targetFile) {
        LOGGER.log(Level.INFO, "Copy file ''{0}'' to ''{1}''", new Object[]{sourceFile, targetFile});
    }

    private synchronized void notifyStart() {
        ProgressEvent evt = new ProgressEvent.Builder().source(this).minimum(0).maximum(this.sourceTargetFiles.size()).value(0).stringPainted(true).stringToPaint(Bundle.getString(FilesystemCopy.class, "FilesystemCopy.ProgressBarString", new Object[0])).build();
        this.progressListeners.notifyStarted(evt);
    }

    private synchronized void notifyPerformed(int value, SourceTargetFile sourceTargetFile) {
        ProgressEvent evt = new ProgressEvent.Builder().source(this).minimum(0).maximum(this.sourceTargetFiles.size()).value(value).stringPainted(true).stringToPaint(Bundle.getString(FilesystemCopy.class, "FilesystemCopy.ProgressBarString", new Object[0])).info(sourceTargetFile).build();
        this.progressListeners.notifyPerformed(evt);
    }

    private synchronized void notifyEnded() {
        ProgressEvent evt = new ProgressEvent.Builder().source(this).minimum(0).maximum(this.sourceTargetFiles.size()).value(this.sourceTargetFiles.size()).info(this.errorFiles).build();
        this.progressListeners.notifyEnded(evt);
    }

    private boolean checkOverwrite(SourceTargetFile sourceTargetFile) {
        boolean force = this.options.equals((Object)CopyMoveFilesOptions.FORCE_OVERWRITE);
        boolean renameExisting = this.options.equals((Object)CopyMoveFilesOptions.RENAME_SOURCE_FILE_IF_TARGET_FILE_EXISTS);
        if (force || renameExisting) {
            return true;
        }
        File target = sourceTargetFile.getTargetFile();
        if (target.exists()) {
            String message = Bundle.getString(FilesystemCopy.class, "FilesystemCopy.Confirm.OverwriteExisting", sourceTargetFile.getTargetFile(), sourceTargetFile.getSourceFile());
            MessageDisplayer.ConfirmAction action = MessageDisplayer.confirmYesNoCancel(null, message);
            if (action.equals((Object)MessageDisplayer.ConfirmAction.CANCEL)) {
                this.cancel();
            } else {
                return action.equals((Object)MessageDisplayer.ConfirmAction.YES);
            }
        }
        return true;
    }

    private boolean checkDifferent(SourceTargetFile sourceTargetFile) {
        if (sourceTargetFile.getSourceFile().equals(sourceTargetFile.getTargetFile())) {
            String message = Bundle.getString(FilesystemCopy.class, "FilesystemCopy.Error.FilesAreEquals", sourceTargetFile.getSourceFile());
            MessageDisplayer.error(null, message);
            return false;
        }
        return true;
    }

    @Override
    public FileCopyService createInstance(Collection<? extends SourceTargetFile> sourceTargetFiles, CopyMoveFilesOptions options) {
        if (sourceTargetFiles == null) {
            throw new NullPointerException("sourceTargetFiles == null");
        }
        if (options == null) {
            throw new NullPointerException("options == null");
        }
        return new FilesystemCopy(sourceTargetFiles, options);
    }

    @Override
    public void copyInNewThread() {
        Thread thread = new Thread(this);
        thread.setName("JPhotoTagger: Copy Files");
        thread.start();
    }

    @Override
    public void copyWaitForTermination() {
        this.run();
    }

    @Override
    public void setCopyListenerShallUpdateRepository(boolean update) {
        this.copyListenerShallUpdateRepository = update;
    }

    public boolean getCopyListenerShallUpdateRepository() {
        return this.copyListenerShallUpdateRepository;
    }
}

