/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.filesystem;

import java.text.DecimalFormat;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.filesystem.FilenameFormat;

public final class FilenameFormatNumberSequence
extends FilenameFormat {
    private int current;
    private int start;
    private int increment;
    private int countDigits;
    private DecimalFormat decimalFormat;

    public FilenameFormatNumberSequence() {
        this(1, 1, 4);
    }

    public FilenameFormatNumberSequence(int start, int increment, int countDigits) {
        this.start = start;
        this.increment = increment;
        this.countDigits = countDigits;
        this.current = start;
        this.createDecimalFormat();
    }

    private void createDecimalFormat() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.countDigits; ++i) {
            sb.append("0");
        }
        this.decimalFormat = new DecimalFormat(sb.toString());
    }

    public int getCountDigits() {
        return this.countDigits;
    }

    public void setCountDigits(int countDigits) {
        this.countDigits = countDigits;
        this.createDecimalFormat();
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setIncrement(int increment) {
        this.increment = increment;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
        this.current = start;
    }

    @Override
    public void next() {
        this.current += this.increment;
    }

    @Override
    public String format() {
        return this.decimalFormat.format(this.current);
    }

    public String toString() {
        return Bundle.getString(FilenameFormatNumberSequence.class, "FilenameFormatNumberSequence.String", new Object[0]);
    }
}

