/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.filesystem;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jphototagger.domain.metadata.exif.Exif;
import org.jphototagger.domain.metadata.exif.ExifUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.filesystem.FilenameFormat;

public final class FilenameFormatDate
extends FilenameFormat {
    private String delimiter;
    private String name;

    public FilenameFormatDate() {
        this("-");
    }

    public FilenameFormatDate(String delimiter) {
        if (delimiter == null) {
            throw new NullPointerException("delimiter == null");
        }
        this.delimiter = delimiter;
    }

    public void setDelimiter(String delimiter) {
        if (delimiter == null) {
            throw new NullPointerException("delimiter == null");
        }
        this.delimiter = delimiter;
    }

    @Override
    public String format() {
        this.formatDate(this.getFile());
        return this.name;
    }

    private void formatDate(File file) {
        Exif exif = ExifUtil.readExifPreferCached(file);
        if (exif == null) {
            this.setFromFilesystem(file);
        } else {
            java.sql.Date date = exif.getDateTimeOriginal();
            if (date == null) {
                this.setFromFilesystem(file);
            } else {
                this.formatDate(new Date(date.getTime()));
            }
        }
    }

    private void setFromFilesystem(File file) {
        this.formatDate(new Date(file.lastModified()));
    }

    private void formatDate(Date date) {
        this.name = new SimpleDateFormat("yyyy" + this.delimiter + "MM" + this.delimiter + "dd").format(date);
    }

    public String toString() {
        return Bundle.getString(FilenameFormatDate.class, "FilenameFormatDate.String", new Object[0]);
    }
}

