/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.filesystem;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jphototagger.domain.templates.RenameTemplate;
import org.jphototagger.program.module.filesystem.FilenameFormat;
import org.jphototagger.program.module.filesystem.FilenameFormatConstantString;
import org.jphototagger.program.module.filesystem.FilenameFormatDate;
import org.jphototagger.program.module.filesystem.FilenameFormatDateTime;
import org.jphototagger.program.module.filesystem.FilenameFormatFilenamePostfix;
import org.jphototagger.program.module.filesystem.FilenameFormatNumberSequence;

public final class FilenameFormatArray {
    private final List<FilenameFormat> formats = new ArrayList<FilenameFormat>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFormat(FilenameFormat format) {
        if (format == null) {
            throw new NullPointerException("format == null");
        }
        List<FilenameFormat> list = this.formats;
        synchronized (list) {
            this.formats.add(format);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyNext() {
        List<FilenameFormat> list = this.formats;
        synchronized (list) {
            for (FilenameFormat format : this.formats) {
                format.next();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<FilenameFormat> list = this.formats;
        synchronized (list) {
            this.formats.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format() {
        StringBuilder sb = new StringBuilder();
        List<FilenameFormat> list = this.formats;
        synchronized (list) {
            for (FilenameFormat format : this.formats) {
                sb.append(format.format());
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        List<FilenameFormat> list = this.formats;
        synchronized (list) {
            for (FilenameFormat format : this.formats) {
                format.setFile(file);
            }
        }
    }

    public static FilenameFormatArray createFormatArrayFromRenameTemplate(RenameTemplate template) throws InstantiationException, IllegalAccessException {
        if (template == null) {
            throw new NullPointerException("template == null");
        }
        FilenameFormatArray array = new FilenameFormatArray();
        FilenameFormat formatAtBegin = FilenameFormatArray.createFormat(template.getFormatClassAtBegin(), template);
        formatAtBegin.setFormat(template.getTextAtBegin());
        array.addFormat(formatAtBegin);
        array.addFormat(new FilenameFormatConstantString(template.getDelimiter1()));
        FilenameFormat formatInTheMiddle = FilenameFormatArray.createFormat(template.getFormatClassInTheMiddle(), template);
        formatInTheMiddle.setFormat(template.getTextInTheMiddle());
        array.addFormat(formatInTheMiddle);
        array.addFormat(new FilenameFormatConstantString(template.getDelimiter2()));
        FilenameFormat formatAtEnd = FilenameFormatArray.createFormat(template.getFormatClassAtEnd(), template);
        formatAtEnd.setFormat(template.getTextAtEnd());
        array.addFormat(formatAtEnd);
        array.addFormat(new FilenameFormatFilenamePostfix());
        return array;
    }

    private static FilenameFormat createFormat(Class<?> clazz, RenameTemplate template) throws InstantiationException, IllegalAccessException {
        Object instance = clazz.newInstance();
        if (!(instance instanceof FilenameFormat)) {
            throw new IllegalStateException("Illegal filename format class: " + clazz);
        }
        FilenameFormat format = (FilenameFormat)instance;
        if (format instanceof FilenameFormatNumberSequence) {
            FilenameFormatNumberSequence f = (FilenameFormatNumberSequence)format;
            f.setStart(template.getStartNumber());
            f.setIncrement(template.getStepWidth());
            f.setCountDigits(template.getNumberCount());
        } else if (format instanceof FilenameFormatDate) {
            FilenameFormatDate f = (FilenameFormatDate)format;
            f.setDelimiter(template.getDateDelimiter());
        } else if (format instanceof FilenameFormatDateTime) {
            FilenameFormatDateTime f = (FilenameFormatDateTime)format;
            f.setDelimiter(template.getDateDelimiter());
        }
        return format;
    }
}

