/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.filesystem;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bushe.swing.event.EventBus;
import org.jphototagger.api.concurrent.Cancelable;
import org.jphototagger.api.file.event.FileMovedEvent;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.domain.filefilter.FileFilterUtil;
import org.jphototagger.domain.repository.SaveOrUpdate;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.io.SourceTargetFile;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.filesystem.FileSystem;
import org.jphototagger.program.module.filesystem.FilesystemRepositoryUpdater;

public final class FileSystemMove
extends FileSystem
implements Runnable,
Cancelable {
    private final List<File> sourceFiles = new ArrayList<File>();
    private final List<File> targetFiles = new ArrayList<File>();
    private final boolean renameIfTargetFileExists;
    private volatile boolean moveListenerShallUpdateRepository = true;
    private volatile boolean cancel;
    private final File targetDirectory;

    public FileSystemMove(List<File> sourceFiles, File targetDirectory, boolean renameIfTargetFileExists) {
        if (sourceFiles == null) {
            throw new NullPointerException("sourceFiles == null");
        }
        if (targetDirectory == null) {
            throw new NullPointerException("targetDirectory == null");
        }
        this.sourceFiles.clear();
        this.sourceFiles.addAll(sourceFiles);
        this.targetDirectory = targetDirectory;
        this.renameIfTargetFileExists = renameIfTargetFileExists;
        this.setTargetFiles();
    }

    public FileSystemMove(List<File> sourceFiles, List<File> targetFiles, boolean renameIfTargetFileExists) {
        if (sourceFiles == null) {
            throw new NullPointerException("sourceFiles == null");
        }
        if (targetFiles == null) {
            throw new NullPointerException("targetFiles == null");
        }
        this.targetDirectory = new File("");
        this.sourceFiles.clear();
        this.targetFiles.clear();
        this.sourceFiles.addAll(sourceFiles);
        this.targetFiles.addAll(targetFiles);
        this.renameIfTargetFileExists = renameIfTargetFileExists;
    }

    private void setTargetFiles() {
        this.targetFiles.clear();
        for (File sourceFile : this.sourceFiles) {
            this.targetFiles.add(new File(this.targetDirectory.getAbsolutePath() + File.separator + sourceFile.getName()));
        }
    }

    @Override
    public void run() {
        int fileCount = this.sourceFiles.size();
        ProgressEvent progressEvent = this.createProgressEvent(fileCount);
        this.notifyProgressListenerStarted(progressEvent);
        for (int i = 0; !this.cancel && !progressEvent.isCancel() && i < fileCount; ++i) {
            File targetFile;
            File sourceFile = this.sourceFiles.get(i);
            if (this.checkExists(sourceFile, targetFile = this.getTargetFile(this.targetFiles.get(i)))) {
                boolean moved = sourceFile.renameTo(targetFile);
                if (!this.moveListenerShallUpdateRepository && FileFilterUtil.isImageFile(sourceFile) && FileFilterUtil.isImageFile(targetFile)) {
                    FilesystemRepositoryUpdater.moveFile(sourceFile, targetFile);
                }
                this.notifyMoved(moved, sourceFile, targetFile);
            }
            progressEvent.setValue(i + 1);
            progressEvent.setInfo(new SourceTargetFile(sourceFile, targetFile));
            this.notifyProgressListenerPerformed(progressEvent);
        }
        this.notifyProgressListenerEnded(progressEvent);
    }

    private ProgressEvent createProgressEvent(int fileCount) {
        return new ProgressEvent.Builder().source(this).minimum(0).maximum(fileCount).value(0).info("").build();
    }

    private File getTargetFile(File file) {
        File targetFile = file;
        if (this.renameIfTargetFileExists && targetFile.exists()) {
            targetFile = FileUtil.getNotExistingFile(targetFile);
        }
        return targetFile;
    }

    private boolean checkExists(File sourceFile, File targetFile) {
        boolean exists = targetFile.exists();
        if (exists) {
            String message = Bundle.getString(FileSystemMove.class, "FileSystemMove.Error.TargetExists", sourceFile, targetFile);
            MessageDisplayer.error(null, message);
        }
        return !exists;
    }

    private void notifyMoved(boolean moved, File sourceFile, File targetFile) {
        if (moved) {
            FileMovedEvent evt = new FileMovedEvent(this, sourceFile, targetFile);
            evt.putProperty(SaveOrUpdate.class, this.moveListenerShallUpdateRepository ? SaveOrUpdate.OUT_OF_DATE : SaveOrUpdate.NONE);
            EventBus.publish(evt);
        } else {
            String message = Bundle.getString(FileSystemMove.class, "FileSystemMove.Error", sourceFile, targetFile);
            MessageDisplayer.error(null, message);
        }
    }

    public void setMoveListenerShallUpdateRepository(boolean update) {
        this.moveListenerShallUpdateRepository = update;
    }

    public boolean getMoveListenerShallUpdateRepository() {
        return this.moveListenerShallUpdateRepository;
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }
}

