/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.filesystem;

import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.EventBus;
import org.jphototagger.api.file.event.FileRenamedEvent;
import org.jphototagger.domain.filefilter.FileFilterUtil;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.io.TreeFileSystemDirectories;
import org.openide.util.Lookup;

public final class FileSystemDirectories {
    private static final Logger LOGGER = Logger.getLogger(FileSystemDirectories.class.getName());
    private static final ImageFilesRepository repo = Lookup.getDefault().lookup(ImageFilesRepository.class);

    private FileSystemDirectories() {
    }

    public static boolean delete(File directory) {
        if (directory == null) {
            throw new NullPointerException("directory == null");
        }
        if (directory.isDirectory() && TreeFileSystemDirectories.confirmDelete(directory.getName())) {
            try {
                List<File> imageFiles = FileFilterUtil.getImageFilesOfDirAndSubDirs(directory);
                FileUtil.deleteDirectoryRecursive(directory);
                int count = repo.deleteImageFiles(imageFiles);
                FileSystemDirectories.logDelete(directory, count);
                return true;
            }
            catch (Throwable t) {
                TreeFileSystemDirectories.errorMessageDelete(directory.getName());
                Logger.getLogger(FileSystemDirectories.class.getName()).log(Level.SEVERE, null, t);
            }
        }
        return false;
    }

    public static File rename(File directory) {
        File newDirectory;
        String newDirectoryName;
        if (directory == null) {
            throw new NullPointerException("directory == null");
        }
        if (directory.isDirectory() && (newDirectoryName = TreeFileSystemDirectories.getNewName(directory)) != null && !newDirectoryName.trim().isEmpty() && TreeFileSystemDirectories.checkDoesNotExist(newDirectory = new File(directory.getParentFile(), newDirectoryName))) {
            try {
                if (directory.renameTo(newDirectory)) {
                    String oldParentDir = directory.getAbsolutePath() + File.separator;
                    String newParentDir = newDirectory.getAbsolutePath() + File.separator;
                    int dbCount = repo.updateRenameFilenamesStartingWith(oldParentDir, newParentDir, null);
                    EventBus.publish(new FileRenamedEvent(FileSystemDirectories.class, directory, newDirectory));
                    FileSystemDirectories.logInfoRenamed(directory, newDirectory, dbCount);
                    return newDirectory;
                }
            }
            catch (Throwable t) {
                Logger.getLogger(FileSystemDirectories.class.getName()).log(Level.SEVERE, null, t);
            }
        }
        return null;
    }

    private static void logDelete(File directory, int countDeletedInRepository) {
        LOGGER.log(Level.INFO, "Deleted folder ''{0}''. {1} image files deleted from the repository", new Object[]{directory, countDeletedInRepository});
    }

    private static void logInfoRenamed(File directory, File newDirectory, int countRenamedInRepository) {
        LOGGER.log(Level.INFO, "Folder ''{0}'' was renamed to ''{1}''. Updated {2} image files in the repository.", new Object[]{directory, newDirectory, countRenamedInRepository});
    }
}

