/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.filesystem;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.List;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.program.module.filesystem.DeleteFiles;
import org.jphototagger.program.module.filesystem.DeleteOption;
import org.jphototagger.program.module.thumbnails.ThumbnailsPanel;
import org.jphototagger.program.module.thumbnails.ThumbnailsPopupMenu;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class DeleteFilesController
implements ActionListener,
KeyListener {
    private final ImageFilesRepository repo = Lookup.getDefault().lookup(ImageFilesRepository.class);

    public DeleteFilesController() {
        this.listen();
    }

    private void listen() {
        ThumbnailsPopupMenu.INSTANCE.getItemFileSystemDeleteFiles().addActionListener(this);
        GUI.getThumbnailsPanel().addKeyListener(this);
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            if (GUI.getThumbnailsPanel().getOriginOfDisplayedThumbnails().isFilesOfAnImageCollection()) {
                return;
            }
            this.delete();
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.delete();
    }

    private void delete() {
        ThumbnailsPanel tnPanel = GUI.getThumbnailsPanel();
        if (tnPanel.isAFileSelected() && tnPanel.getOriginOfDisplayedThumbnails().canDeleteImagesFromFileSystem()) {
            EventQueueUtil.invokeInDispatchThread(new Runnable(){

                @Override
                public void run() {
                    DeleteFilesController.this.deleteSelectedFiles();
                }
            });
        }
    }

    private void deleteSelectedFiles() {
        List<File> deletedImageFiles = DeleteFiles.delete(GUI.getSelectedImageFiles(), DeleteOption.CONFIRM_DELETE, DeleteOption.MESSAGES_ON_FAILURES);
        if (!deletedImageFiles.isEmpty()) {
            this.repo.deleteImageFiles(deletedImageFiles);
            GUI.getThumbnailsPanel().removeFiles(deletedImageFiles);
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }
}

