/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.filesystem;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.EventBus;
import org.jphototagger.api.file.event.FileDeletedEvent;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.filesystem.DeleteOption;
import org.jphototagger.xmp.ImageFileSidecarFile;
import org.jphototagger.xmp.XmpMetadata;

public final class DeleteFiles {
    private static final Logger LOGGER = Logger.getLogger(DeleteFiles.class.getName());

    public static List<File> delete(List<File> imageFiles, DeleteOption ... options) {
        if (imageFiles == null) {
            throw new NullPointerException("imageFiles == null");
        }
        if (options == null) {
            throw new NullPointerException("options == null");
        }
        ArrayList<File> deletedImageFiles = new ArrayList<File>(imageFiles.size());
        List<DeleteOption> optionList = Arrays.asList(options);
        if (DeleteFiles.confirmDelete(optionList)) {
            List<ImageFileSidecarFile> imageFilesWithSidecarFiles = XmpMetadata.getImageFilesWithSidecarFiles(imageFiles);
            for (ImageFileSidecarFile imageFileSidecarFile : imageFilesWithSidecarFiles) {
                File imageFile = imageFileSidecarFile.getImageFile();
                if (imageFile.delete()) {
                    EventBus.publish(new FileDeletedEvent(DeleteFiles.class, imageFile));
                    DeleteFiles.deleteSidecarFile(imageFileSidecarFile.getSidecarFile(), optionList);
                    deletedImageFiles.add(imageFile);
                    continue;
                }
                DeleteFiles.errorMessageDelete(imageFile, optionList);
            }
        }
        return deletedImageFiles;
    }

    private static void deleteSidecarFile(File sidecarFile, List<DeleteOption> options) {
        if (sidecarFile != null && !sidecarFile.delete()) {
            DeleteFiles.errorMessageDelete(sidecarFile, options);
        }
    }

    private static void errorMessageDelete(File file, List<DeleteOption> options) {
        if (options.contains((Object)DeleteOption.MESSAGES_ON_FAILURES)) {
            LOGGER.log(Level.WARNING, "File ''{0}'' couldn''t be deleted!", file);
        }
    }

    private static boolean confirmDelete(List<DeleteOption> options) {
        if (options.contains((Object)DeleteOption.CONFIRM_DELETE)) {
            String message = Bundle.getString(DeleteFiles.class, "DeleteImageFiles.Confirm.Delete", new Object[0]);
            return MessageDisplayer.confirmYesNo(null, message);
        }
        return true;
    }

    private DeleteFiles() {
    }
}

