/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.filesystem;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.file.CopyMoveFilesOptions;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressListener;
import org.jphototagger.domain.event.listener.ProgressListenerSupport;
import org.jphototagger.domain.metadata.xmp.XmpSidecarFileResolver;
import org.jphototagger.lib.api.LookAndFeelChangedEvent;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.io.SourceTargetFile;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.DirectoryChooser;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.SelectRootFilesPanel;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.filesystem.FilesystemCopy;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class CopyToDirectoryDialog
extends Dialog
implements ProgressListener {
    private static final String KEY_LAST_DIRECTORY = "org.jphototagger.program.view.dialogs.CopyToDirectoryDialog.LastDirectory";
    private static final String KEY_COPY_XMP = "CopyToDirectoryDialog.CopyXmp";
    private static final long serialVersionUID = 1L;
    private final transient ProgressListenerSupport pListenerSupport = new ProgressListenerSupport();
    private transient FilesystemCopy copyTask;
    private boolean copy;
    private boolean writeProperties = true;
    private Collection<File> sourceFiles;
    private File targetDirectory = new File("");
    private final XmpSidecarFileResolver xmpSidecarFileResolver = Lookup.getDefault().lookup(XmpSidecarFileResolver.class);
    private JButton buttonCancel;
    private JButton buttonChooseDirectory;
    private ButtonGroup buttonGroupFileExists;
    private JButton buttonStart;
    private JCheckBox checkBoxCopyXmp;
    private JLabel labelCurrentFilename;
    private JLabel labelInfo;
    private JLabel labelInfoCurrentFilename;
    private JLabel labelInfoIsThread;
    private JLabel labelTargetDirectory;
    private JProgressBar progressBar;
    private JRadioButton radioButtonForceOverwrite;
    private JRadioButton radioButtonRenameIfTargetFileExists;

    public CopyToDirectoryDialog() {
        super((Frame)GUI.getAppFrame(), false);
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.setHelpPage();
        MnemonicUtil.setMnemonics(this);
        AnnotationProcessor.process(this);
    }

    private void setHelpPage() {
        this.setHelpPageUrl(Bundle.getString(CopyToDirectoryDialog.class, "CopyToDirectoryDialog.HelpPage", new Object[0]));
    }

    public void addProgressListener(ProgressListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        this.pListenerSupport.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        this.pListenerSupport.remove(listener);
    }

    private void checkClosing() {
        if (this.copy) {
            String message = Bundle.getString(CopyToDirectoryDialog.class, "CopyToDirectoryDialog.Error.CancelBeforeClose", new Object[0]);
            MessageDisplayer.error(this, message);
        } else {
            this.setVisible(false);
        }
    }

    private void checkError(List<String> errorFiles) {
        if (errorFiles.size() > 0) {
            String message = Bundle.getString(CopyToDirectoryDialog.class, "CopyToDirectoryDialog.Error.CopyErrorsOccured", new Object[0]);
            MessageDisplayer.error(this, message);
        }
    }

    private void start(boolean addXmp, CopyMoveFilesOptions options) {
        this.copyTask = new FilesystemCopy(this.getFiles(addXmp), options);
        this.copyTask.setCopyListenerShallUpdateRepository(true);
        this.copyTask.addProgressListener(this);
        Thread thread = new Thread((Runnable)this.copyTask, "JPhotoTagger: Copying files to directories");
        thread.start();
    }

    private CopyMoveFilesOptions getCopyOptions() {
        return this.radioButtonForceOverwrite.isSelected() ? CopyMoveFilesOptions.FORCE_OVERWRITE : (this.radioButtonRenameIfTargetFileExists.isSelected() ? CopyMoveFilesOptions.RENAME_SOURCE_FILE_IF_TARGET_FILE_EXISTS : CopyMoveFilesOptions.CONFIRM_OVERWRITE);
    }

    private List<SourceTargetFile> getFiles(boolean addXmp) {
        ArrayList<SourceTargetFile> sourceTargetFiles = new ArrayList<SourceTargetFile>();
        for (File sourceFile : this.sourceFiles) {
            File targetFile = new File(this.targetDirectory + File.separator + sourceFile.getName());
            if (addXmp) {
                this.addXmp(sourceFile, sourceTargetFiles);
            }
            sourceTargetFiles.add(new SourceTargetFile(sourceFile, targetFile));
        }
        return sourceTargetFiles;
    }

    private void addXmp(File imageFile, List<SourceTargetFile> sourceTargetFiles) {
        File sidecarFile = this.xmpSidecarFileResolver.getXmpSidecarFileOrNullIfNotExists(imageFile);
        if (sidecarFile != null) {
            File sourceSidecarFile = sidecarFile;
            File targetSidecarFile = new File(this.targetDirectory + File.separator + sourceSidecarFile.getName());
            sourceTargetFiles.add(new SourceTargetFile(sourceSidecarFile, targetSidecarFile));
        }
    }

    private void cancel() {
        this.copyTask.cancel();
        this.setVisible(false);
    }

    private void chooseTargetDirectory() {
        List<File> hideRootFiles = SelectRootFilesPanel.readPersistentRootFiles("UserSettings.HideRootFilesFromDirectoriesTab");
        DirectoryChooser dlg = new DirectoryChooser((Frame)GUI.getAppFrame(), this.targetDirectory, hideRootFiles, this.getDirChooserOptionShowHiddenDirs());
        dlg.setPreferencesKey("CopyToDirectoryDialog.DirChooser");
        dlg.setVisible(true);
        this.toFront();
        if (dlg.isAccepted()) {
            List<File> files = dlg.getSelectedDirectories();
            if (files.size() > 0) {
                this.targetDirectory = files.get(0);
                if (this.targetDirectory.canWrite()) {
                    this.labelTargetDirectory.setText(this.targetDirectory.getAbsolutePath());
                    this.setIconToLabelTargetDirectory();
                    this.buttonStart.setEnabled(true);
                } else {
                    String message = Bundle.getString(CopyToDirectoryDialog.class, "CopyToDirectoryDialog.TargetDirNotWritable", this.targetDirectory);
                    MessageDisplayer.error(this, message);
                }
            }
        } else {
            File dir = new File(this.labelTargetDirectory.getText().trim());
            this.buttonStart.setEnabled(FileUtil.isWritableDirectory(dir));
        }
    }

    private DirectoryChooser.Option getDirChooserOptionShowHiddenDirs() {
        return this.isAcceptHiddenDirectories() ? DirectoryChooser.Option.DISPLAY_HIDDEN_DIRECTORIES : DirectoryChooser.Option.NO_OPTION;
    }

    private boolean isAcceptHiddenDirectories() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.IsAcceptHiddenDirectories") ? prefs.getBoolean("UserSettings.IsAcceptHiddenDirectories") : false;
    }

    private void setIconToLabelTargetDirectory() {
        File dir = new File(this.labelTargetDirectory.getText());
        if (dir.isDirectory()) {
            this.labelTargetDirectory.setIcon(FileSystemView.getFileSystemView().getSystemIcon(dir));
        }
    }

    public void setSourceFiles(Collection<File> sourceFiles) {
        if (sourceFiles == null) {
            throw new NullPointerException("sourceFiles == null");
        }
        this.sourceFiles = new ArrayList<File>(sourceFiles);
    }

    public void setTargetDirectory(File directory) {
        if (directory == null) {
            throw new NullPointerException("directory == null");
        }
        if (directory.isDirectory() && directory.exists()) {
            this.targetDirectory = directory;
        }
    }

    public void copy(boolean addXmp, CopyMoveFilesOptions options) {
        if (options == null) {
            throw new NullPointerException("options == null");
        }
        if (this.targetDirectory.exists() && this.sourceFiles.size() > 0) {
            this.labelTargetDirectory.setText(this.targetDirectory.getAbsolutePath());
            this.setOptionsToRadioButtons(options);
            this.setIconToLabelTargetDirectory();
            this.buttonChooseDirectory.setEnabled(false);
            this.buttonStart.setEnabled(false);
            this.checkBoxCopyXmp.setSelected(true);
            this.radioButtonForceOverwrite.setSelected(false);
            this.radioButtonRenameIfTargetFileExists.setSelected(true);
            this.writeProperties = false;
            super.setVisible(true);
            ComponentUtil.centerScreen(this);
            this.start(addXmp, options);
        } else if (!this.targetDirectory.exists()) {
            this.errorMessageTargetDirectoryDoesNotExist();
        } else if (this.sourceFiles.size() <= 0) {
            this.errorMessageMissingSourceFiles();
        }
    }

    private void errorMessageTargetDirectoryDoesNotExist() {
        String message = Bundle.getString(CopyToDirectoryDialog.class, "CopyToDirectoryDialog.Error.TargetDirectoryDoesNotExist", this.targetDirectory.getAbsolutePath());
        MessageDisplayer.error(this, message);
    }

    private void errorMessageMissingSourceFiles() {
        String message = Bundle.getString(CopyToDirectoryDialog.class, "CopyToDirectoryDialog.Error.MissingSourceFiles", new Object[0]);
        MessageDisplayer.error(this, message);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.readProperties();
            this.initDirectory();
        } else if (this.writeProperties) {
            this.writeProperties();
        }
        super.setVisible(visible);
    }

    private void readProperties() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.applyToggleButtonSettings(KEY_COPY_XMP, this.checkBoxCopyXmp);
        File directory = new File(prefs.getString(KEY_LAST_DIRECTORY));
        if (directory.isDirectory()) {
            this.targetDirectory = directory;
        }
    }

    private void writeProperties() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.setString(KEY_LAST_DIRECTORY, this.targetDirectory.getAbsolutePath());
        prefs.setToggleButton(KEY_COPY_XMP, this.checkBoxCopyXmp);
    }

    private void initDirectory() {
        if (this.targetDirectory.exists()) {
            this.labelTargetDirectory.setText(this.targetDirectory.getAbsolutePath());
            this.setIconToLabelTargetDirectory();
            this.buttonStart.setEnabled(true);
        }
    }

    @Override
    public void progressStarted(final ProgressEvent evt) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                CopyToDirectoryDialog.this.copy = true;
                CopyToDirectoryDialog.this.buttonStart.setEnabled(false);
                CopyToDirectoryDialog.this.buttonCancel.setEnabled(true);
                CopyToDirectoryDialog.this.progressBar.setMinimum(evt.getMinimum());
                CopyToDirectoryDialog.this.progressBar.setMaximum(evt.getMaximum());
                CopyToDirectoryDialog.this.progressBar.setValue(evt.getValue());
                CopyToDirectoryDialog.this.pListenerSupport.notifyStarted(evt);
            }
        });
    }

    @Override
    public void progressPerformed(final ProgressEvent evt) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                CopyToDirectoryDialog.this.progressBar.setValue(evt.getValue());
                Object info = evt.getInfo();
                if (info instanceof SourceTargetFile) {
                    SourceTargetFile files = (SourceTargetFile)info;
                    CopyToDirectoryDialog.this.labelCurrentFilename.setText(files.getSourceFile().getAbsolutePath());
                }
                CopyToDirectoryDialog.this.pListenerSupport.notifyPerformed(evt);
            }
        });
    }

    @Override
    public void progressEnded(final ProgressEvent evt) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                CopyToDirectoryDialog.this.progressBar.setValue(evt.getValue());
                List errorFiles = (List)evt.getInfo();
                CopyToDirectoryDialog.this.checkError(errorFiles);
                CopyToDirectoryDialog.this.buttonCancel.setEnabled(false);
                CopyToDirectoryDialog.this.buttonStart.setEnabled(true);
                CopyToDirectoryDialog.this.copy = false;
                CopyToDirectoryDialog.this.pListenerSupport.notifyEnded(evt);
                CopyToDirectoryDialog.this.setVisible(false);
            }
        });
    }

    @Override
    protected void escape() {
        this.checkClosing();
    }

    private void setOptionsToRadioButtons(CopyMoveFilesOptions options) {
        this.radioButtonForceOverwrite.setSelected(options.equals((Object)CopyMoveFilesOptions.FORCE_OVERWRITE));
        this.radioButtonRenameIfTargetFileExists.setSelected(options.equals((Object)CopyMoveFilesOptions.RENAME_SOURCE_FILE_IF_TARGET_FILE_EXISTS));
    }

    @EventSubscriber(eventClass=LookAndFeelChangedEvent.class)
    public void lookAndFeelChanged(LookAndFeelChangedEvent evt) {
        SwingUtilities.updateComponentTreeUI(this);
    }

    private void initComponents() {
        this.buttonGroupFileExists = new ButtonGroup();
        this.labelInfo = new JLabel();
        this.buttonChooseDirectory = new JButton();
        this.labelTargetDirectory = new JLabel();
        this.radioButtonForceOverwrite = new JRadioButton();
        this.radioButtonRenameIfTargetFileExists = new JRadioButton();
        this.checkBoxCopyXmp = new JCheckBox();
        this.progressBar = new JProgressBar();
        this.labelInfoCurrentFilename = new JLabel();
        this.labelCurrentFilename = new JLabel();
        this.labelInfoIsThread = new JLabel();
        this.buttonCancel = new JButton();
        this.buttonStart = new JButton();
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/filesystem/Bundle");
        this.setTitle(bundle.getString("CopyToDirectoryDialog.title"));
        this.setName("Form");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CopyToDirectoryDialog.this.formWindowClosing(evt);
            }
        });
        this.labelInfo.setText(bundle.getString("CopyToDirectoryDialog.labelInfo.text"));
        this.labelInfo.setName("labelInfo");
        this.buttonChooseDirectory.setText(bundle.getString("CopyToDirectoryDialog.buttonChooseDirectory.text"));
        this.buttonChooseDirectory.setName("buttonChooseDirectory");
        this.buttonChooseDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CopyToDirectoryDialog.this.buttonChooseDirectoryActionPerformed(evt);
            }
        });
        this.labelTargetDirectory.setBorder(BorderFactory.createEtchedBorder());
        this.labelTargetDirectory.setName("labelTargetDirectory");
        this.buttonGroupFileExists.add(this.radioButtonForceOverwrite);
        this.radioButtonForceOverwrite.setText(bundle.getString("CopyToDirectoryDialog.radioButtonForceOverwrite.text"));
        this.radioButtonForceOverwrite.setName("radioButtonForceOverwrite");
        this.buttonGroupFileExists.add(this.radioButtonRenameIfTargetFileExists);
        this.radioButtonRenameIfTargetFileExists.setText(bundle.getString("CopyToDirectoryDialog.radioButtonRenameIfTargetFileExists.text"));
        this.radioButtonRenameIfTargetFileExists.setName("radioButtonRenameIfTargetFileExists");
        this.checkBoxCopyXmp.setSelected(true);
        this.checkBoxCopyXmp.setText(bundle.getString("CopyToDirectoryDialog.checkBoxCopyXmp.text"));
        this.checkBoxCopyXmp.setName("checkBoxCopyXmp");
        this.progressBar.setName("progressBar");
        this.labelInfoCurrentFilename.setText(bundle.getString("CopyToDirectoryDialog.labelInfoCurrentFilename.text"));
        this.labelInfoCurrentFilename.setName("labelInfoCurrentFilename");
        this.labelCurrentFilename.setForeground(new Color(0, 0, 255));
        this.labelCurrentFilename.setName("labelCurrentFilename");
        this.labelInfoIsThread.setForeground(new Color(0, 0, 255));
        this.labelInfoIsThread.setText(bundle.getString("CopyToDirectoryDialog.labelInfoIsThread.text"));
        this.labelInfoIsThread.setName("labelInfoIsThread");
        this.buttonCancel.setText(bundle.getString("CopyToDirectoryDialog.buttonCancel.text"));
        this.buttonCancel.setEnabled(false);
        this.buttonCancel.setName("buttonCancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CopyToDirectoryDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonStart.setText(bundle.getString("CopyToDirectoryDialog.buttonStart.text"));
        this.buttonStart.setEnabled(false);
        this.buttonStart.setName("buttonStart");
        this.buttonStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CopyToDirectoryDialog.this.buttonStartActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxCopyXmp).addComponent(this.radioButtonRenameIfTargetFileExists).addComponent(this.radioButtonForceOverwrite).addGroup(layout.createSequentialGroup().addComponent(this.labelInfo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 125, Short.MAX_VALUE).addComponent(this.buttonChooseDirectory)).addComponent(this.labelTargetDirectory, -1, 628, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.labelInfoCurrentFilename).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelCurrentFilename, -1, 530, Short.MAX_VALUE)).addComponent(this.progressBar, -1, 628, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.labelInfoIsThread).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 157, Short.MAX_VALUE).addComponent(this.buttonCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonStart))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelInfo).addComponent(this.buttonChooseDirectory)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelTargetDirectory, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonForceOverwrite).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonRenameIfTargetFileExists).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxCopyXmp).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.progressBar, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.labelInfoCurrentFilename).addComponent(this.labelCurrentFilename, -2, 15, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelInfoIsThread).addComponent(this.buttonStart).addComponent(this.buttonCancel)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(1, this.buttonCancel, this.buttonStart, this.progressBar);
        this.pack();
    }

    private void buttonStartActionPerformed(ActionEvent evt) {
        this.start(this.checkBoxCopyXmp.isSelected(), this.getCopyOptions());
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void buttonChooseDirectoryActionPerformed(ActionEvent evt) {
        this.chooseTargetDirectory();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.checkClosing();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CopyToDirectoryDialog dialog = new CopyToDirectoryDialog();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

