/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.fileexcludepatterns;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.swingx.JXList;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressListener;
import org.jphototagger.api.storage.Persistence;
import org.jphototagger.domain.repository.FileExcludePatternsRepository;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.help.HelpPageProvider;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.SelectRootFilesPanel;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.fileexcludepatterns.FileExcludePatternsListModel;
import org.openide.util.Lookup;

public final class FileExcludePatternsSettingsPanel
extends JPanel
implements ProgressListener,
Persistence,
ListSelectionListener,
HelpPageProvider {
    private static final long serialVersionUID = 1L;
    private final FileExcludePatternsListModel model = new FileExcludePatternsListModel();
    private boolean isUpdateRepository = false;
    private boolean cancel = false;
    private final FileExcludePatternsRepository repo = Lookup.getDefault().lookup(FileExcludePatternsRepository.class);
    private JButton buttonCancelUpdateRepository;
    private JButton buttonDeletePattern;
    private JButton buttonInsertPattern;
    private JButton buttonUpdateRepository;
    private JLabel labelInfoList;
    private JLabel labelInfoRepository;
    private JLabel labelInfopanelDirectoryFolder;
    private JLabel labelTextFieldInputPattern;
    private JXList list;
    private JMenuItem menuItemDeletePattern;
    private JPanel panelDirectoryFolder;
    private JPanel panelFiles;
    private SelectRootFilesPanel panelSelectRootFiles;
    private JPopupMenu popupMenu;
    private JProgressBar progressBarUpdateRepository;
    private JScrollPane scrollPane;
    private JScrollPane scrollPanePanelDirectoryFolder;
    private JTabbedPane tabbedPane;
    private JTextField textFieldInputPattern;

    public FileExcludePatternsSettingsPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.textFieldInputPattern.requestFocusInWindow();
        MnemonicUtil.setMnemonics(this);
        this.panelSelectRootFiles.setPersistenceKey("UserSettings.HideRootFilesFromDirectoriesTab");
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.cancel = false;
            this.isUpdateRepository = false;
            this.setEnabled();
        } else {
            this.cancelUpdateRepository();
        }
        super.setVisible(visible);
    }

    private void deletePattern() {
        if (this.list.getSelectedIndex() < 0) {
            return;
        }
        String pattern = (String)this.list.getSelectedValue();
        this.model.delete(pattern);
        this.setEnabled();
        this.list.requestFocusInWindow();
    }

    private void handleListValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            this.setSelectedPatternToInput();
            this.setEnabled();
        }
    }

    private void handleTextFieldInputPatternKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.insertPattern();
        } else {
            this.setEnabledButtonInsertPattern();
        }
    }

    private void handleListKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.deletePattern();
        }
    }

    private void insertPattern() {
        String input = this.textFieldInputPattern.getText().trim();
        if (!input.isEmpty() && !this.model.contains(input) && this.checkRegex(input)) {
            this.model.insert(input);
            this.textFieldInputPattern.setText("");
        }
        this.setEnabled();
    }

    private boolean checkRegex(String regex) {
        try {
            Pattern.compile(regex);
        }
        catch (Throwable t) {
            String message = Bundle.getString(FileExcludePatternsSettingsPanel.class, "FileExcludePatternsSettingsPanel.Error.Regex", new Object[0]);
            MessageDisplayer.error(this, message);
            return false;
        }
        return true;
    }

    private void setEnabledButtonInsertPattern() {
        this.buttonInsertPattern.setEnabled(this.hasInput() && !this.existsInput());
    }

    private boolean hasInput() {
        return !this.textFieldInputPattern.getText().trim().isEmpty();
    }

    private boolean existsInput() {
        String input = this.textFieldInputPattern.getText().trim();
        return !input.isEmpty() && this.model.contains(input);
    }

    private void setEnabled() {
        int size = this.model.getSize();
        boolean itemIsSelected = this.list.getSelectedIndex() >= 0;
        this.setEnabledButtonInsertPattern();
        this.buttonDeletePattern.setEnabled(itemIsSelected);
        this.menuItemDeletePattern.setEnabled(itemIsSelected);
        this.buttonUpdateRepository.setEnabled(size > 0 && !this.isUpdateRepository);
        this.buttonCancelUpdateRepository.setEnabled(this.isUpdateRepository);
    }

    private void setSelectedPatternToInput() {
        String pattern = (String)this.list.getSelectedValue();
        if (pattern != null) {
            this.textFieldInputPattern.setText(pattern);
        }
    }

    private void updateRepository() {
        List<String> patterns = this.model.getPatterns();
        if (patterns.size() > 0) {
            this.isUpdateRepository = true;
            this.cancel = false;
            this.setEnabled();
            this.repo.deleteMatchingFiles(patterns, this);
        }
    }

    private void cancelUpdateRepository() {
        this.cancel = true;
    }

    private void checkCancel(ProgressEvent evt) {
        if (this.cancel) {
            evt.setCancel(true);
        }
    }

    @Override
    public void progressStarted(final ProgressEvent evt) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                FileExcludePatternsSettingsPanel.this.progressBarUpdateRepository.setMinimum(evt.getMinimum());
                FileExcludePatternsSettingsPanel.this.progressBarUpdateRepository.setMaximum(evt.getMaximum());
                FileExcludePatternsSettingsPanel.this.progressBarUpdateRepository.setValue(evt.getValue());
                FileExcludePatternsSettingsPanel.this.checkCancel(evt);
            }
        });
    }

    @Override
    public void progressPerformed(final ProgressEvent evt) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                FileExcludePatternsSettingsPanel.this.progressBarUpdateRepository.setValue(evt.getValue());
                FileExcludePatternsSettingsPanel.this.checkCancel(evt);
            }
        });
    }

    @Override
    public void progressEnded(final ProgressEvent evt) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                FileExcludePatternsSettingsPanel.this.progressBarUpdateRepository.setValue(evt.getValue());
                FileExcludePatternsSettingsPanel.this.isUpdateRepository = false;
                FileExcludePatternsSettingsPanel.this.cancel = false;
                FileExcludePatternsSettingsPanel.this.setEnabled();
            }
        });
    }

    @Override
    public void restore() {
        this.panelSelectRootFiles.restore();
    }

    @Override
    public void persist() {
        this.panelSelectRootFiles.persist();
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            this.setEnabled();
        }
    }

    @Override
    public String getHelpPageUrl() {
        return Bundle.getString(FileExcludePatternsSettingsPanel.class, "FileExcludePatternsSettingsPanel.HelpPage", new Object[0]);
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.menuItemDeletePattern = new JMenuItem();
        this.tabbedPane = new JTabbedPane();
        this.panelFiles = new JPanel();
        this.labelInfoRepository = new JLabel();
        this.progressBarUpdateRepository = new JProgressBar();
        this.buttonCancelUpdateRepository = new JButton();
        this.buttonUpdateRepository = new JButton();
        this.labelTextFieldInputPattern = new JLabel();
        this.textFieldInputPattern = new JTextField();
        this.buttonDeletePattern = new JButton();
        this.buttonInsertPattern = new JButton();
        this.labelInfoList = new JLabel();
        this.scrollPane = new JScrollPane();
        this.list = new JXList();
        this.panelDirectoryFolder = new JPanel();
        this.labelInfopanelDirectoryFolder = new JLabel();
        this.scrollPanePanelDirectoryFolder = new JScrollPane();
        this.panelSelectRootFiles = new SelectRootFilesPanel();
        this.popupMenu.setName("popupMenu");
        this.menuItemDeletePattern.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.menuItemDeletePattern.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_delete.png")));
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/fileexcludepatterns/Bundle");
        this.menuItemDeletePattern.setText(bundle.getString("FileExcludePatternsSettingsPanel.menuItemDeletePattern.text"));
        this.menuItemDeletePattern.setName("menuItemDeletePattern");
        this.menuItemDeletePattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileExcludePatternsSettingsPanel.this.menuItemDeletePatternActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.menuItemDeletePattern);
        this.setName("Form");
        this.tabbedPane.setName("tabbedPane");
        this.panelFiles.setName("panelFiles");
        this.labelInfoRepository.setText(bundle.getString("FileExcludePatternsSettingsPanel.labelInfoRepository.text"));
        this.labelInfoRepository.setName("labelInfoRepository");
        this.progressBarUpdateRepository.setName("progressBarUpdateRepository");
        this.buttonCancelUpdateRepository.setText(bundle.getString("FileExcludePatternsSettingsPanel.buttonCancelUpdateRepository.text"));
        this.buttonCancelUpdateRepository.setEnabled(false);
        this.buttonCancelUpdateRepository.setName("buttonCancelUpdateRepository");
        this.buttonCancelUpdateRepository.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileExcludePatternsSettingsPanel.this.buttonCancelUpdateRepositoryActionPerformed(evt);
            }
        });
        this.buttonUpdateRepository.setText(bundle.getString("FileExcludePatternsSettingsPanel.buttonUpdateRepository.text"));
        this.buttonUpdateRepository.setName("buttonUpdateRepository");
        this.buttonUpdateRepository.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileExcludePatternsSettingsPanel.this.buttonUpdateRepositoryActionPerformed(evt);
            }
        });
        this.labelTextFieldInputPattern.setLabelFor(this.textFieldInputPattern);
        this.labelTextFieldInputPattern.setText(bundle.getString("FileExcludePatternsSettingsPanel.labelTextFieldInputPattern.text"));
        this.labelTextFieldInputPattern.setName("labelTextFieldInputPattern");
        this.textFieldInputPattern.setName("textFieldInputPattern");
        this.textFieldInputPattern.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FileExcludePatternsSettingsPanel.this.textFieldInputPatternFocusGained(evt);
            }
        });
        this.textFieldInputPattern.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                FileExcludePatternsSettingsPanel.this.textFieldInputPatternKeyReleased(evt);
            }
        });
        this.buttonDeletePattern.setText(bundle.getString("FileExcludePatternsSettingsPanel.buttonDeletePattern.text"));
        this.buttonDeletePattern.setToolTipText(bundle.getString("FileExcludePatternsSettingsPanel.buttonDeletePattern.toolTipText"));
        this.buttonDeletePattern.setEnabled(false);
        this.buttonDeletePattern.setName("buttonDeletePattern");
        this.buttonDeletePattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileExcludePatternsSettingsPanel.this.buttonDeletePatternActionPerformed(evt);
            }
        });
        this.buttonInsertPattern.setText(bundle.getString("FileExcludePatternsSettingsPanel.buttonInsertPattern.text"));
        this.buttonInsertPattern.setToolTipText(bundle.getString("FileExcludePatternsSettingsPanel.buttonInsertPattern.toolTipText"));
        this.buttonInsertPattern.setEnabled(false);
        this.buttonInsertPattern.setName("buttonInsertPattern");
        this.buttonInsertPattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileExcludePatternsSettingsPanel.this.buttonInsertPatternActionPerformed(evt);
            }
        });
        this.labelInfoList.setLabelFor(this.list);
        this.labelInfoList.setText(bundle.getString("FileExcludePatternsSettingsPanel.labelInfoList.text"));
        this.labelInfoList.setName("labelInfoList");
        this.scrollPane.setName("scrollPane");
        this.list.setModel((ListModel)this.model);
        this.list.setSelectionMode(0);
        this.list.setComponentPopupMenu(this.popupMenu);
        this.list.setName("list");
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FileExcludePatternsSettingsPanel.this.listValueChanged(evt);
            }
        });
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                FileExcludePatternsSettingsPanel.this.listKeyPressed(evt);
            }
        });
        this.scrollPane.setViewportView(this.list);
        GroupLayout panelFilesLayout = new GroupLayout(this.panelFiles);
        this.panelFiles.setLayout(panelFilesLayout);
        panelFilesLayout.setHorizontalGroup(panelFilesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 740, Short.MAX_VALUE).addGroup(panelFilesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelFilesLayout.createSequentialGroup().addGap(7, 7, 7).addGroup(panelFilesLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.scrollPane, GroupLayout.Alignment.LEADING, -1, 725, Short.MAX_VALUE).addComponent(this.labelInfoList, GroupLayout.Alignment.LEADING).addGroup(panelFilesLayout.createSequentialGroup().addComponent(this.buttonDeletePattern).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonInsertPattern)).addComponent(this.labelInfoRepository, -1, 725, Short.MAX_VALUE).addComponent(this.progressBarUpdateRepository, GroupLayout.Alignment.LEADING, -1, 725, Short.MAX_VALUE).addGroup(panelFilesLayout.createSequentialGroup().addComponent(this.buttonCancelUpdateRepository).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonUpdateRepository)).addGroup(GroupLayout.Alignment.LEADING, panelFilesLayout.createSequentialGroup().addComponent(this.labelTextFieldInputPattern).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFieldInputPattern, -1, 616, Short.MAX_VALUE))).addGap(8, 8, 8))));
        panelFilesLayout.setVerticalGroup(panelFilesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 312, Short.MAX_VALUE).addGroup(panelFilesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelFilesLayout.createSequentialGroup().addContainerGap().addComponent(this.labelInfoList).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane, -1, 128, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelFilesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textFieldInputPattern, -2, -1, -2).addComponent(this.labelTextFieldInputPattern)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelFilesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonInsertPattern).addComponent(this.buttonDeletePattern)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelInfoRepository, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.progressBarUpdateRepository, -2, 22, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(panelFilesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonUpdateRepository).addComponent(this.buttonCancelUpdateRepository)).addContainerGap())));
        this.tabbedPane.addTab(bundle.getString("FileExcludePatternsSettingsPanel.panelFiles.TabConstraints.tabTitle"), this.panelFiles);
        this.panelDirectoryFolder.setName("panelDirectoryFolder");
        this.labelInfopanelDirectoryFolder.setText(bundle.getString("FileExcludePatternsSettingsPanel.labelInfopanelDirectoryFolder.text"));
        this.labelInfopanelDirectoryFolder.setName("labelInfopanelDirectoryFolder");
        this.scrollPanePanelDirectoryFolder.setName("scrollPanePanelDirectoryFolder");
        this.panelSelectRootFiles.setName("panelSelectRootFiles");
        this.scrollPanePanelDirectoryFolder.setViewportView(this.panelSelectRootFiles);
        GroupLayout panelDirectoryFolderLayout = new GroupLayout(this.panelDirectoryFolder);
        this.panelDirectoryFolder.setLayout(panelDirectoryFolderLayout);
        panelDirectoryFolderLayout.setHorizontalGroup(panelDirectoryFolderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDirectoryFolderLayout.createSequentialGroup().addContainerGap().addGroup(panelDirectoryFolderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPanePanelDirectoryFolder, -1, 720, Short.MAX_VALUE).addComponent(this.labelInfopanelDirectoryFolder)).addContainerGap()));
        panelDirectoryFolderLayout.setVerticalGroup(panelDirectoryFolderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDirectoryFolderLayout.createSequentialGroup().addContainerGap().addComponent(this.labelInfopanelDirectoryFolder).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPanePanelDirectoryFolder, -1, 270, Short.MAX_VALUE).addContainerGap()));
        this.tabbedPane.addTab(bundle.getString("FileExcludePatternsSettingsPanel.panelDirectoryFolder.TabConstraints.tabTitle"), this.panelDirectoryFolder);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane));
    }

    private void listValueChanged(ListSelectionEvent evt) {
        this.handleListValueChanged(evt);
    }

    private void textFieldInputPatternKeyReleased(KeyEvent evt) {
        this.handleTextFieldInputPatternKeyReleased(evt);
    }

    private void buttonCancelUpdateRepositoryActionPerformed(ActionEvent evt) {
        this.cancelUpdateRepository();
    }

    private void buttonDeletePatternActionPerformed(ActionEvent evt) {
        this.deletePattern();
    }

    private void buttonUpdateRepositoryActionPerformed(ActionEvent evt) {
        this.updateRepository();
    }

    private void buttonInsertPatternActionPerformed(ActionEvent evt) {
        this.insertPattern();
    }

    private void listKeyPressed(KeyEvent evt) {
        this.handleListKeyPressed(evt);
    }

    private void menuItemDeletePatternActionPerformed(ActionEvent evt) {
        this.deletePattern();
    }

    private void textFieldInputPatternFocusGained(FocusEvent evt) {
        this.textFieldInputPattern.selectAll();
    }
}

