/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.fileexcludepatterns;

import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.domain.repository.FileExcludePatternsRepository;
import org.jphototagger.domain.repository.Repository;
import org.jphototagger.domain.repository.event.fileexcludepattern.FileExcludePatternDeletedEvent;
import org.jphototagger.domain.repository.event.fileexcludepattern.FileExcludePatternInsertedEvent;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public final class FileExcludePatternsListModel
extends DefaultListModel<Object> {
    private static final long serialVersionUID = 1L;
    private volatile transient boolean listenToDb = true;
    private List<String> patterns;
    private final FileExcludePatternsRepository fepRepo = Lookup.getDefault().lookup(FileExcludePatternsRepository.class);

    public FileExcludePatternsListModel() {
        this.addElements();
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process(this);
    }

    public List<String> getPatterns() {
        return new ArrayList<String>(this.patterns);
    }

    public void insert(String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern == null");
        }
        this.listenToDb = false;
        String trimmedPattern = pattern.trim();
        if (this.fepRepo.existsFileExcludePattern(trimmedPattern)) {
            this.errorMessageExists(trimmedPattern);
            return;
        }
        if (this.fepRepo.saveFileExcludePattern(trimmedPattern)) {
            this.addElement(trimmedPattern);
            this.patterns.add(trimmedPattern);
        } else {
            this.errorMessageInsert(trimmedPattern);
        }
        this.listenToDb = true;
    }

    public void delete(String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern == null");
        }
        this.listenToDb = false;
        String trimmedPattern = pattern.trim();
        if (this.fepRepo.deleteFileExcludePattern(trimmedPattern)) {
            this.removeElement(trimmedPattern);
            this.patterns.remove(trimmedPattern);
        } else {
            this.errorMessageDelete(trimmedPattern);
        }
        this.listenToDb = true;
    }

    private void addElements() {
        Repository repo = Lookup.getDefault().lookup(Repository.class);
        if (repo == null || !repo.isInit()) {
            return;
        }
        this.patterns = this.fepRepo.findAllFileExcludePatterns();
        for (String pattern : this.patterns) {
            this.addElement(pattern);
        }
    }

    private void insertPattern(String pattern) {
        this.addElement(pattern);
        this.patterns.add(pattern);
    }

    private void deletePattern(String pattern) {
        this.removeElement(pattern);
        this.patterns.remove(pattern);
    }

    private void errorMessageDelete(String trimmedPattern) {
        String message = Bundle.getString(FileExcludePatternsListModel.class, "FileExcludePatternsListModel.Error.Delete", trimmedPattern);
        MessageDisplayer.error(null, message);
    }

    private void errorMessageInsert(String trimmedPattern) {
        String message = Bundle.getString(FileExcludePatternsListModel.class, "FileExcludePatternsListModel.Error.InsertPattern.Add", trimmedPattern);
        MessageDisplayer.error(null, message);
    }

    private void errorMessageExists(String trimmedPattern) {
        String message = Bundle.getString(FileExcludePatternsListModel.class, "FileExcludePatternsListModel.Error.InsertPattern.Exists", trimmedPattern);
        MessageDisplayer.error(null, message);
    }

    @EventSubscriber(eventClass=FileExcludePatternInsertedEvent.class)
    public void patternInserted(FileExcludePatternInsertedEvent evt) {
        if (this.listenToDb) {
            this.insertPattern(evt.getPattern());
        }
    }

    @EventSubscriber(eventClass=FileExcludePatternDeletedEvent.class)
    public void patternDeleted(FileExcludePatternDeletedEvent evt) {
        if (this.listenToDb) {
            this.deletePattern(evt.getPattern());
        }
    }
}

