/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.favorites;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.bushe.swing.event.EventBus;
import org.jphototagger.api.file.event.DirectoryRenamedEvent;
import org.jphototagger.domain.favorites.Favorite;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.io.TreeFileSystemDirectories;
import org.jphototagger.program.factory.ControllerFactory;
import org.jphototagger.program.factory.ModelFactory;
import org.jphototagger.program.module.favorites.FavoritesPopupMenu;
import org.jphototagger.program.module.favorites.FavoritesTreeModel;
import org.jphototagger.program.module.favorites.RefreshFavoritesController;
import org.jphototagger.program.module.filesystem.FileSystemDirectories;
import org.jphototagger.program.resource.GUI;

public final class RenameFilesystemFolderInFavoritesController
implements ActionListener,
KeyListener {
    public RenameFilesystemFolderInFavoritesController() {
        this.listen();
    }

    private void listen() {
        FavoritesPopupMenu.INSTANCE.getItemRenameFilesystemFolder().addActionListener(this);
        GUI.getFavoritesTree().addKeyListener(this);
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        Object node;
        JTree tree = GUI.getFavoritesTree();
        if (this.isRename(evt) && !tree.isSelectionEmpty() && (node = tree.getSelectionPath().getLastPathComponent()) instanceof DefaultMutableTreeNode) {
            this.renameDirectory((DefaultMutableTreeNode)node);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                RenameFilesystemFolderInFavoritesController.this.renameDirectory(TreeFileSystemDirectories.getNodeOfLastPathComponent(FavoritesPopupMenu.INSTANCE.getTreePath()));
            }
        });
    }

    private boolean isRename(KeyEvent evt) {
        return evt.getKeyCode() == 113;
    }

    private void renameDirectory(DefaultMutableTreeNode node) {
        File newDir;
        File oldDir = this.getFile(node);
        if (oldDir != null && (newDir = FileSystemDirectories.rename(oldDir)) != null) {
            FavoritesTreeModel model = ModelFactory.INSTANCE.getModel(FavoritesTreeModel.class);
            node.setUserObject(newDir);
            TreeFileSystemDirectories.updateInTreeModel(model, node);
            ControllerFactory.INSTANCE.getController(RefreshFavoritesController.class).refresh();
            EventBus.publish(new DirectoryRenamedEvent(this, oldDir, newDir));
        }
    }

    private File getFile(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof File) {
            return (File)userObject;
        }
        if (userObject instanceof Favorite) {
            return ((Favorite)userObject).getDirectory();
        }
        return null;
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }
}

