/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.favorites;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.JTabbedPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jphototagger.domain.favorites.Favorite;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.swing.AllSystemDirectoriesTreeModel;
import org.jphototagger.lib.swing.KeyEventUtil;
import org.jphototagger.program.app.ui.AppPanel;
import org.jphototagger.program.factory.ModelFactory;
import org.jphototagger.program.module.favorites.FavoritesPopupMenu;
import org.jphototagger.program.resource.GUI;

public final class OpenFavoriteInDirectoriesTreeController
implements ActionListener,
KeyListener {
    public OpenFavoriteInDirectoriesTreeController() {
        this.listen();
    }

    private void listen() {
        FavoritesPopupMenu.INSTANCE.getItemOpenInFolders().addActionListener(this);
        GUI.getFavoritesTree().addKeyListener(this);
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        if (KeyEventUtil.isMenuShortcut(evt, 79) && !GUI.getFavoritesTree().isSelectionEmpty()) {
            this.selectDirectory();
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (GUI.getFavoritesTree().getSelectionCount() >= 0) {
            this.selectDirectory();
        }
    }

    private void selectDirectory() {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                File dir;
                TreePath path = FavoritesPopupMenu.INSTANCE.getTreePath();
                if (path != null && (dir = this.getDir((DefaultMutableTreeNode)path.getLastPathComponent())) != null && dir.isDirectory()) {
                    this.expandTreeToDir(dir);
                }
            }

            private File getDir(DefaultMutableTreeNode node) {
                Object userObject = node.getUserObject();
                if (userObject instanceof File) {
                    return (File)userObject;
                }
                if (userObject instanceof Favorite) {
                    Favorite favoriteDirectory = (Favorite)userObject;
                    return favoriteDirectory.getDirectory();
                }
                return null;
            }

            private void expandTreeToDir(File dir) {
                AppPanel appPanel = GUI.getAppPanel();
                JTabbedPane tabbedPaneSelection = appPanel.getTabbedPaneSelection();
                Component tabTreeDirectories = appPanel.getTabSelectionDirectories();
                GUI.getFavoritesTree().clearSelection();
                tabbedPaneSelection.setSelectedComponent(tabTreeDirectories);
                ModelFactory.INSTANCE.getModel(AllSystemDirectoriesTreeModel.class).expandToFile(dir, true);
            }
        });
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }
}

