/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.favorites;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jphototagger.domain.favorites.Favorite;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.program.factory.ModelFactory;
import org.jphototagger.program.module.favorites.FavoritesPopupMenu;
import org.jphototagger.program.module.favorites.FavoritesTreeModel;

public final class MoveFavoriteController
implements ActionListener {
    public MoveFavoriteController() {
        this.listen();
    }

    private void listen() {
        FavoritesPopupMenu.INSTANCE.getItemMoveUp().addActionListener(this);
        FavoritesPopupMenu.INSTANCE.getItemMoveDown().addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        boolean moveUp = FavoritesPopupMenu.INSTANCE.getItemMoveUp().equals(evt.getSource());
        EventQueueUtil.invokeInDispatchThread(new MoveDir(moveUp));
    }

    private class MoveDir
    implements Runnable {
        private final boolean up;

        MoveDir(boolean up) {
            this.up = up;
        }

        @Override
        public void run() {
            EventQueueUtil.invokeInDispatchThread(new Runnable(){

                @Override
                public void run() {
                    if (MoveDir.this.up) {
                        MoveDir.this.moveUp(MoveDir.this.getFavoriteDirectory());
                    } else {
                        MoveDir.this.moveDown(MoveDir.this.getFavoriteDirectory());
                    }
                }
            });
        }

        private Favorite getFavoriteDirectory() {
            DefaultMutableTreeNode node;
            Object userObject;
            TreePath path = FavoritesPopupMenu.INSTANCE.getTreePath();
            if (path != null && (userObject = (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof Favorite) {
                return (Favorite)userObject;
            }
            return null;
        }

        private void moveUp(Favorite dir) {
            if (dir != null) {
                ModelFactory.INSTANCE.getModel(FavoritesTreeModel.class).moveUpFavorite(dir);
            }
        }

        private void moveDown(Favorite dir) {
            if (dir != null) {
                ModelFactory.INSTANCE.getModel(FavoritesTreeModel.class).moveDownFavorite(dir);
            }
        }
    }
}

