/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.favorites;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.applifecycle.AppWillExitEvent;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.favorites.Favorite;
import org.jphototagger.domain.repository.FavoritesRepository;
import org.jphototagger.domain.repository.event.favorites.FavoriteDeletedEvent;
import org.jphototagger.domain.repository.event.favorites.FavoriteInsertedEvent;
import org.jphototagger.domain.repository.event.favorites.FavoriteUpdatedEvent;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.io.TreeFileSystemDirectories;
import org.jphototagger.lib.io.filefilter.DirectoryFilter;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.SortedChildrenTreeNode;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.TreeUtil;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public final class FavoritesTreeModel
extends DefaultTreeModel
implements TreeWillExpandListener {
    private static final long serialVersionUID = 1L;
    private static final String KEY_SELECTED_DIR = "FavoritesTreeModel.SelDir";
    private static final String KEY_SELECTED_FAV_NAME = "FavoritesTreeModel.SelFavDir";
    private static final long UPDATE_INTERVAL_MILLISECONDS = 2000L;
    private static final Logger LOGGER = Logger.getLogger(FavoritesTreeModel.class.getName());
    private static final Object DUMMY = new Object();
    private final DirectoryFilter directoryFilter = new DirectoryFilter(this.getDirFilterOptionShowHiddenFiles());
    private final Object monitor = new Object();
    private volatile boolean listenToRepo = true;
    private final DefaultMutableTreeNode rootNode;
    private final JTree tree;
    private final FavoritesRepository repo = Lookup.getDefault().lookup(FavoritesRepository.class);
    private final ScheduledExecutorService updateScheduler;
    private volatile boolean autoupdate;
    private final Runnable updater = new Runnable(){
        private final AtomicInteger taskCount = new AtomicInteger(0);

        @Override
        public void run() {
            if (this.taskCount.intValue() > 0) {
                return;
            }
            for (DefaultMutableTreeNode node : FavoritesTreeModel.this.getTreeRowNodes()) {
                this.updateRemoveDummy(node);
                Object userObject = node.getUserObject();
                File dir = null;
                if (userObject instanceof File) {
                    dir = (File)userObject;
                } else if (userObject instanceof Favorite) {
                    Favorite favorite = (Favorite)userObject;
                    dir = favorite.getDirectory();
                }
                if (dir == null) continue;
                if (!dir.exists()) {
                    this.remove(node);
                    continue;
                }
                this.addNewChildren(node);
            }
        }

        private void updateRemoveDummy(final DefaultMutableTreeNode node) {
            this.taskCount.incrementAndGet();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FavoritesTreeModel.this.removeDummy(node, true);
                    taskCount.decrementAndGet();
                }
            });
        }

        private void remove(final DefaultMutableTreeNode node) {
            this.taskCount.incrementAndGet();
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    FavoritesTreeModel.this.removeNodeFromParent(node);
                    Object userObject = node.getUserObject();
                    if (userObject instanceof Favorite) {
                        Favorite favorite = (Favorite)userObject;
                        Object object = FavoritesTreeModel.this.monitor;
                        synchronized (object) {
                            boolean prevListenToRepo = FavoritesTreeModel.this.listenToRepo;
                            FavoritesTreeModel.this.listenToRepo = false;
                            FavoritesTreeModel.this.repo.deleteFavorite(favorite.getName());
                            FavoritesTreeModel.this.listenToRepo = prevListenToRepo;
                        }
                    }
                    taskCount.decrementAndGet();
                }
            });
        }

        private void addNewChildren(final DefaultMutableTreeNode node) {
            File dir;
            this.taskCount.incrementAndGet();
            Object userObject = node.getUserObject();
            File file = userObject instanceof File ? (File)node.getUserObject() : (dir = userObject instanceof Favorite ? ((Favorite)userObject).getDirectory() : null);
            if (dir == null) {
                this.taskCount.decrementAndGet();
                return;
            }
            if (!TreeUtil.isNodeExpanded(FavoritesTreeModel.this.tree, node)) {
                FavoritesTreeModel.this.addDummy(node);
                this.taskCount.decrementAndGet();
                return;
            }
            final List childDirectories = FavoritesTreeModel.getChildDirectories(node);
            final List<File> directories = FileUtil.listFiles(dir, FavoritesTreeModel.this.directoryFilter);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (File directory : directories) {
                        if (childDirectories.contains(directory) || !FileUtil.isReadableDirectory(directory)) continue;
                        DefaultMutableTreeNode child = FavoritesTreeModel.this.addChildDirectory(node, directory);
                        FavoritesTreeModel.this.addDummy(child);
                    }
                    taskCount.decrementAndGet();
                }
            });
        }
    };
    private final ThreadFactory threadFactory = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("JPhotoTagger: Favorite Directories Tree Update");
            return thread;
        }
    };

    public FavoritesTreeModel(JTree tree) {
        super(new DefaultMutableTreeNode(Bundle.getString(FavoritesTreeModel.class, "FavoritesTreeModel.Root.DisplayName", new Object[0])));
        if (tree == null) {
            throw new NullPointerException("tree == null");
        }
        this.tree = tree;
        this.rootNode = (DefaultMutableTreeNode)this.getRoot();
        this.addFavorites();
        this.listen();
        this.updateScheduler = Executors.newSingleThreadScheduledExecutor(this.threadFactory);
    }

    private void listen() {
        this.tree.addTreeWillExpandListener(this);
        AnnotationProcessor.process(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Favorite favorite) {
        if (favorite == null) {
            throw new NullPointerException("favorite == null");
        }
        Object object = this.monitor;
        synchronized (object) {
            this.listenToRepo = false;
            favorite.setIndex(this.getNextNewFavoriteIndex());
            if (!this.existsFavorite(favorite)) {
                if (this.repo.saveOrUpdateFavorite(favorite)) {
                    this.addFavorite(favorite);
                } else {
                    this.errorMessage(favorite.getName(), Bundle.getString(FavoritesTreeModel.class, "FavoritesTreeModel.Error.ParamInsert", new Object[0]));
                }
            }
            this.listenToRepo = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Favorite favorite) {
        if (favorite == null) {
            throw new NullPointerException("favorite == null");
        }
        Object object = this.monitor;
        synchronized (object) {
            this.listenToRepo = false;
            DefaultMutableTreeNode favNode = this.findNode(favorite);
            if (favNode != null && this.repo.deleteFavorite(favorite.getName())) {
                this.removeNodeFromParent(favNode);
                this.resetFavoriteIndices();
            } else {
                this.errorMessage(favorite.getName(), Bundle.getString(FavoritesTreeModel.class, "FavoritesTreeModel.Error.ParamDelete", new Object[0]));
            }
            this.listenToRepo = true;
        }
    }

    private void deleteFavorite(Favorite favorite) {
        DefaultMutableTreeNode favNode = this.findNode(favorite);
        if (favNode != null) {
            this.removeNodeFromParent(favNode);
            this.resetFavoriteIndices();
        }
    }

    private void resetFavoriteIndices() {
        int newIndex = 0;
        Enumeration<TreeNode> children = this.rootNode.children();
        while (children.hasMoreElements()) {
            Object userObject = ((DefaultMutableTreeNode)children.nextElement()).getUserObject();
            if (!(userObject instanceof Favorite)) continue;
            Favorite fav = (Favorite)userObject;
            fav.setIndex(newIndex);
            ++newIndex;
            this.repo.updateFavorite(fav);
        }
    }

    private void updateNodes(DefaultMutableTreeNode nodeOfFavorite, Favorite newFavorite) {
        this.removeAllChildren(nodeOfFavorite);
        Object userObject = nodeOfFavorite.getUserObject();
        if (userObject instanceof Favorite) {
            Favorite favorite = (Favorite)userObject;
            favorite.setDirectory(newFavorite.getDirectory());
            favorite.setName(newFavorite.getName());
        }
        this.addChildren(nodeOfFavorite);
        this.nodeChanged(nodeOfFavorite);
    }

    private void removeAllChildren(DefaultMutableTreeNode node) {
        ArrayList<TreeNode> children = new ArrayList<TreeNode>(node.getChildCount());
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            children.add(e.nextElement());
        }
        for (DefaultMutableTreeNode defaultMutableTreeNode : children) {
            this.removeNodeFromParent(defaultMutableTreeNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveUpFavorite(Favorite favorite) {
        if (favorite == null) {
            throw new NullPointerException("favorite == null");
        }
        Object object = this.monitor;
        synchronized (object) {
            DefaultMutableTreeNode nodeToMoveUp = this.findNode(favorite);
            if (nodeToMoveUp != null) {
                DefaultMutableTreeNode prevNode;
                boolean isFirstNode;
                int indexNodeToMoveUp = this.rootNode.getIndex(nodeToMoveUp);
                boolean bl = isFirstNode = indexNodeToMoveUp == 0;
                if (!isFirstNode && (prevNode = (DefaultMutableTreeNode)this.rootNode.getChildAt(indexNodeToMoveUp - 1)) != null && this.updateFavorite(nodeToMoveUp.getUserObject(), indexNodeToMoveUp - 1) && this.updateFavorite(prevNode.getUserObject(), indexNodeToMoveUp)) {
                    this.removeNodeFromParent(prevNode);
                    this.insertNodeInto(prevNode, this.rootNode, indexNodeToMoveUp);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveDownFavorite(Favorite favorite) {
        if (favorite == null) {
            throw new NullPointerException("favorite == null");
        }
        Object object = this.monitor;
        synchronized (object) {
            DefaultMutableTreeNode nodeToMoveDown = this.findNode(favorite);
            if (nodeToMoveDown != null) {
                DefaultMutableTreeNode nextNode;
                boolean isLastNode;
                int indexNodeToMoveDown = this.rootNode.getIndex(nodeToMoveDown);
                boolean bl = isLastNode = indexNodeToMoveDown == this.rootNode.getChildCount() - 1;
                if (!isLastNode && (nextNode = (DefaultMutableTreeNode)this.rootNode.getChildAt(indexNodeToMoveDown + 1)) != null && this.updateFavorite(nodeToMoveDown.getUserObject(), indexNodeToMoveDown + 1) && this.updateFavorite(nextNode.getUserObject(), indexNodeToMoveDown)) {
                    this.removeNodeFromParent(nextNode);
                    this.insertNodeInto(nextNode, this.rootNode, indexNodeToMoveDown);
                }
            }
        }
    }

    private boolean updateFavorite(Object userObject, int newIndex) {
        if (userObject instanceof Favorite) {
            Favorite favorite = (Favorite)userObject;
            favorite.setIndex(newIndex);
            return this.repo.updateFavorite(favorite);
        }
        return false;
    }

    private void addFavorites() {
        List<Favorite> directories = this.repo.findAllFavorites();
        for (Favorite directory : directories) {
            if (directory.getDirectory().isDirectory()) {
                this.addFavorite(directory);
                continue;
            }
            this.errorMessageAddDirectory(directory);
        }
    }

    private void addFavorite(Favorite favorite) {
        DefaultMutableTreeNode dirNode = this.findNode(favorite);
        if (dirNode == null) {
            SortedChildrenTreeNode node = new SortedChildrenTreeNode(favorite);
            this.insertNodeInto(node, this.rootNode, this.rootNode.getChildCount());
            this.addDummy(node);
            this.tree.expandPath(new TreePath(this.rootNode.getPath()));
        }
    }

    private void addChildren(DefaultMutableTreeNode parentNode) {
        File dir;
        Object userObject = parentNode.getUserObject();
        File file = userObject instanceof File ? (File)userObject : (dir = userObject instanceof Favorite ? ((Favorite)userObject).getDirectory() : null);
        if (!FileUtil.isReadableDirectory(dir)) {
            return;
        }
        LOGGER.log(Level.FINEST, "Reading subdirectories of ''{0}''...", dir);
        File[] subdirs = dir.listFiles(this.directoryFilter);
        LOGGER.log(Level.FINEST, "Subdirectories of ''{0}'' have been read", dir);
        this.removeDummy(parentNode, false);
        if (subdirs == null) {
            return;
        }
        List<File> nodeChildrenDirs = FavoritesTreeModel.getChildDirectories(parentNode);
        for (File subdir : subdirs) {
            if (nodeChildrenDirs.contains(subdir) || !FileUtil.isReadableDirectory(subdir)) continue;
            DefaultMutableTreeNode childNode = this.addChildDirectory(parentNode, subdir);
            this.addDummy(childNode);
        }
    }

    private static List<File> getChildDirectories(DefaultMutableTreeNode node) {
        int childCount = node.getChildCount();
        ArrayList<File> childFiles = new ArrayList<File>(childCount);
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
            Object childNodeUserObject = childNode.getUserObject();
            if (childNodeUserObject instanceof File) {
                childFiles.add((File)childNodeUserObject);
                continue;
            }
            if (!(childNodeUserObject instanceof Favorite)) continue;
            Favorite favorite = (Favorite)childNodeUserObject;
            childFiles.add(favorite.getDirectory());
        }
        return childFiles;
    }

    private DefaultMutableTreeNode addChildDirectory(DefaultMutableTreeNode parentNode, File directory) {
        LOGGER.log(Level.FINEST, "Adding subdirectory ''{0}'' to node ''{1}''", new Object[]{directory, parentNode});
        SortedChildrenTreeNode newChildNode = new SortedChildrenTreeNode(directory);
        parentNode.add(newChildNode);
        int newChildIndex = parentNode.getIndex(newChildNode);
        this.fireTreeNodesInserted(this, parentNode.getPath(), new int[]{newChildIndex}, new Object[]{newChildNode});
        LOGGER.log(Level.FINEST, "Subdirectory ''{0}'' has been added to node ''{1}''", new Object[]{directory, parentNode});
        return newChildNode;
    }

    private void addDummy(DefaultMutableTreeNode parentNode) {
        File dir = this.getDirectory(parentNode);
        if (parentNode.isLeaf() && FileUtil.containsReadableDirectory(dir)) {
            SortedChildrenTreeNode dummy = new SortedChildrenTreeNode(DUMMY);
            parentNode.add(dummy);
            this.fireTreeNodesInserted(this, parentNode.getPath(), new int[]{0}, new Object[]{dummy});
        }
    }

    private void removeDummy(DefaultMutableTreeNode parentNode, boolean onlyIfEmptyDir) {
        if (this.containsDummy(parentNode)) {
            TreeNode dummyChild = parentNode.getChildAt(0);
            boolean remove = true;
            if (onlyIfEmptyDir) {
                Object userObject = parentNode.getUserObject();
                if (userObject instanceof Favorite) {
                    Favorite favorite = (Favorite)userObject;
                    boolean bl = remove = !FileUtil.containsReadableDirectory(favorite.getDirectory());
                }
                if (userObject instanceof File) {
                    boolean bl = remove = !FileUtil.containsReadableDirectory((File)userObject);
                }
            }
            if (remove) {
                parentNode.remove(0);
                this.fireTreeNodesRemoved(this, parentNode.getPath(), new int[]{0}, new Object[]{dummyChild});
            }
        }
    }

    private boolean containsDummy(DefaultMutableTreeNode node) {
        return node.getChildCount() == 1 && ((DefaultMutableTreeNode)node.getChildAt(0)).getUserObject() == DUMMY;
    }

    private DirectoryFilter.Option getDirFilterOptionShowHiddenFiles() {
        return this.isAcceptHiddenDirectories() ? DirectoryFilter.Option.ACCEPT_HIDDEN_FILES : DirectoryFilter.Option.NO_OPTION;
    }

    private boolean isAcceptHiddenDirectories() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.IsAcceptHiddenDirectories") ? prefs.getBoolean("UserSettings.IsAcceptHiddenDirectories") : false;
    }

    private int removeChildrenWithNotExistingFiles(DefaultMutableTreeNode parentNode) {
        Object userObject;
        int childCount = parentNode.getChildCount();
        ArrayList<DefaultMutableTreeNode> nodesToRemove = new ArrayList<DefaultMutableTreeNode>();
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)parentNode.getChildAt(i);
            if (this.containsDummy(child)) {
                this.removeDummy(child, true);
            }
            userObject = child.getUserObject();
            File file = null;
            if (userObject instanceof File) {
                file = (File)userObject;
            } else if (userObject instanceof Favorite) {
                file = ((Favorite)userObject).getDirectory();
            }
            if (file == null || file.exists()) continue;
            nodesToRemove.add(child);
        }
        for (DefaultMutableTreeNode childNodeToRemove : nodesToRemove) {
            userObject = childNodeToRemove.getUserObject();
            if (userObject instanceof Favorite) {
                this.repo.deleteFavorite(((Favorite)userObject).getName());
            }
            this.removeNodeFromParent(childNodeToRemove);
        }
        return nodesToRemove.size();
    }

    private synchronized int getNextNewFavoriteIndex() {
        int index = 0;
        Enumeration<TreeNode> children = this.rootNode.children();
        while (children.hasMoreElements()) {
            Object userObject = ((DefaultMutableTreeNode)children.nextElement()).getUserObject();
            if (!(userObject instanceof Favorite)) continue;
            ++index;
        }
        return index;
    }

    private DefaultMutableTreeNode findNode(Favorite favorite) {
        Enumeration<TreeNode> children = this.rootNode.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            if (!favorite.equals(child.getUserObject())) continue;
            return child;
        }
        return null;
    }

    private boolean existsFavorite(Favorite favorite) {
        return this.findNode(favorite) != null;
    }

    public File createNewDirectory(DefaultMutableTreeNode parentNode) {
        File newDir;
        File dirOfParentNode;
        File file = dirOfParentNode = parentNode == null ? null : this.getDirectory(parentNode);
        if (dirOfParentNode != null && (newDir = TreeFileSystemDirectories.createDirectoryIn(dirOfParentNode)) != null) {
            SortedChildrenTreeNode newDirNode = new SortedChildrenTreeNode(newDir);
            parentNode.add(newDirNode);
            int childIndex = parentNode.getIndex(newDirNode);
            this.fireTreeNodesInserted(this, parentNode.getPath(), new int[]{childIndex}, new Object[]{newDirNode});
            return newDir;
        }
        return null;
    }

    private File getDirectory(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        return userObject instanceof Favorite ? ((Favorite)userObject).getDirectory() : (userObject instanceof File ? (File)userObject : null);
    }

    private Stack<File> getFilePathToNode(DefaultMutableTreeNode node, File file) {
        File nodeFile;
        if (node == null) {
            return null;
        }
        Object userObject = node.getUserObject();
        File file2 = userObject instanceof File ? (File)userObject : (nodeFile = userObject instanceof Favorite ? ((Favorite)userObject).getDirectory() : null);
        if (nodeFile != null) {
            Stack<File> filePath = FileUtil.getPathFromRoot(file);
            File filePathTop = filePath.peek();
            while (!filePath.isEmpty() && !nodeFile.equals(filePathTop)) {
                filePathTop = filePath.pop();
            }
            return filePath;
        }
        return null;
    }

    private void expandToFile(String favoriteName, File file, boolean select) {
        DefaultMutableTreeNode node = this.findFavorite(favoriteName);
        if (node == null) {
            return;
        }
        Stack<File> filePathToFavorite = this.getFilePathToNode(node, file);
        if (filePathToFavorite == null) {
            return;
        }
        this.tree.expandPath(new TreePath(node.getPath()));
        while (node != null && !filePathToFavorite.isEmpty()) {
            if ((node = TreeUtil.findChildNodeWithFile(node, filePathToFavorite.pop())) == null || filePathToFavorite.size() <= 0) continue;
            this.tree.expandPath(new TreePath(node.getPath()));
        }
        if (node != null) {
            TreePath nodePath = new TreePath(node.getPath());
            this.tree.scrollPathToVisible(nodePath);
            if (select) {
                this.tree.setSelectionPath(nodePath);
            }
        }
    }

    private DefaultMutableTreeNode findFavorite(String name) {
        Enumeration<TreeNode> children = this.rootNode.children();
        while (children.hasMoreElements()) {
            Favorite fav;
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)children.nextElement();
            Object userObject = childNode.getUserObject();
            if (!(userObject instanceof Favorite) || !name.equals((fav = (Favorite)userObject).getName())) continue;
            return childNode;
        }
        return null;
    }

    public void readFromProperties() {
        DefaultMutableTreeNode fav;
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        String favname = prefs.getString(KEY_SELECTED_FAV_NAME);
        String dirname = prefs.getString(KEY_SELECTED_DIR);
        if (favname != null && dirname != null && !favname.trim().isEmpty() && !dirname.trim().isEmpty()) {
            this.expandToFile(favname.trim(), new File(dirname.trim()), true);
        } else if (favname != null && (fav = this.findFavorite(favname.trim())) != null) {
            TreePath path = new TreePath(fav.getPath());
            this.tree.setSelectionPath(path);
            this.tree.scrollPathToVisible(path);
        }
    }

    private void writeToProperties() {
        if (this.tree.getSelectionCount() > 0) {
            TreePath path = this.tree.getSelectionPath();
            Object o = path.getLastPathComponent();
            if (o instanceof DefaultMutableTreeNode) {
                String favname = null;
                String dirname = null;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)o;
                Object userObject = node.getUserObject();
                if (userObject instanceof Favorite) {
                    favname = ((Favorite)userObject).getName();
                } else if (userObject instanceof File) {
                    File file = (File)userObject;
                    dirname = file.getAbsolutePath();
                    Favorite favDir = this.getParentFavDir(node);
                    if (favDir != null) {
                        favname = favDir.getName();
                    }
                }
                Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
                if (dirname == null) {
                    prefs.removeKey(KEY_SELECTED_DIR);
                } else {
                    prefs.setString(KEY_SELECTED_DIR, dirname);
                }
                if (favname == null) {
                    prefs.removeKey(KEY_SELECTED_FAV_NAME);
                } else {
                    prefs.setString(KEY_SELECTED_FAV_NAME, favname);
                }
            }
        } else {
            Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
            prefs.removeKey(KEY_SELECTED_DIR);
            prefs.removeKey(KEY_SELECTED_FAV_NAME);
        }
    }

    private Favorite getParentFavDir(DefaultMutableTreeNode childNode) {
        TreeNode parentNode = childNode.getParent();
        while (parentNode instanceof DefaultMutableTreeNode && !parentNode.equals(this.rootNode)) {
            Object userObject = ((DefaultMutableTreeNode)parentNode).getUserObject();
            if (userObject instanceof Favorite) {
                return (Favorite)userObject;
            }
            parentNode = parentNode.getParent();
        }
        return null;
    }

    public void update() {
        Cursor treeCursor = this.tree.getCursor();
        Cursor waitCursor = Cursor.getPredefinedCursor(3);
        this.tree.setCursor(waitCursor);
        for (DefaultMutableTreeNode node : this.getTreeRowNodes()) {
            TreeNode parent = node.getParent();
            this.removeChildrenWithNotExistingFiles((DefaultMutableTreeNode)parent);
            this.addChildren((DefaultMutableTreeNode)parent);
            Enumeration<? extends TreeNode> e = parent.children();
            while (e.hasMoreElements()) {
                TreeNode sibling = e.nextElement();
                this.addDummy((DefaultMutableTreeNode)sibling);
            }
        }
        this.tree.setCursor(treeCursor);
    }

    private void updateFavorite(Favorite oldFavorite, Favorite updatedFavorite) {
        DefaultMutableTreeNode nodeOfFavorite = this.findNode(oldFavorite);
        if (nodeOfFavorite != null) {
            this.updateNodes(nodeOfFavorite, updatedFavorite);
        }
    }

    @EventSubscriber(eventClass=FavoriteInsertedEvent.class)
    public void favoriteInserted(FavoriteInsertedEvent evt) {
        if (this.listenToRepo) {
            this.addFavorite(evt.getFavorite());
        }
    }

    @EventSubscriber(eventClass=FavoriteDeletedEvent.class)
    public void favoriteDeleted(FavoriteDeletedEvent evt) {
        if (this.listenToRepo) {
            this.deleteFavorite(evt.getFavorite());
        }
    }

    @EventSubscriber(eventClass=FavoriteUpdatedEvent.class)
    public void favoriteUpdated(FavoriteUpdatedEvent evt) {
        if (this.listenToRepo) {
            this.updateFavorite(evt.getOldFavorite(), evt.getUpdatedFavorite());
        }
    }

    private List<DefaultMutableTreeNode> getTreeRowNodes() {
        int rows = this.tree.getRowCount();
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>(rows);
        for (int i = 0; i < rows; ++i) {
            nodes.add((DefaultMutableTreeNode)this.tree.getPathForRow(i).getLastPathComponent());
        }
        return nodes;
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        if (event == null) {
            throw new NullPointerException("event == null");
        }
        Cursor treeCursor = this.tree.getCursor();
        Cursor waitCursor = Cursor.getPredefinedCursor(3);
        this.tree.setCursor(waitCursor);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
        LOGGER.log(Level.FINEST, "Node ''{0}'' has been expanded, adding children...", node);
        this.addChildren(node);
        this.tree.setCursor(treeCursor);
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    @EventSubscriber(eventClass=AppWillExitEvent.class)
    public void appWillExit(AppWillExitEvent evt) {
        this.writeToProperties();
    }

    private void errorMessage(String favoriteName, String cause) {
        String message = Bundle.getString(FavoritesTreeModel.class, "FavoritesTreeModel.Error.Template", favoriteName, cause);
        MessageDisplayer.error(null, message);
    }

    private void errorMessageAddDirectory(final Favorite favorite) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                String message = Bundle.getString(FavoritesTreeModel.class, "FavoritesTreeModel.Confirm.RemoveNotExistingFavorite", favorite.getDirectory(), favorite.getName());
                if (MessageDisplayer.confirmYesNo(ComponentUtil.findFrameWithIcon(), message)) {
                    FavoritesTreeModel.this.repo.deleteFavorite(favorite.getName());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAutoUpdate() {
        ScheduledExecutorService scheduledExecutorService = this.updateScheduler;
        synchronized (scheduledExecutorService) {
            if (!this.autoupdate) {
                this.updateScheduler.scheduleWithFixedDelay(this.updater, 0L, 2000L, TimeUnit.MILLISECONDS);
                this.autoupdate = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAutoUpdate() {
        ScheduledExecutorService scheduledExecutorService = this.updateScheduler;
        synchronized (scheduledExecutorService) {
            if (this.autoupdate) {
                this.updateScheduler.shutdown();
                this.autoupdate = false;
            }
        }
    }
}

