/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.favorites;

import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.preferences.PreferencesChangedEvent;
import org.jphototagger.domain.favorites.Favorite;
import org.jphototagger.lib.swing.KeyEventUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.app.ui.AppLookAndFeel;
import org.openide.util.Lookup;

public final class FavoritesPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = 1L;
    private static final ImageIcon ICON_ARROW_DOWN = AppLookAndFeel.getIcon("icon_arrow_down.png");
    private static final ImageIcon ICON_ARROW_UP = AppLookAndFeel.getIcon("icon_arrow_up.png");
    private static final ImageIcon ICON_FOLDER = AppLookAndFeel.getIcon("icon_folder.png");
    private static final ImageIcon ICON_FOLDER_NEW = AppLookAndFeel.getIcon("icon_folder_new.png");
    public static final FavoritesPopupMenu INSTANCE = new FavoritesPopupMenu();
    private final JMenuItem itemInsertFavorite = new JMenuItem(Bundle.getString(FavoritesPopupMenu.class, "FavoritesPopupMenu.DisplayName.Action.InsertFavorite", new Object[0]), AppLookAndFeel.ICON_NEW);
    private final JMenuItem itemUpdateFavorite = new JMenuItem(Bundle.getString(FavoritesPopupMenu.class, "FavoritesPopupMenu.DisplayName.Action.UpdateFavorite", new Object[0]), AppLookAndFeel.ICON_EDIT);
    private final JMenuItem itemRenameFilesystemFolder = new JMenuItem(Bundle.getString(FavoritesPopupMenu.class, "FavoritesPopupMenu.DisplayName.Action.RenameFilesystemFolder", new Object[0]), AppLookAndFeel.ICON_RENAME);
    private final JMenuItem itemRefresh = new JMenuItem(Bundle.getString(FavoritesPopupMenu.class, "FavoritesPopupMenu.DisplayName.Action.Refresh", new Object[0]), AppLookAndFeel.ICON_REFRESH);
    private final JMenuItem itemOpenInFolders = new JMenuItem(Bundle.getString(FavoritesPopupMenu.class, "FavoritesPopupMenu.DisplayName.Action.OpenInFolders", new Object[0]), ICON_FOLDER);
    private final JMenuItem itemMoveUp = new JMenuItem(Bundle.getString(FavoritesPopupMenu.class, "FavoritesPopupMenu.DisplayName.Action.MoveUp", new Object[0]), ICON_ARROW_UP);
    private final JMenuItem itemMoveDown = new JMenuItem(Bundle.getString(FavoritesPopupMenu.class, "FavoritesPopupMenu.DisplayName.Action.MoveDown", new Object[0]), ICON_ARROW_DOWN);
    private final JMenuItem itemExpandAllSubitems = new JMenuItem(Bundle.getString(FavoritesPopupMenu.class, "FavoritesPopupMenu.ItemExpand", new Object[0]));
    private final JMenuItem itemDeleteFilesystemFolder = new JMenuItem(Bundle.getString(FavoritesPopupMenu.class, "FavoritesPopupMenu.DisplayName.Action.DeleteFilesystemFolder", new Object[0]), AppLookAndFeel.ICON_DELETE);
    private final JMenuItem itemDeleteFavorite = new JMenuItem(Bundle.getString(FavoritesPopupMenu.class, "FavoritesPopupMenu.DisplayName.Action.DeleteFavorite", new Object[0]), AppLookAndFeel.ICON_DELETE);
    private final JMenuItem itemCollapseAllSubitems = new JMenuItem(Bundle.getString(FavoritesPopupMenu.class, "FavoritesPopupMenu.ItemCollapse", new Object[0]));
    private final JMenuItem itemAddFilesystemFolder = new JMenuItem(Bundle.getString(FavoritesPopupMenu.class, "FavoritesPopupMenu.DisplayName.Action.AddFilesystemFolder", new Object[0]), ICON_FOLDER_NEW);
    private final JMenuItem itemOpenInDesktop = new JMenuItem(Bundle.getString(FavoritesPopupMenu.class, "FavoritesPopupMenu.Action.OpenInDesktop", new Object[0]));
    private transient Favorite favoriteDirectory;
    private TreePath treePath;

    private FavoritesPopupMenu() {
        this.init();
    }

    public JMenuItem getItemDeleteFavorite() {
        return this.itemDeleteFavorite;
    }

    public JMenuItem getItemInsertFavorite() {
        return this.itemInsertFavorite;
    }

    public JMenuItem getItemUpdateFavorite() {
        return this.itemUpdateFavorite;
    }

    public JMenuItem getItemOpenInFolders() {
        return this.itemOpenInFolders;
    }

    public JMenuItem getItemRefresh() {
        return this.itemRefresh;
    }

    public JMenuItem getItemAddFilesystemFolder() {
        return this.itemAddFilesystemFolder;
    }

    public JMenuItem getItemDeleteFilesystemFolder() {
        return this.itemDeleteFilesystemFolder;
    }

    public JMenuItem getItemMoveDown() {
        return this.itemMoveDown;
    }

    public JMenuItem getItemMoveUp() {
        return this.itemMoveUp;
    }

    public JMenuItem getItemRenameFilesystemFolder() {
        return this.itemRenameFilesystemFolder;
    }

    public JMenuItem getItemCollapseAllSubitems() {
        return this.itemCollapseAllSubitems;
    }

    public JMenuItem getItemExpandAllSubitems() {
        return this.itemExpandAllSubitems;
    }

    JMenuItem getItemOpenInDesktop() {
        return this.itemOpenInDesktop;
    }

    public TreePath getTreePath() {
        return this.treePath;
    }

    public void setTreePath(TreePath treePath) {
        this.treePath = treePath;
    }

    public Favorite getFavorite() {
        return this.favoriteDirectory;
    }

    public void setFavoriteDirectory(Favorite favoriteDirectory) {
        this.favoriteDirectory = favoriteDirectory;
    }

    private void init() {
        this.addItems();
        this.setAccelerators();
        this.setItemsEnabled();
        this.listen();
    }

    private void addItems() {
        this.add(this.itemInsertFavorite);
        this.add(this.itemUpdateFavorite);
        this.add(this.itemDeleteFavorite);
        this.add(this.itemMoveUp);
        this.add(this.itemMoveDown);
        this.add(new JPopupMenu.Separator());
        this.add(this.itemOpenInDesktop);
        this.add(this.itemOpenInFolders);
        this.add(new JPopupMenu.Separator());
        this.add(this.itemAddFilesystemFolder);
        this.add(this.itemRenameFilesystemFolder);
        this.add(this.itemDeleteFilesystemFolder);
        this.add(new JPopupMenu.Separator());
        this.add(this.itemExpandAllSubitems);
        this.add(this.itemCollapseAllSubitems);
        this.add(new JPopupMenu.Separator());
        this.add(this.itemRefresh);
    }

    private void setAccelerators() {
        this.itemUpdateFavorite.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(69));
        this.itemInsertFavorite.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(73));
        this.itemOpenInFolders.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(79));
        this.itemAddFilesystemFolder.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(78));
        this.itemDeleteFavorite.setAccelerator(KeyEventUtil.getKeyStroke(127));
        this.itemDeleteFilesystemFolder.setAccelerator(KeyEventUtil.getKeyStroke(127));
        this.itemRenameFilesystemFolder.setAccelerator(KeyEventUtil.getKeyStroke(113));
        this.itemRefresh.setAccelerator(KeyEventUtil.getKeyStroke(116));
    }

    private void setItemsEnabled() {
        this.setDeleteDirectoryEnabled();
    }

    private void listen() {
        AnnotationProcessor.process(this);
    }

    @EventSubscriber(eventClass=PreferencesChangedEvent.class)
    public void preferencesChanged(PreferencesChangedEvent e) {
        if ("Preferences.Enable.DeleteDirectories".equals(e.getKey())) {
            this.setDeleteDirectoryEnabled();
        }
    }

    private void setDeleteDirectoryEnabled() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        boolean enabled = prefs != null && prefs.containsKey("Preferences.Enable.DeleteDirectories") ? prefs.getBoolean("Preferences.Enable.DeleteDirectories") : true;
        this.itemDeleteFilesystemFolder.setEnabled(enabled);
    }
}

