/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.favorites;

import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jphototagger.domain.favorites.Favorite;
import org.jphototagger.lib.swing.MouseEventUtil;
import org.jphototagger.lib.swing.util.TreeUtil;
import org.jphototagger.program.event.listener.TreeMouseListener;
import org.jphototagger.program.module.favorites.DeleteFilesystemFolderFromFavoritesController;
import org.jphototagger.program.module.favorites.FavoritesPopupMenu;

public final class FavoritesMouseListener
extends TreeMouseListener {
    private final FavoritesPopupMenu popupMenu = FavoritesPopupMenu.INSTANCE;

    public FavoritesMouseListener() {
        this.listenExpandAllSubItems(this.popupMenu.getItemExpandAllSubitems(), true);
        this.listenCollapseAllSubItems(this.popupMenu.getItemCollapseAllSubitems(), true);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        super.mousePressed(evt);
        if (MouseEventUtil.isPopupTrigger(evt)) {
            Object usrObj;
            TreePath path = TreeUtil.getTreePath(evt);
            boolean isFavorite = false;
            boolean isDirectory = false;
            this.popupMenu.setTreePath(path);
            if (path != null && (usrObj = path.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)usrObj;
                Object userObject = node.getUserObject();
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                TreeNode root = (TreeNode)((JTree)evt.getSource()).getModel().getRoot();
                isDirectory = userObject instanceof File;
                if (root.equals(parent) && userObject instanceof Favorite) {
                    isFavorite = true;
                    this.popupMenu.setFavoriteDirectory((Favorite)userObject);
                }
            }
            this.popupMenu.getItemDeleteFavorite().setEnabled(isFavorite);
            this.popupMenu.getItemUpdateFavorite().setEnabled(isFavorite);
            this.popupMenu.getItemMoveUp().setEnabled(isFavorite);
            this.popupMenu.getItemMoveDown().setEnabled(isFavorite);
            this.popupMenu.getItemOpenInFolders().setEnabled(isFavorite || isDirectory);
            this.popupMenu.getItemAddFilesystemFolder().setEnabled(isFavorite || isDirectory);
            this.popupMenu.getItemRenameFilesystemFolder().setEnabled(isDirectory);
            this.popupMenu.getItemDeleteFilesystemFolder().setEnabled(isDirectory && DeleteFilesystemFolderFromFavoritesController.isDeleteDirectoriesEnabled());
            this.popupMenu.show((JTree)evt.getSource(), evt.getX(), evt.getY());
        }
    }
}

