/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.favorites;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.filefilter.FileFilterUtil;
import org.jphototagger.domain.thumbnails.OriginOfDisplayedThumbnails;
import org.jphototagger.domain.thumbnails.ThumbnailsPanelSettings;
import org.jphototagger.domain.thumbnails.event.ThumbnailsPanelRefreshEvent;
import org.jphototagger.program.module.favorites.FavoritesUtil;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class FavoriteSelectedController
implements TreeSelectionListener {
    private static final String KEY_RECURSIVE = "FavoriteSelectedController.DirectoriesRecursive";
    private final ActionListener recursiveListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean recursive = ((AbstractButton)e.getSource()).isSelected();
            FavoriteSelectedController.this.persistRecursive(recursive);
            FavoriteSelectedController.this.setFiles(null);
        }
    };

    public FavoriteSelectedController() {
        this.restoreRecursive();
        this.listen();
    }

    private void listen() {
        GUI.getCheckBoxFavoritesRecursive().addActionListener(this.recursiveListener);
        GUI.getFavoritesTree().getSelectionModel().addTreeSelectionListener(this);
        AnnotationProcessor.process(this);
    }

    private void persistRecursive(boolean recursive) {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.setBoolean(KEY_RECURSIVE, recursive);
    }

    private void restoreRecursive() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        GUI.getCheckBoxFavoritesRecursive().setSelected(prefs.getBoolean(KEY_RECURSIVE));
    }

    private static boolean isMyOrigin(OriginOfDisplayedThumbnails origin) {
        return origin.isFilesInSameFavoriteDirectory() || origin.isFilesInFavoriteDirectoryRecursive();
    }

    private static OriginOfDisplayedThumbnails getMyOrigin() {
        return GUI.getCheckBoxFavoritesRecursive().isSelected() ? OriginOfDisplayedThumbnails.FILES_IN_FAVORITE_DIRECTORY_RECURSIVE : OriginOfDisplayedThumbnails.FILES_IN_SAME_FAVORITE_DIRECTORY;
    }

    private static boolean isRecursive() {
        return FavoriteSelectedController.getMyOrigin().isFilesInFavoriteDirectoryRecursive();
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        if (evt.isAddedPath()) {
            this.setFiles(null);
        }
    }

    @EventSubscriber(eventClass=ThumbnailsPanelRefreshEvent.class)
    public void refresh(ThumbnailsPanelRefreshEvent evt) {
        OriginOfDisplayedThumbnails origin;
        if (GUI.getFavoritesTree().getSelectionCount() > 0 && FavoriteSelectedController.isMyOrigin(origin = evt.getOriginOfDisplayedThumbnails())) {
            this.setFiles(evt.getThumbnailsPanelSettings());
        }
    }

    private void setFiles(ThumbnailsPanelSettings settings) {
        List<File> files = this.getFiles(FavoritesUtil.getSelectedDir());
        FavoritesUtil.setFilesToThumbnailPanel(files, settings, FavoriteSelectedController.getMyOrigin());
    }

    private List<File> getFiles(File directory) {
        return directory == null ? Collections.emptyList() : (FavoriteSelectedController.isRecursive() ? FileFilterUtil.getImageFilesOfDirAndSubDirs(directory) : FileFilterUtil.getImageFilesOfDirectory(directory));
    }
}

