/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.favorites;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.favorites.Favorite;
import org.jphototagger.domain.repository.FavoritesRepository;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.DirectoryChooser;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.SelectRootFilesPanel;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class FavoritePropertiesDialog
extends Dialog {
    private static final String KEY_LAST_DIRECTORY = "org.jphototagger.program.view.dialogs.FavoriteDirectoryPropertiesDialog.LastDirectory";
    private static final long serialVersionUID = 1L;
    private final FavoritesRepository repo = Lookup.getDefault().lookup(FavoritesRepository.class);
    private File dir = new File("");
    private boolean accepted;
    private boolean update;
    private JButton buttonCancel;
    private JButton buttonChooseDirectory;
    private JButton buttonOk;
    private JLabel labelDirectoryname;
    private JLabel labelPromptFavoriteName;
    private JTextField textFieldFavoriteName;

    public FavoritePropertiesDialog() {
        super((Frame)GUI.getAppFrame(), true);
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.setHelpPage();
        MnemonicUtil.setMnemonics(this);
    }

    private void setHelpPage() {
        this.setHelpPageUrl(Bundle.getString(FavoritePropertiesDialog.class, "FavoritePropertiesDialog.HelpPage", new Object[0]));
    }

    private void chooseDirectory() {
        DirectoryChooser.Option showHiddenDirs = this.getDirChooserOptionShowHiddenDirs();
        List<File> hideRootFiles = SelectRootFilesPanel.readPersistentRootFiles("UserSettings.HideRootFilesFromDirectoriesTab");
        DirectoryChooser dlg = new DirectoryChooser((Frame)GUI.getAppFrame(), this.dir, hideRootFiles, showHiddenDirs);
        dlg.setPreferencesKey("FavoritePropertiesDialog.DirChooser");
        dlg.setVisible(true);
        this.toFront();
        if (dlg.isAccepted()) {
            this.setDirectory(dlg.getSelectedDirectories().get(0));
        }
        this.setOkEnabled();
    }

    private DirectoryChooser.Option getDirChooserOptionShowHiddenDirs() {
        return this.isAcceptHiddenDirectories() ? DirectoryChooser.Option.DISPLAY_HIDDEN_DIRECTORIES : DirectoryChooser.Option.NO_OPTION;
    }

    private boolean isAcceptHiddenDirectories() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.IsAcceptHiddenDirectories") ? prefs.getBoolean("UserSettings.IsAcceptHiddenDirectories") : false;
    }

    public boolean isEqualsTo(Favorite favorite) {
        if (favorite == null) {
            throw new NullPointerException("favorite == null");
        }
        if (!this.valuesOk()) {
            return false;
        }
        String favoriteName = favorite.getName();
        String componentName = this.getName();
        boolean componentNameIsFavoriteName = componentName.equalsIgnoreCase(favoriteName);
        File favoriteDirectory = favorite.getDirectory();
        return this.dir.equals(favoriteDirectory) && componentNameIsFavoriteName;
    }

    public void setFavoriteName(String name) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        this.textFieldFavoriteName.setText(name);
        this.update = true;
    }

    public void setDirectory(File dir) {
        if (dir == null) {
            throw new NullPointerException("dir == null");
        }
        this.dir = dir;
        String dirPathName = dir.getAbsolutePath();
        this.labelDirectoryname.setText(dirPathName);
        if (this.textFieldFavoriteName.getText().trim().isEmpty()) {
            this.textFieldFavoriteName.setText(dir.getName());
        }
    }

    public void setEnabledButtonChooseDirectory(boolean enabled) {
        this.buttonChooseDirectory.setEnabled(enabled);
    }

    public String getFavoriteName() {
        return this.textFieldFavoriteName.getText().trim();
    }

    public File getDirectory() {
        return this.dir;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    private void exitIfOk() {
        if (this.checkValuesOk()) {
            String favoriteName = this.textFieldFavoriteName.getText().trim();
            boolean exists = this.repo.existsFavorite(favoriteName);
            if (!this.update && exists) {
                String message = Bundle.getString(FavoritePropertiesDialog.class, "FavoritePropertiesDialog.Error.FavoriteExists", favoriteName);
                MessageDisplayer.error(this, message);
            } else {
                this.accepted = true;
                this.setVisible(false);
            }
        }
    }

    private boolean checkValuesOk() {
        if (!this.valuesOk()) {
            String message = Bundle.getString(FavoritePropertiesDialog.class, "FavoritePropertiesDialog.Error.InvalidInput", new Object[0]);
            MessageDisplayer.error(this, message);
            return false;
        }
        return true;
    }

    private boolean valuesOk() {
        return this.dir.isDirectory() && !this.getFavoriteName().isEmpty();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            if (this.dir == null || !this.dir.isDirectory()) {
                this.directoryFromSettings();
            }
            this.setOkEnabled();
        } else {
            this.directoryToSettings();
        }
        super.setVisible(visible);
    }

    private void directoryFromSettings() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        if (prefs.containsKey(KEY_LAST_DIRECTORY)) {
            this.dir = new File(prefs.getString(KEY_LAST_DIRECTORY));
        }
    }

    private void setOkEnabled() {
        this.buttonOk.setEnabled(this.valuesOk());
    }

    private void directoryToSettings() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.setString(KEY_LAST_DIRECTORY, this.dir.getAbsolutePath());
    }

    @Override
    protected void escape() {
        this.accepted = false;
        this.setVisible(false);
    }

    private void handleKeyPressed(KeyEvent evt) {
        if (!this.buttonOk.isEnabled()) {
            return;
        }
        if (evt.getKeyCode() == 10) {
            this.exitIfOk();
        }
    }

    private void initComponents() {
        this.labelPromptFavoriteName = new JLabel();
        this.textFieldFavoriteName = new JTextField();
        this.buttonChooseDirectory = new JButton();
        this.labelDirectoryname = new JLabel();
        this.buttonCancel = new JButton();
        this.buttonOk = new JButton();
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/favorites/Bundle");
        this.setTitle(bundle.getString("FavoritePropertiesDialog.title"));
        this.setName("Form");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FavoritePropertiesDialog.this.formWindowClosing(evt);
            }
        });
        this.labelPromptFavoriteName.setLabelFor(this.textFieldFavoriteName);
        this.labelPromptFavoriteName.setText(bundle.getString("FavoritePropertiesDialog.labelPromptFavoriteName.text"));
        this.labelPromptFavoriteName.setName("labelPromptFavoriteName");
        this.textFieldFavoriteName.setName("textFieldFavoriteName");
        this.textFieldFavoriteName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                FavoritePropertiesDialog.this.textFieldFavoriteNameKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                FavoritePropertiesDialog.this.textFieldFavoriteNameKeyReleased(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                FavoritePropertiesDialog.this.textFieldFavoriteNameKeyTyped(evt);
            }
        });
        this.buttonChooseDirectory.setText(bundle.getString("FavoritePropertiesDialog.buttonChooseDirectory.text_1"));
        this.buttonChooseDirectory.setName("buttonChooseDirectory");
        this.buttonChooseDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FavoritePropertiesDialog.this.buttonChooseDirectoryActionPerformed(evt);
            }
        });
        this.labelDirectoryname.setBorder(BorderFactory.createEtchedBorder());
        this.labelDirectoryname.setName("labelDirectoryname");
        this.buttonCancel.setText(bundle.getString("FavoritePropertiesDialog.buttonCancel.text"));
        this.buttonCancel.setName("buttonCancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FavoritePropertiesDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonOk.setText(bundle.getString("FavoritePropertiesDialog.buttonOk.text"));
        this.buttonOk.setEnabled(false);
        this.buttonOk.setName("buttonOk");
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FavoritePropertiesDialog.this.buttonOkActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelDirectoryname, -1, 281, Short.MAX_VALUE).addComponent(this.textFieldFavoriteName, -1, 281, Short.MAX_VALUE).addComponent(this.labelPromptFavoriteName).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonOk)).addComponent(this.buttonChooseDirectory, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(7, 7, 7).addComponent(this.labelPromptFavoriteName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFieldFavoriteName, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonChooseDirectory).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelDirectoryname, -2, 12, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonOk).addComponent(this.buttonCancel)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(1, this.labelDirectoryname, this.textFieldFavoriteName);
        this.pack();
    }

    private void buttonChooseDirectoryActionPerformed(ActionEvent evt) {
        this.chooseDirectory();
    }

    private void buttonOkActionPerformed(ActionEvent evt) {
        this.exitIfOk();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.escape();
    }

    private void textFieldFavoriteNameKeyPressed(KeyEvent evt) {
        this.handleKeyPressed(evt);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.escape();
    }

    private void textFieldFavoriteNameKeyTyped(KeyEvent evt) {
        this.setOkEnabled();
    }

    private void textFieldFavoriteNameKeyReleased(KeyEvent evt) {
        this.setOkEnabled();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FavoritePropertiesDialog dialog = new FavoritePropertiesDialog();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

