/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.favorites;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.io.TreeFileSystemDirectories;
import org.jphototagger.program.factory.ModelFactory;
import org.jphototagger.program.module.favorites.FavoritesPopupMenu;
import org.jphototagger.program.module.favorites.FavoritesTreeModel;
import org.jphototagger.program.module.filesystem.FileSystemDirectories;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class DeleteFilesystemFolderFromFavoritesController
implements ActionListener,
KeyListener {
    public DeleteFilesystemFolderFromFavoritesController() {
        this.listen();
    }

    private void listen() {
        FavoritesPopupMenu.INSTANCE.getItemDeleteFilesystemFolder().addActionListener(this);
        GUI.getFavoritesTree().addKeyListener(this);
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        Object node;
        JTree tree = GUI.getFavoritesTree();
        if (evt.getKeyCode() == 127 && !tree.isSelectionEmpty() && (node = tree.getSelectionPath().getLastPathComponent()) instanceof DefaultMutableTreeNode) {
            this.deleteDirectory((DefaultMutableTreeNode)node);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                TreePath treePath = FavoritesPopupMenu.INSTANCE.getTreePath();
                DeleteFilesystemFolderFromFavoritesController.this.deleteDirectory(TreeFileSystemDirectories.getNodeOfLastPathComponent(treePath));
            }
        });
    }

    private void deleteDirectory(DefaultMutableTreeNode node) {
        File dir;
        if (!DeleteFilesystemFolderFromFavoritesController.isDeleteDirectoriesEnabled()) {
            return;
        }
        File file = dir = node == null ? null : TreeFileSystemDirectories.getFile(node);
        if (dir != null && FileSystemDirectories.delete(dir)) {
            FavoritesTreeModel model = ModelFactory.INSTANCE.getModel(FavoritesTreeModel.class);
            TreeFileSystemDirectories.removeFromTreeModel(model, node);
        }
    }

    static boolean isDeleteDirectoriesEnabled() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("Preferences.Enable.DeleteDirectories") ? prefs.getBoolean("Preferences.Enable.DeleteDirectories") : true;
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }
}

