/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.favorites;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.io.TreeFileSystemDirectories;
import org.jphototagger.lib.swing.KeyEventUtil;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.factory.ControllerFactory;
import org.jphototagger.program.factory.ModelFactory;
import org.jphototagger.program.module.favorites.FavoritesPopupMenu;
import org.jphototagger.program.module.favorites.FavoritesTreeModel;
import org.jphototagger.program.module.filesystem.MoveFilesController;
import org.jphototagger.program.resource.GUI;

public final class AddFilesystemFolderToFavoritesController
implements ActionListener,
KeyListener {
    public AddFilesystemFolderToFavoritesController() {
        this.listen();
    }

    private void listen() {
        FavoritesPopupMenu.INSTANCE.getItemAddFilesystemFolder().addActionListener(this);
        GUI.getFavoritesTree().addKeyListener(this);
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        final JTree tree = GUI.getFavoritesTree();
        if (KeyEventUtil.isMenuShortcut(evt, 78) && !tree.isSelectionEmpty()) {
            EventQueueUtil.invokeInDispatchThread(new Runnable(){

                @Override
                public void run() {
                    Object node = tree.getSelectionPath().getLastPathComponent();
                    if (node instanceof DefaultMutableTreeNode) {
                        DefaultMutableTreeNode pathNode = (DefaultMutableTreeNode)node;
                        AddFilesystemFolderToFavoritesController.this.createDirectory(new TreePath(pathNode.getPath()));
                    }
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.createDirectory(FavoritesPopupMenu.INSTANCE.getTreePath());
    }

    private void createDirectory(TreePath path) {
        FavoritesTreeModel model = ModelFactory.INSTANCE.getModel(FavoritesTreeModel.class);
        File dir = model.createNewDirectory(TreeFileSystemDirectories.getNodeOfLastPathComponent(path));
        if (dir != null) {
            this.confirmMoveSelFilesInto(dir);
        }
    }

    public void confirmMoveSelFilesInto(File dir) {
        MoveFilesController ctrl;
        List<File> selFiles;
        if (dir == null) {
            throw new NullPointerException("dir == null");
        }
        if (dir.isDirectory() && !(selFiles = GUI.getSelectedImageFiles()).isEmpty() && this.isMoveSelFiles() && (ctrl = ControllerFactory.INSTANCE.getController(MoveFilesController.class)) != null) {
            ctrl.moveFilesWithoutConfirm(selFiles, dir);
        }
    }

    private boolean isMoveSelFiles() {
        String message = Bundle.getString(AddFilesystemFolderToFavoritesController.class, "AddFilesystemFolderToFavoritesController.Confirm.MoveSelFiles", new Object[0]);
        return MessageDisplayer.confirmYesNo(null, message);
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }
}

