/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.exportimport.importer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jphototagger.domain.repository.RepositoryDataImporter;
import org.jphototagger.program.module.exportimport.exporter.KeywordsExporterJpt;
import org.jphototagger.program.module.exportimport.importer.KeywordString;
import org.jphototagger.program.module.exportimport.importer.KeywordsImporter;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class KeywordsImporterJpt
extends KeywordsImporter
implements RepositoryDataImporter,
EntityResolver {
    @Override
    public Collection<List<KeywordString>> getPaths(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            docBuilder.setEntityResolver(this);
            Document doc = docBuilder.parse(file);
            NodeList nl = doc.getElementsByTagName("keywords");
            if (nl.getLength() > 0) {
                return this.getPaths(nl.item(0));
            }
        }
        catch (Throwable t) {
            Logger.getLogger(KeywordsImporterJpt.class.getName()).log(Level.SEVERE, null, t);
        }
        return null;
    }

    private List<List<KeywordString>> getPaths(Node rootNode) {
        ArrayList<List<KeywordString>> paths = new ArrayList<List<KeywordString>>();
        List<Node> leafs = this.getAllLeafs(rootNode);
        ArrayList<Stack<Node>> pathStacks = new ArrayList<Stack<Node>>();
        for (Node node : leafs) {
            Stack<Node> stack = new Stack<Node>();
            stack.push(node);
            this.pushParents(stack, node);
            pathStacks.add(stack);
        }
        for (Stack stack : pathStacks) {
            ArrayList<KeywordString> path = new ArrayList<KeywordString>(stack.size());
            while (!stack.isEmpty()) {
                path.add(this.getKeyword((Node)stack.pop()));
            }
            paths.add(path);
        }
        return paths;
    }

    private KeywordString getKeyword(Node node) {
        NamedNodeMap attr = node.getAttributes();
        String name = attr.getNamedItem("name").getNodeValue();
        Boolean real = attr.getNamedItem("type").getNodeValue().equals(KeywordsExporterJpt.VALUE_OF_ATTRIBUTE_TYPE.get(true));
        return new KeywordString(name, real);
    }

    private void pushParents(Stack<Node> nodes, Node node) {
        Node parent = node.getParentNode();
        if (parent != null && !parent.getNodeName().equals("keywords")) {
            nodes.push(parent);
            this.pushParents(nodes, parent);
        }
    }

    private List<Node> getAllLeafs(Node rootNode) {
        ArrayList<Node> leafs = new ArrayList<Node>();
        NodeList nl = rootNode.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            this.addLeaf(leafs, nl.item(i));
        }
        return leafs;
    }

    private void addLeaf(Collection<Node> leafs, Node node) {
        if (!node.getNodeName().equals("keyword")) {
            return;
        }
        NodeList nl = node.getChildNodes();
        int length = nl.getLength();
        if (length <= 0) {
            leafs.add(node);
            return;
        }
        for (int i = 0; i < length; ++i) {
            this.addLeaf(leafs, nl.item(i));
        }
    }

    @Override
    public FileFilter getFileFilter() {
        return KeywordsExporterJpt.FILE_FILTER;
    }

    @Override
    public String getDisplayName() {
        return KeywordsExporterJpt.DISPLAY_NAME;
    }

    @Override
    public Icon getIcon() {
        return KeywordsExporterJpt.ICON;
    }

    @Override
    public String getDefaultFilename() {
        return "JptKeywords.xml";
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (systemId == null) {
            throw new NullPointerException("systemId == null");
        }
        InputStream stream = null;
        String dtd = "keywords.dtd";
        if (systemId.endsWith(dtd)) {
            String name = "/org/jphototagger/program/resource/dtd/" + dtd;
            stream = EntityResolver.class.getResourceAsStream(name);
            assert (stream != null) : name;
        }
        return stream == null ? null : new InputSource(new InputStreamReader(stream));
    }

    @Override
    public int getPosition() {
        return 10;
    }

    @Override
    public boolean isJPhotoTaggerData() {
        return true;
    }

    @Override
    public void importFromFile(File file) {
        this.importKeywordsFile(file);
    }
}

