/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.exportimport.importer;

import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jphototagger.api.concurrent.Cancelable;
import org.jphototagger.api.messages.MessageType;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressHandle;
import org.jphototagger.api.progress.ProgressHandleFactory;
import org.jphototagger.api.windows.MainWindowManager;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.factory.ModelFactory;
import org.jphototagger.program.module.exportimport.importer.KeywordString;
import org.jphototagger.program.module.keywords.tree.KeywordsTreeModel;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public abstract class KeywordsImporter {
    public abstract Collection<List<KeywordString>> getPaths(File var1);

    protected void importKeywordsFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        Collection<List<KeywordString>> paths = this.getPaths(file);
        if (paths != null) {
            new ImportTask(paths).start();
        }
    }

    private static class ImportTask
    extends Thread
    implements Cancelable {
        private final Collection<List<KeywordString>> paths;
        private final TreeModel treeModel = ModelFactory.INSTANCE.getModel(KeywordsTreeModel.class);
        private volatile boolean cancel;
        private final Object source = this;
        private static final String PROGRESSBAR_STRING = Bundle.getString(KeywordsImporter.class, "KeywordImporter.ProgressBar.String", new Object[0]);
        private ProgressHandle progressHandle;

        ImportTask(Collection<List<KeywordString>> paths) {
            super("JPhotoTagger: Importing keywords");
            if (paths == null) {
                throw new NullPointerException("paths == null");
            }
            this.paths = paths;
        }

        @Override
        public void cancel() {
            this.cancel = true;
        }

        @Override
        public void run() {
            EventQueueUtil.invokeInDispatchThread(new Runnable(){

                @Override
                public void run() {
                    ImportTask.this.importKeywords();
                }
            });
        }

        private void importKeywords() {
            if (this.treeModel instanceof KeywordsTreeModel) {
                KeywordsTreeModel model = (KeywordsTreeModel)this.treeModel;
                this.progressHandle = Lookup.getDefault().lookup(ProgressHandleFactory.class).createProgressHandle(this);
                this.progressHandle.progressStarted(this.createProgressEventWithValue(0));
                int progressValue = 0;
                int importCount = 0;
                for (List<KeywordString> path : this.paths) {
                    if (this.cancel || this.isInterrupted()) break;
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getRoot();
                    for (KeywordString keyword : path) {
                        DefaultMutableTreeNode existingNode = model.findChildByName(node, keyword.getKeyword());
                        if (existingNode == null) {
                            model.insert(node, keyword.getKeyword(), keyword.isReal(), false);
                            node = model.findChildByName(node, keyword.getKeyword());
                            ++importCount;
                            continue;
                        }
                        node = existingNode;
                    }
                    this.progressHandle.progressPerformed(this.createProgressEventWithValue(++progressValue));
                }
                this.progressHandle.progressEnded();
                this.messageImported(importCount);
                this.expandRootSelHk();
            }
        }

        private void expandRootSelHk() {
            JTree tree = GUI.getAppPanel().getTreeSelKeywords();
            Object root = tree.getModel().getRoot();
            tree.expandPath(new TreePath(((DefaultMutableTreeNode)root).getPath()));
        }

        private ProgressEvent createProgressEventWithValue(int value) {
            return new ProgressEvent.Builder().source(this.source).minimum(0).maximum(this.paths.size()).value(value).stringPainted(true).stringToPaint(PROGRESSBAR_STRING).build();
        }

        private void messageImported(int importCount) {
            String message = Bundle.getString(ImportTask.class, "ImportTask.Info.Imported", importCount);
            MainWindowManager messageDisplayer = Lookup.getDefault().lookup(MainWindowManager.class);
            messageDisplayer.setMainWindowStatusbarText(message, MessageType.INFO, 2000L);
        }
    }
}

