/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.exportimport.exporter;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jphototagger.domain.metadata.keywords.Keyword;
import org.jphototagger.domain.repository.KeywordsRepository;
import org.jphototagger.domain.repository.RepositoryDataExporter;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.app.ui.AppLookAndFeel;
import org.openide.util.Lookup;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class KeywordsExporterJpt
implements RepositoryDataExporter {
    public static final String DEFAULT_FILENAME = "JptKeywords.xml";
    public static final String DTD = "keywords.dtd";
    public static final int POSITION = 10;
    public static final String TAGNAME_ROOT = "keywords";
    public static final String TAGNAME_KEYWORD = "keyword";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final Map<Boolean, String> VALUE_OF_ATTRIBUTE_TYPE = new HashMap<Boolean, String>();
    public static final String ATTRIBUTE_NAME = "name";
    public static final Icon ICON = AppLookAndFeel.getIcon("icon_app_small.png");
    public static final String DISPLAY_NAME = Bundle.getString(KeywordsExporterJpt.class, "KeywordExporterJpt.DisplayName", new Object[0]);
    public static final FileFilter FILE_FILTER = new FileNameExtensionFilter(DISPLAY_NAME, "xml");
    private final KeywordsRepository repo = Lookup.getDefault().lookup(KeywordsRepository.class);

    @Override
    public void exportToFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        try {
            Document doc = this.getXml();
            DOMSource ds = new DOMSource(doc);
            StreamResult sr = new StreamResult(this.checkSuffix(file));
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer trans = tf.newTransformer();
            this.initTransformer(trans);
            trans.transform(ds, sr);
        }
        catch (Throwable t) {
            Logger.getLogger(KeywordsExporterJpt.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    private File checkSuffix(File file) {
        String suffix = ".xml";
        if (!file.getName().endsWith(suffix)) {
            return new File(file.getAbsolutePath() + suffix);
        }
        return file;
    }

    private Document getXml() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        DOMImplementation impl = builder.getDOMImplementation();
        Document doc = impl.createDocument(null, null, null);
        Element rootElement = doc.createElement(TAGNAME_ROOT);
        doc.appendChild(rootElement);
        this.appendChildren(doc, rootElement, null);
        return doc;
    }

    private void appendChildren(Document doc, Element parentElement, Keyword parentKeyword) {
        Collection<Keyword> children = parentKeyword == null ? this.repo.findRootKeywords() : this.repo.findChildKeywords(parentKeyword.getId());
        for (Keyword childKeyword : children) {
            Element childElement = this.appendChild(doc, parentElement, childKeyword);
            this.appendChildren(doc, childElement, childKeyword);
        }
    }

    private Element appendChild(Document doc, Element parentElement, Keyword childKeyword) {
        Element childElement = doc.createElement(TAGNAME_KEYWORD);
        this.setElementAttributes(childElement, childKeyword);
        parentElement.appendChild(childElement);
        return childElement;
    }

    private void setElementAttributes(Element el, Keyword keyword) throws DOMException {
        el.setAttribute(ATTRIBUTE_NAME, keyword.getName());
        el.setAttribute(ATTRIBUTE_TYPE, VALUE_OF_ATTRIBUTE_TYPE.get(keyword.isReal()));
    }

    private void initTransformer(Transformer trans) throws IllegalArgumentException {
        trans.setOutputProperty("method", "xml");
        trans.setOutputProperty("encoding", "UTF8");
        trans.setOutputProperty("doctype-system", DTD);
        trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        trans.setOutputProperty("indent", "yes");
        trans.setOutputProperty("standalone", "no");
    }

    @Override
    public FileFilter getFileFilter() {
        return FILE_FILTER;
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public String getDefaultFilename() {
        return DEFAULT_FILENAME;
    }

    @Override
    public boolean isJPhotoTaggerData() {
        return true;
    }

    @Override
    public int getPosition() {
        return 10;
    }

    public String toString() {
        return this.getDisplayName();
    }

    static {
        VALUE_OF_ATTRIBUTE_TYPE.put(true, "real");
        VALUE_OF_ATTRIBUTE_TYPE.put(false, "helper");
    }

    private static class FilenameSuffixes {
        public static final String LIGHTROOM_KEYWORDS = "txt";
        public static final String JPT_KEYWORDS = "xml";

        private FilenameSuffixes() {
        }
    }
}

