/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.exportimport;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.event.listener.ListenerSupport;
import org.jphototagger.domain.repository.RepositoryDataExporter;
import org.jphototagger.domain.repository.RepositoryDataImporter;
import org.jphototagger.lib.api.LayerUtil;
import org.jphototagger.lib.api.PositionProviderAscendingComparator;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.swing.DirectoryChooser;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.swing.LongMessageDialog;
import org.jphototagger.lib.swing.SelectObjectsPanel;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.CollectionUtil;
import org.jphototagger.program.module.exportimport.ExportImportContext;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public class ExportImportPanel
extends JPanel
implements SelectObjectsPanel.SelectionListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ExportImportPanel.class.getName());
    private static final String TEXT_EXPORT = Bundle.getString(ExportImportPanel.class, "ExportImportPanel.Button.DisplayName.Export", new Object[0]);
    private static final String TEXT_IMPORT = Bundle.getString(ExportImportPanel.class, "ExportImportPanel.Button.DisplayName.Import", new Object[0]);
    private static final String KEY_SEL_INDICES_EXPORT = "ExportImportPanel.Export.SelIndices";
    private static final String KEY_SEL_INDICES_IMPORT = "ExportImportPanel.Import.SelIndices";
    private static final String KEY_LAST_DIR = "ExportImportPanel.LastDirectory";
    private ExportImportContext context = ExportImportContext.EXPORT;
    private File dir;
    private final transient ListenerSupport<ExportImportListener> ls = new ListenerSupport();
    private JButton buttonExportImport;
    private JButton buttonSelDir;
    private JButton buttonSelectAll;
    private JButton buttonSelectNone;
    private JLabel labelDir;
    private JLabel labelPromptDir;
    private JLabel labelSelectInfo;
    private JPanel panelButtons;
    private JPanel panelDirectory;
    private SelectObjectsPanel panelSelectObjects;
    private JScrollPane scrollPane;

    public ExportImportPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    public ExportImportPanel(ExportImportContext context) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        this.context = context;
        this.initComponents();
        this.postInitComponents();
        this.addObjects();
    }

    private void postInitComponents() {
        MnemonicUtil.setMnemonics(this);
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        String lastDirString = prefs == null ? "" : prefs.getString(KEY_LAST_DIR);
        this.dir = new File(lastDirString);
        if (this.dir.isDirectory()) {
            this.setDirLabel();
        }
        this.setInfoLabel();
        this.panelSelectObjects.addSelectionListener(this);
    }

    private void setInfoLabel() {
        this.labelSelectInfo.setText(this.isExport() ? Bundle.getString(ExportImportPanel.class, "ExportImportPanel.LabelSelectInfo.Text.Export", new Object[0]) : Bundle.getString(ExportImportPanel.class, "ExportImportPanel.LabelSelectInfo.Text.Import", new Object[0]));
    }

    public void setContext(ExportImportContext context) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        this.context = context;
        this.setInfoLabel();
        this.addObjects();
    }

    private void addObjects() {
        if (this.isExport()) {
            this.setExportCheckBoxes();
        } else {
            this.setImportCheckBoxes();
        }
        this.panelSelectObjects.setPreferencesKeyForSelectedIndices(this.isExport() ? KEY_SEL_INDICES_EXPORT : KEY_SEL_INDICES_IMPORT);
        this.panelSelectObjects.restoreSelectedIndices();
        this.buttonExportImport.setText(this.isExport() ? TEXT_EXPORT : TEXT_IMPORT);
        MnemonicUtil.setMnemonics(this);
        this.setEnabledButtons();
    }

    private boolean isExport() {
        return this.context.equals((Object)ExportImportContext.EXPORT);
    }

    private void setExportCheckBoxes() {
        List<RepositoryDataExporter> exporters = this.getJptExporters();
        this.panelSelectObjects.removeAll();
        this.panelSelectObjects.setObjectCount(exporters.size());
        for (RepositoryDataExporter exporter : exporters) {
            this.panelSelectObjects.add(exporter, exporter.getDisplayName());
        }
    }

    private List<RepositoryDataExporter> getJptExporters() {
        Collection<RepositoryDataExporter> allExporters = Lookup.getDefault().lookupAll(RepositoryDataExporter.class);
        ArrayList<RepositoryDataExporter> jptExporters = new ArrayList<RepositoryDataExporter>(allExporters.size());
        for (RepositoryDataExporter exporter : allExporters) {
            if (!exporter.isJPhotoTaggerData()) continue;
            jptExporters.add(exporter);
        }
        Collections.sort(jptExporters, PositionProviderAscendingComparator.INSTANCE);
        LayerUtil.logWarningIfNotUniquePositions(jptExporters);
        return jptExporters;
    }

    private void setImportCheckBoxes() {
        List<RepositoryDataImporter> importers = this.getJptImporters();
        this.panelSelectObjects.removeAll();
        this.panelSelectObjects.setObjectCount(importers.size());
        for (RepositoryDataImporter importer : importers) {
            this.panelSelectObjects.add(importer, importer.getDisplayName());
        }
    }

    private List<RepositoryDataImporter> getJptImporters() {
        Collection<RepositoryDataImporter> allImporters = Lookup.getDefault().lookupAll(RepositoryDataImporter.class);
        ArrayList<RepositoryDataImporter> jptImporters = new ArrayList<RepositoryDataImporter>(allImporters.size());
        for (RepositoryDataImporter importer : allImporters) {
            if (!importer.isJPhotoTaggerData()) continue;
            jptImporters.add(importer);
        }
        Collections.sort(jptImporters, PositionProviderAscendingComparator.INSTANCE);
        LayerUtil.logWarningIfNotUniquePositions(jptImporters);
        return jptImporters;
    }

    private void selectDirectory() {
        DirectoryChooser.Option showHiddenDirs = this.getDirChooserOptionShowHiddenDirs();
        File lastDir = this.getLastDirForChooser();
        DirectoryChooser dlg = new DirectoryChooser((Frame)GUI.getAppFrame(), lastDir, showHiddenDirs);
        dlg.setPreferencesKey("ExportImportPanel.DirChooser");
        dlg.setVisible(true);
        ComponentUtil.parentWindowToFront(this);
        if (dlg.isAccepted()) {
            this.dir = dlg.getSelectedDirectories().get(0);
            Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
            prefs.setString(KEY_LAST_DIR, this.dir.getAbsolutePath());
            this.setDirLabel();
            this.setEnabledButtons();
        }
    }

    private File getLastDirForChooser() {
        File lastDir;
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        if (prefs.containsKey(KEY_LAST_DIR) && (lastDir = new File(prefs.getString(KEY_LAST_DIR))).isDirectory()) {
            return lastDir;
        }
        return new File("");
    }

    private DirectoryChooser.Option getDirChooserOptionShowHiddenDirs() {
        return this.isAcceptHiddenDirectories() ? DirectoryChooser.Option.DISPLAY_HIDDEN_DIRECTORIES : DirectoryChooser.Option.NO_OPTION;
    }

    private boolean isAcceptHiddenDirectories() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.IsAcceptHiddenDirectories") ? prefs.getBoolean("UserSettings.IsAcceptHiddenDirectories") : false;
    }

    private void setDirLabel() {
        this.labelDir.setText(FileUtil.toStringWithMaximumLength(this.dir, 45));
        this.labelDir.setIcon(IconUtil.getSystemIcon(this.dir));
    }

    private void exportImport() {
        if (this.context.equals((Object)ExportImportContext.EXPORT)) {
            this.exportFiles();
        } else {
            this.importFiles();
        }
        this.notifyExportImportListeners();
    }

    private void exportFiles() {
        List<Object> selectedObjects = this.panelSelectObjects.getSelectedObjects();
        ArrayList<File> exportedFiles = new ArrayList<File>(selectedObjects.size());
        for (Object o : selectedObjects) {
            if (!(o instanceof RepositoryDataExporter)) continue;
            RepositoryDataExporter exporter = (RepositoryDataExporter)o;
            File exportFile = new File(this.dir.getAbsolutePath() + File.separator + exporter.getDefaultFilename());
            this.logExport(exporter, exportFile);
            exporter.exportToFile(exportFile);
            exportedFiles.add(exportFile);
        }
        this.displayFiles(Bundle.getString(ExportImportPanel.class, "ExportImportPanel.Info.ExportedFiles", new Object[0]), exportedFiles);
    }

    private void displayFiles(String shortMessage, Collection<? extends File> files) {
        if (files.size() > 0) {
            LongMessageDialog dialog = new LongMessageDialog(ComponentUtil.findFrameWithIcon(), true);
            String filesString = CollectionUtil.toTokenString(files, "\n", "");
            dialog.setTitle(Bundle.getString(ExportImportPanel.class, "ExportImportPanel.DisplayFiles.DialogTitle", new Object[0]));
            dialog.setShortMessage(shortMessage);
            dialog.setLongMessage(filesString);
            dialog.setVisible(true);
        }
    }

    private void logExport(RepositoryDataExporter exporter, File exportFile) {
        String exporterDisplayName = exporter.getDisplayName();
        LOGGER.log(Level.INFO, "{0}: Exporting File ''{1}''", new Object[]{exporterDisplayName, exportFile});
    }

    private void importFiles() {
        ArrayList<File> importedFiles = new ArrayList<File>();
        ArrayList<File> missingFiles = new ArrayList<File>();
        List<Object> selectedObjects = this.panelSelectObjects.getSelectedObjects();
        for (Object o : selectedObjects) {
            if (!(o instanceof RepositoryDataImporter)) continue;
            RepositoryDataImporter importer = (RepositoryDataImporter)o;
            File importFile = new File(this.dir.getAbsolutePath() + File.separator + importer.getDefaultFilename());
            if (importFile.exists()) {
                this.logImport(importer, importFile);
                importer.importFromFile(importFile);
                importedFiles.add(importFile);
                continue;
            }
            this.logImportErrorFileDoesNotExist(importer, importFile);
            missingFiles.add(importFile);
        }
        this.displayFiles(Bundle.getString(ExportImportPanel.class, "ExportImportPanel.Info.ImportedFiles", new Object[0]), importedFiles);
    }

    private void logImport(RepositoryDataImporter importer, File importFile) {
        String importerDisplayName = importer.getDisplayName();
        LOGGER.log(Level.INFO, "{0}: Importing File ''{1}''", new Object[]{importerDisplayName, importFile});
    }

    private void logImportErrorFileDoesNotExist(RepositoryDataImporter importer, File importFile) {
        String importerDisplayName = importer.getDisplayName();
        LOGGER.log(Level.INFO, "{0}: The following file can''t be imported, because it does not exist: ''{1}''", new Object[]{importerDisplayName, importFile});
    }

    private void setEnabledButtons() {
        int selCount = this.panelSelectObjects.getSelectionCount();
        int objectCount = this.panelSelectObjects.getObjectCount();
        this.buttonExportImport.setEnabled(this.dir != null && this.dir.isDirectory() && selCount > 0);
        this.buttonSelectAll.setEnabled(objectCount > 0 && objectCount > selCount);
        this.buttonSelectNone.setEnabled(selCount > 0);
    }

    @Override
    public void objectSelected(SelectObjectsPanel.SelectionEvent evt) {
        this.setEnabledButtons();
    }

    private void setSelectedAll(boolean select) {
        this.panelSelectObjects.setSelectedAll(select);
        this.setEnabledButtons();
    }

    public void addListener(ExportImportListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        this.ls.add(listener);
    }

    public void removeListener(ExportImportListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        this.ls.remove(listener);
    }

    private void notifyExportImportListeners() {
        for (ExportImportListener listener : this.ls.get()) {
            listener.done();
        }
    }

    private void initComponents() {
        this.panelDirectory = new JPanel();
        this.labelPromptDir = new JLabel();
        this.labelDir = new JLabel();
        this.buttonSelDir = new JButton();
        this.labelSelectInfo = new JLabel();
        this.scrollPane = new JScrollPane();
        this.panelSelectObjects = new SelectObjectsPanel();
        this.panelButtons = new JPanel();
        this.buttonSelectAll = new JButton();
        this.buttonSelectNone = new JButton();
        this.buttonExportImport = new JButton();
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.panelDirectory.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/exportimport/Bundle");
        this.labelPromptDir.setText(bundle.getString("ExportImportPanel.labelPromptDir.text"));
        this.labelPromptDir.setName("labelPromptDir");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelDirectory.add((Component)this.labelPromptDir, gridBagConstraints);
        this.labelDir.setName("labelDir");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelDirectory.add((Component)this.labelDir, gridBagConstraints);
        this.buttonSelDir.setText(bundle.getString("ExportImportPanel.buttonSelDir.text"));
        this.buttonSelDir.setName("buttonSelDir");
        this.buttonSelDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportImportPanel.this.buttonSelDirActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelDirectory.add((Component)this.buttonSelDir, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.panelDirectory, gridBagConstraints);
        this.labelSelectInfo.setText("Auswahl:");
        this.labelSelectInfo.setName("labelSelectInfo");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.labelSelectInfo, gridBagConstraints);
        this.scrollPane.setName("scrollPane");
        this.panelSelectObjects.setName("panelSelectObjects");
        this.scrollPane.setViewportView(this.panelSelectObjects);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 100;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.scrollPane, gridBagConstraints);
        this.panelButtons.setLayout(new GridBagLayout());
        this.buttonSelectAll.setText(bundle.getString("ExportImportPanel.buttonSelectAll.text"));
        this.buttonSelectAll.setEnabled(false);
        this.buttonSelectAll.setName("buttonSelectAll");
        this.buttonSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportImportPanel.this.buttonSelectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelButtons.add((Component)this.buttonSelectAll, gridBagConstraints);
        this.buttonSelectNone.setText(bundle.getString("ExportImportPanel.buttonSelectNone.text"));
        this.buttonSelectNone.setEnabled(false);
        this.buttonSelectNone.setName("buttonSelectNone");
        this.buttonSelectNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportImportPanel.this.buttonSelectNoneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelButtons.add((Component)this.buttonSelectNone, gridBagConstraints);
        this.buttonExportImport.setText(TEXT_EXPORT);
        this.buttonExportImport.setEnabled(false);
        this.buttonExportImport.setName("buttonExportImport");
        this.buttonExportImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportImportPanel.this.buttonExportImportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelButtons.add((Component)this.buttonExportImport, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelButtons, gridBagConstraints);
    }

    private void buttonSelDirActionPerformed(ActionEvent evt) {
        this.selectDirectory();
    }

    private void buttonExportImportActionPerformed(ActionEvent evt) {
        this.exportImport();
    }

    private void buttonSelectAllActionPerformed(ActionEvent evt) {
        this.setSelectedAll(true);
    }

    private void buttonSelectNoneActionPerformed(ActionEvent evt) {
        this.setSelectedAll(false);
    }

    public static interface ExportImportListener {
        public void done();
    }
}

