/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.editmetadata;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jphototagger.domain.event.listener.TextEntryListener;
import org.jphototagger.domain.event.listener.TextEntryListenerSupport;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpRatingMetaDataValue;
import org.jphototagger.domain.text.TextEntry;
import org.jphototagger.lib.util.StringUtil;
import org.jphototagger.program.app.ui.AppLookAndFeel;

public class RatingSelectionPanel
extends JPanel
implements TextEntry,
FocusListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private final Icon star = AppLookAndFeel.getIcon("icon_xmp_rating_set.png");
    private final Icon dark_star = AppLookAndFeel.getIcon("icon_xmp_rating_not_set.png");
    private final Icon icon_rating_remove = AppLookAndFeel.getIcon("icon_xmp_rating_remove.png");
    private final Icon icon_rating_remove_not_set = AppLookAndFeel.getIcon("icon_xmp_rating_remove_not_set.png");
    private final transient MetaDataValue metaDataValue;
    private boolean editable;
    private boolean dirty = false;
    private int value = 0;
    private final JButton[] buttons = new JButton[5];
    private JButton lastClickedButton;
    private final transient TextEntryListenerSupport textEntryListenerSupport = new TextEntryListenerSupport();
    private final Map<JButton, String> textOfButton = new HashMap<JButton, String>();
    private JButton buttonNoRating;
    private JButton buttonStar1;
    private JButton buttonStar2;
    private JButton buttonStar3;
    private JButton buttonStar4;
    private JButton buttonStar5;
    private JLabel labelPrompt;

    public RatingSelectionPanel(MetaDataValue metaDataValue) {
        if (metaDataValue == null) {
            throw new NullPointerException("metaDataValue == null");
        }
        this.metaDataValue = metaDataValue;
        this.init();
    }

    public RatingSelectionPanel() {
        this.metaDataValue = XmpRatingMetaDataValue.INSTANCE;
        this.init();
    }

    private void init() {
        this.initComponents();
        this.buttons[0] = this.buttonStar1;
        this.buttons[1] = this.buttonStar2;
        this.buttons[2] = this.buttonStar3;
        this.buttons[3] = this.buttonStar4;
        this.buttons[4] = this.buttonStar5;
        this.setPropmt();
        this.setTextOfButtonMap();
        this.listenToButtons();
    }

    private void setTextOfButtonMap() {
        this.textOfButton.put(this.buttonStar1, "1");
        this.textOfButton.put(this.buttonStar2, "2");
        this.textOfButton.put(this.buttonStar3, "3");
        this.textOfButton.put(this.buttonStar4, "4");
        this.textOfButton.put(this.buttonStar5, "5");
        this.textOfButton.put(this.buttonNoRating, "");
    }

    private void listenToButtons() {
        for (JButton button : this.buttons) {
            button.addFocusListener(this);
            button.addKeyListener(this);
        }
        this.buttonNoRating.addFocusListener(this);
        this.buttonNoRating.addKeyListener(this);
    }

    private void setPropmt() {
        this.labelPrompt.setText(this.metaDataValue.getDescription());
        this.labelPrompt.setLabelFor(this.buttonNoRating);
    }

    @Override
    public String getText() {
        if (this.value < 0) {
            return "";
        }
        return String.valueOf(this.value);
    }

    @Override
    public void empty() {
        this.setText("0");
    }

    @Override
    public void setText(String text) {
        if (text == null) {
            throw new NullPointerException("text == null");
        }
        int inputAsInteger = 0;
        try {
            if (StringUtil.hasContent(text)) {
                inputAsInteger = Integer.valueOf(text);
            }
        }
        catch (Throwable t) {
            Logger.getLogger(RatingSelectionPanel.class.getName()).log(Level.SEVERE, null, t);
            return;
        }
        if (this.value == inputAsInteger) {
            return;
        }
        this.value = inputAsInteger;
        for (int i = 0; i < this.buttons.length; ++i) {
            if (i >= inputAsInteger) {
                this.buttons[i].setIcon(this.dark_star);
                continue;
            }
            this.buttons[i].setIcon(this.star);
        }
        this.buttonNoRating.setIcon(this.value > 0 ? this.icon_rating_remove_not_set : this.icon_rating_remove);
        this.dirty = true;
    }

    public void setTextAndNotify(String text) {
        if (text == null) {
            throw new NullPointerException("text == null");
        }
        String oldText = this.getText();
        this.setText(text);
        this.dirty = true;
        this.notifyTextChanged(this.metaDataValue, oldText, text);
    }

    @Override
    public MetaDataValue getMetaDataValue() {
        return this.metaDataValue;
    }

    @Override
    public void requestFocus() {
        this.buttonNoRating.requestFocus();
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public boolean isEmpty() {
        return this.value == 0;
    }

    @Override
    public void enableAutocomplete() {
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public void addTextEntryListener(TextEntryListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        this.textEntryListenerSupport.add(listener);
    }

    @Override
    public void removeTextEntryListener(TextEntryListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        this.textEntryListenerSupport.remove(listener);
    }

    private void notifyTextChanged(MetaDataValue mdValue, String oldText, String newText) {
        this.textEntryListenerSupport.notifyTextChanged(mdValue, oldText, newText);
    }

    @Override
    public List<Component> getInputComponents() {
        return Arrays.asList(this.buttonNoRating, this.buttonStar1, this.buttonStar2, this.buttonStar3, this.buttonStar4, this.buttonStar5);
    }

    public void repeatLastClick() {
        if (this.lastClickedButton != null) {
            this.handleButtonPressed(this.lastClickedButton);
        }
    }

    @Override
    public synchronized void addMouseListenerToInputComponents(MouseListener l) {
        if (l == null) {
            throw new NullPointerException("l == null");
        }
        List<Component> inputComponents = this.getInputComponents();
        for (Component component : inputComponents) {
            component.addMouseListener(l);
        }
    }

    @Override
    public synchronized void removeMouseListenerFromInputComponents(MouseListener l) {
        if (l == null) {
            throw new NullPointerException("l == null");
        }
        List<Component> inputComponents = this.getInputComponents();
        for (Component component : inputComponents) {
            component.removeMouseListener(l);
        }
    }

    private void handleButtonPressed(JButton button) {
        assert (this.textOfButton.containsKey(button));
        this.lastClickedButton = button;
        if (!this.editable) {
            return;
        }
        String oldVal = this.getText();
        this.setText(this.textOfButton.get(button));
        this.dirty = true;
        this.notifyTextChanged(this.metaDataValue, oldVal, this.getText());
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        if (evt.getKeyCode() != 10 && evt.getKeyCode() != 32) {
            return;
        }
        Object src = evt.getSource();
        if (src instanceof JButton) {
            this.handleButtonPressed((JButton)src);
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    @Override
    public void focusGained(FocusEvent evt) {
        boolean isButton = evt.getSource() instanceof JButton;
        if (!isButton) {
            throw new IllegalArgumentException("Not ab button: " + evt.getSource());
        }
        ((JButton)evt.getSource()).setBorder(BorderFactory.createLineBorder(Color.GRAY));
    }

    @Override
    public void focusLost(FocusEvent evt) {
        assert (evt.getSource() instanceof JButton) : evt.getSource();
        ((JButton)evt.getSource()).setBorder(null);
    }

    @Override
    public Collection<? extends Component> getExcludeFromAutoMnemonicComponents() {
        return Collections.emptyList();
    }

    private void initComponents() {
        this.labelPrompt = new JLabel();
        this.buttonNoRating = new JButton();
        this.buttonStar1 = new JButton();
        this.buttonStar2 = new JButton();
        this.buttonStar3 = new JButton();
        this.buttonStar4 = new JButton();
        this.buttonStar5 = new JButton();
        this.setMinimumSize(new Dimension(102, 32));
        this.setName("Rating Selection Panel");
        this.setPreferredSize(new Dimension(102, 32));
        this.setLayout(new GridBagLayout());
        this.labelPrompt.setText("Prompt:");
        this.labelPrompt.setToolTipText(this.metaDataValue.getLongerDescription());
        this.labelPrompt.setName("labelPrompt");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.labelPrompt, gridBagConstraints);
        this.buttonNoRating.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_xmp_rating_remove_not_set.png")));
        this.buttonNoRating.setMnemonic('0');
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/editmetadata/Bundle");
        this.buttonNoRating.setToolTipText(bundle.getString("RatingSelectionPanel.buttonNoRating.toolTipText"));
        this.buttonNoRating.setBorder(null);
        this.buttonNoRating.setContentAreaFilled(false);
        this.buttonNoRating.setName("buttonNoRating");
        this.buttonNoRating.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                RatingSelectionPanel.this.buttonNoRatingMousePressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 1, 6);
        this.add((Component)this.buttonNoRating, gridBagConstraints);
        this.buttonStar1.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_xmp_rating_not_set.png")));
        this.buttonStar1.setMnemonic('1');
        this.buttonStar1.setToolTipText(bundle.getString("RatingSelectionPanel.buttonStar1.toolTipText"));
        this.buttonStar1.setBorder(null);
        this.buttonStar1.setContentAreaFilled(false);
        this.buttonStar1.setName("buttonStar1");
        this.buttonStar1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                RatingSelectionPanel.this.buttonStar1MousePressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 1, 0);
        this.add((Component)this.buttonStar1, gridBagConstraints);
        this.buttonStar2.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_xmp_rating_not_set.png")));
        this.buttonStar2.setMnemonic('2');
        this.buttonStar2.setToolTipText(bundle.getString("RatingSelectionPanel.buttonStar2.toolTipText"));
        this.buttonStar2.setBorder(null);
        this.buttonStar2.setContentAreaFilled(false);
        this.buttonStar2.setName("buttonStar2");
        this.buttonStar2.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                RatingSelectionPanel.this.buttonStar2MousePressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 1, 0);
        this.add((Component)this.buttonStar2, gridBagConstraints);
        this.buttonStar3.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_xmp_rating_not_set.png")));
        this.buttonStar3.setMnemonic('3');
        this.buttonStar3.setToolTipText(bundle.getString("RatingSelectionPanel.buttonStar3.toolTipText"));
        this.buttonStar3.setBorder(null);
        this.buttonStar3.setContentAreaFilled(false);
        this.buttonStar3.setName("buttonStar3");
        this.buttonStar3.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                RatingSelectionPanel.this.buttonStar3MousePressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 1, 0);
        this.add((Component)this.buttonStar3, gridBagConstraints);
        this.buttonStar4.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_xmp_rating_not_set.png")));
        this.buttonStar4.setMnemonic('4');
        this.buttonStar4.setToolTipText(bundle.getString("RatingSelectionPanel.buttonStar4.toolTipText"));
        this.buttonStar4.setBorder(null);
        this.buttonStar4.setContentAreaFilled(false);
        this.buttonStar4.setName("buttonStar4");
        this.buttonStar4.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                RatingSelectionPanel.this.buttonStar4MousePressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 1, 0);
        this.add((Component)this.buttonStar4, gridBagConstraints);
        this.buttonStar5.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_xmp_rating_not_set.png")));
        this.buttonStar5.setMnemonic('5');
        this.buttonStar5.setToolTipText(bundle.getString("RatingSelectionPanel.buttonStar5.toolTipText"));
        this.buttonStar5.setBorder(null);
        this.buttonStar5.setContentAreaFilled(false);
        this.buttonStar5.setName("buttonStar5");
        this.buttonStar5.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                RatingSelectionPanel.this.buttonStar5MousePressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 1, 0);
        this.add((Component)this.buttonStar5, gridBagConstraints);
    }

    private void buttonNoRatingMousePressed(MouseEvent evt) {
        this.handleButtonPressed((JButton)evt.getSource());
    }

    private void buttonStar1MousePressed(MouseEvent evt) {
        this.handleButtonPressed((JButton)evt.getSource());
    }

    private void buttonStar2MousePressed(MouseEvent evt) {
        this.handleButtonPressed((JButton)evt.getSource());
    }

    private void buttonStar3MousePressed(MouseEvent evt) {
        this.handleButtonPressed((JButton)evt.getSource());
    }

    private void buttonStar4MousePressed(MouseEvent evt) {
        this.handleButtonPressed((JButton)evt.getSource());
    }

    private void buttonStar5MousePressed(MouseEvent evt) {
        this.handleButtonPressed((JButton)evt.getSource());
    }
}

