/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.editmetadata;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.preferences.PreferencesChangedEvent;
import org.jphototagger.domain.event.listener.TextEntryListener;
import org.jphototagger.domain.event.listener.TextEntryListenerSupport;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.selections.AutoCompleteDataOfMetaDataValue;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.metadata.xmp.XmpDcTitleMetaDataValue;
import org.jphototagger.domain.repository.event.dcsubjects.DcSubjectInsertedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpInsertedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpUpdatedEvent;
import org.jphototagger.domain.text.TextEntry;
import org.jphototagger.lib.swing.util.Autocomplete;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.util.StringUtil;
import org.jphototagger.program.datatransfer.DropTextComponentTransferHandler;
import org.jphototagger.program.misc.AutocompleteUtil;
import org.openide.util.Lookup;

public final class EditTextEntryPanel
extends JPanel
implements TextEntry,
DocumentListener {
    private static final Color EDITABLE_COLOR = Color.WHITE;
    private static final long serialVersionUID = 1L;
    private transient MetaDataValue metaDataValue;
    private boolean dirty = false;
    private boolean editable;
    private final transient TextEntryListenerSupport textEntryListenerSupport = new TextEntryListenerSupport();
    private Autocomplete autocomplete;
    private JLabel labelPrompt;
    public JTextArea textAreaEdit;

    public EditTextEntryPanel() {
        this(XmpDcTitleMetaDataValue.INSTANCE);
    }

    public EditTextEntryPanel(MetaDataValue metaDataValue) {
        if (metaDataValue == null) {
            throw new NullPointerException("metaDataValue == null");
        }
        this.metaDataValue = metaDataValue;
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.setName(this.metaDataValue.getDescription());
        this.setPropmt();
        this.initTextArea();
        AnnotationProcessor.process(this);
    }

    private void initTextArea() {
        this.setTextAreaColumnWidth();
        Border border = UIManager.getBorder("TextField.border");
        this.textAreaEdit.setBorder(border == null ? BorderFactory.createLineBorder(Color.BLACK) : border);
        Font font = UIManager.getFont("TextField.font");
        if (font != null) {
            this.textAreaEdit.setFont(font);
        }
        this.textAreaEdit.setInputVerifier(this.metaDataValue.getInputVerifier());
        this.textAreaEdit.getDocument().addDocumentListener(this);
        this.textAreaEdit.setName(this.metaDataValue.getDescription());
    }

    private void setTextAreaColumnWidth() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        if (prefs != null && prefs.containsKey("UserSettings.Columns.MetadataInputTextAreas")) {
            int columns = prefs.getInt("UserSettings.Columns.MetadataInputTextAreas");
            this.textAreaEdit.setColumns(columns >= 10 && columns <= 100 ? columns : 40);
        } else {
            this.textAreaEdit.setColumns(40);
        }
    }

    @EventSubscriber(eventClass=PreferencesChangedEvent.class)
    public void preferencesChanged(PreferencesChangedEvent evt) {
        if ("UserSettings.Columns.MetadataInputTextAreas".equals(evt.getKey())) {
            int oldColumns = this.textAreaEdit.getColumns();
            int newColumns = (Integer)evt.getNewValue();
            if (newColumns != oldColumns) {
                this.textAreaEdit.setColumns(newColumns);
                ComponentUtil.forceRepaint(this);
            }
        }
    }

    private void setPropmt() {
        this.labelPrompt.setText(this.metaDataValue.getDescription());
        this.labelPrompt.setLabelFor(this.textAreaEdit);
    }

    @Override
    public String getText() {
        return this.textAreaEdit.getText().trim();
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public void setText(String text) {
        if (text == null) {
            throw new NullPointerException("text == null");
        }
        this.textAreaEdit.setText(text.trim());
        this.dirty = false;
    }

    @Override
    public void empty() {
        String oldText = this.getText();
        if (StringUtil.hasContent(oldText)) {
            this.textAreaEdit.setText("");
            this.dirty = true;
        }
    }

    @Override
    public MetaDataValue getMetaDataValue() {
        return this.metaDataValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableAutocomplete() {
        if (this.getPersistedAutocomplete()) {
            EditTextEntryPanel editTextEntryPanel = this;
            synchronized (editTextEntryPanel) {
                if (this.autocomplete != null) {
                    return;
                }
            }
            this.autocomplete = new Autocomplete(false);
            this.autocomplete.decorate(this.textAreaEdit, AutoCompleteDataOfMetaDataValue.INSTANCE.get(this.metaDataValue).get(), true);
        }
    }

    private boolean getPersistedAutocomplete() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.EnableAutoComplete") ? prefs.getBoolean("UserSettings.EnableAutoComplete") : true;
    }

    private boolean isAutocomplete() {
        return this.autocomplete != null && this.getPersistedAutocomplete();
    }

    private void addToAutocomplete(Xmp xmp) {
        if (this.isAutocomplete()) {
            AutocompleteUtil.addAutocompleteData(this.metaDataValue, this.autocomplete, xmp);
        }
    }

    @EventSubscriber(eventClass=XmpInsertedEvent.class)
    public void xmpInserted(XmpInsertedEvent evt) {
        this.addToAutocomplete(evt.getXmp());
    }

    @EventSubscriber(eventClass=XmpUpdatedEvent.class)
    public void xmpUpdated(XmpUpdatedEvent evt) {
        this.addToAutocomplete(evt.getUpdatedXmp());
    }

    @EventSubscriber(eventClass=DcSubjectInsertedEvent.class)
    public void dcSubjectInserted(DcSubjectInsertedEvent evt) {
        if (this.isAutocomplete()) {
            AutocompleteUtil.addAutocompleteData(this.metaDataValue, this.autocomplete, Collections.singleton(evt.getDcSubject()));
        }
    }

    @Override
    public boolean isEmpty() {
        return StringUtil.hasContent(this.textAreaEdit.getText());
    }

    @Override
    public void requestFocus() {
        this.textAreaEdit.requestFocus();
        this.textAreaEdit.selectAll();
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
        this.textAreaEdit.setEditable(editable);
        this.textAreaEdit.setBackground(editable ? EDITABLE_COLOR : this.getBackground());
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        this.notifyTextChanged(this.metaDataValue, "", this.getText());
        this.dirty = true;
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        this.notifyTextChanged(this.metaDataValue, "", this.getText());
        this.dirty = true;
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
        this.notifyTextChanged(this.metaDataValue, "", this.getText());
        this.dirty = true;
    }

    @Override
    public void addTextEntryListener(TextEntryListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        this.textEntryListenerSupport.add(listener);
    }

    @Override
    public void removeTextEntryListener(TextEntryListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        this.textEntryListenerSupport.remove(listener);
    }

    private void notifyTextChanged(MetaDataValue value, String oldText, String newText) {
        this.textEntryListenerSupport.notifyTextChanged(value, oldText, newText);
    }

    @Override
    public List<Component> getInputComponents() {
        return Arrays.asList(this.textAreaEdit);
    }

    @Override
    public synchronized void addMouseListenerToInputComponents(MouseListener l) {
        if (l == null) {
            throw new NullPointerException("l == null");
        }
        List<Component> inputComponents = this.getInputComponents();
        for (Component component : inputComponents) {
            component.addMouseListener(l);
        }
    }

    @Override
    public synchronized void removeMouseListenerFromInputComponents(MouseListener l) {
        if (l == null) {
            throw new NullPointerException("l == null");
        }
        List<Component> inputComponents = this.getInputComponents();
        for (Component component : inputComponents) {
            component.removeMouseListener(l);
        }
    }

    @Override
    public Collection<? extends Component> getExcludeFromAutoMnemonicComponents() {
        return Collections.emptyList();
    }

    private void initComponents() {
        this.labelPrompt = new JLabel();
        this.textAreaEdit = new JTextArea();
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.labelPrompt.setLabelFor(this.textAreaEdit);
        this.labelPrompt.setText("Prompt:");
        this.labelPrompt.setToolTipText(this.metaDataValue.getLongerDescription());
        this.labelPrompt.setName("labelPrompt");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.labelPrompt, gridBagConstraints);
        this.textAreaEdit.setLineWrap(true);
        this.textAreaEdit.setRows(1);
        this.textAreaEdit.setWrapStyleWord(true);
        this.textAreaEdit.setName("textAreaEdit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.textAreaEdit, gridBagConstraints);
        this.textAreaEdit.setTransferHandler(new DropTextComponentTransferHandler());
    }
}

