/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.editmetadata;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jdesktop.swingx.JXList;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.text.Suggest;
import org.jphototagger.domain.event.listener.TextEntryListener;
import org.jphototagger.domain.event.listener.TextEntryListenerSupport;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.selections.AutoCompleteDataOfMetaDataValue;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.metadata.xmp.XmpDcSubjectsSubjectMetaDataValue;
import org.jphototagger.domain.repository.event.dcsubjects.DcSubjectInsertedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpInsertedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpUpdatedEvent;
import org.jphototagger.domain.text.TextEntry;
import org.jphototagger.lib.swing.KeyEventUtil;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.util.Autocomplete;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.ListUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.datatransfer.DropListTransferHandler;
import org.jphototagger.program.misc.AutocompleteUtil;
import org.jphototagger.program.module.editmetadata.EditTextEntryPanel;
import org.jphototagger.program.module.editmetadata.KeywordsEditPanelListCellRenderer;
import org.jphototagger.program.module.wordsets.WordsetsPanel;
import org.jphototagger.program.module.wordsets.WordsetsPanelListener;
import org.openide.util.Lookup;

public final class EditRepeatableTextEntryPanel
extends JPanel
implements TextEntry,
ActionListener,
DocumentListener,
ListDataListener {
    private static final long serialVersionUID = 1L;
    private String bundleKeyPosRenameDialog;
    private final DefaultListModel<Object> model = new DefaultListModel();
    private transient MetaDataValue metaDataValue = XmpDcSubjectsSubjectMetaDataValue.INSTANCE;
    private boolean editable = true;
    private boolean dirty = false;
    private Suggest suggest;
    private boolean settingTexts;
    private boolean ignoreIntervalAdded;
    private final transient TextEntryListenerSupport textEntryListenerSupport = new TextEntryListenerSupport();
    private Autocomplete autocomplete;
    private WordsetsPanel panelWordsets;
    private Color editBackground;
    private final WordsetsPanelListener wordsetsPanelListener = new WordsetsPanelListener(){

        @Override
        public void wordClicked(String word) {
            if (EditRepeatableTextEntryPanel.this.editable) {
                EditRepeatableTextEntryPanel.this.addText(word);
            }
        }
    };
    private JButton buttonAddInput;
    private JButton buttonRemoveSelection;
    private JButton buttonSuggestion;
    private JLabel labelPrompt;
    private JXList list;
    private JMenuItem menuItemRemove;
    private JMenuItem menuItemRename;
    private JPanel panelFill;
    private JPanel panelInput;
    private JPanel panelListButtons;
    private JPopupMenu popupMenuList;
    public JTextArea textAreaInput;

    public EditRepeatableTextEntryPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    public EditRepeatableTextEntryPanel(MetaDataValue metaDataValue) {
        if (metaDataValue == null) {
            throw new NullPointerException("metaDataValue == null");
        }
        this.metaDataValue = metaDataValue;
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.initTextArea();
        this.setTextFieldBorder(this.list);
        this.setPropmt();
        this.model.addListDataListener(this);
        AnnotationProcessor.process(this);
    }

    private void initTextArea() {
        this.editBackground = this.textAreaInput.getBackground();
        this.setTextFieldBorder(this.textAreaInput);
        Font font = UIManager.getFont("TextField.font");
        if (font != null) {
            this.textAreaInput.setFont(font);
        }
        this.textAreaInput.setInputVerifier(this.metaDataValue.getInputVerifier());
        this.textAreaInput.getDocument().addDocumentListener(this);
        this.textAreaInput.setName(this.metaDataValue.getDescription());
    }

    private void setTextFieldBorder(JComponent component) {
        Border border = UIManager.getBorder("TextField.border");
        component.setBorder(border == null ? BorderFactory.createLineBorder(Color.BLACK) : border);
    }

    public void addWordsetsPanel() {
        if (this.panelWordsets != null) {
            return;
        }
        this.panelWordsets = new WordsetsPanel();
        String wordsetsPanelBorderTitle = Bundle.getString(EditRepeatableTextEntryPanel.class, "EditRepeatableTextEntryPanel.WordsetsPanelBorder.Title", new Object[0]);
        this.panelWordsets.setBorder(BorderFactory.createTitledBorder(wordsetsPanelBorderTitle));
        this.panelWordsets.setName("panelWordsets." + this.metaDataValue.getCategory());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.panelWordsets, gbc);
        this.panelWordsets.setPersistenceKeyPrefix(this.metaDataValue.getCategory());
        this.panelWordsets.addWordsetsPanelListener(this.wordsetsPanelListener);
        this.forceRepaint();
    }

    public void removeWordsetsPanel() {
        if (this.panelWordsets != null) {
            this.remove(this.panelWordsets);
            this.panelWordsets = null;
            this.forceRepaint();
        }
    }

    private void setPropmt() {
        this.labelPrompt.setText(this.metaDataValue.getDescription());
        this.labelPrompt.setLabelFor(this.textAreaInput);
    }

    public void setPrompt(String text) {
        if (text == null) {
            throw new NullPointerException("text == null");
        }
        this.labelPrompt.setText(text);
        this.labelPrompt.setLabelFor(this.textAreaInput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableAutocomplete() {
        if (this.getPersistedAutocomplete()) {
            EditRepeatableTextEntryPanel editRepeatableTextEntryPanel = this;
            synchronized (editRepeatableTextEntryPanel) {
                if (this.autocomplete != null) {
                    return;
                }
            }
            this.autocomplete = new Autocomplete(false);
            this.autocomplete.setTransferFocusForward(false);
            this.autocomplete.decorate(this.textAreaInput, AutoCompleteDataOfMetaDataValue.INSTANCE.get(this.metaDataValue).get(), true);
        }
    }

    private boolean getPersistedAutocomplete() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs == null ? false : (prefs.containsKey("UserSettings.EnableAutoComplete") ? prefs.getBoolean("UserSettings.EnableAutoComplete") : true);
    }

    @Override
    public String getText() {
        return this.textAreaInput.getText().trim();
    }

    public Collection<String> getRepeatableText() {
        ArrayList<String> texts = new ArrayList<String>(this.model.size());
        int size = this.model.getSize();
        for (int i = 0; i < size; ++i) {
            texts.add(this.model.get(i).toString());
        }
        return texts;
    }

    public void setSuggest(Suggest suggest) {
        if (suggest == null) {
            throw new NullPointerException("suggest == null");
        }
        this.suggest = suggest;
        this.setButtonSuggestionEnabled();
        this.buttonSuggestion.setToolTipText(suggest.getDescription());
    }

    @Override
    public void setText(String text) {
        assert (false) : "Don't call this (Called with text: '" + text + "')";
    }

    public void setTexts(Collection<String> texts) {
        if (texts == null) {
            throw new NullPointerException("texts == null");
        }
        this.settingTexts = true;
        this.textAreaInput.setText("");
        this.model.removeAllElements();
        this.addToList(texts);
        this.setButtonsEnabled();
        this.dirty = false;
        this.settingTexts = false;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenuList;
    }

    public JMenuItem getItemRename() {
        return this.menuItemRename;
    }

    public JMenuItem getItemRemove() {
        return this.menuItemRemove;
    }

    public JXList getList() {
        return this.list;
    }

    public JTextArea getTextArea() {
        return this.textAreaInput;
    }

    public void setBundleKeyPosRenameDialog(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        this.bundleKeyPosRenameDialog = key;
    }

    @Override
    public void empty() {
        this.textAreaInput.setText("");
        if (!this.model.isEmpty()) {
            Object[] elements = new Object[this.model.getSize()];
            this.model.copyInto(elements);
            for (Object element : elements) {
                this.notifyTextRemoved(this.metaDataValue, (String)element);
            }
            this.model.removeAllElements();
            this.dirty = true;
        }
    }

    public void removeText(String text) {
        if (text == null) {
            throw new NullPointerException("text == null");
        }
        if (!this.editable) {
            return;
        }
        this.model.removeElement(text);
        this.notifyTextRemoved(this.metaDataValue, text);
        this.dirty = true;
    }

    public void addText(String text) {
        if (text == null) {
            throw new NullPointerException("text == null");
        }
        if (!this.editable) {
            return;
        }
        this.addToList(Collections.singleton(text));
        this.dirty = true;
    }

    @Override
    public MetaDataValue getMetaDataValue() {
        return this.metaDataValue;
    }

    private void handleTextFieldKeyReleased(KeyEvent evt) {
        JComponent component = (JComponent)evt.getSource();
        if (evt.getKeyCode() == 10 && component.getInputVerifier().verify(component)) {
            this.addInputToList();
        } else {
            this.setButtonsEnabled();
        }
    }

    private void addInputToList() {
        if (this.addToList(Collections.singleton(this.getText())) > 0) {
            this.textAreaInput.setText("");
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public boolean isEmpty() {
        return this.model.isEmpty();
    }

    @Override
    public void requestFocus() {
        this.textAreaInput.requestFocus();
        this.textAreaInput.selectAll();
    }

    private void removeSelectedElements() {
        if (this.isElementSelected() && this.confirmRemoveSelectedItems()) {
            List values = this.list.getSelectedValuesList();
            for (Object value : values) {
                this.model.removeElement(value);
                this.notifyTextRemoved(this.metaDataValue, value.toString());
                this.dirty = true;
            }
            this.forceRepaint();
        }
    }

    private boolean isElementSelected() {
        return this.list.getSelectedIndex() >= 0;
    }

    private boolean confirmRemoveSelectedItems() {
        String message = Bundle.getString(EditRepeatableTextEntryPanel.class, "EditRepeatableTextEntryPanel.Confirm.RemoveSelItems", new Object[0]);
        return MessageDisplayer.confirmYesNo(this, message);
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
        this.textAreaInput.setEditable(editable);
        this.setButtonsEnabled();
        Color background = editable ? this.editBackground : this.getBackground();
        this.list.setBackground(background);
        this.textAreaInput.setBackground(background);
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    private void handleButtonAddInputActionPerformed() {
        this.addInputToList();
        this.textAreaInput.requestFocusInWindow();
    }

    private void handleButtonRemoveInputActionPerformed() {
        this.removeSelectedElements();
        this.textAreaInput.requestFocusInWindow();
    }

    private void handleListKeyPressed(KeyEvent evt) {
        if (this.editable) {
            if (evt.getKeyCode() == 127) {
                this.removeSelectedElements();
            } else if (evt.getKeyCode() == 113) {
                this.renameSelectedListItems();
            }
        }
    }

    private void handleListValueChanged(ListSelectionEvent evt) {
        this.setButtonsEnabled();
    }

    private void setButtonsEnabled() {
        this.setButtonSuggestionEnabled();
        this.setButtonAddInputEnabled();
        this.setButtonRemoveEnabled();
    }

    private void setButtonAddInputEnabled() {
        this.buttonAddInput.setEnabled(this.editable && this.hasInput());
    }

    private void setButtonRemoveEnabled() {
        this.buttonRemoveSelection.setEnabled(this.editable && this.isElementSelected());
    }

    private void setButtonSuggestionEnabled() {
        this.buttonSuggestion.setEnabled(this.editable && this.hasInput() && this.suggest != null);
    }

    private boolean hasInput() {
        return !this.getText().isEmpty();
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.removeSelectedElements();
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        this.dirty = true;
        this.setButtonAddInputEnabled();
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        this.dirty = true;
        this.setButtonAddInputEnabled();
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
        this.dirty = true;
        this.setButtonAddInputEnabled();
    }

    private void suggestText(KeyEvent evt) {
        if (KeyEventUtil.isMenuShortcut(evt, 75)) {
            this.suggestText();
        }
    }

    private void suggestText() {
        String input = this.getText();
        if (this.checkCanSuggest(input)) {
            Collection<String> suggestedText = this.suggest.suggest(input);
            if (this.suggest.isAccepted() && suggestedText.isEmpty()) {
                String message = Bundle.getString(EditTextEntryPanel.class, "EditTextEntryPanel.Warning.SuggestTextNoSuggestionsFound", input, this.suggest.getRequiresDescription());
                MessageDisplayer.warning(this, message);
            } else {
                this.addToList(suggestedText);
            }
        }
    }

    private boolean checkCanSuggest(String input) {
        if (this.suggest == null) {
            String message = Bundle.getString(EditTextEntryPanel.class, "EditTextEntryPanel.Warning.NoSuggestExists", new Object[0]);
            MessageDisplayer.warning(this, message);
            return false;
        }
        if (input.isEmpty()) {
            String message = Bundle.getString(EditTextEntryPanel.class, "EditTextEntryPanel.Warning.SuggestTextEmpty", new Object[0]);
            MessageDisplayer.warning(this, message);
            return false;
        }
        return true;
    }

    private int addToList(Collection<String> texts) {
        if (!this.metaDataValue.getInputVerifier().verify(this.textAreaInput)) {
            return 0;
        }
        this.ignoreIntervalAdded = true;
        int countAdded = 0;
        for (String text : texts) {
            String trimmedText = text.trim();
            if (trimmedText.isEmpty() || this.containsElementIgnoreCase(trimmedText)) continue;
            this.model.addElement(trimmedText);
            this.addToAutomaticWordsetsPanel(trimmedText);
            ++countAdded;
            this.notifyTextAdded(this.metaDataValue, trimmedText);
        }
        if (countAdded > 0) {
            this.repaint();
            this.forceRepaint();
            if (this.autocomplete != null && this.getPersistedAutocomplete()) {
                AutocompleteUtil.addAutocompleteData(this.metaDataValue, this.autocomplete, texts);
            }
        }
        this.ignoreIntervalAdded = false;
        return countAdded;
    }

    private void addToAutomaticWordsetsPanel(String word) {
        if (!this.settingTexts && this.panelWordsets != null) {
            this.panelWordsets.addToAutomaticWordset(word);
        }
    }

    private boolean containsElementIgnoreCase(String element) {
        Enumeration<Object> enumeration = this.model.elements();
        while (enumeration.hasMoreElements()) {
            String modelElement = (String)enumeration.nextElement();
            if (!element.equalsIgnoreCase(modelElement)) continue;
            return true;
        }
        return false;
    }

    private void renameSelectedListItems() {
        int[] selIndices = this.list.getSelectedIndices();
        if (!this.checkSelectionRequired(selIndices.length)) {
            return;
        }
        for (int selIndex : selIndices) {
            int modelIndex = this.list.convertIndexToModel(selIndex);
            this.renameListItem(modelIndex);
        }
    }

    private void renameListItem(int modelIndex) {
        boolean ready;
        String fromName = this.model.getElementAt(modelIndex).toString();
        String toName = null;
        do {
            String message;
            String input;
            this.bundleKeyPosRenameDialog = this.getClass().getName();
            String info = Bundle.getString(EditRepeatableTextEntryPanel.class, "EditRepeatableTextEntryPanel.Input.RenameListItem", new Object[0]);
            toName = MessageDisplayer.input(info, input = fromName);
            boolean bl = ready = toName == null;
            if (toName != null && toName.trim().equals(fromName)) {
                message = Bundle.getString(EditRepeatableTextEntryPanel.class, "EditRepeatableTextEntryPanel.Confirm.SameNames", new Object[0]);
                ready = !MessageDisplayer.confirmYesNo(this.list, message);
                toName = null;
                continue;
            }
            if (toName != null && ListUtil.containsString(this.list.getModel(), toName.trim())) {
                message = Bundle.getString(EditRepeatableTextEntryPanel.class, "EditRepeatableTextEntryPanel.Confirm.NameExists", toName);
                ready = !MessageDisplayer.confirmYesNo(this.list, message);
                toName = null;
                continue;
            }
            if (toName == null || toName.trim().isEmpty()) continue;
            ready = true;
            toName = toName.trim();
        } while (!ready);
        if (toName != null) {
            this.model.set(modelIndex, toName);
            this.dirty = true;
            this.notifyTextChanged(this.metaDataValue, fromName, toName);
        }
    }

    private boolean checkSelectionRequired(int selCount) {
        if (selCount <= 0) {
            String message = Bundle.getString(EditRepeatableTextEntryPanel.class, "EditRepeatableTextEntryPanel.Error.Select", new Object[0]);
            MessageDisplayer.error(this, message);
            return false;
        }
        return true;
    }

    @Override
    public void addTextEntryListener(TextEntryListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        this.textEntryListenerSupport.add(listener);
    }

    @Override
    public void removeTextEntryListener(TextEntryListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        this.textEntryListenerSupport.remove(listener);
    }

    private void notifyTextRemoved(MetaDataValue value, String removedText) {
        this.textEntryListenerSupport.notifyTextRemoved(value, removedText);
    }

    private void notifyTextAdded(MetaDataValue value, String addedText) {
        this.textEntryListenerSupport.notifyTextAdded(value, addedText);
    }

    private void notifyTextChanged(MetaDataValue value, String oldText, String newText) {
        this.textEntryListenerSupport.notifyTextChanged(value, oldText, newText);
    }

    @Override
    public void intervalAdded(ListDataEvent evt) {
        if (this.ignoreIntervalAdded) {
            return;
        }
        int index0 = evt.getIndex0();
        int index1 = evt.getIndex1();
        for (int i = index0; i <= index1; ++i) {
            this.notifyTextAdded(this.metaDataValue, this.model.get(i).toString());
            this.dirty = true;
        }
        this.setButtonsEnabled();
    }

    @Override
    public void intervalRemoved(ListDataEvent evt) {
        this.dirty = true;
    }

    @Override
    public void contentsChanged(ListDataEvent evt) {
        this.setButtonsEnabled();
    }

    @Override
    public List<Component> getInputComponents() {
        return Arrays.asList(this.list, this.buttonRemoveSelection, this.buttonAddInput, this.buttonSuggestion, this.textAreaInput);
    }

    @Override
    public synchronized void addMouseListenerToInputComponents(MouseListener l) {
        if (l == null) {
            throw new NullPointerException("l == null");
        }
        List<Component> inputComponents = this.getInputComponents();
        for (Component component : inputComponents) {
            component.addMouseListener(l);
        }
    }

    @Override
    public synchronized void removeMouseListenerFromInputComponents(MouseListener l) {
        if (l == null) {
            throw new NullPointerException("l == null");
        }
        List<Component> inputComponents = this.getInputComponents();
        for (Component component : inputComponents) {
            component.removeMouseListener(l);
        }
    }

    private boolean isAutocomplete() {
        return this.autocomplete != null && this.getPersistedAutocomplete();
    }

    private void addToAutocomplete(Xmp xmp) {
        if (this.isAutocomplete()) {
            AutocompleteUtil.addAutocompleteData(this.metaDataValue, this.autocomplete, xmp);
        }
    }

    @EventSubscriber(eventClass=XmpInsertedEvent.class)
    public void xmpInserted(XmpInsertedEvent evt) {
        this.addToAutocomplete(evt.getXmp());
    }

    @EventSubscriber(eventClass=XmpUpdatedEvent.class)
    public void xmpUpdated(XmpUpdatedEvent evt) {
        this.addToAutocomplete(evt.getUpdatedXmp());
    }

    @EventSubscriber(eventClass=DcSubjectInsertedEvent.class)
    public void dcSubjectInserted(DcSubjectInsertedEvent evt) {
        if (this.isAutocomplete()) {
            AutocompleteUtil.addAutocompleteData((MetaDataValue)XmpDcSubjectsSubjectMetaDataValue.INSTANCE, this.autocomplete, Collections.singleton(evt.getDcSubject()));
        }
    }

    @Override
    public Collection<? extends Component> getExcludeFromAutoMnemonicComponents() {
        return this.panelWordsets == null ? Collections.emptyList() : Arrays.asList(this.panelWordsets);
    }

    private void forceRepaint() {
        this.list.repaint();
        this.repaint();
        this.repaintParent();
        this.repaintGrandParent();
    }

    private void repaintParent() {
        Container parent = this.getParent();
        if (parent != null) {
            ComponentUtil.forceRepaint(parent);
        }
    }

    private void repaintGrandParent() {
        Container parent = this.getParent();
        if (parent != null && (parent = parent.getParent()) != null) {
            ComponentUtil.forceRepaint(parent);
        }
    }

    private void initComponents() {
        this.popupMenuList = new JPopupMenu();
        this.menuItemRename = new JMenuItem();
        this.menuItemRemove = new JMenuItem();
        this.labelPrompt = new JLabel();
        this.list = new JXList();
        this.panelListButtons = new JPanel();
        this.buttonRemoveSelection = new JButton();
        this.panelInput = new JPanel();
        this.textAreaInput = new JTextArea();
        this.buttonAddInput = new JButton();
        this.buttonSuggestion = new JButton();
        this.panelFill = new JPanel();
        this.popupMenuList.setName("popupMenuList");
        this.menuItemRename.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/editmetadata/Bundle");
        this.menuItemRename.setText(bundle.getString("EditRepeatableTextEntryPanel.menuItemRename.text"));
        this.menuItemRename.setName("menuItemRename");
        this.menuItemRename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditRepeatableTextEntryPanel.this.menuItemRenameActionPerformed(evt);
            }
        });
        this.popupMenuList.add(this.menuItemRename);
        this.menuItemRemove.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.menuItemRemove.setText(bundle.getString("EditRepeatableTextEntryPanel.menuItemRemove.text"));
        this.menuItemRemove.setName("menuItemRemove");
        this.menuItemRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditRepeatableTextEntryPanel.this.menuItemRemoveActionPerformed(evt);
            }
        });
        this.popupMenuList.add(this.menuItemRemove);
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.labelPrompt.setText("Prompt:");
        this.labelPrompt.setToolTipText(this.metaDataValue.getLongerDescription());
        this.labelPrompt.setName("labelPrompt");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.labelPrompt, gridBagConstraints);
        this.list.setModel((ListModel)this.model);
        this.list.setToolTipText(bundle.getString("EditRepeatableTextEntryPanel.list.toolTipText"));
        this.list.setCellRenderer((ListCellRenderer)new KeywordsEditPanelListCellRenderer());
        this.list.setComponentPopupMenu(this.popupMenuList);
        this.list.setDragEnabled(true);
        this.list.setDropMode(DropMode.INSERT);
        this.list.setLayoutOrientation(2);
        this.list.setName("list");
        this.list.setVisibleRowCount(-1);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                EditRepeatableTextEntryPanel.this.listValueChanged(evt);
            }
        });
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                EditRepeatableTextEntryPanel.this.listKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.list, gridBagConstraints);
        this.list.setTransferHandler(new DropListTransferHandler());
        this.panelListButtons.setName("panelListButtons");
        this.panelListButtons.setLayout(new GridLayout(1, 1));
        this.buttonRemoveSelection.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/module/editmetadata/delete.png")));
        this.buttonRemoveSelection.setMnemonic('-');
        this.buttonRemoveSelection.setToolTipText(bundle.getString("EditRepeatableTextEntryPanel.buttonRemoveSelection.toolTipText"));
        this.buttonRemoveSelection.setContentAreaFilled(false);
        this.buttonRemoveSelection.setMargin(new Insets(0, 0, 0, 0));
        this.buttonRemoveSelection.setName("buttonRemoveSelection");
        this.buttonRemoveSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditRepeatableTextEntryPanel.this.buttonRemoveSelectionActionPerformed(evt);
            }
        });
        this.panelListButtons.add(this.buttonRemoveSelection);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.panelListButtons, gridBagConstraints);
        this.panelInput.setLayout(new GridBagLayout());
        this.textAreaInput.setColumns(15);
        this.textAreaInput.setRows(1);
        this.textAreaInput.setName("textAreaInput");
        this.textAreaInput.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                EditRepeatableTextEntryPanel.this.textAreaInputKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                EditRepeatableTextEntryPanel.this.textAreaInputKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelInput.add((Component)this.textAreaInput, gridBagConstraints);
        this.buttonAddInput.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/module/editmetadata/add.png")));
        this.buttonAddInput.setMnemonic('+');
        this.buttonAddInput.setToolTipText(bundle.getString("EditRepeatableTextEntryPanel.buttonAddInput.toolTipText"));
        this.buttonAddInput.setContentAreaFilled(false);
        this.buttonAddInput.setMargin(new Insets(0, 0, 0, 0));
        this.buttonAddInput.setName("buttonAddInput");
        this.buttonAddInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditRepeatableTextEntryPanel.this.buttonAddInputActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelInput.add((Component)this.buttonAddInput, gridBagConstraints);
        this.buttonSuggestion.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/module/editmetadata/word.png")));
        this.buttonSuggestion.setMnemonic('k');
        this.buttonSuggestion.setContentAreaFilled(false);
        this.buttonSuggestion.setEnabled(false);
        this.buttonSuggestion.setMargin(new Insets(0, 0, 0, 0));
        this.buttonSuggestion.setName("buttonSuggestion");
        this.buttonSuggestion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditRepeatableTextEntryPanel.this.buttonSuggestionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelInput.add((Component)this.buttonSuggestion, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.panelInput, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.panelFill, gridBagConstraints);
    }

    private void buttonAddInputActionPerformed(ActionEvent evt) {
        this.handleButtonAddInputActionPerformed();
    }

    private void buttonRemoveSelectionActionPerformed(ActionEvent evt) {
        this.handleButtonRemoveInputActionPerformed();
    }

    private void listValueChanged(ListSelectionEvent evt) {
        this.handleListValueChanged(evt);
    }

    private void listKeyPressed(KeyEvent evt) {
        this.handleListKeyPressed(evt);
    }

    private void buttonSuggestionActionPerformed(ActionEvent evt) {
        this.suggestText();
        this.textAreaInput.requestFocusInWindow();
    }

    private void menuItemRenameActionPerformed(ActionEvent evt) {
        this.renameSelectedListItems();
    }

    private void menuItemRemoveActionPerformed(ActionEvent evt) {
        this.removeSelectedElements();
    }

    private void textAreaInputKeyReleased(KeyEvent evt) {
        this.handleTextFieldKeyReleased(evt);
    }

    private void textAreaInputKeyPressed(KeyEvent evt) {
        this.suggestText(evt);
    }
}

