/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.editmetadata;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.applifecycle.AppWillExitEvent;
import org.jphototagger.api.concurrent.Cancelable;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.preferences.PreferencesChangedEvent;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.event.EditMetadataPanelsEditDisabledEvent;
import org.jphototagger.domain.metadata.event.EditMetadataPanelsEditEnabledEvent;
import org.jphototagger.domain.metadata.xmp.FileXmp;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.metadata.xmp.XmpDcSubjectsSubjectMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpRatingMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpSidecarFileResolver;
import org.jphototagger.domain.repository.event.xmp.XmpDeletedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpInsertedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpUpdatedEvent;
import org.jphototagger.domain.templates.MetadataTemplate;
import org.jphototagger.domain.text.TextEntry;
import org.jphototagger.domain.thumbnails.event.ThumbnailsSelectionChangedEvent;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.swing.ExpandCollapseComponentPanel;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.StringUtil;
import org.jphototagger.program.misc.SaveXmp;
import org.jphototagger.program.module.editmetadata.EditMetaDataActionsPanel;
import org.jphototagger.program.module.editmetadata.EditRepeatableTextEntryPanel;
import org.jphototagger.program.module.editmetadata.EditTextEntryPanel;
import org.jphototagger.program.module.editmetadata.RatingSelectionPanel;
import org.jphototagger.program.module.keywords.tree.SuggestKeywords;
import org.jphototagger.program.module.wordsets.WordsetPreferences;
import org.jphototagger.program.view.ViewUtil;
import org.jphototagger.xmp.EditHints;
import org.jphototagger.xmp.EditableMetaDataValues;
import org.jphototagger.xmp.XmpMetadata;
import org.openide.util.Lookup;

final class EditMetaDataPanels
implements FocusListener {
    private static final Logger LOGGER = Logger.getLogger(EditMetaDataPanels.class.getName());
    private final List<TextEntry> textEntries = new ArrayList<TextEntry>();
    private final List<FileXmp> filesXmp = new CopyOnWriteArrayList<FileXmp>();
    private final Set<MetaDataValue> repeatableMetaDataValuesOfTextEntries = new HashSet<MetaDataValue>();
    private final Set<MetaDataValue> notRepeatableMetaDataValuesOfTextEntries = new HashSet<MetaDataValue>();
    private volatile boolean editable = true;
    private final WatchDifferentValues watchDifferentValues = new WatchDifferentValues();
    private SetFilesThread currentSetFilesThread;
    private final JComponent parentContainer;
    private final Object monitor = new Object();
    private final EditMetaDataActionsPanel editMetadataActionsPanel = new EditMetaDataActionsPanel(this);
    private final XmpSidecarFileResolver xmpSidecarFileResolver = Lookup.getDefault().lookup(XmpSidecarFileResolver.class);
    private EditRepeatableTextEntryPanel keywordsPanel;
    private Component lastFocussedEditControl;

    EditMetaDataPanels(JComponent parentContainer) {
        if (parentContainer == null) {
            throw new NullPointerException("parentContainer == null");
        }
        this.parentContainer = parentContainer;
        this.createEditPanels();
        this.addEditPanelsToParentContainer();
        this.requestFocusToFirstEditField();
        this.enableAutocomplete();
        this.setEditable(false);
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process(this);
    }

    private boolean isDirty() {
        for (TextEntry textEntry : this.textEntries) {
            if (!textEntry.isDirty()) continue;
            return true;
        }
        return false;
    }

    private void setDirty(final boolean dirty) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                for (TextEntry textEntry : EditMetaDataPanels.this.textEntries) {
                    textEntry.setDirty(dirty);
                }
            }
        });
    }

    private void saveIfDirty() {
        if (this.isDirty()) {
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        Object object = this.monitor;
        synchronized (object) {
            SaveXmp.save(this.filesXmp);
        }
        this.setDirty(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEditable(final boolean editable) {
        Object object = this.monitor;
        synchronized (object) {
            this.editable = editable;
        }
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                for (TextEntry textEntry : EditMetaDataPanels.this.textEntries) {
                    textEntry.setEditable(editable);
                }
                EventBus.publish(editable ? new EditMetadataPanelsEditEnabledEvent(this) : new EditMetadataPanelsEditDisabledEvent(this));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEditable() {
        Object object = this.monitor;
        synchronized (object) {
            return this.editable;
        }
    }

    @EventSubscriber(eventClass=ThumbnailsSelectionChangedEvent.class)
    public void thumbnailsSelectionChanged(ThumbnailsSelectionChangedEvent evt) {
        List<File> selFiles = evt.getSelectedFiles();
        if (evt.isAFileSelected()) {
            boolean canEdit = this.canEdit(selFiles);
            this.setEditable(canEdit);
            this.setFiles(selFiles);
        } else {
            this.clear();
            this.setEditable(false);
        }
    }

    boolean canEdit(List<File> selectedFiles) {
        for (File selFile : selectedFiles) {
            if (XmpMetadata.canWriteSidecarFileForImageFile(selFile)) continue;
            return false;
        }
        return selectedFiles.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFiles(Collection<File> files) {
        if (files == null) {
            throw new NullPointerException("files == null");
        }
        Object object = this.monitor;
        synchronized (object) {
            this.setEditable(false);
            this.parentContainer.setCursor(Cursor.getPredefinedCursor(3));
            this.saveIfDirty();
            this.removeXmpAsListenerFromAllTextEntries(this.getXmpOfFilesXmp(this.filesXmp));
            this.emptyAllEditPanels();
            this.watchDifferentValues.setListen(false);
            this.watchDifferentValues.setEntries(new ArrayList<TextEntry>());
            if (this.currentSetFilesThread != null) {
                this.currentSetFilesThread.cancel();
            }
            this.currentSetFilesThread = new SetFilesThread(files);
            this.currentSetFilesThread.start();
        }
    }

    private List<Xmp> getXmpOfFilesXmp(Collection<? extends FileXmp> filesXmp) {
        ArrayList<Xmp> xmps = new ArrayList<Xmp>(filesXmp.size());
        for (FileXmp fileXmp : filesXmp) {
            Xmp xmp = fileXmp.getXmp();
            xmps.add(xmp);
        }
        return xmps;
    }

    private void setXmpToEditPanels(final List<? extends Xmp> xmps) {
        if (xmps.isEmpty()) {
            return;
        }
        final Map<MetaDataValue, Collection<String>> commonXmpOfRepeatableMetaDataValues = this.getCommonXmpOfRepeatableMetaDataValues(xmps);
        final Map<MetaDataValue, String> commonXmpOfNotRepeatableMetaDataValues = this.getCommonXmpOfNotRepeatableMetaDataValues(xmps);
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                ArrayList<TextEntry> textEntriesWithDifferentValues = new ArrayList<TextEntry>();
                boolean containsMultipleFilesForEdit = xmps.size() > 1;
                for (TextEntry textEntry : EditMetaDataPanels.this.textEntries) {
                    MetaDataValue metaDataValue = textEntry.getMetaDataValue();
                    if (textEntry instanceof EditRepeatableTextEntryPanel) {
                        EditRepeatableTextEntryPanel panel = (EditRepeatableTextEntryPanel)textEntry;
                        Collection commonXmp = (Collection)commonXmpOfRepeatableMetaDataValues.get(metaDataValue);
                        panel.setTexts(commonXmp);
                    } else {
                        String commonText = (String)commonXmpOfNotRepeatableMetaDataValues.get(metaDataValue);
                        textEntry.setText(commonText);
                        if (containsMultipleFilesForEdit && commonText.isEmpty() && EditMetaDataPanels.this.oneOfXmpsContainsMetaDataValue(xmps, metaDataValue)) {
                            textEntriesWithDifferentValues.add(textEntry);
                        }
                    }
                    textEntry.setDirty(false);
                }
                if (containsMultipleFilesForEdit && !textEntriesWithDifferentValues.isEmpty()) {
                    EditMetaDataPanels.this.watchDifferentValues.setEntries(textEntriesWithDifferentValues);
                    EditMetaDataPanels.this.watchDifferentValues.setListen(true);
                }
            }
        });
    }

    private Map<MetaDataValue, Collection<String>> getCommonXmpOfRepeatableMetaDataValues(List<? extends Xmp> xmps) {
        HashMap<MetaDataValue, Collection<String>> commonXmp = new HashMap<MetaDataValue, Collection<String>>();
        for (MetaDataValue metaDataValue : this.repeatableMetaDataValuesOfTextEntries) {
            Collection<String> commonXmpAsStrings = this.getCommonXmpValuesAsStrings(xmps, metaDataValue);
            commonXmp.put(metaDataValue, commonXmpAsStrings);
        }
        return commonXmp;
    }

    private Map<MetaDataValue, String> getCommonXmpOfNotRepeatableMetaDataValues(List<? extends Xmp> xmps) {
        HashMap<MetaDataValue, String> commonXmp = new HashMap<MetaDataValue, String>();
        for (MetaDataValue metaDataValue : this.notRepeatableMetaDataValuesOfTextEntries) {
            String commonXmpAsString = this.getCommonXmpString(xmps, metaDataValue);
            commonXmp.put(metaDataValue, commonXmpAsString);
        }
        return commonXmp;
    }

    private Collection<String> getCommonXmpValuesAsStrings(List<? extends Xmp> xmps, MetaDataValue metaDataValue) {
        if (xmps.size() == 1) {
            Xmp xmp = xmps.get(0);
            Object currentXmpValue = xmp.getValue(metaDataValue);
            if (currentXmpValue instanceof List) {
                return (List)currentXmpValue;
            }
            return new ArrayList<String>(1);
        }
        Stack<List> lists = new Stack<List>();
        for (Xmp xmp : xmps) {
            Object xmpValue = xmp.getValue(metaDataValue);
            if (!(xmpValue instanceof List)) continue;
            lists.push((List)xmpValue);
        }
        if (lists.size() != xmps.size()) {
            return new ArrayList<String>(1);
        }
        List coll = (List)lists.pop();
        while (!lists.isEmpty() && coll.size() > 0) {
            coll.retainAll((Collection)lists.pop());
        }
        return coll;
    }

    private String getCommonXmpString(List<? extends Xmp> xmps, MetaDataValue metaDataValue) {
        if (xmps.size() == 1) {
            Xmp xmp = xmps.get(0);
            Object currentXmpValue = xmp.getValue(metaDataValue);
            String string = this.valueToString(currentXmpValue);
            return string == null ? "" : string.trim();
        }
        Stack<String> strings = new Stack<String>();
        for (Xmp xmp : xmps) {
            Object xmpValue = xmp.getValue(metaDataValue);
            String xmpValueAsString = this.valueToString(xmpValue);
            if (xmpValueAsString == null) continue;
            strings.push(xmpValueAsString.trim());
        }
        if (strings.size() != xmps.size()) {
            return "";
        }
        String string = (String)strings.pop();
        while (!strings.empty()) {
            if (((String)strings.pop()).equalsIgnoreCase(string)) continue;
            return "";
        }
        return string;
    }

    private boolean oneOfXmpsContainsMetaDataValue(Collection<? extends Xmp> xmps, MetaDataValue metaDataValue) {
        for (Xmp xmp : xmps) {
            Object xmpValue = xmp.getValue(metaDataValue);
            String xmpValueAsString = this.valueToString(xmpValue);
            if (!StringUtil.hasContent(xmpValueAsString)) continue;
            return true;
        }
        return false;
    }

    private String valueToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Long) {
            return Long.toOctalString((Long)value);
        }
        throw new IllegalArgumentException("No string conversion implemented for " + value + " Class " + value.getClass());
    }

    private void addXmpAsListenerToAllTextEntries(Collection<? extends Xmp> xmps) {
        for (Xmp xmp : xmps) {
            this.addXmpAsListenerToAllTextEntries(xmp);
        }
    }

    private void addXmpAsListenerToAllTextEntries(final Xmp xmp) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                for (TextEntry textEntry : EditMetaDataPanels.this.textEntries) {
                    textEntry.addTextEntryListener(xmp);
                }
            }
        });
    }

    private void removeXmpAsListenerFromAllTextEntries(Collection<? extends Xmp> xmps) {
        for (Xmp xmp : xmps) {
            this.removeXmpAsListenerFromAllTextEntries(xmp);
        }
    }

    private void removeXmpAsListenerFromAllTextEntries(final Xmp xmp) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                for (TextEntry textEntry : EditMetaDataPanels.this.textEntries) {
                    textEntry.removeTextEntryListener(xmp);
                }
            }
        });
    }

    JPanel getEditPanelForMetaDataValue(MetaDataValue metaDataValue) {
        if (metaDataValue == null) {
            throw new NullPointerException("metaDataValue == null");
        }
        for (TextEntry textEntry : this.textEntries) {
            if (!(textEntry instanceof JPanel)) {
                throw new IllegalStateException("Unexpected type of TextEntry: " + textEntry.getClass());
            }
            MetaDataValue textEntryMetaDataValue = textEntry.getMetaDataValue();
            if (!textEntryMetaDataValue.equals(metaDataValue)) continue;
            return (JPanel)((Object)textEntry);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOrAddText(final MetaDataValue metaDataValue, final String text) {
        if (metaDataValue == null) {
            throw new NullPointerException("metaDataValue == null");
        }
        if (text == null) {
            throw new NullPointerException("text == null");
        }
        Object object = this.monitor;
        synchronized (object) {
            if (!this.editable) {
                return;
            }
        }
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                TextEntry textEntryForAdd = null;
                int size = EditMetaDataPanels.this.textEntries.size();
                for (int i = 0; textEntryForAdd == null && i < size; ++i) {
                    TextEntry textEntry = (TextEntry)EditMetaDataPanels.this.textEntries.get(i);
                    MetaDataValue textEntryMetaDataValue = textEntry.getMetaDataValue();
                    if (!textEntryMetaDataValue.equals(metaDataValue)) continue;
                    textEntryForAdd = textEntry;
                }
                if (textEntryForAdd instanceof EditRepeatableTextEntryPanel) {
                    EditRepeatableTextEntryPanel editRepeatableTextEntryPanel = (EditRepeatableTextEntryPanel)textEntryForAdd;
                    editRepeatableTextEntryPanel.addText(text);
                } else if (textEntryForAdd instanceof TextEntry) {
                    textEntryForAdd.setText(text);
                    textEntryForAdd.setDirty(true);
                }
                EditMetaDataPanels.this.saveIfDirtyAndInputIsSaveEarly();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeText(final MetaDataValue metaDataValue, final String text) {
        if (metaDataValue == null) {
            throw new NullPointerException("metaDataValue == null");
        }
        if (text == null) {
            throw new NullPointerException("text == null");
        }
        Object object = this.monitor;
        synchronized (object) {
            if (!this.editable) {
                return;
            }
        }
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                TextEntry textEntryForRemove = null;
                int size = EditMetaDataPanels.this.textEntries.size();
                for (int i = 0; textEntryForRemove == null && i < size; ++i) {
                    TextEntry textEntry = (TextEntry)EditMetaDataPanels.this.textEntries.get(i);
                    MetaDataValue textEntryMetaDataValue = textEntry.getMetaDataValue();
                    if (!textEntryMetaDataValue.equals(metaDataValue)) continue;
                    textEntryForRemove = textEntry;
                }
                if (textEntryForRemove instanceof EditRepeatableTextEntryPanel) {
                    EditRepeatableTextEntryPanel editRepeatableTextEntryPanel = (EditRepeatableTextEntryPanel)textEntryForRemove;
                    editRepeatableTextEntryPanel.removeText(text);
                } else if (textEntryForRemove instanceof TextEntry) {
                    textEntryForRemove.setText("");
                    textEntryForRemove.setDirty(true);
                }
                EditMetaDataPanels.this.saveIfDirtyAndInputIsSaveEarly();
            }
        });
    }

    Xmp createXmpFromInput() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("Not called in EDT");
        }
        Xmp xmp = new Xmp();
        for (TextEntry textEntry : this.textEntries) {
            String text;
            MetaDataValue metaDataValue;
            JPanel panel;
            if (textEntry instanceof EditTextEntryPanel) {
                panel = (EditTextEntryPanel)textEntry;
                metaDataValue = ((EditTextEntryPanel)panel).getMetaDataValue();
                text = ((EditTextEntryPanel)panel).getText();
                xmp.setValue(metaDataValue, text);
                continue;
            }
            if (textEntry instanceof EditRepeatableTextEntryPanel) {
                panel = (EditRepeatableTextEntryPanel)textEntry;
                metaDataValue = ((EditRepeatableTextEntryPanel)panel).getMetaDataValue();
                text = ((EditRepeatableTextEntryPanel)panel).getText();
                xmp.setValue(metaDataValue, text);
                for (String repetableText : ((EditRepeatableTextEntryPanel)panel).getRepeatableText()) {
                    xmp.setValue(metaDataValue, repetableText);
                }
                continue;
            }
            if (!(textEntry instanceof RatingSelectionPanel)) continue;
            panel = (RatingSelectionPanel)textEntry;
            try {
                String text2 = ((RatingSelectionPanel)panel).getText();
                if (text2 == null || text2.isEmpty()) continue;
                Long rating = Long.getLong(text2);
                xmp.setValue(XmpRatingMetaDataValue.INSTANCE, rating);
            }
            catch (Throwable t) {
                Logger.getLogger(EditMetaDataPanels.class.getName()).log(Level.SEVERE, null, t);
            }
        }
        return xmp;
    }

    void setXmp(final Xmp xmp) {
        if (xmp == null) {
            throw new NullPointerException("xmp == null");
        }
        if (!this.editable) {
            return;
        }
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                for (TextEntry textEntry : EditMetaDataPanels.this.textEntries) {
                    Object xmpValue;
                    MetaDataValue metaDataValue;
                    JPanel panel;
                    if (textEntry instanceof EditTextEntryPanel) {
                        panel = (EditTextEntryPanel)textEntry;
                        metaDataValue = ((EditTextEntryPanel)panel).getMetaDataValue();
                        xmpValue = xmp.getValue(metaDataValue);
                        if (xmpValue == null) continue;
                        String text = xmpValue.toString();
                        ((EditTextEntryPanel)panel).setText(text);
                        ((EditTextEntryPanel)panel).setDirty(true);
                        continue;
                    }
                    if (textEntry instanceof EditRepeatableTextEntryPanel) {
                        panel = (EditRepeatableTextEntryPanel)textEntry;
                        metaDataValue = ((EditRepeatableTextEntryPanel)panel).getMetaDataValue();
                        xmpValue = xmp.getValue(metaDataValue);
                        if (!(xmpValue instanceof Collection)) continue;
                        Collection collection = (Collection)xmpValue;
                        for (Object o : collection) {
                            ((EditRepeatableTextEntryPanel)panel).addText(o.toString());
                        }
                        continue;
                    }
                    if (!(textEntry instanceof RatingSelectionPanel)) continue;
                    panel = (RatingSelectionPanel)textEntry;
                    Long rating = xmp.contains(XmpRatingMetaDataValue.INSTANCE) ? (Long)xmp.getValue(XmpRatingMetaDataValue.INSTANCE) : null;
                    if (rating == null) continue;
                    String ratingAsString = Long.toString(rating);
                    ((RatingSelectionPanel)panel).setText(ratingAsString);
                    ((RatingSelectionPanel)panel).setDirty(true);
                }
                EditMetaDataPanels.this.saveIfDirtyAndInputIsSaveEarly();
            }
        });
    }

    void setRating(final Long rating) {
        if (rating == null) {
            throw new NullPointerException("rating == null");
        }
        if (!this.editable) {
            return;
        }
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                TextEntry textEntryForSet = null;
                int size = EditMetaDataPanels.this.textEntries.size();
                for (int i = 0; textEntryForSet == null && i < size; ++i) {
                    TextEntry textEntry = (TextEntry)EditMetaDataPanels.this.textEntries.get(i);
                    MetaDataValue metaDataValue = textEntry.getMetaDataValue();
                    if (!metaDataValue.equals(XmpRatingMetaDataValue.INSTANCE)) continue;
                    textEntryForSet = textEntry;
                }
                if (textEntryForSet instanceof RatingSelectionPanel) {
                    RatingSelectionPanel ratingPanel = (RatingSelectionPanel)textEntryForSet;
                    String ratingAsString = Long.toString(rating);
                    ratingPanel.setTextAndNotify(ratingAsString);
                }
                EditMetaDataPanels.this.saveIfDirtyAndInputIsSaveEarly();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMetadataTemplate(final MetadataTemplate template) {
        if (template == null) {
            throw new NullPointerException("template == null");
        }
        Object object = this.monitor;
        synchronized (object) {
            if (!this.editable) {
                return;
            }
        }
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                for (TextEntry textEntry : EditMetaDataPanels.this.textEntries) {
                    MetaDataValue metaDataValue = textEntry.getMetaDataValue();
                    Object templateValue = template.getMetaDataValue(metaDataValue);
                    if (templateValue instanceof String) {
                        String string = (String)templateValue;
                        if (string.isEmpty()) continue;
                        textEntry.setText(string);
                        textEntry.setDirty(true);
                        continue;
                    }
                    if (!(templateValue instanceof Collection)) continue;
                    Collection strings = (Collection)templateValue;
                    EditRepeatableTextEntryPanel repeatableTextEntry = (EditRepeatableTextEntryPanel)textEntry;
                    repeatableTextEntry.setTexts(strings);
                    repeatableTextEntry.setDirty(true);
                }
            }
        });
    }

    MetadataTemplate createMetadataTemplateFromInput() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("Not called in EDT");
        }
        MetadataTemplate template = new MetadataTemplate();
        for (TextEntry textEntry : this.textEntries) {
            MetaDataValue metaDataValue;
            if (textEntry instanceof EditRepeatableTextEntryPanel) {
                EditRepeatableTextEntryPanel repeatableEntry = (EditRepeatableTextEntryPanel)textEntry;
                metaDataValue = textEntry.getMetaDataValue();
                Collection<String> repeatableText = repeatableEntry.getRepeatableText();
                template.setMetaDataValue(metaDataValue, repeatableText);
                continue;
            }
            String text = textEntry.getText();
            if (text == null || text.trim().isEmpty()) continue;
            metaDataValue = textEntry.getMetaDataValue();
            template.setMetaDataValue(metaDataValue, text.trim());
        }
        return template;
    }

    private void addEditPanelsToParentContainer() {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                EditMetaDataPanels.this.parentContainer.removeAll();
                EditMetaDataPanels.this.parentContainer.setLayout(new GridBagLayout());
                LinkedList<? extends Component> excludeFromAutoMnemonicComponents = new LinkedList<Component>();
                int size = EditMetaDataPanels.this.textEntries.size();
                for (int i = 0; i < size; ++i) {
                    GridBagConstraints constraints = EditMetaDataPanels.this.createGridBagConstraints();
                    if (i == size - 1) {
                        constraints.insets.bottom += 10;
                    }
                    TextEntry textEntry = (TextEntry)EditMetaDataPanels.this.textEntries.get(i);
                    excludeFromAutoMnemonicComponents.addAll(textEntry.getExcludeFromAutoMnemonicComponents());
                    ExpandCollapseComponentPanel panel = new ExpandCollapseComponentPanel((Component)((Object)textEntry));
                    EditMetaDataPanels.this.parentContainer.add((Component)panel, constraints);
                    panel.readExpandedState();
                }
                EditMetaDataPanels.this.setMnemonics(excludeFromAutoMnemonicComponents);
                EditMetaDataPanels.this.addActionPanel();
            }
        });
    }

    private void setMnemonics(final Collection<? extends Component> excludeFromAutoMnemonicComponents) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                List<Character> mnemonicChars = EditMetaDataPanels.this.editMetadataActionsPanel.getButtonsMnemonicChars();
                ViewUtil.setDisplayedMnemonicsToLabels(EditMetaDataPanels.this.parentContainer, excludeFromAutoMnemonicComponents, mnemonicChars.toArray(new Character[0]));
            }
        });
    }

    private GridBagConstraints createGridBagConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 10, 0, 10);
        gbc.weightx = 1.0;
        return gbc;
    }

    private void addActionPanel() {
        GridBagConstraints gbc = this.createGridBagConstraints();
        gbc.gridheight = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        this.parentContainer.add((Component)this.editMetadataActionsPanel, gbc);
        this.editMetadataActionsPanel.tabbedPane.addFocusListener(this);
    }

    private void requestFocusToFirstEditField() {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (EditMetaDataPanels.this.textEntries.size() > 0) {
                    TextEntry textEntry = (TextEntry)EditMetaDataPanels.this.textEntries.get(0);
                    textEntry.requestFocus();
                    EditMetaDataPanels.this.lastFocussedEditControl = (Component)EditMetaDataPanels.this.textEntries.get(0);
                }
            }
        });
    }

    void setFocusToLastFocussedEditControl() {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (EditMetaDataPanels.this.lastFocussedEditControl != null) {
                    EditMetaDataPanels.this.lastFocussedEditControl.requestFocus();
                } else {
                    EditMetaDataPanels.this.requestFocusToFirstEditField();
                }
            }
        });
    }

    private void createEditPanels() {
        if (!this.textEntries.isEmpty()) {
            throw new IllegalStateException("Panels already created");
        }
        for (MetaDataValue metaDataValue : EditableMetaDataValues.get()) {
            JPanel panel;
            EditHints editHints = EditableMetaDataValues.getEditHints(metaDataValue);
            boolean isRepeatable = editHints.isRepeatable();
            if (isRepeatable) {
                panel = new EditRepeatableTextEntryPanel(metaDataValue);
                ((EditRepeatableTextEntryPanel)panel).textAreaInput.addFocusListener(this);
                if (metaDataValue.equals(XmpDcSubjectsSubjectMetaDataValue.INSTANCE)) {
                    this.keywordsPanel = panel;
                    ((EditRepeatableTextEntryPanel)panel).setSuggest(new SuggestKeywords());
                    ((EditRepeatableTextEntryPanel)panel).setBundleKeyPosRenameDialog("EditMetadataPanels.Keywords.RenameDialog.Pos");
                    if (WordsetPreferences.isDisplayWordsetsEditPanel()) {
                        ((EditRepeatableTextEntryPanel)panel).addWordsetsPanel();
                    }
                }
                this.textEntries.add((TextEntry)((Object)panel));
                this.repeatableMetaDataValuesOfTextEntries.add(metaDataValue);
                continue;
            }
            if (metaDataValue.equals(XmpRatingMetaDataValue.INSTANCE)) {
                panel = new RatingSelectionPanel(metaDataValue);
                for (Component component : ((RatingSelectionPanel)panel).getInputComponents()) {
                    component.addFocusListener(this);
                }
                this.textEntries.add((TextEntry)((Object)panel));
            } else {
                panel = new EditTextEntryPanel(metaDataValue);
                ((EditTextEntryPanel)panel).textAreaEdit.addFocusListener(this);
                this.textEntries.add((TextEntry)((Object)panel));
            }
            this.notRepeatableMetaDataValuesOfTextEntries.add(metaDataValue);
        }
    }

    private void enableAutocomplete() {
        if (this.isAutocompleteEnabled()) {
            for (TextEntry textEntry : this.textEntries) {
                textEntry.enableAutocomplete();
            }
        }
    }

    private boolean isAutocompleteEnabled() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.EnableAutoComplete") ? prefs.getBoolean("UserSettings.EnableAutoComplete") : true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        Object object = this.monitor;
        synchronized (object) {
            this.setFiles(Collections.emptyList());
        }
    }

    void emptyAllEditPanels() {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                for (TextEntry textEntry : EditMetaDataPanels.this.textEntries) {
                    textEntry.empty();
                }
            }
        });
    }

    @Override
    public void focusGained(FocusEvent evt) {
        Component sourceComponent = (Component)evt.getSource();
        if (this.isEditComponent(sourceComponent) && !(sourceComponent instanceof RatingSelectionPanel)) {
            this.lastFocussedEditControl = sourceComponent;
        }
        this.scrollToVisible(sourceComponent);
    }

    @Override
    public void focusLost(FocusEvent evt) {
        Component oppositeComponent = evt.getOppositeComponent();
        if (this.isEditComponent(oppositeComponent)) {
            this.saveIfDirtyAndInputIsSaveEarly();
        }
    }

    private boolean isEditComponent(Component c) {
        return c instanceof JTextArea || c instanceof JTextField || c instanceof RatingSelectionPanel;
    }

    private void scrollToVisible(final Component component) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                Component parent = EditMetaDataPanels.this.getParentNextToContainer(component);
                if (parent != null) {
                    EditMetaDataPanels.this.parentContainer.scrollRectToVisible(parent.getBounds());
                }
            }
        });
    }

    private Component getParentNextToContainer(Component component) {
        for (Component parent = component; parent != null; parent = parent.getParent()) {
            Container parentsParent = parent.getParent();
            if (parentsParent != this.parentContainer) continue;
            return parent;
        }
        return null;
    }

    @EventSubscriber(eventClass=PreferencesChangedEvent.class)
    public void preferencesChanged(PreferencesChangedEvent evt) {
        String key = evt.getKey();
        if ("UserSettings.DisplayWordSettingsEditPanel".equals(key) && this.keywordsPanel != null) {
            boolean display = (Boolean)evt.getNewValue();
            if (display) {
                this.keywordsPanel.addWordsetsPanel();
            } else {
                this.keywordsPanel.removeWordsetsPanel();
            }
        }
    }

    @EventSubscriber(eventClass=AppWillExitEvent.class)
    public void appWillExit(AppWillExitEvent evt) {
        this.saveIfDirty();
    }

    void saveIfDirtyAndInputIsSaveEarly() {
        if (!(this.editable && this.isSaveInputEarly() && this.isDirty())) {
            return;
        }
        this.save();
    }

    private boolean isSaveInputEarly() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.SaveInputEarly") ? prefs.getBoolean("UserSettings.SaveInputEarly") : true;
    }

    @EventSubscriber(eventClass=XmpInsertedEvent.class)
    public void xmpInserted(XmpInsertedEvent evt) {
        this.insertValuesOfExternalUpdatedXmp(evt.getImageFile(), evt.getXmp());
    }

    @EventSubscriber(eventClass=XmpUpdatedEvent.class)
    public void xmpUpdated(XmpUpdatedEvent evt) {
        this.insertValuesOfExternalUpdatedXmp(evt.getImageFile(), evt.getUpdatedXmp());
    }

    @EventSubscriber(eventClass=XmpDeletedEvent.class)
    public void xmpDeleted(XmpDeletedEvent evt) {
        this.insertValuesOfExternalUpdatedXmp(evt.getImageFile(), evt.getXmp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertValuesOfExternalUpdatedXmp(File file, Xmp xmp) {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.isAsSingleFileInEdit(file) || this.isDirty()) {
                return;
            }
            FileXmp currentFileXmpInEdit = this.filesXmp.get(0);
            this.filesXmp.set(0, new FileXmp(file, xmp));
            Xmp currentXmpInEdit = currentFileXmpInEdit.getXmp();
            this.removeXmpAsListenerFromAllTextEntries(currentXmpInEdit);
            this.addXmpAsListenerToAllTextEntries(xmp);
            this.setXmpToEditPanels(Arrays.asList(xmp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAsSingleFileInEdit(File file) {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.editable || !this.containsExactlyOneFileForEdit()) {
                return false;
            }
            FileXmp currentFileXmp = this.filesXmp.get(0);
            File currentFile = currentFileXmp.getFile();
            return file.equals(currentFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsExactlyOneFileForEdit() {
        Object object = this.monitor;
        synchronized (object) {
            return this.filesXmp.size() == 1;
        }
    }

    private class WatchDifferentValues
    extends MouseAdapter {
        private final List<TextEntry> entries = new ArrayList<TextEntry>();
        private final Set<TextEntry> releasedEntries = new HashSet<TextEntry>();
        private volatile boolean listen;

        private WatchDifferentValues() {
        }

        public synchronized void setListen(boolean listen) {
            if (listen) {
                this.listenToEntries();
            }
            this.listen = listen;
        }

        private void listenToEntries() {
            for (TextEntry entry : this.entries) {
                if (!(entry instanceof RatingSelectionPanel)) {
                    entry.setText(Bundle.getString(EditMetaDataPanels.class, "EditMetadataPanels.DisableIfMultipleValues.Info.TextEntry", new Object[0]));
                }
                entry.addMouseListenerToInputComponents(this);
                entry.setDirty(false);
                entry.setEditable(false);
            }
        }

        private void releaseAllEntries() {
            for (TextEntry entry : this.entries) {
                if (this.releasedEntries.contains(entry)) continue;
                this.releaseEntry(entry);
            }
        }

        private void releaseEntry(TextEntry entry) {
            entry.removeMouseListenerFromInputComponents(this);
            entry.setEditable(true);
            entry.setText("");
            entry.setDirty(false);
            this.releasedEntries.add(entry);
        }

        public synchronized void setEntries(Collection<TextEntry> entries) {
            if (entries == null) {
                throw new NullPointerException("entries == null");
            }
            this.releaseAllEntries();
            this.releasedEntries.clear();
            this.entries.clear();
            this.entries.addAll(entries);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mousePressed(MouseEvent evt) {
            WatchDifferentValues watchDifferentValues = this;
            synchronized (watchDifferentValues) {
                if (!EditMetaDataPanels.this.editable || !this.listen) {
                    return;
                }
                TextEntry entry = this.getTextEntry(evt.getSource());
                if (this.enableEdit(entry) && entry instanceof RatingSelectionPanel) {
                    ((RatingSelectionPanel)entry).repeatLastClick();
                }
            }
        }

        private TextEntry getTextEntry(Object o) {
            Object obj = o;
            if (obj instanceof TextEntry) {
                return (TextEntry)obj;
            }
            while (obj != null) {
                if (obj instanceof Component) {
                    if (!((obj = ((Component)obj).getParent()) instanceof TextEntry)) continue;
                    return (TextEntry)obj;
                }
                return null;
            }
            return null;
        }

        private boolean enableEdit(TextEntry entry) {
            if (entry == null) {
                throw new NullPointerException("entry == null");
            }
            String message = Bundle.getString(WatchDifferentValues.class, "EditMetadataPanels.DisableIfMultipleValues.Confirm.Edit", new Object[0]);
            if (MessageDisplayer.confirmYesNo(null, message)) {
                this.releaseEntry(entry);
                return true;
            }
            return false;
        }
    }

    private class SetFilesThread
    extends Thread
    implements Cancelable {
        private volatile boolean cancelled;
        private final Collection<File> threadFiles;
        private final List<FileXmp> threadFilesXmp;

        private SetFilesThread(Collection<File> files) {
            super("JPhotoTagger: Set File's XMP to Edit Panel");
            this.threadFiles = new ArrayList<File>(files);
            this.threadFilesXmp = new ArrayList<FileXmp>(files.size());
            LOGGER.log(Level.INFO, "Setting XMP to edit panel from that files: {0}", files);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            this.setFilesXmp();
            if (!this.cancelled) {
                object = EditMetaDataPanels.this.monitor;
                synchronized (object) {
                    List xmps = EditMetaDataPanels.this.getXmpOfFilesXmp(this.threadFilesXmp);
                    EditMetaDataPanels.this.setXmpToEditPanels(xmps);
                    EditMetaDataPanels.this.addXmpAsListenerToAllTextEntries(xmps);
                    EditMetaDataPanels.this.filesXmp.clear();
                    EditMetaDataPanels.this.filesXmp.addAll(this.threadFilesXmp);
                    EditMetaDataPanels.this.setDirty(false);
                    EditMetaDataPanels.this.setEditable(!this.threadFiles.isEmpty());
                    EditMetaDataPanels.this.parentContainer.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            object = EditMetaDataPanels.this.monitor;
            synchronized (object) {
                if (EditMetaDataPanels.this.currentSetFilesThread == this) {
                    EditMetaDataPanels.this.currentSetFilesThread = null;
                }
            }
        }

        private void setFilesXmp() {
            for (File file : this.threadFiles) {
                if (this.cancelled) {
                    return;
                }
                Xmp xmp = null;
                if (EditMetaDataPanels.this.xmpSidecarFileResolver.hasXmpSidecarFile(file)) {
                    try {
                        xmp = XmpMetadata.getXmpFromSidecarFileOf(file);
                    }
                    catch (Throwable t) {
                        LOGGER.log(Level.SEVERE, null, t);
                    }
                }
                if (xmp == null) {
                    xmp = new Xmp();
                }
                FileXmp fileXmp = new FileXmp(file, xmp);
                this.threadFilesXmp.add(fileXmp);
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            LOGGER.log(Level.INFO, "Cancelled setting XMP to edit panel from that files: {0}", this.threadFiles);
        }
    }
}

