/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.editmetadata;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.domain.repository.MetadataTemplatesRepository;
import org.jphototagger.domain.templates.MetadataTemplate;
import org.jphototagger.domain.thumbnails.event.ThumbnailsSelectionChangedEvent;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.editmetadata.EditMetaDataPanels;
import org.jphototagger.program.module.metadatatemplates.EditMetaDataTemplateDialog;
import org.jphototagger.program.module.metadatatemplates.MetadataTemplatesComboBoxModel;
import org.openide.util.Lookup;

final class EditMetaDataActionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final EditMetaDataPanels editMetaDataPanels;
    private final MetadataTemplatesComboBoxModel metadataTemplatesComboBoxModel = new MetadataTemplatesComboBoxModel();
    private final MetadataTemplatesRepository repo = Lookup.getDefault().lookup(MetadataTemplatesRepository.class);
    private boolean aFileSelected;
    private JButton buttonEmptyMetadata;
    private JButton buttonMetadataTemplateAdd;
    private JButton buttonMetadataTemplateCreate;
    private JButton buttonMetadataTemplateDelete;
    private JButton buttonMetadataTemplateEdit;
    private JButton buttonMetadataTemplateInsert;
    private JButton buttonMetadataTemplateRename;
    private JButton buttonMetadataTemplateUpdate;
    private JComboBox<Object> comboBoxMetadataTemplates;
    private JLabel labelPromptCurrentTemplate;
    private JLabel labelPromptInfoCurrentTemplate;
    private JLabel labelTemplateName;
    private JPanel panelComboBox;
    private JPanel panelEditButtons;
    private JPanel panelGroupMetadataEdit;
    private JPanel panelGroupMetadataTemplates;
    private JPanel panelTemplateButtons;
    private JPanel panelTemplateNameInfo;
    public JTabbedPane tabbedPane;

    EditMetaDataActionsPanel(EditMetaDataPanels editMetaDataPanels) {
        this.editMetaDataPanels = editMetaDataPanels;
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.setTemplateName();
        this.setTemplateButtonsEnabled();
        MnemonicUtil.setMnemonics(this);
        AnnotationProcessor.process(this);
    }

    private void setTemplateName() {
        Object selectedItem = this.comboBoxMetadataTemplates.getSelectedItem();
        this.labelTemplateName.setText(selectedItem == null ? Bundle.getString(EditMetaDataActionsPanel.class, "EditMetadataActionsPanel.labelTemplateName.NoTemplateSelected", new Object[0]) : selectedItem.toString());
    }

    List<Character> getButtonsMnemonicChars() {
        ArrayList<Character> mnemonicChars = new ArrayList<Character>();
        mnemonicChars.add(Character.valueOf((char)this.buttonEmptyMetadata.getMnemonic()));
        mnemonicChars.add(Character.valueOf((char)this.buttonMetadataTemplateCreate.getMnemonic()));
        mnemonicChars.add(Character.valueOf((char)this.buttonMetadataTemplateDelete.getMnemonic()));
        mnemonicChars.add(Character.valueOf((char)this.buttonMetadataTemplateEdit.getMnemonic()));
        mnemonicChars.add(Character.valueOf((char)this.buttonMetadataTemplateInsert.getMnemonic()));
        mnemonicChars.add(Character.valueOf((char)this.buttonMetadataTemplateRename.getMnemonic()));
        mnemonicChars.add(Character.valueOf((char)this.buttonMetadataTemplateUpdate.getMnemonic()));
        mnemonicChars.add(Character.valueOf((char)this.buttonMetadataTemplateAdd.getMnemonic()));
        mnemonicChars.add(Character.valueOf((char)this.labelPromptCurrentTemplate.getDisplayedMnemonic()));
        return mnemonicChars;
    }

    @EventSubscriber(eventClass=ThumbnailsSelectionChangedEvent.class)
    public void thumbnailsSelectionChanged(ThumbnailsSelectionChangedEvent evt) {
        this.aFileSelected = evt.isAFileSelected();
        boolean editable = this.editMetaDataPanels.canEdit(evt.getSelectedFiles());
        this.buttonEmptyMetadata.setEnabled(this.aFileSelected && editable);
        this.buttonMetadataTemplateCreate.setEnabled(this.aFileSelected);
        boolean metaDataTemplateSelected = this.isMetaDataTemplateSelected();
        this.buttonMetadataTemplateInsert.setEnabled(metaDataTemplateSelected && this.aFileSelected && editable);
        this.buttonMetadataTemplateUpdate.setEnabled(this.aFileSelected && metaDataTemplateSelected);
    }

    private void setTemplateButtonsEnabled() {
        boolean templateSelected = this.isMetaDataTemplateSelected();
        this.buttonMetadataTemplateRename.setEnabled(templateSelected);
        this.buttonMetadataTemplateDelete.setEnabled(templateSelected);
        this.buttonMetadataTemplateEdit.setEnabled(templateSelected);
        boolean metaDataTemplateSelected = this.isMetaDataTemplateSelected();
        this.buttonMetadataTemplateUpdate.setEnabled(this.aFileSelected && metaDataTemplateSelected);
        this.buttonMetadataTemplateInsert.setEnabled(this.aFileSelected && metaDataTemplateSelected);
    }

    private boolean isMetaDataTemplateSelected() {
        return this.comboBoxMetadataTemplates.getSelectedIndex() >= 0;
    }

    private void emptyMetaData() {
        this.editMetaDataPanels.emptyAllEditPanels();
    }

    private void insertSelectedTemplateIntoEditPanels() {
        Object selectedItem = this.metadataTemplatesComboBoxModel.getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        MetadataTemplate selectedTemplate = (MetadataTemplate)selectedItem;
        this.editMetaDataPanels.setMetadataTemplate(selectedTemplate);
    }

    private void createTemplateFromEditMetaDataPanels() {
        MetadataTemplate template = this.editMetaDataPanels.createMetadataTemplateFromInput();
        String defaultName = null;
        String gotName = this.askForNotExistingTemplateName(defaultName);
        if (gotName != null) {
            template.setName(gotName);
            this.repo.saveOrUpdateMetadataTemplate(template);
        }
    }

    private void deleteSelectedTemplate() {
        Object selectedItem = this.metadataTemplatesComboBoxModel.getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        MetadataTemplate selectedTemplate = (MetadataTemplate)selectedItem;
        String templateName = selectedTemplate.getName();
        if (this.confirmDelete(templateName)) {
            this.repo.deleteMetadataTemplate(templateName);
        }
    }

    private boolean confirmDelete(String templateName) {
        String message = Bundle.getString(EditMetaDataActionsPanel.class, "EditMetaDataActionsPanel.Confirm.Delete", templateName);
        return MessageDisplayer.confirmYesNo(null, message);
    }

    private void updateSelectedTemplateFromEditMetaDataPanels() {
        Object selectedItem = this.metadataTemplatesComboBoxModel.getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        MetadataTemplate oldTemplate = (MetadataTemplate)selectedItem;
        MetadataTemplate newTemplate = this.editMetaDataPanels.createMetadataTemplateFromInput();
        newTemplate.setName(oldTemplate.getName());
        this.repo.updateMetadataTemplate(newTemplate);
    }

    private void editSelectedTemplate() {
        Object selectedItem = this.metadataTemplatesComboBoxModel.getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        EditMetaDataTemplateDialog dialog = new EditMetaDataTemplateDialog();
        MetadataTemplate selectedTemplate = (MetadataTemplate)selectedItem;
        dialog.setTemplate(selectedTemplate);
        dialog.setVisible(true);
    }

    private void renameSelectedTemplate() {
        Object selectedItem = this.metadataTemplatesComboBoxModel.getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        MetadataTemplate selectedTemplate = (MetadataTemplate)selectedItem;
        String fromName = selectedTemplate.getName();
        String toName = this.askForNotExistingTemplateName(fromName);
        if (toName != null) {
            this.repo.updateRenameMetadataTemplate(fromName, toName);
        }
    }

    private String askForNotExistingTemplateName(String defaultName) {
        boolean exists = true;
        boolean cancel = false;
        String name = defaultName;
        while (exists && !cancel) {
            String input;
            String info = Bundle.getString(EditMetaDataActionsPanel.class, "EditMetaDataActionsPanel.Input.TemplateName", new Object[0]);
            name = MessageDisplayer.input(info, input = name);
            boolean bl = exists = name != null && this.repo.existsMetadataTemplate(name);
            if (exists) {
                cancel = this.confirmOverwrite(name);
            }
            if (!exists || !cancel) continue;
            name = null;
        }
        return name;
    }

    private boolean confirmOverwrite(String name) {
        String message = Bundle.getString(EditMetaDataActionsPanel.class, "EditMetaDataActionsPanel.Confirm.OverwriteExistingTemplate", name);
        return !MessageDisplayer.confirmYesNo(null, message);
    }

    private void createNewTemplate() {
        MetadataTemplate template = new MetadataTemplate();
        EditMetaDataTemplateDialog dialog = new EditMetaDataTemplateDialog();
        dialog.setTemplate(template);
        dialog.setVisible(true);
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.panelGroupMetadataEdit = new JPanel();
        this.panelTemplateNameInfo = new JPanel();
        this.labelPromptInfoCurrentTemplate = new JLabel();
        this.labelTemplateName = new JLabel();
        this.panelEditButtons = new JPanel();
        this.buttonMetadataTemplateInsert = new JButton();
        this.buttonMetadataTemplateCreate = new JButton();
        this.buttonEmptyMetadata = new JButton();
        this.panelGroupMetadataTemplates = new JPanel();
        this.panelComboBox = new JPanel();
        this.labelPromptCurrentTemplate = new JLabel();
        this.comboBoxMetadataTemplates = new JComboBox();
        this.panelTemplateButtons = new JPanel();
        this.buttonMetadataTemplateRename = new JButton();
        this.buttonMetadataTemplateUpdate = new JButton();
        this.buttonMetadataTemplateDelete = new JButton();
        this.buttonMetadataTemplateEdit = new JButton();
        this.buttonMetadataTemplateAdd = new JButton();
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.tabbedPane.setName("tabbedPane");
        this.panelGroupMetadataEdit.setName("panelGroupMetadataEdit");
        this.panelGroupMetadataEdit.setLayout(new GridBagLayout());
        this.panelTemplateNameInfo.setName("panelTemplateNameInfo");
        this.panelTemplateNameInfo.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/editmetadata/Bundle");
        this.labelPromptInfoCurrentTemplate.setText(bundle.getString("EditMetaDataActionsPanel.labelPromptInfoCurrentTemplate.text"));
        this.labelPromptInfoCurrentTemplate.setName("labelPromptInfoCurrentTemplate");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelTemplateNameInfo.add((Component)this.labelPromptInfoCurrentTemplate, gridBagConstraints);
        this.labelTemplateName.setText(bundle.getString("EditMetaDataActionsPanel.labelTemplateName.text"));
        this.labelTemplateName.setName("labelTemplateName");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelTemplateNameInfo.add((Component)this.labelTemplateName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelGroupMetadataEdit.add((Component)this.panelTemplateNameInfo, gridBagConstraints);
        this.panelEditButtons.setName("panelEditButtons");
        this.panelEditButtons.setLayout(new GridBagLayout());
        this.buttonMetadataTemplateInsert.setText(bundle.getString("EditMetaDataActionsPanel.buttonMetadataTemplateInsert.text"));
        this.buttonMetadataTemplateInsert.setToolTipText(bundle.getString("EditMetaDataActionsPanel.buttonMetadataTemplateInsert.toolTipText"));
        this.buttonMetadataTemplateInsert.setEnabled(false);
        this.buttonMetadataTemplateInsert.setMargin(new Insets(2, 2, 2, 2));
        this.buttonMetadataTemplateInsert.setName("buttonMetadataTemplateInsert");
        this.buttonMetadataTemplateInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditMetaDataActionsPanel.this.buttonMetadataTemplateInsertActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.panelEditButtons.add((Component)this.buttonMetadataTemplateInsert, gridBagConstraints);
        this.buttonMetadataTemplateCreate.setText(bundle.getString("EditMetaDataActionsPanel.buttonMetadataTemplateCreate.text"));
        this.buttonMetadataTemplateCreate.setToolTipText(bundle.getString("EditMetaDataActionsPanel.buttonMetadataTemplateCreate.toolTipText"));
        this.buttonMetadataTemplateCreate.setEnabled(false);
        this.buttonMetadataTemplateCreate.setMargin(new Insets(2, 2, 2, 2));
        this.buttonMetadataTemplateCreate.setName("buttonMetadataTemplateCreate");
        this.buttonMetadataTemplateCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditMetaDataActionsPanel.this.buttonMetadataTemplateCreateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelEditButtons.add((Component)this.buttonMetadataTemplateCreate, gridBagConstraints);
        this.buttonEmptyMetadata.setText(bundle.getString("EditMetaDataActionsPanel.buttonEmptyMetadata.text"));
        this.buttonEmptyMetadata.setToolTipText(bundle.getString("EditMetaDataActionsPanel.buttonEmptyMetadata.toolTipText"));
        this.buttonEmptyMetadata.setEnabled(false);
        this.buttonEmptyMetadata.setMargin(new Insets(2, 2, 2, 2));
        this.buttonEmptyMetadata.setName("buttonEmptyMetadata");
        this.buttonEmptyMetadata.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditMetaDataActionsPanel.this.buttonEmptyMetadataActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelEditButtons.add((Component)this.buttonEmptyMetadata, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelGroupMetadataEdit.add((Component)this.panelEditButtons, gridBagConstraints);
        this.tabbedPane.addTab(bundle.getString("EditMetaDataActionsPanel.panelGroupMetadataEdit.TabConstraints.tabTitle"), this.panelGroupMetadataEdit);
        this.panelGroupMetadataTemplates.setName("panelGroupMetadataTemplates");
        this.panelGroupMetadataTemplates.setLayout(new GridBagLayout());
        this.panelComboBox.setName("panelComboBox");
        this.panelComboBox.setLayout(new GridBagLayout());
        this.labelPromptCurrentTemplate.setLabelFor(this.comboBoxMetadataTemplates);
        this.labelPromptCurrentTemplate.setText(bundle.getString("EditMetaDataActionsPanel.labelPromptCurrentTemplate.text"));
        this.labelPromptCurrentTemplate.setName("labelPromptCurrentTemplate");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelComboBox.add((Component)this.labelPromptCurrentTemplate, gridBagConstraints);
        this.comboBoxMetadataTemplates.setModel(this.metadataTemplatesComboBoxModel);
        this.comboBoxMetadataTemplates.setToolTipText(bundle.getString("EditMetaDataActionsPanel.comboBoxMetadataTemplates.toolTipText"));
        this.comboBoxMetadataTemplates.setName("comboBoxMetadataTemplates");
        this.comboBoxMetadataTemplates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditMetaDataActionsPanel.this.comboBoxMetadataTemplatesActionPerformed(evt);
            }
        });
        this.comboBoxMetadataTemplates.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EditMetaDataActionsPanel.this.comboBoxMetadataTemplatesPropertyChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelComboBox.add(this.comboBoxMetadataTemplates, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelGroupMetadataTemplates.add((Component)this.panelComboBox, gridBagConstraints);
        this.panelTemplateButtons.setName("panelTemplateButtons");
        this.panelTemplateButtons.setLayout(new GridLayout(3, 0, 5, 5));
        this.buttonMetadataTemplateRename.setText(bundle.getString("EditMetaDataActionsPanel.buttonMetadataTemplateRename.text"));
        this.buttonMetadataTemplateRename.setToolTipText(bundle.getString("EditMetaDataActionsPanel.buttonMetadataTemplateRename.toolTipText"));
        this.buttonMetadataTemplateRename.setEnabled(false);
        this.buttonMetadataTemplateRename.setMargin(new Insets(2, 2, 2, 2));
        this.buttonMetadataTemplateRename.setName("buttonMetadataTemplateRename");
        this.buttonMetadataTemplateRename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditMetaDataActionsPanel.this.buttonMetadataTemplateRenameActionPerformed(evt);
            }
        });
        this.panelTemplateButtons.add(this.buttonMetadataTemplateRename);
        this.buttonMetadataTemplateUpdate.setText(bundle.getString("EditMetaDataActionsPanel.buttonMetadataTemplateUpdate.text"));
        this.buttonMetadataTemplateUpdate.setToolTipText(bundle.getString("EditMetaDataActionsPanel.buttonMetadataTemplateUpdate.toolTipText"));
        this.buttonMetadataTemplateUpdate.setEnabled(false);
        this.buttonMetadataTemplateUpdate.setMargin(new Insets(2, 2, 2, 2));
        this.buttonMetadataTemplateUpdate.setName("buttonMetadataTemplateUpdate");
        this.buttonMetadataTemplateUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditMetaDataActionsPanel.this.buttonMetadataTemplateUpdateActionPerformed(evt);
            }
        });
        this.panelTemplateButtons.add(this.buttonMetadataTemplateUpdate);
        this.buttonMetadataTemplateDelete.setText(bundle.getString("EditMetaDataActionsPanel.buttonMetadataTemplateDelete.text"));
        this.buttonMetadataTemplateDelete.setToolTipText(bundle.getString("EditMetaDataActionsPanel.buttonMetadataTemplateDelete.toolTipText"));
        this.buttonMetadataTemplateDelete.setEnabled(false);
        this.buttonMetadataTemplateDelete.setMargin(new Insets(2, 2, 2, 2));
        this.buttonMetadataTemplateDelete.setName("buttonMetadataTemplateDelete");
        this.buttonMetadataTemplateDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditMetaDataActionsPanel.this.buttonMetadataTemplateDeleteActionPerformed(evt);
            }
        });
        this.panelTemplateButtons.add(this.buttonMetadataTemplateDelete);
        this.buttonMetadataTemplateEdit.setText(bundle.getString("EditMetaDataActionsPanel.buttonMetadataTemplateEdit.text"));
        this.buttonMetadataTemplateEdit.setToolTipText(bundle.getString("EditMetaDataActionsPanel.buttonMetadataTemplateEdit.toolTipText"));
        this.buttonMetadataTemplateEdit.setEnabled(false);
        this.buttonMetadataTemplateEdit.setName("buttonMetadataTemplateEdit");
        this.buttonMetadataTemplateEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditMetaDataActionsPanel.this.buttonMetadataTemplateEditActionPerformed(evt);
            }
        });
        this.panelTemplateButtons.add(this.buttonMetadataTemplateEdit);
        this.buttonMetadataTemplateAdd.setText(bundle.getString("EditMetaDataActionsPanel.buttonMetadataTemplateAdd.text"));
        this.buttonMetadataTemplateAdd.setToolTipText(bundle.getString("EditMetaDataActionsPanel.buttonMetadataTemplateAdd.toolTipText"));
        this.buttonMetadataTemplateAdd.setMargin(new Insets(2, 2, 2, 2));
        this.buttonMetadataTemplateAdd.setName("buttonMetadataTemplateAdd");
        this.buttonMetadataTemplateAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditMetaDataActionsPanel.this.buttonMetadataTemplateAddActionPerformed(evt);
            }
        });
        this.panelTemplateButtons.add(this.buttonMetadataTemplateAdd);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelGroupMetadataTemplates.add((Component)this.panelTemplateButtons, gridBagConstraints);
        this.tabbedPane.addTab(bundle.getString("EditMetaDataActionsPanel.panelGroupMetadataTemplates.TabConstraints.tabTitle"), this.panelGroupMetadataTemplates);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tabbedPane, gridBagConstraints);
    }

    private void comboBoxMetadataTemplatesPropertyChange(PropertyChangeEvent evt) {
        this.setTemplateName();
    }

    private void comboBoxMetadataTemplatesActionPerformed(ActionEvent evt) {
        this.setTemplateName();
        this.setTemplateButtonsEnabled();
    }

    private void buttonEmptyMetadataActionPerformed(ActionEvent evt) {
        this.emptyMetaData();
    }

    private void buttonMetadataTemplateCreateActionPerformed(ActionEvent evt) {
        this.createTemplateFromEditMetaDataPanels();
    }

    private void buttonMetadataTemplateUpdateActionPerformed(ActionEvent evt) {
        this.updateSelectedTemplateFromEditMetaDataPanels();
    }

    private void buttonMetadataTemplateDeleteActionPerformed(ActionEvent evt) {
        this.deleteSelectedTemplate();
    }

    private void buttonMetadataTemplateInsertActionPerformed(ActionEvent evt) {
        this.insertSelectedTemplateIntoEditPanels();
    }

    private void buttonMetadataTemplateRenameActionPerformed(ActionEvent evt) {
        this.renameSelectedTemplate();
    }

    private void buttonMetadataTemplateEditActionPerformed(ActionEvent evt) {
        this.editSelectedTemplate();
    }

    private void buttonMetadataTemplateAddActionPerformed(ActionEvent evt) {
        this.createNewTemplate();
    }
}

