/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.directories;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.tree.DefaultMutableTreeNode;
import org.bushe.swing.event.EventBus;
import org.jphototagger.api.file.event.DirectoryRenamedEvent;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.io.TreeFileSystemDirectories;
import org.jphototagger.lib.swing.AllSystemDirectoriesTreeModel;
import org.jphototagger.program.factory.ModelFactory;
import org.jphototagger.program.module.directories.DirectoriesPopupMenu;
import org.jphototagger.program.module.directories.DirectoryController;
import org.jphototagger.program.module.filesystem.FileSystemDirectories;

public final class RenameDirectoryController
extends DirectoryController {
    public RenameDirectoryController() {
        this.listenToActionsOf(DirectoriesPopupMenu.INSTANCE.getItemRenameDirectory());
    }

    @Override
    protected boolean myKey(KeyEvent evt) {
        return evt.getKeyCode() == 113;
    }

    @Override
    protected boolean myAction(ActionEvent evt) {
        return evt.getSource() == DirectoriesPopupMenu.INSTANCE.getItemRenameDirectory();
    }

    @Override
    protected void action(final DefaultMutableTreeNode node) {
        File newDir;
        final File oldDir = this.getDirOfNode(node);
        if (oldDir != null && (newDir = FileSystemDirectories.rename(oldDir)) != null) {
            EventQueueUtil.invokeInDispatchThread(new Runnable(){

                @Override
                public void run() {
                    node.setUserObject(newDir);
                    TreeFileSystemDirectories.updateInTreeModel(ModelFactory.INSTANCE.getModel(AllSystemDirectoriesTreeModel.class), node);
                    EventBus.publish(new DirectoryRenamedEvent(this, oldDir, newDir));
                }
            });
        }
    }
}

