/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.directories;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.List;
import javax.swing.JTree;
import org.jphototagger.domain.thumbnails.OriginOfDisplayedThumbnails;
import org.jphototagger.lib.datatransfer.TransferUtil;
import org.jphototagger.lib.swing.KeyEventUtil;
import org.jphototagger.lib.util.ClipboardUtil;
import org.jphototagger.program.module.directories.DirectoryTreeTransferHandler;
import org.jphototagger.program.module.thumbnails.ThumbnailsPanel;
import org.jphototagger.program.resource.GUI;
import org.jphototagger.program.types.FileAction;
import org.jphototagger.program.view.ViewUtil;

public final class PasteFilesIntoDirectoryController
implements KeyListener {
    public PasteFilesIntoDirectoryController() {
        this.listen();
    }

    private void listen() {
        GUI.getDirectoriesTree().addKeyListener(this);
        GUI.getFavoritesTree().addKeyListener(this);
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        Object source;
        if (KeyEventUtil.isPaste(evt) && (source = evt.getSource()) instanceof JTree) {
            this.copyOrMovePastedFilesTo((JTree)source);
        }
    }

    private void copyOrMovePastedFilesTo(JTree targetTree) {
        ThumbnailsPanel tnPanel = GUI.getThumbnailsPanel();
        if (this.isSingleDirectory(tnPanel.getOriginOfDisplayedThumbnails()) && this.filesWereCopiedOrCutted(tnPanel.getFileAction())) {
            this.insertFilesIntoSelectedDirectoryOf(targetTree);
        }
    }

    private void insertFilesIntoSelectedDirectoryOf(JTree targetTree) {
        List<File> sourceFiles = ClipboardUtil.getFilesFromSystemClipboard(TransferUtil.FilenameDelimiter.NEWLINE);
        File targetDirectory = ViewUtil.getSelectedFile(targetTree);
        if (targetDirectory != null && !sourceFiles.isEmpty()) {
            this.copyOrMoveFiles(sourceFiles, targetDirectory);
        }
    }

    private void copyOrMoveFiles(List<File> sourceFiles, File targetDirectory) {
        ThumbnailsPanel tnPanel = GUI.getThumbnailsPanel();
        FileAction action = tnPanel.getFileAction();
        if (this.filesWereCopiedOrCutted(action)) {
            DirectoryTreeTransferHandler.handleDroppedFiles(action.getTransferHandlerAction(), sourceFiles, targetDirectory);
            tnPanel.setFileAction(FileAction.UNDEFINED);
        }
    }

    private boolean filesWereCopiedOrCutted(FileAction action) {
        return action.equals((Object)FileAction.COPY) || action.equals((Object)FileAction.CUT);
    }

    private boolean isSingleDirectory(OriginOfDisplayedThumbnails origin) {
        return origin.isFilesInSameDirectory() || origin.isFilesInDirectoryRecursive() || origin.isFilesInSameFavoriteDirectory() || origin.isFilesInFavoriteDirectoryRecursive();
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }
}

