/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.directories;

import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jphototagger.domain.favorites.Favorite;
import org.jphototagger.domain.filefilter.FileFilterUtil;
import org.jphototagger.lib.datatransfer.TransferUtil;
import org.jphototagger.program.datatransfer.Flavor;
import org.jphototagger.program.module.filesystem.FilesystemImageUtil;

public final class DirectoryTreeTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (!Flavor.hasFiles(support.getTransferable())) {
            return false;
        }
        JTree.DropLocation dropLocation = (JTree.DropLocation)support.getDropLocation();
        return dropLocation.getPath() != null;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        return null;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 0;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!support.isDrop()) {
            return false;
        }
        File targetDirectory = this.getTargetDirectory(support);
        List<File> sourceFiles = TransferUtil.getFiles(support.getTransferable(), TransferUtil.FilenameDelimiter.EMPTY);
        if (targetDirectory != null && !sourceFiles.isEmpty()) {
            DirectoryTreeTransferHandler.handleDroppedFiles(support.getUserDropAction(), sourceFiles, targetDirectory);
        }
        return true;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
    }

    public static void handleDroppedFiles(int dropAction, List<File> sourceFiles, File targetDirectory) {
        if (sourceFiles == null) {
            throw new NullPointerException("sourceFiles == null");
        }
        if (targetDirectory == null) {
            throw new NullPointerException("targetDirectory == null");
        }
        List<File> imageFiles = FileFilterUtil.filterImageFiles(sourceFiles);
        if (imageFiles.isEmpty()) {
            return;
        }
        if (dropAction == 1) {
            FilesystemImageUtil.copyImageFiles(imageFiles, targetDirectory, FilesystemImageUtil.ConfirmOverwrite.YES);
        } else if (dropAction == 2) {
            FilesystemImageUtil.moveImageFiles(imageFiles, targetDirectory, FilesystemImageUtil.ConfirmOverwrite.YES);
        }
    }

    private File getTargetDirectory(TransferHandler.TransferSupport support) {
        TreePath path = ((JTree.DropLocation)support.getDropLocation()).getPath();
        Object selNode = path.getLastPathComponent();
        if (selNode instanceof DefaultMutableTreeNode) {
            Object userObject = ((DefaultMutableTreeNode)selNode).getUserObject();
            if (userObject instanceof File) {
                return (File)userObject;
            }
            if (userObject instanceof Favorite) {
                return ((Favorite)userObject).getDirectory();
            }
        } else if (selNode instanceof File) {
            return (File)selNode;
        }
        return null;
    }
}

