/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.directories;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.windows.MainWindowManager;
import org.jphototagger.api.windows.WaitDisplayer;
import org.jphototagger.domain.filefilter.FileFilterUtil;
import org.jphototagger.domain.thumbnails.OriginOfDisplayedThumbnails;
import org.jphototagger.domain.thumbnails.ThumbnailsPanelSettings;
import org.jphototagger.domain.thumbnails.event.ThumbnailsPanelRefreshEvent;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.directories.DirectoriesPopupMenu;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class DirectorySelectedController
implements TreeSelectionListener {
    private static final String KEY_RECURSIVE = "DirectorySelectedController.DirectoriesRecursive";
    private final ActionListener recursiveListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean recursive = ((AbstractButton)e.getSource()).isSelected();
            DirectorySelectedController.this.persistRecursive(recursive);
            DirectorySelectedController.this.setFilesToThumbnailsPanel(null);
        }
    };

    public DirectorySelectedController() {
        this.restoreRecursive();
        this.listen();
    }

    private void listen() {
        GUI.getDirectoriesTree().addTreeSelectionListener(this);
        GUI.getCheckBoxDirectoriesRecursive().addActionListener(this.recursiveListener);
        AnnotationProcessor.process(this);
    }

    private void persistRecursive(boolean recursive) {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.setBoolean(KEY_RECURSIVE, recursive);
    }

    private void restoreRecursive() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        GUI.getCheckBoxDirectoriesRecursive().setSelected(prefs.getBoolean(KEY_RECURSIVE));
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        if (evt.isAddedPath() && !DirectoriesPopupMenu.INSTANCE.isTreeSelected()) {
            this.setFilesToThumbnailsPanel(null);
        }
    }

    private static boolean isMyOrigin(OriginOfDisplayedThumbnails origin) {
        return origin.isFilesInSameDirectory() || origin.isFilesInDirectoryRecursive();
    }

    private static OriginOfDisplayedThumbnails getMyOrigin() {
        return GUI.getCheckBoxDirectoriesRecursive().isSelected() ? OriginOfDisplayedThumbnails.FILES_IN_DIRECTORY_RECURSIVE : OriginOfDisplayedThumbnails.FILES_IN_SAME_DIRECTORY;
    }

    private static boolean isRecursive() {
        return DirectorySelectedController.getMyOrigin().isFilesInDirectoryRecursive();
    }

    private void setFilesToThumbnailsPanel(ThumbnailsPanelSettings settings) {
        EventQueueUtil.invokeInDispatchThread(new ShowThumbnails(settings));
    }

    @EventSubscriber(eventClass=ThumbnailsPanelRefreshEvent.class)
    public void refresh(ThumbnailsPanelRefreshEvent evt) {
        OriginOfDisplayedThumbnails origin = evt.getOriginOfDisplayedThumbnails();
        if (DirectorySelectedController.isMyOrigin(origin)) {
            this.setFilesToThumbnailsPanel(evt.getThumbnailsPanelSettings());
        }
    }

    private class ShowThumbnails
    implements Runnable {
        private final ThumbnailsPanelSettings panelSettings;

        ShowThumbnails(ThumbnailsPanelSettings panelSettings) {
            this.panelSettings = panelSettings;
        }

        @Override
        public void run() {
            EventQueueUtil.invokeInDispatchThread(new Runnable(){

                @Override
                public void run() {
                    ShowThumbnails.this.showThumbnails();
                }
            });
        }

        private void showThumbnails() {
            if (GUI.getDirectoriesTree().getSelectionCount() > 0) {
                WaitDisplayer waitDisplayer = Lookup.getDefault().lookup(WaitDisplayer.class);
                waitDisplayer.show();
                File selectedDirectory = new File(this.getDirectorynameFromTree());
                OriginOfDisplayedThumbnails origin = DirectorySelectedController.getMyOrigin();
                this.setTitle(selectedDirectory);
                GUI.getThumbnailsPanel().setFiles(this.getFiles(selectedDirectory), origin);
                GUI.getThumbnailsPanel().applyThumbnailsPanelSettings(this.panelSettings);
                waitDisplayer.hide();
            }
        }

        private List<File> getFiles(File directory) {
            return DirectorySelectedController.isRecursive() ? FileFilterUtil.getImageFilesOfDirAndSubDirs(directory) : FileFilterUtil.getImageFilesOfDirectory(directory);
        }

        private void setTitle(File selectedDirectory) {
            String title = Bundle.getString(ShowThumbnails.class, "ControllerDirectorySelected.AppFrame.Title.Directory", selectedDirectory);
            MainWindowManager mainWindowManager = Lookup.getDefault().lookup(MainWindowManager.class);
            mainWindowManager.setMainWindowTitle(title);
        }

        private String getDirectorynameFromTree() {
            TreePath treePath = GUI.getDirectoriesTree().getSelectionPath();
            if (treePath.getLastPathComponent() instanceof File) {
                return ((File)treePath.getLastPathComponent()).getAbsolutePath();
            }
            return treePath.getLastPathComponent().toString();
        }
    }
}

