/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.directories;

import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.preferences.PreferencesChangedEvent;
import org.jphototagger.lib.swing.KeyEventUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.app.ui.AppLookAndFeel;
import org.openide.util.Lookup;

public final class DirectoriesPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = 1L;
    public static final ImageIcon ICON_FAVORITE = AppLookAndFeel.getIcon("icon_favorite.png");
    public static final ImageIcon ICON_FOLDER_NEW = AppLookAndFeel.getIcon("icon_folder_new.png");
    private final JMenuItem itemAddToFavorites = new JMenuItem(Bundle.getString(DirectoriesPopupMenu.class, "DirectoriesPopupMenu.DisplayName.Action.AddToFavoriteDirectories", new Object[0]), ICON_FAVORITE);
    private final JMenuItem itemCreateDirectory = new JMenuItem(Bundle.getString(DirectoriesPopupMenu.class, "DirectoriesPopupMenu.DisplayName.Action.CreateDirectory", new Object[0]), ICON_FOLDER_NEW);
    private final JMenuItem itemRenameDirectory = new JMenuItem(Bundle.getString(DirectoriesPopupMenu.class, "DirectoriesPopupMenu.DisplayName.Action.RenameDirectory", new Object[0]), AppLookAndFeel.ICON_RENAME);
    private final JMenuItem itemRefresh = new JMenuItem(Bundle.getString(DirectoriesPopupMenu.class, "DirectoriesPopupMenu.DisplayName.Action.Refresh", new Object[0]), AppLookAndFeel.ICON_REFRESH);
    private final JMenuItem itemDeleteDirectory = new JMenuItem(Bundle.getString(DirectoriesPopupMenu.class, "DirectoriesPopupMenu.DisplayName.Action.DeleteDirectory", new Object[0]), AppLookAndFeel.ICON_DELETE);
    private final JMenuItem itemExpandAllSubitems = new JMenuItem(Bundle.getString(DirectoriesPopupMenu.class, "DirectoriesPopupMenu.ItemExpand", new Object[0]));
    private final JMenuItem itemCollapseAllSubitems = new JMenuItem(Bundle.getString(DirectoriesPopupMenu.class, "DirectoriesPopupMenu.ItemCollapse", new Object[0]));
    private final JMenuItem itemOpenInDesktop = new JMenuItem(Bundle.getString(DirectoriesPopupMenu.class, "DirectoriesPopupMenu.Action.OpenInDesktop", new Object[0]));
    private boolean treeSelected = false;
    private File directory;
    private TreePath path;
    public static final DirectoriesPopupMenu INSTANCE = new DirectoriesPopupMenu();

    private DirectoriesPopupMenu() {
        this.init();
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public void setTreePath(TreePath path) {
        this.path = path;
    }

    public TreePath getTreePath() {
        return this.path;
    }

    public JMenuItem getItemAddToFavorites() {
        return this.itemAddToFavorites;
    }

    public JMenuItem getItemCreateDirectory() {
        return this.itemCreateDirectory;
    }

    public JMenuItem getItemRenameDirectory() {
        return this.itemRenameDirectory;
    }

    public JMenuItem getItemDeleteDirectory() {
        return this.itemDeleteDirectory;
    }

    public JMenuItem getItemRefresh() {
        return this.itemRefresh;
    }

    public JMenuItem getItemCollapseAllSubitems() {
        return this.itemCollapseAllSubitems;
    }

    public JMenuItem getItemExpandAllSubitems() {
        return this.itemExpandAllSubitems;
    }

    public JMenuItem getItemOpenInDesktop() {
        return this.itemOpenInDesktop;
    }

    private void init() {
        this.addItems();
        this.setAccelerators();
        this.setItemsEnabled();
        this.listen();
    }

    public boolean isTreeSelected() {
        return this.treeSelected;
    }

    public void setTreeSelected(boolean treeSelected) {
        this.treeSelected = treeSelected;
    }

    private void addItems() {
        this.add(this.itemAddToFavorites);
        this.add(this.itemOpenInDesktop);
        this.add(new JPopupMenu.Separator());
        this.add(this.itemCreateDirectory);
        this.add(this.itemRenameDirectory);
        this.add(this.itemDeleteDirectory);
        this.add(new JPopupMenu.Separator());
        this.add(this.itemExpandAllSubitems);
        this.add(this.itemCollapseAllSubitems);
        this.add(new JPopupMenu.Separator());
        this.add(this.itemRefresh);
    }

    private void setAccelerators() {
        this.itemOpenInDesktop.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(79));
        this.itemCreateDirectory.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(78));
        this.itemDeleteDirectory.setAccelerator(KeyEventUtil.getKeyStroke(127));
        this.itemRenameDirectory.setAccelerator(KeyEventUtil.getKeyStroke(113));
        this.itemRefresh.setAccelerator(KeyEventUtil.getKeyStroke(116));
    }

    private void setItemsEnabled() {
        this.setDeleteDirectoryEnabled();
    }

    private void listen() {
        AnnotationProcessor.process(this);
    }

    @EventSubscriber(eventClass=PreferencesChangedEvent.class)
    public void preferencesChanged(PreferencesChangedEvent e) {
        if ("Preferences.Enable.DeleteDirectories".equals(e.getKey())) {
            this.setDeleteDirectoryEnabled();
        }
    }

    private void setDeleteDirectoryEnabled() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        boolean enabled = prefs != null && prefs.containsKey("Preferences.Enable.DeleteDirectories") ? prefs.getBoolean("Preferences.Enable.DeleteDirectories") : true;
        this.itemDeleteDirectory.setEnabled(enabled);
    }
}

