/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.directories;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.io.TreeFileSystemDirectories;
import org.jphototagger.lib.swing.AllSystemDirectoriesTreeModel;
import org.jphototagger.program.factory.ModelFactory;
import org.jphototagger.program.module.directories.DirectoriesPopupMenu;
import org.jphototagger.program.module.directories.DirectoryController;
import org.jphototagger.program.module.filesystem.FileSystemDirectories;
import org.openide.util.Lookup;

public final class DeleteDirectoryController
extends DirectoryController {
    public DeleteDirectoryController() {
        this.listenToActionsOf(DirectoriesPopupMenu.INSTANCE.getItemDeleteDirectory());
    }

    @Override
    protected boolean myKey(KeyEvent evt) {
        return evt.getKeyCode() == 127;
    }

    @Override
    protected boolean myAction(ActionEvent evt) {
        return evt.getSource() == DirectoriesPopupMenu.INSTANCE.getItemDeleteDirectory();
    }

    @Override
    protected void action(final DefaultMutableTreeNode node) {
        if (!this.isDeleteDirectoriesEnabled()) {
            return;
        }
        File dir = this.getDirOfNode(node);
        if (dir != null && FileSystemDirectories.delete(dir)) {
            EventQueueUtil.invokeInDispatchThread(new Runnable(){

                @Override
                public void run() {
                    TreeFileSystemDirectories.removeFromTreeModel(ModelFactory.INSTANCE.getModel(AllSystemDirectoriesTreeModel.class), node);
                }
            });
        }
    }

    private boolean isDeleteDirectoriesEnabled() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("Preferences.Enable.DeleteDirectories") ? prefs.getBoolean("Preferences.Enable.DeleteDirectories") : true;
    }
}

