/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jdesktop.swingx.JXList;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.storage.Persistence;
import org.jphototagger.domain.programs.Program;
import org.jphototagger.domain.programs.ProgramType;
import org.jphototagger.domain.repository.ActionsAfterRepoUpdatesRepository;
import org.jphototagger.domain.repository.ProgramsRepository;
import org.jphototagger.domain.repository.Repository;
import org.jphototagger.domain.repository.event.programs.ProgramDeletedEvent;
import org.jphototagger.domain.repository.event.programs.ProgramInsertedEvent;
import org.jphototagger.lib.help.HelpPageProvider;
import org.jphototagger.lib.swing.KeyEventUtil;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.actions.ActionsAfterSavesOrUpdatesInRepositoryListModel;
import org.jphototagger.program.module.actions.ActionsDialog;
import org.jphototagger.program.module.actions.ActionsListCellRenderer;
import org.jphototagger.program.module.programs.SelectProgramDialog;
import org.openide.util.Lookup;

public class ActionsSettingsPanel
extends JPanel
implements ListSelectionListener,
Persistence,
HelpPageProvider {
    private static final long serialVersionUID = 1L;
    private final ActionsAfterSavesOrUpdatesInRepositoryListModel model = new ActionsAfterSavesOrUpdatesInRepositoryListModel();
    private final ProgramsRepository programsRepo = Lookup.getDefault().lookup(ProgramsRepository.class);
    private volatile boolean listenToModel = true;
    private final ActionsAfterRepoUpdatesRepository actionsRepo = Lookup.getDefault().lookup(ActionsAfterRepoUpdatesRepository.class);
    private JButton buttonAddAction;
    private JButton buttonDeleteAction;
    private ButtonGroup buttonGroupExecute;
    private JButton buttonMoveDownAction;
    private JButton buttonMoveUpAction;
    private JButton buttonShowActions;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JXList list;
    private JMenuItem menuItemAddAction;
    private JMenuItem menuItemDeleteAction;
    private JMenuItem menuItemMoveDownAction;
    private JMenuItem menuItemMoveUpAction;
    private JMenuItem menuItemShowActions;
    private JPopupMenu popupMenu;
    private JRadioButton radioButtonExecuteAlways;
    private JRadioButton radioButtonExecuteIfImageHasXmp;
    private JScrollPane scrollPane;

    public ActionsSettingsPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.list.getSelectionModel().addListSelectionListener(this);
        MnemonicUtil.setMnemonics(this);
        this.addAccelerators();
        this.setEnabled();
        AnnotationProcessor.process(this);
    }

    private void addAccelerators() {
        this.menuItemAddAction.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(78));
        this.menuItemMoveDownAction.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(40));
        this.menuItemMoveUpAction.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(38));
    }

    private void setEnabled() {
        boolean actionSelected = this.isActionSelected();
        boolean canMoveUp = this.canMoveUp();
        boolean canMoveDown = this.canMoveDown();
        this.setEnabledAddAction();
        this.buttonDeleteAction.setEnabled(actionSelected);
        this.menuItemDeleteAction.setEnabled(actionSelected);
        this.buttonMoveUpAction.setEnabled(canMoveUp);
        this.menuItemMoveUpAction.setEnabled(canMoveUp);
        this.buttonMoveDownAction.setEnabled(canMoveDown);
        this.menuItemMoveDownAction.setEnabled(canMoveDown);
    }

    private void setEnabledAddAction() {
        boolean hasActions = false;
        Repository repo = Lookup.getDefault().lookup(Repository.class);
        if (repo != null && repo.isInit()) {
            hasActions = this.programsRepo.getProgramCount(true) > 0;
        }
        this.buttonAddAction.setEnabled(hasActions);
        this.menuItemAddAction.setEnabled(hasActions);
    }

    private void addAction() {
        SelectProgramDialog dlg = new SelectProgramDialog(ProgramType.ACTION);
        dlg.setVisible(true);
        Program action = dlg.getSelectedProgram();
        if (dlg.isAccepted() && !this.model.contains(action)) {
            this.actionsRepo.saveAction(action, this.model.size());
            this.setEnabled();
        }
    }

    private void moveActionDown() {
        if (this.canMoveDown()) {
            List<Program> actions;
            this.listenToModel = false;
            int selectedIndex = this.list.getSelectedIndex();
            int modelIndex = this.list.convertIndexToModel(selectedIndex);
            if (modelIndex < (actions = this.model.getActions()).size() - 1) {
                Collections.swap(actions, modelIndex, modelIndex + 1);
                this.actionsRepo.setActionOrder(actions, 0);
            }
            this.setEnabled();
            this.listenToModel = true;
        }
    }

    private void moveActionUp() {
        if (this.canMoveUp()) {
            this.listenToModel = false;
            int selectedIndex = this.list.getSelectedIndex();
            int modelIndex = this.list.convertIndexToModel(selectedIndex);
            List<Program> actions = this.model.getActions();
            if (modelIndex > 0) {
                Collections.swap(actions, modelIndex, modelIndex - 1);
                this.actionsRepo.setActionOrder(actions, 0);
            }
            this.setEnabled();
            this.listenToModel = true;
        }
    }

    private void deleteAction() {
        int selectedIndex;
        int modelIndex;
        Program action;
        if (this.isActionSelected() && this.confirmDelete((action = (Program)this.model.get(modelIndex = this.list.convertIndexToModel(selectedIndex = this.list.getSelectedIndex()))).getAlias())) {
            this.actionsRepo.deleteAction(action);
            this.setEnabled();
        }
    }

    private void executeActionsAlways() {
        this.setExecuteActionsAfterImageChangeInDbAlways(this.radioButtonExecuteAlways.isSelected());
    }

    private void setExecuteActionsAfterImageChangeInDbAlways(boolean set) {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.setBoolean("UserSettings.ExecuteActionsAfterImageChangeInDbAlways", set);
        prefs.setBoolean("UserSettings.ExecuteActionsAfterImageChangeInDbIfImageHasXmp", !set);
    }

    private void executeActionsIfXmpExists() {
        this.setExecuteActionsAfterImageChangeInDbIfImageHasXmp(this.radioButtonExecuteIfImageHasXmp.isSelected());
    }

    private void setExecuteActionsAfterImageChangeInDbIfImageHasXmp(boolean set) {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.setBoolean("UserSettings.ExecuteActionsAfterImageChangeInDbAlways", !set);
        prefs.setBoolean("UserSettings.ExecuteActionsAfterImageChangeInDbIfImageHasXmp", set);
    }

    @Override
    public void restore() {
        this.radioButtonExecuteAlways.setSelected(this.isExecuteActionsAfterImageChangeInDbAlways());
        this.radioButtonExecuteIfImageHasXmp.setSelected(this.isExecuteActionsAfterImageChangeInDbIfImageHasXmp());
    }

    private boolean isExecuteActionsAfterImageChangeInDbIfImageHasXmp() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.ExecuteActionsAfterImageChangeInDbIfImageHasXmp") ? prefs.getBoolean("UserSettings.ExecuteActionsAfterImageChangeInDbIfImageHasXmp") : false;
    }

    private boolean isExecuteActionsAfterImageChangeInDbAlways() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.ExecuteActionsAfterImageChangeInDbAlways") ? prefs.getBoolean("UserSettings.ExecuteActionsAfterImageChangeInDbAlways") : false;
    }

    @Override
    public void persist() {
    }

    private void showActions() {
        ComponentUtil.show(ActionsDialog.INSTANCE);
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            this.setEnabled();
        }
    }

    private boolean confirmDelete(String actionName) {
        String message = Bundle.getString(ActionsSettingsPanel.class, "ActionsPanel.Confirm.RemoveAction", actionName);
        return MessageDisplayer.confirmYesNo(this, message);
    }

    private boolean canMoveDown() {
        int selectedIndex = this.list.getSelectedIndex();
        int modelIndex = this.list.convertIndexToModel(selectedIndex);
        return modelIndex < this.model.getSize() - 1 && selectedIndex >= 0;
    }

    private boolean canMoveUp() {
        return this.list.getSelectedIndex() > 0;
    }

    private boolean isActionSelected() {
        return this.list.getSelectedIndex() >= 0;
    }

    private void handleListKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.deleteAction();
        } else if (KeyEventUtil.isMenuShortcut(evt, 78)) {
            this.addAction();
        } else if (KeyEventUtil.isMenuShortcut(evt, 40)) {
            this.moveActionDown();
        } else if (KeyEventUtil.isMenuShortcut(evt, 38)) {
            this.moveActionUp();
        }
    }

    @EventSubscriber(eventClass=ProgramInsertedEvent.class)
    public void programInserted(ProgramInsertedEvent evt) {
        Program program = evt.getProgram();
        if (program.isAction()) {
            this.setEnabledAddAction();
        }
    }

    @EventSubscriber(eventClass=ProgramDeletedEvent.class)
    public void programDeleted(ProgramDeletedEvent evt) {
        Program program = evt.getProgram();
        if (program.isAction()) {
            this.setEnabledAddAction();
        }
    }

    @Override
    public String getHelpPageUrl() {
        return Bundle.getString(ActionsSettingsPanel.class, "ActionsSettingsPanel.HelpPage", new Object[0]);
    }

    private void initComponents() {
        this.buttonGroupExecute = new ButtonGroup();
        this.popupMenu = new JPopupMenu();
        this.menuItemAddAction = new JMenuItem();
        this.menuItemDeleteAction = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.menuItemMoveUpAction = new JMenuItem();
        this.menuItemMoveDownAction = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.menuItemShowActions = new JMenuItem();
        this.scrollPane = new JScrollPane();
        this.list = new JXList();
        this.buttonMoveUpAction = new JButton();
        this.buttonMoveDownAction = new JButton();
        this.buttonAddAction = new JButton();
        this.buttonDeleteAction = new JButton();
        this.buttonShowActions = new JButton();
        this.radioButtonExecuteAlways = new JRadioButton();
        this.radioButtonExecuteIfImageHasXmp = new JRadioButton();
        this.popupMenu.setName("popupMenu");
        this.menuItemAddAction.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_new.png")));
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/actions/Bundle");
        this.menuItemAddAction.setText(bundle.getString("ActionsSettingsPanel.menuItemAddAction.text"));
        this.menuItemAddAction.setEnabled(false);
        this.menuItemAddAction.setName("menuItemAddAction");
        this.menuItemAddAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionsSettingsPanel.this.menuItemAddActionActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.menuItemAddAction);
        this.menuItemDeleteAction.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.menuItemDeleteAction.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_delete.png")));
        this.menuItemDeleteAction.setText(bundle.getString("ActionsSettingsPanel.menuItemDeleteAction.text"));
        this.menuItemDeleteAction.setEnabled(false);
        this.menuItemDeleteAction.setName("menuItemDeleteAction");
        this.menuItemDeleteAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionsSettingsPanel.this.menuItemDeleteActionActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.menuItemDeleteAction);
        this.jSeparator1.setName("jSeparator1");
        this.popupMenu.add(this.jSeparator1);
        this.menuItemMoveUpAction.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_arrow_up.png")));
        this.menuItemMoveUpAction.setText(bundle.getString("ActionsSettingsPanel.menuItemMoveUpAction.text"));
        this.menuItemMoveUpAction.setEnabled(false);
        this.menuItemMoveUpAction.setName("menuItemMoveUpAction");
        this.menuItemMoveUpAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionsSettingsPanel.this.menuItemMoveUpActionActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.menuItemMoveUpAction);
        this.menuItemMoveDownAction.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_arrow_down.png")));
        this.menuItemMoveDownAction.setText(bundle.getString("ActionsSettingsPanel.menuItemMoveDownAction.text"));
        this.menuItemMoveDownAction.setEnabled(false);
        this.menuItemMoveDownAction.setName("menuItemMoveDownAction");
        this.menuItemMoveDownAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionsSettingsPanel.this.menuItemMoveDownActionActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.menuItemMoveDownAction);
        this.jSeparator2.setName("jSeparator2");
        this.popupMenu.add(this.jSeparator2);
        this.menuItemShowActions.setText(bundle.getString("ActionsSettingsPanel.menuItemShowActions.text"));
        this.menuItemShowActions.setName("menuItemShowActions");
        this.menuItemShowActions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionsSettingsPanel.this.menuItemShowActionsActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.menuItemShowActions);
        this.setBorder(BorderFactory.createTitledBorder(bundle.getString("ActionsSettingsPanel.border.title")));
        this.setName("Form");
        this.scrollPane.setName("scrollPane");
        this.list.setModel((ListModel)this.model);
        this.list.setSelectionMode(0);
        this.list.setCellRenderer((ListCellRenderer)new ActionsListCellRenderer());
        this.list.setComponentPopupMenu(this.popupMenu);
        this.list.setName("list");
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ActionsSettingsPanel.this.listKeyPressed(evt);
            }
        });
        this.scrollPane.setViewportView(this.list);
        this.buttonMoveUpAction.setText(bundle.getString("ActionsSettingsPanel.buttonMoveUpAction.text"));
        this.buttonMoveUpAction.setEnabled(false);
        this.buttonMoveUpAction.setName("buttonMoveUpAction");
        this.buttonMoveUpAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionsSettingsPanel.this.buttonMoveUpActionActionPerformed(evt);
            }
        });
        this.buttonMoveDownAction.setText(bundle.getString("ActionsSettingsPanel.buttonMoveDownAction.text"));
        this.buttonMoveDownAction.setEnabled(false);
        this.buttonMoveDownAction.setName("buttonMoveDownAction");
        this.buttonMoveDownAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionsSettingsPanel.this.buttonMoveDownActionActionPerformed(evt);
            }
        });
        this.buttonAddAction.setText(bundle.getString("ActionsSettingsPanel.buttonAddAction.text"));
        this.buttonAddAction.setEnabled(false);
        this.buttonAddAction.setName("buttonAddAction");
        this.buttonAddAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionsSettingsPanel.this.buttonAddActionActionPerformed(evt);
            }
        });
        this.buttonDeleteAction.setText(bundle.getString("ActionsSettingsPanel.buttonDeleteAction.text"));
        this.buttonDeleteAction.setEnabled(false);
        this.buttonDeleteAction.setName("buttonDeleteAction");
        this.buttonDeleteAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionsSettingsPanel.this.buttonDeleteActionActionPerformed(evt);
            }
        });
        this.buttonShowActions.setText(bundle.getString("ActionsSettingsPanel.buttonShowActions.text"));
        this.buttonShowActions.setName("buttonShowActions");
        this.buttonShowActions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionsSettingsPanel.this.buttonShowActionsActionPerformed(evt);
            }
        });
        this.buttonGroupExecute.add(this.radioButtonExecuteAlways);
        this.radioButtonExecuteAlways.setText(bundle.getString("ActionsSettingsPanel.radioButtonExecuteAlways.text"));
        this.radioButtonExecuteAlways.setName("radioButtonExecuteAlways");
        this.radioButtonExecuteAlways.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionsSettingsPanel.this.radioButtonExecuteAlwaysActionPerformed(evt);
            }
        });
        this.buttonGroupExecute.add(this.radioButtonExecuteIfImageHasXmp);
        this.radioButtonExecuteIfImageHasXmp.setText(bundle.getString("ActionsSettingsPanel.radioButtonExecuteIfImageHasXmp.text"));
        this.radioButtonExecuteIfImageHasXmp.setName("radioButtonExecuteIfImageHasXmp");
        this.radioButtonExecuteIfImageHasXmp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionsSettingsPanel.this.radioButtonExecuteIfImageHasXmpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.radioButtonExecuteIfImageHasXmp).addContainerGap()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.radioButtonExecuteAlways).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.scrollPane, -1, 227, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buttonDeleteAction).addComponent(this.buttonMoveUpAction).addComponent(this.buttonMoveDownAction).addComponent(this.buttonAddAction)).addComponent(this.buttonShowActions, GroupLayout.Alignment.TRAILING)).addGap(12, 12, 12))))));
        layout.linkSize(0, this.buttonAddAction, this.buttonDeleteAction, this.buttonMoveDownAction, this.buttonMoveUpAction, this.buttonShowActions);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.buttonMoveUpAction).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonMoveDownAction).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonAddAction).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonDeleteAction).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonShowActions).addGap(8, 8, 8)).addGroup(layout.createSequentialGroup().addComponent(this.scrollPane, -1, 161, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addComponent(this.radioButtonExecuteAlways).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonExecuteIfImageHasXmp).addContainerGap()));
    }

    private void buttonShowActionsActionPerformed(ActionEvent evt) {
        this.showActions();
        ComponentUtil.parentWindowToFront(this);
    }

    private void buttonMoveUpActionActionPerformed(ActionEvent evt) {
        this.moveActionUp();
    }

    private void buttonMoveDownActionActionPerformed(ActionEvent evt) {
        this.moveActionDown();
    }

    private void buttonDeleteActionActionPerformed(ActionEvent evt) {
        this.deleteAction();
    }

    private void buttonAddActionActionPerformed(ActionEvent evt) {
        this.addAction();
        ComponentUtil.parentWindowToFront(this);
    }

    private void radioButtonExecuteAlwaysActionPerformed(ActionEvent evt) {
        this.executeActionsAlways();
    }

    private void radioButtonExecuteIfImageHasXmpActionPerformed(ActionEvent evt) {
        this.executeActionsIfXmpExists();
    }

    private void menuItemAddActionActionPerformed(ActionEvent evt) {
        this.addAction();
    }

    private void menuItemDeleteActionActionPerformed(ActionEvent evt) {
        this.deleteAction();
    }

    private void menuItemMoveUpActionActionPerformed(ActionEvent evt) {
        this.moveActionUp();
    }

    private void menuItemMoveDownActionActionPerformed(ActionEvent evt) {
        this.moveActionDown();
    }

    private void listKeyPressed(KeyEvent evt) {
        this.handleListKeyPressed(evt);
    }

    private void menuItemShowActionsActionPerformed(ActionEvent evt) {
        this.showActions();
    }
}

