/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.DropMode;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.swingx.JXList;
import org.jphototagger.domain.event.listener.ListenerSupport;
import org.jphototagger.domain.programs.Program;
import org.jphototagger.domain.programs.ProgramExecutor;
import org.jphototagger.domain.programs.ProgramType;
import org.jphototagger.domain.repository.ActionsAfterRepoUpdatesRepository;
import org.jphototagger.domain.repository.ProgramsRepository;
import org.jphototagger.lib.swing.KeyEventUtil;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.MouseEventUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.datatransfer.ReorderListItemsTransferHandler;
import org.jphototagger.program.module.actions.ActionsDialog;
import org.jphototagger.program.module.actions.ActionsListCellRenderer;
import org.jphototagger.program.module.programs.ProgramExecutorImpl;
import org.jphototagger.program.module.programs.ProgramPropertiesDialog;
import org.jphototagger.program.module.programs.ProgramsListModel;
import org.jphototagger.program.module.programs.ProgramsUtil;
import org.openide.util.Lookup;

public final class ActionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final ProgramsListModel model = new ProgramsListModel(ProgramType.ACTION);
    private final ListenerSupport<ProgramExecutor> ls = new ListenerSupport();
    private final ProgramsUtil.ReorderListener reorderListener = new ProgramsUtil.ReorderListener(this.model);
    private final ActionsAfterRepoUpdatesRepository actionsAfterRepoUpdatesRepo = Lookup.getDefault().lookup(ActionsAfterRepoUpdatesRepository.class);
    private final ProgramsRepository programsRepo = Lookup.getDefault().lookup(ProgramsRepository.class);
    private JButton buttonCreate;
    private JButton buttonDelete;
    private JButton buttonEdit;
    private JButton buttonExecute;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JLabel labelActionList;
    private JXList list;
    private JMenuItem menuItemCreate;
    private JMenuItem menuItemDelete;
    private JMenuItem menuItemEdit;
    private JMenuItem menuItemExecute;
    private JMenuItem menuItemMoveActionDown;
    private JMenuItem menuItemMoveActionUp;
    private JPanel panelButtons;
    private JPopupMenu popupMenu;
    private JScrollPane scrollPane;

    public ActionsPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        MnemonicUtil.setMnemonics(this);
        this.setAccelerators();
        this.selectFirstItem();
        this.addListener(new ProgramExecutorImpl(true));
    }

    private void selectFirstItem() {
        if (this.list.getModel().getSize() > 0) {
            this.list.setSelectedIndex(0);
        }
    }

    private void setAccelerators() {
        this.menuItemCreate.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(78));
        this.menuItemEdit.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(69));
        this.menuItemMoveActionDown.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(40));
        this.menuItemMoveActionUp.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(38));
    }

    public void setEnabled() {
        int selectedIndex = this.list.getSelectedIndex();
        int size = this.list.getModel().getSize();
        boolean isActionSelected = selectedIndex >= 0;
        boolean canMoveDown = isActionSelected && selectedIndex < size - 1;
        boolean canMoveUp = isActionSelected && selectedIndex > 0;
        this.buttonDelete.setEnabled(isActionSelected);
        this.menuItemDelete.setEnabled(isActionSelected);
        this.buttonEdit.setEnabled(isActionSelected);
        this.menuItemEdit.setEnabled(isActionSelected);
        this.buttonExecute.setEnabled(isActionSelected);
        this.menuItemExecute.setEnabled(isActionSelected);
        this.menuItemMoveActionDown.setEnabled(canMoveDown);
        this.menuItemMoveActionUp.setEnabled(canMoveUp);
    }

    private Program getSelectedAction() {
        return (Program)this.list.getSelectedValue();
    }

    private void executeAction() {
        if (this.list.getSelectedIndex() >= 0) {
            this.notifyProgramExecuted(this.getSelectedAction());
        }
    }

    private void createAction() {
        Program program;
        ProgramPropertiesDialog dlg = new ProgramPropertiesDialog(true);
        this.setActionsAlwaysDialogOnTop(false);
        dlg.toFront();
        dlg.setVisible(true);
        this.setActionsAlwaysDialogOnTop(true);
        if (dlg.isAccepted() && this.programsRepo.saveProgram(program = dlg.getProgram())) {
            this.selectLastListItem();
        }
        this.setEnabled();
        this.list.requestFocusInWindow();
    }

    private void selectLastListItem() {
        int size = this.list.getModel().getSize();
        if (size > 0) {
            this.list.setSelectedIndex(size - 1);
        }
    }

    private void editAction() {
        if (this.list.getSelectedIndex() >= 0) {
            Program program = this.getSelectedAction();
            ProgramPropertiesDialog dlg = new ProgramPropertiesDialog(true);
            dlg.setProgram(program);
            this.setActionsAlwaysDialogOnTop(false);
            dlg.toFront();
            dlg.setVisible(true);
            this.setActionsAlwaysDialogOnTop(true);
            if (dlg.isAccepted()) {
                this.programsRepo.updateProgram(program);
            }
        }
        this.setEnabled();
        this.list.requestFocusInWindow();
    }

    private void setActionsAlwaysDialogOnTop(boolean onTop) {
        if (ActionsDialog.INSTANCE.isAncestorOf(this)) {
            ActionsDialog.INSTANCE.setAlwaysOnTop(onTop);
            if (onTop) {
                ActionsDialog.INSTANCE.toFront();
                ActionsDialog.INSTANCE.requestFocusInWindow();
            }
        }
    }

    private void handleListKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.executeAction();
        } else if (evt.getKeyCode() == 127) {
            this.deleteAction();
        } else if (KeyEventUtil.isMenuShortcut(evt, 69)) {
            this.editAction();
        } else if (KeyEventUtil.isMenuShortcut(evt, 78)) {
            this.createAction();
        } else if (KeyEventUtil.isMenuShortcut(evt, 40)) {
            this.moveActionDown();
        } else if (KeyEventUtil.isMenuShortcut(evt, 38)) {
            this.moveActionUp();
        }
    }

    private void handleListMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1) {
            if (evt.getClickCount() == 1) {
                this.setEnabled();
            } else if (MouseEventUtil.isDoubleClick(evt)) {
                this.executeAction();
            }
        }
    }

    private void deleteAction() {
        if (this.list.getSelectedIndex() >= 0) {
            Program program = this.getSelectedAction();
            if (this.confirmDelete(program)) {
                this.programsRepo.deleteProgram(program);
            }
            this.setEnabled();
            this.list.requestFocusInWindow();
        }
    }

    private boolean confirmDelete(Program program) {
        String programName = program.getAlias();
        boolean existsInActionsAfterRepoUpdates = this.actionsAfterRepoUpdatesRepo.existsAction(program);
        String messageExistsInOtherDb = Bundle.getString(ActionsPanel.class, "ActionsPanel.Confirm.Delete.ExistsInOtherDb", programName);
        String messageExists = Bundle.getString(ActionsPanel.class, "ActionsPanel.Confirm.Delete", programName);
        return existsInActionsAfterRepoUpdates ? MessageDisplayer.confirmYesNo(this, messageExistsInOtherDb) : MessageDisplayer.confirmYesNo(this, messageExists);
    }

    public synchronized void addListener(ProgramExecutor l) {
        if (l == null) {
            throw new NullPointerException("l == null");
        }
        this.ls.add(l);
    }

    private synchronized void notifyProgramExecuted(Program program) {
        for (ProgramExecutor listener : this.ls.get()) {
            listener.execute(program);
        }
    }

    private void moveActionDown() {
        this.reorderListener.setListenToModel(false);
        ProgramsUtil.moveProgramDown(this.list);
        this.reorderListener.setListenToModel(true);
    }

    private void moveActionUp() {
        this.reorderListener.setListenToModel(false);
        ProgramsUtil.moveProgramUp(this.list);
        this.reorderListener.setListenToModel(true);
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.menuItemExecute = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.menuItemCreate = new JMenuItem();
        this.menuItemEdit = new JMenuItem();
        this.menuItemDelete = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.menuItemMoveActionUp = new JMenuItem();
        this.menuItemMoveActionDown = new JMenuItem();
        this.labelActionList = new JLabel();
        this.scrollPane = new JScrollPane();
        this.list = new JXList();
        this.panelButtons = new JPanel();
        this.buttonDelete = new JButton();
        this.buttonEdit = new JButton();
        this.buttonCreate = new JButton();
        this.buttonExecute = new JButton();
        this.popupMenu.setName("popupMenu");
        this.menuItemExecute.setAccelerator(KeyStroke.getKeyStroke(10, 0));
        this.menuItemExecute.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_action.png")));
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/actions/Bundle");
        this.menuItemExecute.setText(bundle.getString("ActionsPanel.menuItemExecute.text"));
        this.menuItemExecute.setName("menuItemExecute");
        this.menuItemExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionsPanel.this.menuItemExecuteActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.menuItemExecute);
        this.jSeparator1.setName("jSeparator1");
        this.popupMenu.add(this.jSeparator1);
        this.menuItemCreate.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_new.png")));
        this.menuItemCreate.setText(bundle.getString("ActionsPanel.menuItemCreate.text"));
        this.menuItemCreate.setName("menuItemCreate");
        this.menuItemCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionsPanel.this.menuItemCreateActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.menuItemCreate);
        this.menuItemEdit.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_edit.png")));
        this.menuItemEdit.setText(bundle.getString("ActionsPanel.menuItemEdit.text"));
        this.menuItemEdit.setName("menuItemEdit");
        this.menuItemEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionsPanel.this.menuItemEditActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.menuItemEdit);
        this.menuItemDelete.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.menuItemDelete.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_delete.png")));
        this.menuItemDelete.setText(bundle.getString("ActionsPanel.menuItemDelete.text"));
        this.menuItemDelete.setName("menuItemDelete");
        this.menuItemDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionsPanel.this.menuItemDeleteActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.menuItemDelete);
        this.jSeparator2.setName("jSeparator2");
        this.popupMenu.add(this.jSeparator2);
        this.menuItemMoveActionUp.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_arrow_up.png")));
        this.menuItemMoveActionUp.setText(bundle.getString("ActionsPanel.menuItemMoveActionUp.text"));
        this.menuItemMoveActionUp.setName("menuItemMoveActionUp");
        this.menuItemMoveActionUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionsPanel.this.menuItemMoveActionUpActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.menuItemMoveActionUp);
        this.menuItemMoveActionDown.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_arrow_down.png")));
        this.menuItemMoveActionDown.setText(bundle.getString("ActionsPanel.menuItemMoveActionDown.text"));
        this.menuItemMoveActionDown.setName("menuItemMoveActionDown");
        this.menuItemMoveActionDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionsPanel.this.menuItemMoveActionDownActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.menuItemMoveActionDown);
        this.setFocusable(false);
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.labelActionList.setLabelFor(this.list);
        this.labelActionList.setText(bundle.getString("ActionsPanel.labelActionList.text"));
        this.labelActionList.setName("labelActionList");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.labelActionList, gridBagConstraints);
        this.scrollPane.setFocusable(false);
        this.scrollPane.setName("scrollPane");
        this.list.setModel((ListModel)this.model);
        this.list.setSelectionMode(0);
        this.list.setCellRenderer((ListCellRenderer)new ActionsListCellRenderer());
        this.list.setComponentPopupMenu(this.popupMenu);
        this.list.setDragEnabled(true);
        this.list.setDropMode(DropMode.INSERT);
        this.list.setName("list");
        this.list.setTransferHandler(new ReorderListItemsTransferHandler(this.list));
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ActionsPanel.this.listMouseClicked(evt);
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ActionsPanel.this.listValueChanged(evt);
            }
        });
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ActionsPanel.this.listKeyPressed(evt);
            }
        });
        this.scrollPane.setViewportView(this.list);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.scrollPane, gridBagConstraints);
        this.panelButtons.setName("panelButtons");
        this.buttonDelete.setText(bundle.getString("ActionsPanel.buttonDelete.text"));
        this.buttonDelete.setToolTipText(bundle.getString("ActionsPanel.buttonDelete.toolTipText"));
        this.buttonDelete.setEnabled(false);
        this.buttonDelete.setName("buttonDelete");
        this.buttonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionsPanel.this.buttonDeleteActionPerformed(evt);
            }
        });
        this.buttonEdit.setText(bundle.getString("ActionsPanel.buttonEdit.text"));
        this.buttonEdit.setToolTipText(bundle.getString("ActionsPanel.buttonEdit.toolTipText"));
        this.buttonEdit.setEnabled(false);
        this.buttonEdit.setName("buttonEdit");
        this.buttonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionsPanel.this.buttonEditActionPerformed(evt);
            }
        });
        this.buttonCreate.setText(bundle.getString("ActionsPanel.buttonCreate.text"));
        this.buttonCreate.setToolTipText(bundle.getString("ActionsPanel.buttonCreate.toolTipText"));
        this.buttonCreate.setName("buttonCreate");
        this.buttonCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionsPanel.this.buttonCreateActionPerformed(evt);
            }
        });
        this.buttonExecute.setText(bundle.getString("ActionsPanel.buttonExecute.text"));
        this.buttonExecute.setToolTipText(bundle.getString("ActionsPanel.buttonExecute.toolTipText"));
        this.buttonExecute.setEnabled(false);
        this.buttonExecute.setName("buttonExecute");
        this.buttonExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionsPanel.this.buttonExecuteActionPerformed(evt);
            }
        });
        GroupLayout panelButtonsLayout = new GroupLayout(this.panelButtons);
        this.panelButtons.setLayout(panelButtonsLayout);
        panelButtonsLayout.setHorizontalGroup(panelButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelButtonsLayout.createSequentialGroup().addComponent(this.buttonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCreate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonExecute)));
        panelButtonsLayout.setVerticalGroup(panelButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelButtonsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonExecute).addComponent(this.buttonCreate).addComponent(this.buttonEdit).addComponent(this.buttonDelete)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 3, 5);
        this.add((Component)this.panelButtons, gridBagConstraints);
    }

    private void listValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            this.setEnabled();
        }
    }

    private void listMouseClicked(MouseEvent evt) {
        this.handleListMouseClicked(evt);
    }

    private void buttonDeleteActionPerformed(ActionEvent evt) {
        this.deleteAction();
    }

    private void buttonEditActionPerformed(ActionEvent evt) {
        this.editAction();
    }

    private void buttonCreateActionPerformed(ActionEvent evt) {
        this.createAction();
    }

    private void buttonExecuteActionPerformed(ActionEvent evt) {
        this.executeAction();
    }

    private void menuItemExecuteActionPerformed(ActionEvent evt) {
        this.executeAction();
    }

    private void menuItemEditActionPerformed(ActionEvent evt) {
        this.editAction();
    }

    private void menuItemCreateActionPerformed(ActionEvent evt) {
        this.createAction();
    }

    private void menuItemDeleteActionPerformed(ActionEvent evt) {
        this.deleteAction();
    }

    private void listKeyPressed(KeyEvent evt) {
        this.handleListKeyPressed(evt);
    }

    private void menuItemMoveActionUpActionPerformed(ActionEvent evt) {
        this.moveActionUp();
    }

    private void menuItemMoveActionDownActionPerformed(ActionEvent evt) {
        this.moveActionDown();
    }
}

