/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.actions;

import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.domain.programs.Program;
import org.jphototagger.domain.repository.ActionsAfterRepoUpdatesRepository;
import org.jphototagger.domain.repository.Repository;
import org.jphototagger.domain.repository.event.programs.ProgramDeletedEvent;
import org.jphototagger.domain.repository.event.programs.ProgramUpdatedEvent;
import org.jphototagger.domain.repository.event.repoupdates.ActionAfterRepoUpdateDeletedEvent;
import org.jphototagger.domain.repository.event.repoupdates.ActionAfterRepoUpdateInsertedEvent;
import org.jphototagger.domain.repository.event.repoupdates.ActionsAfterRepoUpdateReorderedEvent;
import org.openide.util.Lookup;

public final class ActionsAfterSavesOrUpdatesInRepositoryListModel
extends DefaultListModel<Object> {
    private static final long serialVersionUID = 1L;
    private final ActionsAfterRepoUpdatesRepository actionsRepo = Lookup.getDefault().lookup(ActionsAfterRepoUpdatesRepository.class);

    public ActionsAfterSavesOrUpdatesInRepositoryListModel() {
        this.addElements();
        this.listen();
    }

    private void addElements() {
        Repository repo = Lookup.getDefault().lookup(Repository.class);
        if (repo == null || !repo.isInit()) {
            return;
        }
        List<Program> actions = this.actionsRepo.findAllActions();
        for (Program action : actions) {
            this.addElement(action);
        }
    }

    private void listen() {
        AnnotationProcessor.process(this);
    }

    @EventSubscriber(eventClass=ActionAfterRepoUpdateInsertedEvent.class)
    public void actionInserted(ActionAfterRepoUpdateInsertedEvent event) {
        Program action = event.getAction();
        this.addElement(action);
    }

    @EventSubscriber(eventClass=ActionAfterRepoUpdateDeletedEvent.class)
    public void actionDeleted(ActionAfterRepoUpdateDeletedEvent event) {
        Program action = event.getAction();
        this.removeElement(action);
    }

    @EventSubscriber(eventClass=ActionsAfterRepoUpdateReorderedEvent.class)
    public void actionsReordered(ActionsAfterRepoUpdateReorderedEvent evt) {
        this.removeAllElements();
        this.addElements();
    }

    public List<Program> getActions() {
        Object[] array = this.toArray();
        ArrayList<Program> actions = new ArrayList<Program>(array.length);
        for (Object o : array) {
            actions.add((Program)o);
        }
        return actions;
    }

    private void updateProgram(Program program) {
        int index = this.indexOf(program);
        if (index >= 0) {
            this.set(index, program);
            this.fireContentsChanged(this, index, index);
        }
    }

    private void deleteProgram(Program program) {
        int index = this.indexOf(program);
        if (index >= 0) {
            this.removeElementAt(index);
        }
    }

    @EventSubscriber(eventClass=ProgramDeletedEvent.class)
    public void programDeleted(ProgramDeletedEvent evt) {
        this.deleteProgram(evt.getProgram());
    }

    @EventSubscriber(eventClass=ProgramUpdatedEvent.class)
    public void programUpdated(ProgramUpdatedEvent evt) {
        this.updateProgram(evt.getProgram());
    }
}

