/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.misc;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.swingx.JXList;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.storage.Persistence;
import org.jphototagger.domain.repository.AutoscanDirectoriesRepository;
import org.jphototagger.lib.help.HelpPageProvider;
import org.jphototagger.lib.swing.DirectoryChooser;
import org.jphototagger.lib.swing.FileSystemListCellRenderer;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.SelectRootFilesPanel;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.misc.AutoscanDirectoriesListModel;
import org.jphototagger.program.resource.GUI;
import org.jphototagger.program.tasks.ScheduledTasks;
import org.openide.util.Lookup;

public final class ScheduledTasksSettingsPanel
extends JPanel
implements Persistence,
HelpPageProvider {
    private static final long serialVersionUID = 1L;
    private static final String KEY_LAST_SELECTED_AUTOSCAN_DIRECTORY = "UserSettingsDialog.keyLastSelectedAutoscanDirectory";
    private AutoscanDirectoriesListModel modelAutoscanDirectories = new AutoscanDirectoriesListModel();
    private String lastSelectedAutoscanDirectory = "";
    private final AutoscanDirectoriesRepository repo = Lookup.getDefault().lookup(AutoscanDirectoriesRepository.class);
    private JButton buttonAddAutoscanDirectories;
    private JButton buttonRemoveAutoscanDirectories;
    private JButton buttonScheduledTasks;
    private JCheckBox checkBoxIsAutoscanIncludeSubdirectories;
    private JLabel labelAutoscanDirectoriesInfo;
    private JLabel labelAutoscanDirectoriesPrompt;
    private JLabel labelTasksMinutesToStartScheduledTasks;
    private JXList listAutoscanDirectories;
    private JPanel panelTasksAutoscan;
    private JScrollPane scrollPaneListAutoscanDirectories;
    private JSpinner spinnerMinutesToStartScheduledTasks;

    public ScheduledTasksSettingsPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.modelAutoscanDirectories = new AutoscanDirectoriesListModel();
        this.listAutoscanDirectories.setModel((ListModel)this.modelAutoscanDirectories);
        MnemonicUtil.setMnemonics(this);
        this.setEnabled();
    }

    public void setEnabled() {
        this.buttonRemoveAutoscanDirectories.setEnabled(this.listAutoscanDirectories.getSelectedIndex() >= 0);
        this.setEnabledCheckBoxSubdirs();
    }

    @Override
    public void restore() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        this.spinnerMinutesToStartScheduledTasks.setValue(ScheduledTasks.getMinutesToStartScheduledTasks());
        this.checkBoxIsAutoscanIncludeSubdirectories.setSelected(this.isAutoscanIncludeSubdirectories());
        this.lastSelectedAutoscanDirectory = prefs.getString(KEY_LAST_SELECTED_AUTOSCAN_DIRECTORY);
        this.setEnabledCheckBoxSubdirs();
    }

    private boolean isAutoscanIncludeSubdirectories() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.IsAutoscanIncludeSubdirectories") ? prefs.getBoolean("UserSettings.IsAutoscanIncludeSubdirectories") : true;
    }

    private void setEnabledCheckBoxSubdirs() {
        boolean hasDirs = this.listAutoscanDirectories.getModel().getSize() > 0;
        this.checkBoxIsAutoscanIncludeSubdirectories.setEnabled(hasDirs);
    }

    @Override
    public void persist() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.setString(KEY_LAST_SELECTED_AUTOSCAN_DIRECTORY, this.lastSelectedAutoscanDirectory);
    }

    private void addAutoscanDirectories() {
        DirectoryChooser.Option showHiddenDirs = this.getDirChooserOptionShowHiddenDirs();
        List<File> hideRootFiles = SelectRootFilesPanel.readPersistentRootFiles("UserSettings.HideRootFilesFromDirectoriesTab");
        DirectoryChooser dlg = new DirectoryChooser((Frame)GUI.getAppFrame(), new File(this.lastSelectedAutoscanDirectory), hideRootFiles, showHiddenDirs);
        dlg.setPreferencesKey("ScheduledTasksSettingsPanel.DirChooser");
        dlg.setVisible(true);
        ComponentUtil.parentWindowToFront(this);
        if (dlg.isAccepted()) {
            List<File> directories = dlg.getSelectedDirectories();
            for (File directory : directories) {
                if (this.modelAutoscanDirectories.contains(directory)) continue;
                this.lastSelectedAutoscanDirectory = directory.getAbsolutePath();
                if (this.repo.existsAutoscanDirectory(directory) || this.repo.saveAutoscanDirectory(directory)) continue;
                this.errorMessageInsertAutoscanDirectory(directory);
            }
        }
        this.setEnabled();
    }

    private DirectoryChooser.Option getDirChooserOptionShowHiddenDirs() {
        return this.isAcceptHiddenDirectories() ? DirectoryChooser.Option.DISPLAY_HIDDEN_DIRECTORIES : DirectoryChooser.Option.NO_OPTION;
    }

    private boolean isAcceptHiddenDirectories() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.IsAcceptHiddenDirectories") ? prefs.getBoolean("UserSettings.IsAcceptHiddenDirectories") : false;
    }

    private void removeSelectedAutoscanDirectories() {
        List values = this.listAutoscanDirectories.getSelectedValuesList();
        for (int i = 0; i < values.size(); ++i) {
            File directory = (File)values.get(i);
            if (!this.repo.existsAutoscanDirectory(directory) || this.repo.deleteAutoscanDirectory(directory)) continue;
            this.errorMessageDeleteAutoscanDirectory(directory);
        }
        this.setEnabled();
    }

    private void errorMessageInsertAutoscanDirectory(File directory) {
        String message = Bundle.getString(ScheduledTasksSettingsPanel.class, "ScheduledTasksSettingsPanel.Error.InsertAutoscanDirectory", directory);
        MessageDisplayer.error(this, message);
    }

    private void errorMessageDeleteAutoscanDirectory(File directory) {
        String message = Bundle.getString(ScheduledTasksSettingsPanel.class, "ScheduledTasksSettingsPanel.Error.DeleteAutoscanDirectory", directory);
        MessageDisplayer.error(this, message);
    }

    private void handleKeyEventListTasksAutoscanDirectories(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.removeSelectedAutoscanDirectories();
        }
    }

    private void handleStateChangedSpinnerMinutesToStartScheduledTasks() {
        this.setMinutesToStartScheduledTasks((Integer)this.spinnerMinutesToStartScheduledTasks.getValue());
    }

    private void setMinutesToStartScheduledTasks(int minutes) {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.setString("UserSettings.MinutesToStartScheduledTasks", Integer.toString(minutes));
    }

    private void handleActionCheckBoxIsAutoscanIncludeSubdirectories() {
        this.setAutoscanIncludeSubdirectories(this.checkBoxIsAutoscanIncludeSubdirectories.isSelected());
    }

    private void setAutoscanIncludeSubdirectories(boolean include) {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.setBoolean("UserSettings.IsAutoscanIncludeSubdirectories", include);
    }

    private void setEnabledButtonRemoveAutoscanDirectory() {
        this.buttonRemoveAutoscanDirectories.setEnabled(this.listAutoscanDirectories.getSelectedIndices().length > 0);
    }

    public JButton getButtonScheduledTasks() {
        return this.buttonScheduledTasks;
    }

    @Override
    public String getHelpPageUrl() {
        return Bundle.getString(ScheduledTasksSettingsPanel.class, "ScheduledTasksSettingsPanel.HelpPage", new Object[0]);
    }

    private void initComponents() {
        this.panelTasksAutoscan = new JPanel();
        this.labelAutoscanDirectoriesInfo = new JLabel();
        this.labelAutoscanDirectoriesPrompt = new JLabel();
        this.scrollPaneListAutoscanDirectories = new JScrollPane();
        this.listAutoscanDirectories = new JXList();
        this.checkBoxIsAutoscanIncludeSubdirectories = new JCheckBox();
        this.buttonRemoveAutoscanDirectories = new JButton();
        this.buttonAddAutoscanDirectories = new JButton();
        this.buttonScheduledTasks = new JButton();
        this.labelTasksMinutesToStartScheduledTasks = new JLabel();
        this.spinnerMinutesToStartScheduledTasks = new JSpinner();
        this.setName("Form");
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/misc/Bundle");
        this.panelTasksAutoscan.setBorder(BorderFactory.createTitledBorder(bundle.getString("ScheduledTasksSettingsPanel.panelTasksAutoscan.border.title")));
        this.panelTasksAutoscan.setName("panelTasksAutoscan");
        this.panelTasksAutoscan.setLayout(new GridBagLayout());
        this.labelAutoscanDirectoriesInfo.setText(bundle.getString("ScheduledTasksSettingsPanel.labelAutoscanDirectoriesInfo.text"));
        this.labelAutoscanDirectoriesInfo.setName("labelAutoscanDirectoriesInfo");
        this.labelAutoscanDirectoriesInfo.setPreferredSize(new Dimension(978, 48));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelTasksAutoscan.add((Component)this.labelAutoscanDirectoriesInfo, gridBagConstraints);
        this.labelAutoscanDirectoriesPrompt.setLabelFor(this.listAutoscanDirectories);
        this.labelAutoscanDirectoriesPrompt.setText(bundle.getString("ScheduledTasksSettingsPanel.labelAutoscanDirectoriesPrompt.text"));
        this.labelAutoscanDirectoriesPrompt.setName("labelAutoscanDirectoriesPrompt");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panelTasksAutoscan.add((Component)this.labelAutoscanDirectoriesPrompt, gridBagConstraints);
        this.scrollPaneListAutoscanDirectories.setName("scrollPaneListAutoscanDirectories");
        this.listAutoscanDirectories.setModel((ListModel)this.modelAutoscanDirectories);
        this.listAutoscanDirectories.setCellRenderer((ListCellRenderer)new FileSystemListCellRenderer(true));
        this.listAutoscanDirectories.setName("listAutoscanDirectories");
        this.listAutoscanDirectories.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ScheduledTasksSettingsPanel.this.listAutoscanDirectoriesValueChanged(evt);
            }
        });
        this.listAutoscanDirectories.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ScheduledTasksSettingsPanel.this.listAutoscanDirectoriesKeyReleased(evt);
            }
        });
        this.scrollPaneListAutoscanDirectories.setViewportView(this.listAutoscanDirectories);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelTasksAutoscan.add((Component)this.scrollPaneListAutoscanDirectories, gridBagConstraints);
        this.checkBoxIsAutoscanIncludeSubdirectories.setText(bundle.getString("ScheduledTasksSettingsPanel.checkBoxIsAutoscanIncludeSubdirectories.text"));
        this.checkBoxIsAutoscanIncludeSubdirectories.setName("checkBoxIsAutoscanIncludeSubdirectories");
        this.checkBoxIsAutoscanIncludeSubdirectories.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScheduledTasksSettingsPanel.this.checkBoxIsAutoscanIncludeSubdirectoriesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.panelTasksAutoscan.add((Component)this.checkBoxIsAutoscanIncludeSubdirectories, gridBagConstraints);
        this.buttonRemoveAutoscanDirectories.setText(bundle.getString("ScheduledTasksSettingsPanel.buttonRemoveAutoscanDirectories.text"));
        this.buttonRemoveAutoscanDirectories.setEnabled(false);
        this.buttonRemoveAutoscanDirectories.setName("buttonRemoveAutoscanDirectories");
        this.buttonRemoveAutoscanDirectories.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScheduledTasksSettingsPanel.this.buttonRemoveAutoscanDirectoriesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.panelTasksAutoscan.add((Component)this.buttonRemoveAutoscanDirectories, gridBagConstraints);
        this.buttonAddAutoscanDirectories.setText(bundle.getString("ScheduledTasksSettingsPanel.buttonAddAutoscanDirectories.text"));
        this.buttonAddAutoscanDirectories.setName("buttonAddAutoscanDirectories");
        this.buttonAddAutoscanDirectories.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScheduledTasksSettingsPanel.this.buttonAddAutoscanDirectoriesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTasksAutoscan.add((Component)this.buttonAddAutoscanDirectories, gridBagConstraints);
        this.buttonScheduledTasks.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_start.png")));
        this.buttonScheduledTasks.setToolTipText(bundle.getString("ScheduledTasksSettingsPanel.buttonScheduledTasks.toolTipText"));
        this.buttonScheduledTasks.setAlignmentY(0.0f);
        this.buttonScheduledTasks.setHorizontalAlignment(4);
        this.buttonScheduledTasks.setMargin(new Insets(0, 0, 0, 0));
        this.buttonScheduledTasks.setName("buttonScheduledTasks");
        this.labelTasksMinutesToStartScheduledTasks.setLabelFor(this.spinnerMinutesToStartScheduledTasks);
        this.labelTasksMinutesToStartScheduledTasks.setText(bundle.getString("ScheduledTasksSettingsPanel.labelTasksMinutesToStartScheduledTasks.text"));
        this.labelTasksMinutesToStartScheduledTasks.setName("labelTasksMinutesToStartScheduledTasks");
        this.spinnerMinutesToStartScheduledTasks.setModel(new SpinnerNumberModel(5, 1, 6000, 1));
        this.spinnerMinutesToStartScheduledTasks.setName("spinnerMinutesToStartScheduledTasks");
        this.spinnerMinutesToStartScheduledTasks.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ScheduledTasksSettingsPanel.this.spinnerMinutesToStartScheduledTasksStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelTasksAutoscan, -1, 659, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.labelTasksMinutesToStartScheduledTasks).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerMinutesToStartScheduledTasks, -2, 51, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonScheduledTasks))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.panelTasksAutoscan, -1, 241, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.spinnerMinutesToStartScheduledTasks, -2, -1, -2).addComponent(this.labelTasksMinutesToStartScheduledTasks).addComponent(this.buttonScheduledTasks)).addContainerGap()));
    }

    private void listAutoscanDirectoriesValueChanged(ListSelectionEvent evt) {
        this.setEnabledButtonRemoveAutoscanDirectory();
    }

    private void listAutoscanDirectoriesKeyReleased(KeyEvent evt) {
        this.handleKeyEventListTasksAutoscanDirectories(evt);
    }

    private void checkBoxIsAutoscanIncludeSubdirectoriesActionPerformed(ActionEvent evt) {
        this.handleActionCheckBoxIsAutoscanIncludeSubdirectories();
    }

    private void buttonRemoveAutoscanDirectoriesActionPerformed(ActionEvent evt) {
        this.removeSelectedAutoscanDirectories();
    }

    private void buttonAddAutoscanDirectoriesActionPerformed(ActionEvent evt) {
        this.addAutoscanDirectories();
    }

    private void spinnerMinutesToStartScheduledTasksStateChanged(ChangeEvent evt) {
        this.handleStateChangedSpinnerMinutesToStartScheduledTasks();
    }
}

